/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IntegerHashtable {
    private static final int HASHTABLE_SIZE = 128;
    private static final int INITIAL_BUCKET_COUNT = 2;
    private static final int HEADER_SIZE = 1;
    private int[][] fTable = new int[128][];
    private int fKeyCount;

    public int size() {
        return this.fKeyCount;
    }

    public int get(int n) {
        if (this.fKeyCount == 0) {
            return -1;
        }
        int n2 = n % 128;
        int[] nArray = this.fTable[n2];
        if (nArray != null) {
            int n3 = 1 + (nArray[0] << 1);
            int n4 = 1;
            while (n4 < n3) {
                if (n == nArray[n4]) {
                    return nArray[n4 + 1];
                }
                n4 += 2;
            }
        }
        return -1;
    }

    public int put(int n, int n2) {
        int n3 = n % 128;
        int[] nArray = this.fTable[n3];
        if (nArray != null) {
            int n4 = 1 + (nArray[0] << 1);
            int n5 = 1;
            while (n5 < n4) {
                if (n == nArray[n5]) {
                    int n6 = nArray[n5 + 1];
                    nArray[n5 + 1] = n2;
                    return n6;
                }
                n5 += 2;
            }
            nArray[0] = nArray[0] + 1;
            if (n4 >= nArray.length) {
                int n7 = (nArray.length << 1) - 1;
                int[] nArray2 = new int[n7];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
                this.fTable[n3] = nArray;
            }
            nArray[n4] = n;
            nArray[n4 + 1] = n2;
        } else {
            nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = n;
            nArray[2] = n2;
            this.fTable[n3] = nArray;
        }
        ++this.fKeyCount;
        return -1;
    }

    public int getKey(int n) {
        int n2 = 0;
        int n3 = 0;
        while (this.fKeyCount > n2 && n3 < 128) {
            int[] nArray = this.fTable[n3];
            if (nArray != null) {
                int n4 = 1 + (nArray[0] << 1);
                int n5 = 1;
                while (n5 < n4) {
                    if (nArray[n5 + 1] == n) {
                        return nArray[n5];
                    }
                    ++n2;
                    n5 += 2;
                }
            }
            ++n3;
        }
        return -1;
    }

    public void getKeys(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (this.fKeyCount > n && n2 < 128) {
            int[] nArray2 = this.fTable[n2];
            if (nArray2 != null) {
                int n3 = 1 + (nArray2[0] << 1);
                int n4 = 1;
                while (n4 < n3) {
                    nArray[n++] = nArray2[n4];
                    n4 += 2;
                }
            }
            ++n2;
        }
    }

    public void clear(boolean bl) {
        int n = 0;
        while (this.fKeyCount > 0 && n < 128) {
            int[] nArray = this.fTable[n];
            if (nArray != null) {
                this.fKeyCount -= nArray[0];
                if (bl) {
                    nArray[0] = 0;
                } else {
                    this.fTable[n] = null;
                }
            }
            ++n;
        }
    }

    static void writeInt32(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24);
        outputStream.write(n >> 16);
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    public boolean save(OutputStream outputStream) throws IOException {
        int n = this.fKeyCount;
        IntegerHashtable.writeInt32(outputStream, n);
        n = 0;
        int n2 = 0;
        while (this.fKeyCount > n && n2 < 128) {
            int[] nArray = this.fTable[n2];
            if (nArray != null) {
                int n3 = 1 + (nArray[0] << 1);
                int n4 = 1;
                while (n4 < n3) {
                    int n5 = nArray[n4];
                    int n6 = nArray[n4 + 1];
                    IntegerHashtable.writeInt32(outputStream, n5);
                    IntegerHashtable.writeInt32(outputStream, n6);
                    ++n;
                    n4 += 2;
                }
            }
            ++n2;
        }
        return true;
    }

    static int readInt32(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        return n;
    }

    public boolean restore(InputStream inputStream) throws IOException {
        int n = IntegerHashtable.readInt32(inputStream);
        if (n > 0 && this.fKeyCount > 0) {
            this.clear(true);
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = IntegerHashtable.readInt32(inputStream);
            int n4 = IntegerHashtable.readInt32(inputStream);
            this.put(n3, n4);
            ++n2;
        }
        return true;
    }
}

