/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.scontext.XStaticContext;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class Template
extends FunctionDecl {
    private QName _mode = null;
    private ArrayList _modes = null;
    private Expr _pattern;
    private double _priority;
    private int _position;
    private boolean _disabled = false;
    private boolean _compiled = false;
    private String m_pattern;
    private boolean _isSimpleNamedTemplate = false;
    private List _nonTunnelParams = new ArrayList();
    private List _tunnelParams = new ArrayList();
    private XTQProgram _xtqprog = null;

    public Template() {
        super(227);
    }

    public Template(int n) {
        super(n);
    }

    public Template(String string) {
        super(227);
        this.setProgramVersion(string);
    }

    public boolean hasNonTunnelParams() {
        return this._nonTunnelParams.size() > 0;
    }

    public boolean hasTunnelParams() {
        return this._tunnelParams.size() > 0;
    }

    public boolean isCompiled() {
        return this._compiled;
    }

    public void setCompiled(boolean bl) {
        this._compiled = bl;
    }

    public boolean isSimpleNamedTemplate() {
        return this._isSimpleNamedTemplate;
    }

    public void addNonTunnelParam(Param param) {
        this._nonTunnelParams.add(param);
    }

    public List getNonTunnelParams() {
        return this._nonTunnelParams;
    }

    public void addTunnelParam(Param param) {
        this._tunnelParams.add(param);
    }

    public List getTunnelParams() {
        return this._tunnelParams;
    }

    public Param lookupParam(QName qName) {
        Param param;
        int n;
        for (n = 0; n < this._nonTunnelParams.size(); ++n) {
            param = (Param)this._nonTunnelParams.get(n);
            if (!param.getQName().equals(qName)) continue;
            return param;
        }
        for (n = 0; n < this._tunnelParams.size(); ++n) {
            param = (Param)this._tunnelParams.get(n);
            if (!param.getQName().equals(qName)) continue;
            return param;
        }
        return null;
    }

    public void disable() {
        this._disabled = true;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public double getPriority() {
        return this._priority;
    }

    public int getPosition() {
        return this._position;
    }

    public boolean isNamed() {
        return this._name != null;
    }

    public boolean isNamedTemplate() {
        if (this._name == null) {
            return false;
        }
        return !this._name.getLocalPart().startsWith("template$dot$");
    }

    public Expr getPattern() {
        return this._pattern;
    }

    public void setPattern(String string) {
        this.m_pattern = string;
    }

    public QName getQName() {
        return this._name;
    }

    public void setQName(QName qName) {
        if (this._name == null) {
            this._name = qName;
        }
    }

    public QName getModeName() {
        return this._mode;
    }

    public ArrayList getModeNames() {
        return this._modes;
    }

    public void dump(String string, PrintStream printStream) {
        printStream.print(string + "Template");
        printStream.print(" name=" + this._name);
        if (this._mode != null) {
            printStream.print(" mode=" + this._mode);
        } else if (this._modes != null) {
            printStream.print(" mode=" + this._modes);
        } else {
            printStream.print(" mode=");
        }
        printStream.print(" priority=" + this._priority);
        printStream.println(" match=" + this.getAttribute("match"));
        if (null != this._pattern) {
            this._pattern.dump(" " + string, printStream);
        }
        this.dumpChildren(string + " ", printStream);
    }

    private boolean resolveNamedTemplates(Template template, XSLTParser xSLTParser) {
        if (template == null) {
            return true;
        }
        int n = this.getImportPrecedence();
        int n2 = template.getImportPrecedence();
        XStaticContext xStaticContext = xSLTParser.getStaticContext();
        if (n > n2) {
            template.disable();
            return true;
        }
        if (n < n2) {
            xStaticContext.addTemplate(template);
            this.disable();
            return true;
        }
        return false;
    }

    public XTQProgram getXTQProgram() {
        return this._xtqprog;
    }

    public void parseContents(XSLTParser xSLTParser) {
        ASTMsg aSTMsg;
        Object object;
        String string = this.getAttribute("name");
        String string2 = this.getAttribute("mode");
        String string3 = this.getAttribute("match");
        String string4 = this.getAttribute("priority");
        this._xtqprog = super.getXTQProgram();
        boolean bl = false;
        boolean bl2 = false;
        if (string3.equals("")) {
            if (string.equals("")) {
                bl = true;
            }
            if (!string2.equals("") || !string4.equals("")) {
                if (xSLTParser.isXSLT20()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
        }
        if (bl || bl2) {
            int n = bl2 ? 4 : 3;
            object = new ASTMsg("INVALID_TEMPLATE_DECLARATION", null, (Expr)this);
            xSLTParser.reportError(n, (ASTBaseMsg)object);
        }
        String string5 = XPathTreeConstants.jjtNodeName[this.getId()];
        if (string.length() > 0) {
            xSLTParser.checkAttributeValue(this, string5, "name", string, 3);
            this._name = xSLTParser.getQNameIgnoreDefaultNs(string);
        }
        if (string2.length() > 0) {
            xSLTParser.checkAttributeValue(this, string5, "mode", string2, 3);
            if (xSLTParser.isXSLT20()) {
                this._modes = xSLTParser.getQNameListIgnoreDefaultNs(string2);
            } else {
                this._mode = xSLTParser.getQNameIgnoreDefaultNs(string2);
            }
        }
        if (string3.length() > 0) {
            this._pattern = xSLTParser.parsePattern(this, "match", null);
        }
        if (this.m_pattern != null) {
            this._pattern = xSLTParser.parsePattern(this, this.m_pattern);
        }
        if (string4.length() > 0) {
            try {
                this._priority = Double.parseDouble(string4);
            }
            catch (NumberFormatException numberFormatException) {
                aSTMsg = new ASTMsg("ERR_PRIORITY", (Object)string4, (Expr)this);
                xSLTParser.reportError(3, aSTMsg);
            }
        } else {
            this._priority = Double.NaN;
        }
        this._position = xSLTParser.getTemplateIndex();
        if (this._name != null) {
            object = xSLTParser.getStaticContext().addTemplate(this);
            if (!this.resolveNamedTemplates((Template)object, xSLTParser)) {
                aSTMsg = new ASTMsg("TEMPLATE_REDEF_ERR", (Object)this._name, (Expr)this);
                xSLTParser.reportError(3, aSTMsg);
            }
            if (this._pattern == null && this._mode == null && this._modes == null) {
                this._isSimpleNamedTemplate = true;
            }
        }
        if (((String)(object = this.getAttribute("as"))).length() > 0) {
            this.setResultType(xSLTParser.parseSequenceTypeExpression(this, (String)object));
        }
        if (this.jjtGetParent() instanceof XTQProgram) {
            ((XTQProgram)this.jjtGetParent()).addTemplate(this);
        }
        xSLTParser.setTemplate(this);
        this.parseChildren(xSLTParser);
        xSLTParser.setTemplate(null);
    }

    public void parseSimplified(XTQProgram xTQProgram, XSLTParser xSLTParser) {
        this._xtqprog = xTQProgram;
        this.jjtSetParent(xTQProgram);
        this._name = null;
        this._mode = null;
        this._priority = Double.NaN;
        this._pattern = xSLTParser.parsePattern(this, "/");
        Expr expr = (Expr)this._xtqprog.jjtGetChild(0);
        if (expr instanceof DirElemConstructor) {
            this.jjtAppendChild(xSLTParser, expr);
            expr.jjtSetParent(this);
            this._xtqprog.jjtAddChild(xSLTParser, this, 0);
            xSLTParser.setTemplate(this);
            xSLTParser.getStaticContext().setCurrentNode(expr);
            expr.callParseContents(xSLTParser);
            xSLTParser.setTemplate(null);
        }
    }

    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        if (null == this.getQName()) {
            stringBuffer.append("declare template match[");
            if (null != this._pattern) {
                this._pattern.getXQueryString(stringBuffer, bl, "");
            } else {
                stringBuffer.append(this.m_pattern);
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append("declare function ").append(this.getString(this.getQName()));
        }
        stringBuffer.append("(");
        this.getParamsString(stringBuffer, bl, string);
        if (null != this._returnType) {
            stringBuffer.append(") as ").append(this._returnType);
        } else {
            stringBuffer.append(")");
        }
        if (this.isExternal()) {
            stringBuffer.append(" external");
        } else {
            if (this._mode != null) {
                stringBuffer.append(" mode:").append(this._mode);
            }
            if (this._modes != null) {
                stringBuffer.append(" modes:").append(this._modes);
            }
            if (!Double.isNaN(this._priority)) {
                stringBuffer.append(" priority:").append(this._priority);
            }
            stringBuffer.append("\n" + string + "{\n" + string + " ");
            this.getXQueryStringForChildren(stringBuffer, bl, string);
            stringBuffer.append("\n" + string + "}" + string + " ");
        }
        stringBuffer.append("\r\r");
    }
}

