/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XHexBinary;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigInteger;
import org.apache.xerces.impl.dv.util.Base64;

public class XBase64Binary
extends XItemBase {
    private byte[] m_bytes;
    private String m_str = null;

    public XBase64Binary(byte[] byArray) {
        this(byArray, Type.BASE64BINARY);
    }

    public XBase64Binary(byte[] byArray, String string) {
        this(byArray, Type.BASE64BINARY);
        this.m_str = string;
    }

    public XBase64Binary(byte[] byArray, ItemType itemType) {
        this.m_bytes = byArray;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 18;
    }

    public static XBase64Binary parse(String string) {
        byte[] byArray = Base64.decode(string);
        if (byArray != null) {
            return new XBase64Binary(byArray, string);
        }
        throw new DynamicError(XMLMessages.createXMLMessage("ER_CAN_NOT_CAST_XBASE64BINARY", new Object[]{string}));
    }

    public XBase64Binary toBase64Binary() {
        return this;
    }

    public XHexBinary toHexBinary() {
        BigInteger bigInteger = new BigInteger(this.m_bytes);
        return XHexBinary.parse(bigInteger.toString(2));
    }

    public String toString() {
        if (this.m_str == null) {
            this.m_str = Base64.encode(this.m_bytes);
        }
        return this.m_str;
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public int getLength() {
        return this.m_bytes.length;
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 18: {
                return this.equals(xItem.toBase64Binary());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XBase64Binary xBase64Binary) {
        int n = this.getLength();
        if (n != xBase64Binary.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.m_bytes[i] == xBase64Binary.getBytes()[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean notEquals(XBase64Binary xBase64Binary) throws TypeError {
        return !this.equals(xBase64Binary);
    }
}

