/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.XDouble;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.res.XMLMessages;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XFloat
extends XItemBase {
    private float m_value;

    public XFloat(float f) {
        this.m_value = f;
        this.m_type = Type.FLOAT;
    }

    public XFloat(float f, ItemType itemType) {
        this.m_value = f;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 2;
    }

    public static XFloat valueOf(float f) {
        return new XFloat(f);
    }

    public static XFloat valueOf(String string) {
        return new XFloat(CastLibrary.toFloat(string));
    }

    public float getCurrentItemFloat() throws TypeError {
        return this.m_value;
    }

    public double getCurrentItemAsDouble() throws TypeError {
        return this.m_value;
    }

    public boolean toBoolean() {
        return CastLibrary.toBoolean(this.m_value);
    }

    public BigDecimal toDecimal() {
        return CastLibrary.toDecimal(this.m_value);
    }

    public double toDouble() {
        return CastLibrary.toDouble(this.m_value);
    }

    public float toFloat() {
        return this.m_value;
    }

    public BigInteger toInteger() {
        return CastLibrary.toInteger(this.m_value);
    }

    public String toString() {
        return CastLibrary.toString(this.m_value);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XItem add(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return new XFloat(this.m_value + xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble((double)this.m_value + xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public XItem subtract(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return new XFloat(this.m_value + xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble((double)this.m_value - xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public XItem multiply(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return new XFloat(this.m_value * xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble((double)this.m_value * xItem.toDouble());
            }
            case 8: {
                return xItem.toDayTimeDuration().multiply(this.toDouble());
            }
            case 7: {
                return xItem.toYearMonthDuration().multiply(this.toDouble());
            }
        }
        throw new TypeError();
    }

    public XItem divide(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return new XFloat(this.m_value / xItem.toFloat());
            }
            case 0: 
            case 3: {
                return new XDouble((double)this.m_value / xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public float idiv(float f) throws TypeError {
        throw new TypeError();
    }

    public final XItem mod(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return new XFloat(this.mod(xItem.toFloat()));
            }
            case 0: 
            case 3: {
                return new XDouble(this.toDouble() % xItem.toDouble());
            }
        }
        throw new TypeError(XMLMessages.createXMLMessage("TYPE_ERR_TYPE_UNMATCH", new Object[]{this.getType(), xItem.getType()}));
    }

    public final float mod(float f) throws TypeError {
        return this.m_value % f;
    }

    public XItem negate() throws TypeError {
        return new XFloat(-this.m_value);
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return this.equals(xItem.toFloat());
            }
            case 3: {
                double d = XDouble.compare(this.m_value, xItem.toDouble());
                if (Double.isNaN(d)) {
                    return false;
                }
                return d == 0.0;
            }
        }
        throw new TypeError();
    }

    public final boolean equals(float f) throws TypeError {
        float f2 = XFloat.compare(this.m_value, f);
        if (Float.isNaN(f2)) {
            return false;
        }
        return f2 == 0.0f;
    }

    public final boolean notEquals(float f) throws TypeError {
        return !this.equals(f);
    }

    public int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 2: 
            case 4: 
            case 5: {
                return this.compareTo(xItem.toFloat());
            }
            case 3: {
                return (int)XDouble.compare(this.m_value, xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(float f) throws TypeError {
        return (int)XFloat.compare(this.m_value, f);
    }

    public final boolean greaterThan(float f) throws TypeError {
        float f2 = XFloat.compare(this.m_value, f);
        if (Float.isNaN(f2)) {
            return false;
        }
        return f2 > 0.0f;
    }

    public final boolean greaterOrEquals(float f) throws TypeError {
        float f2 = XFloat.compare(this.m_value, f);
        if (Float.isNaN(f2)) {
            return false;
        }
        return f2 >= 0.0f;
    }

    public final boolean lessThan(float f) throws TypeError {
        float f2 = XFloat.compare(this.m_value, f);
        if (Float.isNaN(f2)) {
            return false;
        }
        return f2 < 0.0f;
    }

    public final boolean lessOrEquals(float f) throws TypeError {
        float f2 = XFloat.compare(this.m_value, f);
        if (Float.isNaN(f2)) {
            return false;
        }
        return f2 <= 0.0f;
    }

    public static final float compare(float f, float f2) {
        if (Float.isNaN(f) || Float.isNaN(f2)) {
            return Float.NaN;
        }
        if (f == -0.0f && f2 == 0.0f) {
            return 0.0f;
        }
        if (f == Float.POSITIVE_INFINITY) {
            return f2 == Float.POSITIVE_INFINITY ? 0.0f : 1.0f;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return f2 == Float.NEGATIVE_INFINITY ? 0.0f : -1.0f;
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return f == Float.POSITIVE_INFINITY ? 0.0f : -1.0f;
        }
        if (f2 == Float.NEGATIVE_INFINITY) {
            return f == Float.NEGATIVE_INFINITY ? 0.0f : 1.0f;
        }
        if (f == f2) {
            return 0.0f;
        }
        if (f > f2) {
            return 1.0f;
        }
        return -1.0f;
    }
}

