/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.YearDV;

public class XGYear
extends XItemBase {
    private static TypeValidator m_validator = new YearDV();
    private int m_year;

    public XGYear(int n) {
        this(n, Type.GYEAR);
    }

    public XGYear(int n, ItemType itemType) {
        this.m_year = n;
        this.m_type = itemType;
    }

    public int getYear() {
        return this.m_year;
    }

    public int getPrimitiveId() {
        return 13;
    }

    public static XGYear parse(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XGYear(dateTimeBase.getYear());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XGYear toGYear() {
        return this;
    }

    public String toString() {
        return CastLibrary.convertYearToString(this.m_year);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 13: {
                return this.equals(xItem.toGYear());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XGYear xGYear) {
        return this.m_year == xGYear.getYear();
    }

    public final boolean notEquals(XGYear xGYear) throws TypeError {
        return !this.equals(xGYear);
    }
}

