/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDataTypeUtils;
import com.ibm.xtq.xml.datamodel.XDateTime;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TimeDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XTime
extends XItemBase {
    private static TypeValidator m_validator = new TimeDV();
    private int m_hour;
    private int m_minute;
    private double m_second;
    private XDayTimeDuration m_timezone = null;

    protected XTime(DateTimeBase dateTimeBase) {
        this.m_hour = dateTimeBase.getHours();
        this.m_minute = dateTimeBase.getMinutes();
        this.m_second = (double)dateTimeBase.getSeconds() + dateTimeBase.getFraction();
        this.m_type = Type.TIME;
    }

    public XTime(int n, int n2, double d) {
        this(n, n2, d, null, Type.TIME);
    }

    public XTime(int n, int n2, double d, ItemType itemType) {
        this(n, n2, d, null, itemType);
    }

    public XTime(int n, int n2, double d, XDayTimeDuration xDayTimeDuration) {
        this(n, n2, d, xDayTimeDuration, Type.TIME);
    }

    public XTime(int n, int n2, double d, int n3, int n4) {
        this(n, n2, d, new XDayTimeDuration(0, n3, n4, 0.0), Type.TIME);
    }

    public XTime(int n, int n2, double d, XDayTimeDuration xDayTimeDuration, ItemType itemType) {
        this.m_hour = n;
        this.m_minute = n2;
        this.m_second = d;
        this.m_timezone = xDayTimeDuration;
        this.m_type = itemType;
    }

    public int getPrimitiveId() {
        return 10;
    }

    public static XTime parse(String string) {
        try {
            return new XTime((DateTimeBase)m_validator.getActualValue(string, null));
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public double getSecond() {
        return this.m_second;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XDateTime toDateTime() {
        XDateTime xDateTime = CastLibrary.current_dateTime();
        int n = xDateTime.getYear();
        int n2 = xDateTime.getMonth();
        int n3 = xDateTime.getDay();
        return new XDateTime(n, n2, n3, this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    public String toString() {
        return CastLibrary.composeTimeStrRep(this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    public XTime toTime() {
        return this;
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XItem add(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 10: {
                return this.add(xItem.toTime());
            }
        }
        throw new TypeError();
    }

    public XTime add(XDayTimeDuration xDayTimeDuration) {
        double d = this.m_second + xDayTimeDuration.getSeconds();
        int n = XDataTypeUtils.fQuotient(d, 60.0);
        double d2 = XDataTypeUtils.modulo(d, 60.0, n);
        int n2 = this.m_minute + xDayTimeDuration.getMinutes() + n;
        n = XDataTypeUtils.fQuotient(n2, 60.0);
        int n3 = (int)XDataTypeUtils.modulo((double)n2, 60.0, n);
        n2 = this.m_hour + xDayTimeDuration.getHours() + n;
        n = XDataTypeUtils.fQuotient(n2, 24.0);
        int n4 = (int)XDataTypeUtils.modulo((double)n2, 24.0, n);
        return new XTime(n4, n3, d2, this.m_timezone);
    }

    public XItem subtract(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 10: {
                return this.subtract(xItem.toTime());
            }
            case 8: {
                return this.subtract(xItem.toDayTimeDuration());
            }
        }
        throw new TypeError();
    }

    public XDayTimeDuration subtract(XTime xTime) {
        XDateTime xDateTime = new XDateTime(1970, 6, 20, this.getHour(), this.getMinute(), this.getSecond(), this.getTimeZoneHour(), this.getTimeZoneMinute()).normalize();
        XDateTime xDateTime2 = new XDateTime(1970, 6, 20, xTime.getHour(), xTime.getMinute(), xTime.getSecond(), xTime.getTimeZoneHour(), xTime.getTimeZoneMinute()).normalize();
        return xDateTime.subtract(xDateTime2);
    }

    public XTime subtract(XDayTimeDuration xDayTimeDuration) {
        return this.add(XDataTypeUtils.negate(xDayTimeDuration));
    }

    public final int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 10: {
                return this.compareTo(xItem.toTime());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(XTime xTime) throws TypeError {
        double d = this.m_hour - xTime.getHour();
        if (d != 0.0) {
            return XItemBase.FormatCompareOut(d);
        }
        d = this.m_minute - xTime.getMinute();
        if (d != 0.0) {
            return XItemBase.FormatCompareOut(d);
        }
        double d2 = this.m_second - xTime.getSecond();
        return XItemBase.FormatCompareOut(d2);
    }

    public final boolean equals(XTime xTime) throws TypeError {
        return this.compareTo(xTime) == 0;
    }

    public final boolean notEquals(XTime xTime) throws TypeError {
        return !this.equals(xTime);
    }

    public final boolean greaterThan(XTime xTime) throws TypeError {
        return this.compareTo(xTime) > 0;
    }

    public final boolean greaterOrEquals(XTime xTime) throws TypeError {
        return this.compareTo(xTime) >= 0;
    }

    public final boolean lessThan(XTime xTime) throws TypeError {
        return this.compareTo(xTime) < 0;
    }

    public final boolean lessOrEquals(XTime xTime) throws TypeError {
        return this.compareTo(xTime) <= 0;
    }
}

