/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDate;
import com.ibm.xtq.xml.datamodel.XDateTime;
import com.ibm.xtq.xml.datamodel.XDuration;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import java.math.BigDecimal;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

public class XYearMonthDuration
extends XDuration {
    public XYearMonthDuration(int n, int n2) {
        this.m_CValue = new BigDecimal(n).multiply(new BigDecimal(12)).add(new BigDecimal(n2));
        this.m_years = n + n2 / 12;
        this.m_months = n2 % 12;
        this.m_type = Type.YEARMONTHDURATION;
    }

    public XYearMonthDuration(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
        this.m_type = Type.YEARMONTHDURATION;
    }

    public XYearMonthDuration(int n, int n2, ItemType itemType) {
        this.m_CValue = new BigDecimal(n).multiply(new BigDecimal(12)).add(new BigDecimal(n2));
        this.m_years = n + n2 / 12;
        this.m_months = n2 % 12;
        this.m_type = itemType;
    }

    public XYearMonthDuration(BigDecimal bigDecimal, ItemType itemType) {
        this.setValue(bigDecimal);
        this.m_type = itemType;
    }

    public final void setValue(BigDecimal bigDecimal) {
        this.m_CValue = bigDecimal;
        this.m_years = (int)this.m_CValue.divide(new BigDecimal(12), 0, 1).longValue();
        this.m_months = (int)this.m_CValue.add(new BigDecimal((double)this.m_years * -12.0)).longValue();
    }

    public int getPrimitiveId() {
        return 7;
    }

    public static XYearMonthDuration parseTMP(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XYearMonthDuration(dateTimeBase.getYear(), dateTimeBase.getMonth());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    public XDuration toDuration() {
        return new XDuration(this.m_years, this.m_months, 0, 0, 0, 0.0);
    }

    public String toString() {
        return CastLibrary.composeDurationCRep(this.m_years, this.m_months, 0, 0, 0, 0.0, this.m_CValue, 7);
    }

    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    public XYearMonthDuration toYearMonthDuration() {
        return this;
    }

    public XYearMonthDuration add(XYearMonthDuration xYearMonthDuration) {
        return new XYearMonthDuration(this.m_CValue.add(xYearMonthDuration.getCValue()));
    }

    public XDate addTo(XDate xDate) {
        return xDate.add(this);
    }

    public XDateTime addTo(XDateTime xDateTime) {
        return xDateTime.add(this);
    }

    public XItem add(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 7: {
                return this.add(xItem.toYearMonthDuration());
            }
            case 9: {
                return this.add(xItem.toDatetime());
            }
            case 10: {
                return this.add(xItem.toTime());
            }
            case 11: {
                return this.add(xItem.toDate());
            }
        }
        throw new TypeError();
    }

    public XYearMonthDuration subtract(XYearMonthDuration xYearMonthDuration) {
        return new XYearMonthDuration(this.m_CValue.add(xYearMonthDuration.getCValue().negate()));
    }

    public XItem subtract(XItem xItem) {
        switch (xItem.getPrimitiveId()) {
            case 7: {
                return this.subtract(xItem.toYearMonthDuration());
            }
        }
        throw new TypeError();
    }

    public XYearMonthDuration multiply(double d) {
        return new XYearMonthDuration(this.m_CValue.multiply(new BigDecimal(d)));
    }

    public XItem multiply(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.multiply(xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public XYearMonthDuration divide(double d) {
        return new XYearMonthDuration(this.m_CValue.divide(new BigDecimal(d), 0, 1));
    }

    public double divide(XYearMonthDuration xYearMonthDuration) {
        return this.m_CValue.divide(xYearMonthDuration.getCValue(), 4, 4).doubleValue();
    }

    public XItem divide(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.divide(xItem.toDouble());
            }
        }
        throw new TypeError();
    }

    public final int compareTo(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return XItemBase.FormatCompareOut(this.m_CValue.add(xYearMonthDuration.getCValue().negate()));
    }

    public final int compareTo(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 7: {
                return this.compareTo(xItem.toYearMonthDuration());
            }
        }
        throw new TypeError();
    }

    public final boolean equals(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return this.compareTo(xYearMonthDuration) == 0;
    }

    public final boolean notEquals(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return !this.equals(xYearMonthDuration);
    }

    public final boolean greaterThan(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return this.compareTo(xYearMonthDuration) > 0;
    }

    public final boolean greaterOrEquals(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return this.compareTo(xYearMonthDuration) >= 0;
    }

    public final boolean lessThan(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return this.compareTo(xYearMonthDuration) < 0;
    }

    public final boolean lessOrEquals(XYearMonthDuration xYearMonthDuration) throws TypeError {
        return this.compareTo(xYearMonthDuration) <= 0;
    }
}

