/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.ref;

import com.ibm.xtq.common.utils.XMLString;
import com.ibm.xtq.xml.dtm.DTM;
import com.ibm.xtq.xml.dtm.DTMException;
import com.ibm.xtq.xml.dtm.DTMManager;
import com.ibm.xtq.xml.dtm.DTMWSFilter;
import com.ibm.xtq.xml.dtm.ref.DTMManagerDefault;
import com.ibm.xtq.xml.dtm.ref.DTMNodeProxy;
import com.ibm.xtq.xml.dtm.ref.SparseSchemaInfo;
import com.ibm.xtq.xml.dtm.utils.BoolStack;
import com.ibm.xtq.xml.dtm.utils.DTMDefaultBaseTable;
import com.ibm.xtq.xml.dtm.utils.SuballocatedIntVector;
import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xml.xdm.ExpandedNameTable;
import com.ibm.xtq.xml.xdm.ExtendedType;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.XDMSequence;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class DTMDefaultBase
implements DTM {
    public static final int TYPESHIFT = 24;
    public static final int TYPEMASK = 0xFFFFFF;
    protected static final String EMPTY_STR = "";
    protected int m_size = 0;
    protected DTMDefaultBaseTable m_maintable;
    protected int[][] m_exptype_map;
    protected int[][] m_nextsib_map;
    protected int[][] m_firstch_map;
    protected int[][] m_parent_map;
    protected int[][] m_prevsib_map;
    protected int[] m_exptype_map0;
    protected int[] m_nextsib_map0;
    protected int[] m_firstch_map0;
    protected int[] m_parent_map0;
    protected int[] m_prevsib_map0;
    public int m_SHIFT;
    public int m_MASK;
    public int m_blocksize;
    protected Vector m_namespaceDeclSets = null;
    protected SuballocatedIntVector m_namespaceDeclSetElements = null;
    private int XML_ID;
    private int EMPTY_ID;
    private static final int[] EMPTY_NAMESPACE_TABLE = new int[0];
    protected HashMap m_namespaceTables = null;
    protected HashMap m_namespaceTablesWithDefault = null;
    protected int[][][] m_elemIndexes;
    protected SparseSchemaInfo m_schemaTypeOverride = new SparseSchemaInfo();
    public static final int DEFAULT_BLOCKSIZE = 512;
    public static final int DEFAULT_NUMBLOCKS = 32;
    public static final int DEFAULT_NUMBLOCKS_SMALL = 4;
    public static final int NOTPROCESSED = -2;
    public DTMManager m_mgr;
    protected DTMManagerDefault m_mgrDefault = null;
    protected SuballocatedIntVector m_dtmIdent;
    protected int m_maxNodeIndex;
    protected String m_documentBaseURI;
    protected DTMWSFilter m_wsfilter;
    protected boolean m_shouldStripWS = false;
    protected BoolStack m_shouldStripWhitespaceStack;
    protected boolean m_isXMLSpacePreserve = false;
    protected BoolStack m_XMLSpaceStack = new BoolStack();
    protected ExpandedNameTable m_expandedNameTable;
    protected ExtendedType[] m_extendedTypes;
    protected boolean m_indexing;
    protected boolean m_buildIdIndex = true;
    static final short DERMETH = 3;

    public DTMDefaultBase(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, boolean bl) {
        this(dTMManager, source, n, dTMWSFilter, bl, 512, true, false);
    }

    public DTMDefaultBase(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, boolean bl, int n2, boolean bl2, boolean bl3) {
        int n3;
        if (n2 <= 64) {
            n3 = 4;
            this.m_dtmIdent = new SuballocatedIntVector(4, 1);
        } else {
            n3 = 32;
            this.m_dtmIdent = new SuballocatedIntVector(32);
        }
        this.m_maintable = new DTMDefaultBaseTable(n2, n3);
        this.m_mgr = dTMManager;
        if (dTMManager instanceof DTMManagerDefault) {
            this.m_mgrDefault = (DTMManagerDefault)dTMManager;
        }
        this.m_documentBaseURI = null != source ? source.getSystemId() : null;
        this.m_dtmIdent.setElementAt(n, 0);
        this.m_wsfilter = dTMWSFilter;
        this.m_indexing = bl;
        this.m_expandedNameTable = this.m_mgrDefault.getExpandedNameTable(this);
        if (null != dTMWSFilter) {
            this.m_shouldStripWhitespaceStack = new BoolStack();
            this.pushShouldStripWhitespace(false);
        }
    }

    public void setExpandedNameTable(ExpandedNameTable expandedNameTable) {
        this.m_expandedNameTable = expandedNameTable;
    }

    protected void ensureSizeOfIndex(int n, int n2) {
        Object object;
        Object object2;
        if (null == this.m_elemIndexes) {
            this.m_elemIndexes = new int[n + 20][][];
        } else if (this.m_elemIndexes.length <= n) {
            object2 = this.m_elemIndexes;
            this.m_elemIndexes = new int[n + 20][][];
            System.arraycopy(object2, 0, this.m_elemIndexes, 0, ((int[][][])object2).length);
        }
        object2 = this.m_elemIndexes[n];
        if (null == object2) {
            object2 = new int[n2 + 100][];
            this.m_elemIndexes[n] = (int[][])object2;
        } else if (((int[][][])object2).length <= n2) {
            object = object2;
            object2 = new int[n2 + 100][];
            System.arraycopy(object, 0, object2, 0, ((int[][][])object).length);
            this.m_elemIndexes[n] = (int[][])object2;
        }
        object = object2[n2];
        if (null == object) {
            object = new int[128];
            object2[n2] = (int[][])object;
            object[0] = (int[][])true;
        } else if (((int[][][])object).length <= object[0] + true) {
            Object object3 = object;
            object = new int[object[0] + 1024];
            System.arraycopy(object3, 0, object, 0, ((int[][][])object3).length);
            object2[n2] = (int[][])object;
        }
    }

    protected void indexElementNode(int n, int n2) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        int n3 = expandedNameTable.getNamespaceID(n);
        int n4 = expandedNameTable.getLocalNameID(n);
        this.ensureSizeOfIndex(n3, n4);
        int[] nArray = this.m_elemIndexes[n3][n4];
        nArray[nArray[0]] = n2;
        nArray[0] = nArray[0] + 1;
    }

    protected int findGTE(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = n4 = n + (n2 - 1);
        while (n5 <= n4) {
            int n7 = (n5 + n4) / 2;
            int n8 = nArray[n7];
            if (n8 > n3) {
                n4 = n7 - 1;
                continue;
            }
            if (n8 < n3) {
                n5 = n7 + 1;
                continue;
            }
            return n7;
        }
        return n5 <= n6 && nArray[n5] > n3 ? n5 : -1;
    }

    int findElementFromIndex(int n, int n2, int n3) {
        int n4;
        int[] nArray;
        int[][] nArray2;
        int[][][] nArray3 = this.m_elemIndexes;
        if (null != nArray3 && n < nArray3.length && null != (nArray2 = nArray3[n]) && n2 < nArray2.length && null != (nArray = nArray2[n2]) && (n4 = this.findGTE(nArray, 1, nArray[0], n3)) > -1) {
            return nArray[n4];
        }
        return -2;
    }

    protected abstract int _nextNode(int var1);

    protected abstract boolean nextNode();

    public abstract int getNumberOfNodes();

    protected int _type(int n) {
        int n2 = this._exptype2(n);
        if (n2 == 0xFFFFFF) {
            return -1;
        }
        return this.m_expandedNameTable.getType(n2);
    }

    public final int _type2(int n) {
        int n2 = n < this.m_blocksize ? this.m_exptype_map0[n] : this.m_exptype_map[n >>> this.m_SHIFT][n & this.m_MASK];
        return n2 >= 0 ? n2 >> 24 : n2;
    }

    public final int _exptype(int n) {
        return 0xFFFFFF & this.m_maintable.element_exptype_At(n);
    }

    public final int _exptype2(int n) {
        if (n < this.m_blocksize) {
            return 0xFFFFFF & this.m_exptype_map0[n];
        }
        return 0xFFFFFF & this.m_exptype_map[n >>> this.m_SHIFT][n & this.m_MASK];
    }

    public final int _exptype2Type(int n) {
        if (-1 != n) {
            return this.m_extendedTypes[n].getNodeType();
        }
        return -1;
    }

    public int _level(int n) {
        int n2;
        while (n >= this.m_size) {
            n2 = this.nextNode();
            if (n2 != 0 || n < this.m_size) continue;
            return -1;
        }
        n2 = 0;
        while (-1 != (n = this._parent(n))) {
            ++n2;
        }
        return n2;
    }

    protected int _firstch(int n) {
        return this.m_maintable.element_firstch_At(n);
    }

    public final int _firstch2(int n) {
        if (n < this.m_blocksize) {
            return this.m_firstch_map0[n];
        }
        return this.m_firstch_map[n >>> this.m_SHIFT][n & this.m_MASK];
    }

    protected int _nextsib(int n) {
        return this.m_maintable.element_nextsib_At(n);
    }

    public final int _nextsib2(int n) {
        if (n < this.m_blocksize) {
            return this.m_nextsib_map0[n];
        }
        return this.m_nextsib_map[n >>> this.m_SHIFT][n & this.m_MASK];
    }

    public int _prevsib(int n) {
        if (n < this.m_size) {
            return this.m_maintable.element_prevsib_At(n);
        }
        do {
            boolean bl = this.nextNode();
            if (n < this.m_size || bl) continue;
            return -1;
        } while (n >= this.m_size);
        return this.m_maintable.element_prevsib_At(n);
    }

    public final int _prevsib2(int n) {
        if (n < this.m_blocksize) {
            return this.m_prevsib_map0[n];
        }
        return this.m_prevsib_map[n >>> this.m_SHIFT][n & this.m_MASK];
    }

    protected int _parent(int n) {
        if (n < this.m_size) {
            return this.m_maintable.element_parent_At(n);
        }
        do {
            boolean bl = this.nextNode();
            if (n < this.m_size || bl) continue;
            return -1;
        } while (n >= this.m_size);
        return this.m_maintable.element_parent_At(n);
    }

    public final int _parent2(int n) {
        if (n < this.m_blocksize) {
            return this.m_parent_map0[n];
        }
        return this.m_parent_map[n >>> this.m_SHIFT][n & this.m_MASK];
    }

    public void dumpDTM(OutputStream outputStream) {
        try {
            Object object;
            if (outputStream == null) {
                object = new File("DTMDump" + this.hashCode() + ".txt");
                System.err.println("Dumping... " + ((File)object).getAbsolutePath());
                outputStream = new FileOutputStream((File)object);
            }
            object = new PrintStream(outputStream);
            while (this.nextNode()) {
            }
            int n = this.m_size;
            ((PrintStream)object).println("Total nodes: " + n);
            for (int i = 0; i < n; ++i) {
                String string;
                int n2 = this.makeNodeHandle(i);
                ((PrintStream)object).println("=========== index=" + i + " handle=" + n2 + " ===========");
                ((PrintStream)object).println("NodeName: " + this.getNodeName(n2));
                ((PrintStream)object).println("NodeNameX: " + this.getNodeNameX(n2));
                ((PrintStream)object).println("LocalName: " + this.getLocalName(n2));
                ((PrintStream)object).println("NamespaceURI: " + this.getNamespaceURI(n2));
                ((PrintStream)object).println("Prefix: " + this.getPrefix(n2));
                int n3 = this._exptype2(i);
                ((PrintStream)object).println("Expanded Type ID: " + Integer.toHexString(n3));
                int n4 = this._type(i);
                switch (n4) {
                    case 2: {
                        string = "ATTRIBUTE_NODE";
                        break;
                    }
                    case 4: {
                        string = "CDATA_SECTION_NODE";
                        break;
                    }
                    case 8: {
                        string = "COMMENT_NODE";
                        break;
                    }
                    case 11: {
                        string = "DOCUMENT_FRAGMENT_NODE";
                        break;
                    }
                    case 9: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 10: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 1: {
                        string = "ELEMENT_NODE";
                        break;
                    }
                    case 6: {
                        string = "ENTITY_NODE";
                        break;
                    }
                    case 5: {
                        string = "ENTITY_REFERENCE_NODE";
                        break;
                    }
                    case 13: {
                        string = "NAMESPACE_NODE";
                        break;
                    }
                    case 12: {
                        string = "NOTATION_NODE";
                        break;
                    }
                    case -1: {
                        string = "NULL";
                        break;
                    }
                    case 7: {
                        string = "PROCESSING_INSTRUCTION_NODE";
                        break;
                    }
                    case 3: {
                        string = "TEXT_NODE";
                        break;
                    }
                    default: {
                        string = "Unknown!";
                    }
                }
                ((PrintStream)object).println("Type: " + string);
                int n5 = this._firstch(i);
                if (-1 == n5) {
                    ((PrintStream)object).println("First child: DTM.NULL");
                } else {
                    ((PrintStream)object).println("First child: " + n5);
                }
                int n6 = this._prevsib(i);
                if (-1 == n6) {
                    ((PrintStream)object).println("Prev sibling: DTM.NULL");
                } else if (-2 == n6) {
                    ((PrintStream)object).println("Prev sibling: NOTPROCESSED");
                } else {
                    ((PrintStream)object).println("Prev sibling: " + n6);
                }
                n6 = this._nextsib(i);
                if (-1 == n6) {
                    ((PrintStream)object).println("Next sibling: DTM.NULL");
                } else if (-2 == n6) {
                    ((PrintStream)object).println("Next sibling: NOTPROCESSED");
                } else {
                    ((PrintStream)object).println("Next sibling: " + n6);
                }
                int n7 = this._parent(i);
                if (-1 == n7) {
                    ((PrintStream)object).println("Parent: DTM.NULL");
                } else if (-2 == n7) {
                    ((PrintStream)object).println("Parent: NOTPROCESSED");
                } else {
                    ((PrintStream)object).println("Parent: " + n7);
                }
                int n8 = this._level(i);
                ((PrintStream)object).println("Level: " + n8);
                ((PrintStream)object).println("Node Value: " + this.getNodeValue(n2));
                ((PrintStream)object).println("String Value: " + this.getStringValue(n2));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public String dumpNode(int n) {
        String string;
        if (n == -1) {
            return "[null]";
        }
        switch (this.getNodeType(n)) {
            case 2: {
                string = "ATTR";
                break;
            }
            case 4: {
                string = "CDATA";
                break;
            }
            case 8: {
                string = "COMMENT";
                break;
            }
            case 11: {
                string = "DOC_FRAG";
                break;
            }
            case 9: {
                string = "DOC";
                break;
            }
            case 10: {
                string = "DOC_TYPE";
                break;
            }
            case 1: {
                string = "ELEMENT";
                break;
            }
            case 6: {
                string = "ENTITY";
                break;
            }
            case 5: {
                string = "ENT_REF";
                break;
            }
            case 13: {
                string = "NAMESPACE";
                break;
            }
            case 12: {
                string = "NOTATION";
                break;
            }
            case -1: {
                string = "null";
                break;
            }
            case 7: {
                string = "PI";
                break;
            }
            case 3: {
                string = "TEXT";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + n + ": " + string + "(0x" + Integer.toHexString(this.getExpandedTypeID(n)) + ") " + this.getNodeNameX(n) + " {" + this.getNamespaceURI(n) + "}" + "=\"" + this.getNodeValue(n) + "\"]");
        return stringBuffer.toString();
    }

    public void setFeature(String string, boolean bl) {
    }

    public boolean hasChildNodes(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._firstch(n2);
        return n3 != -1;
    }

    public final int makeNodeHandle(int n) {
        if (-1 == n) {
            return -1;
        }
        return this.m_dtmIdent.elementAt(n >>> 16) + (n & 0xFFFF);
    }

    public final int makeNodeIdentity(int n) {
        if (-1 == n) {
            return -1;
        }
        if (this.m_mgrDefault != null) {
            int n2 = n >>> 16;
            if (this.m_mgrDefault.m_dtms[n2] != this) {
                return -1;
            }
            return this.m_mgrDefault.m_dtm_offsets[n2] | n & 0xFFFF;
        }
        int n3 = this.m_dtmIdent.indexOf(n & 0xFFFF0000);
        return n3 == -1 ? -1 : (n3 << 16) + (n & 0xFFFF);
    }

    public int getFirstChild(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._firstch(n2);
        return this.makeNodeHandle(n3);
    }

    public int getTypedFirstChild(int n, int n2) {
        if (n2 < 14) {
            int n3 = this._firstch(this.makeNodeIdentity(n));
            while (n3 != -1) {
                int n4 = this._exptype2(n3);
                if (n4 == n2 || n4 >= 14 && this.m_expandedNameTable.getType(n4) == n2) {
                    return this.makeNodeHandle(n3);
                }
                n3 = this._nextsib(n3);
            }
        } else {
            int n5 = this._firstch(this.makeNodeIdentity(n));
            while (n5 != -1) {
                if (this._exptype2(n5) == n2) {
                    return this.makeNodeHandle(n5);
                }
                n5 = this._nextsib(n5);
            }
        }
        return -1;
    }

    public int getLastChild(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._firstch(n2);
        int n4 = -1;
        while (n3 != -1) {
            n4 = n3;
            n3 = this._nextsib(n3);
        }
        return this.makeNodeHandle(n4);
    }

    public abstract int getAttributeNode(int var1, String var2, String var3);

    public final int getFirstAttribute(int n) {
        block2: {
            int n2 = this.makeNodeIdentity(n);
            if (n2 == -1) {
                return -1;
            }
            int n3 = this._type2(n2);
            if (1 != n3) break block2;
            do {
                if ((n3 = this._type2(++n2)) != 2) continue;
                return this.makeNodeHandle(n2);
            } while (13 == n3);
        }
        return -1;
    }

    public int _firstAttribute(int n) {
        block1: {
            int n2 = this._type2(n);
            if (1 != n2) break block1;
            do {
                if ((n2 = this._type2(++n)) != 2) continue;
                return n;
            } while (13 == n2);
        }
        return -1;
    }

    public final int getTypedAttribute(int n, int n2) {
        block4: {
            int n3 = this.makeNodeIdentity(n);
            if (n3 == -1) {
                return -1;
            }
            int n4 = this._type2(n3);
            if (1 != n4) break block4;
            while (true) {
                int n5;
                if ((n5 = this._exptype2(++n3)) == -1) {
                    return -1;
                }
                n4 = this.m_extendedTypes[n5].getNodeType();
                if (n4 == 2) {
                    if (n5 != n2) continue;
                    return this.makeNodeHandle(n3);
                }
                if (13 != n4) break;
            }
        }
        return -1;
    }

    public int getNextSibling(int n) {
        if (n == -1) {
            return -1;
        }
        return this.makeNodeHandle(this._nextsib(this.makeNodeIdentity(n)));
    }

    public int getTypedNextSibling(int n, int n2) {
        int n3;
        if (n == -1) {
            return -1;
        }
        int n4 = this.makeNodeIdentity(n);
        while ((n4 = this._nextsib(n4)) != -1 && (n3 = this._exptype2(n4)) != n2 && this.m_expandedNameTable.getType(n3) != n2) {
        }
        return n4 == -1 ? -1 : this.makeNodeHandle(n4);
    }

    public int getPreviousSibling(int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = this._prevsib2(this.makeNodeIdentity(n));
        if (n2 > 0) {
            return this.makeNodeHandle(n2);
        }
        int n3 = this.makeNodeIdentity(n);
        if (n3 > 0) {
            int n4;
            int n5;
            int n6 = this._type2(n3);
            if (2 == n6 || 13 == n6) {
                n5 = n3;
            } else {
                n4 = this._parent(n3);
                n5 = this._firstch(n4);
            }
            n4 = -1;
            while (n5 != n3) {
                n4 = n5;
                n5 = this._nextsib(n5);
            }
            return this.makeNodeHandle(n4);
        }
        return -1;
    }

    public int getNextAttribute(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (this._type2(n2) == 2) {
            return this.makeNodeHandle(this._nextAttribute(n2));
        }
        return -1;
    }

    public int _nextAttribute(int n) {
        int n2;
        do {
            if ((n2 = this._type2(++n)) != 2) continue;
            return n;
        } while (n2 == 13);
        return -1;
    }

    protected void declareNamespaceInContext(int n, int n2) {
        int n3;
        int n4;
        SuballocatedIntVector suballocatedIntVector = null;
        if (this.m_namespaceDeclSets == null) {
            this.m_namespaceDeclSetElements = new SuballocatedIntVector(32);
            this.m_namespaceDeclSetElements.addElement(n);
            this.m_namespaceDeclSets = new Vector();
            suballocatedIntVector = new SuballocatedIntVector(32);
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
        } else {
            n4 = this.m_namespaceDeclSetElements.size() - 1;
            if (n4 >= 0 && n == this.m_namespaceDeclSetElements.elementAt(n4)) {
                suballocatedIntVector = (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n4);
            }
        }
        if (suballocatedIntVector == null) {
            this.m_namespaceDeclSetElements.addElement(n);
            SuballocatedIntVector suballocatedIntVector2 = this.findNamespaceContext(this._parent(n));
            if (suballocatedIntVector2 != null) {
                n3 = suballocatedIntVector2.size();
                suballocatedIntVector = new SuballocatedIntVector(Math.max(Math.min(n3 + 16, 2048), 32));
                for (int i = 0; i < n3; ++i) {
                    suballocatedIntVector.addElement(suballocatedIntVector2.elementAt(i));
                }
            } else {
                suballocatedIntVector = new SuballocatedIntVector(32);
            }
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
        }
        n4 = this._exptype(n2);
        for (n3 = suballocatedIntVector.size() - 1; n3 >= 0; --n3) {
            if (n4 != this.getExpandedTypeIDForBT(suballocatedIntVector.elementAt(n3))) continue;
            suballocatedIntVector.setElementAt(this.makeNodeHandle(n2), n3);
            return;
        }
        suballocatedIntVector.addElement(this.makeNodeHandle(n2));
    }

    protected SuballocatedIntVector findNamespaceContext(int n) {
        int n2 = this.getNamespaceContextOffset(n);
        if (n2 >= 0) {
            return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n2);
        }
        return null;
    }

    protected int getNamespaceContextOffset(int n) {
        if (null != this.m_namespaceDeclSetElements) {
            int n2 = this.findInSortedSuballocatedIntVector(this.m_namespaceDeclSetElements, n);
            if (n2 >= 0) {
                return n2;
            }
            if (n2 == -1) {
                return -1;
            }
            n2 = -1 - n2;
            int n3 = this.m_namespaceDeclSetElements.elementAt(--n2);
            int n4 = this._parent(n);
            if (n2 == 0 && n3 < n4) {
                int n5;
                int n6 = this.getDocumentRoot(this.makeNodeHandle(n));
                int n7 = this.makeNodeIdentity(n6);
                int n8 = this.getNodeType(n6) == 9 ? ((n5 = this._firstch(n7)) != -1 ? n5 : n7) : n7;
                if (n3 == n8) {
                    return n2;
                }
            }
            while (n2 >= 0 && n4 > 0) {
                if (n3 == n4) {
                    return n2;
                }
                if (n3 < n4) {
                    while (n3 < (n4 = this._parent(n4))) {
                    }
                    continue;
                }
                if (n2 <= 0) break;
                n3 = this.m_namespaceDeclSetElements.elementAt(--n2);
            }
        }
        return -1;
    }

    protected int findInSortedSuballocatedIntVector(SuballocatedIntVector suballocatedIntVector, int n) {
        int n2 = 0;
        if (suballocatedIntVector != null) {
            int n3 = 0;
            int n4 = suballocatedIntVector.size() - 1;
            while (n3 <= n4) {
                n2 = (n3 + n4) / 2;
                int n5 = n - suballocatedIntVector.elementAt(n2);
                if (n5 == 0) {
                    return n2;
                }
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
        }
        return -1 - n2;
    }

    public int getFirstNamespaceNode(int n, boolean bl) {
        if (bl) {
            int n2 = this.makeNodeIdentity(n);
            if (this._type2(n2) == 1) {
                SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n2);
                if (suballocatedIntVector == null || suballocatedIntVector.size() < 1) {
                    return -1;
                }
                return suballocatedIntVector.elementAt(0);
            }
            return -1;
        }
        int n3 = this.makeNodeIdentity(n);
        if (this._type2(n3) == 1) {
            while (-1 != (n3 = this._nextNode(n3))) {
                int n4 = this._type2(n3);
                if (n4 == 13) {
                    return this.makeNodeHandle(n3);
                }
                if (2 == n4) continue;
                break;
            }
            return -1;
        }
        return -1;
    }

    public int getNextNamespaceNode(int n, int n2, boolean bl) {
        if (bl) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(this.makeNodeIdentity(n));
            if (suballocatedIntVector == null) {
                return -1;
            }
            int n3 = 1 + suballocatedIntVector.indexOf(n2);
            if (n3 <= 0 || n3 == suballocatedIntVector.size()) {
                return -1;
            }
            return suballocatedIntVector.elementAt(n3);
        }
        int n4 = this.makeNodeIdentity(n2);
        while (-1 != (n4 = this._nextNode(n4))) {
            int n5 = this._type(n4);
            if (n5 == 13) {
                return this.makeNodeHandle(n4);
            }
            if (n5 == 2) continue;
            break;
        }
        return -1;
    }

    public final SuballocatedIntVector startInScopeNamespaceSearch(int n) {
        if (n == -1) {
            return null;
        }
        if (this._type2(n) == 1) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n);
            if (suballocatedIntVector == null || suballocatedIntVector.size() < 1) {
                return null;
            }
            int n2 = suballocatedIntVector.size();
            for (int i = 0; i < n2; ++i) {
                if (this._nodeValue(this.makeNodeIdentity(suballocatedIntVector.elementAt(i))) != null) continue;
                suballocatedIntVector.removeElementAt(i);
                --n2;
                --i;
            }
            return suballocatedIntVector;
        }
        return null;
    }

    public final int[] getInScopeNamespaceTable(int n) {
        if (n == -1) {
            return EMPTY_NAMESPACE_TABLE;
        }
        if (this._type2(n) == 1) {
            SuballocatedIntVector suballocatedIntVector;
            int n2;
            int n3 = this.getNamespaceContextOffset(n);
            if (n3 < 0) {
                return null;
            }
            if (this.m_namespaceTables == null) {
                this.m_namespaceTables = new HashMap(32);
                this.m_namespaceTablesWithDefault = new HashMap(32);
                this.XML_ID = this.m_expandedNameTable.getExpandedTypeID(EMPTY_STR, "xml", 13, false);
                this.EMPTY_ID = this.m_expandedNameTable.getExpandedTypeID(EMPTY_STR, EMPTY_STR, 13, false);
            }
            boolean bl = this._prefix(n).length() == 0;
            Integer n4 = new Integer(n3);
            if (bl) {
                if (this.m_namespaceTablesWithDefault.containsKey(n4)) {
                    return (int[])this.m_namespaceTablesWithDefault.get(n4);
                }
                if (this.m_namespaceTables.containsKey(n4)) {
                    return this.createNamespaceTableWithDefault((int[])this.m_namespaceTables.get(n4), n4);
                }
            } else if (this.m_namespaceTables.containsKey(n4)) {
                return (int[])this.m_namespaceTables.get(n4);
            }
            if ((n2 = (suballocatedIntVector = (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n3)).size()) <= 0) {
                return EMPTY_NAMESPACE_TABLE;
            }
            int[] nArray = new int[(n2 - 1) * 2];
            boolean bl2 = false;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                int n6 = this.makeNodeIdentity(suballocatedIntVector.elementAt(i));
                int n7 = this._exptype2(n6);
                if (n7 == this.XML_ID) continue;
                if (n7 == this.EMPTY_ID) {
                    bl2 = true;
                }
                int n8 = this._namespaceURIID(n6);
                nArray[n5++] = n7;
                nArray[n5++] = n8;
            }
            this.m_namespaceTables.put(n4, nArray);
            if (bl2) {
                this.m_namespaceTablesWithDefault.put(n4, nArray);
            }
            if (bl && !bl2) {
                return this.createNamespaceTableWithDefault(nArray, n4);
            }
            return nArray;
        }
        return EMPTY_NAMESPACE_TABLE;
    }

    private final int[] createNamespaceTableWithDefault(int[] nArray, Integer n) {
        int[] nArray2 = new int[nArray.length + 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[nArray.length] = this.EMPTY_ID;
        nArray2[nArray.length + 1] = this.EMPTY_ID;
        this.m_namespaceTablesWithDefault.put(n, nArray2);
        return nArray2;
    }

    public final int getInScopeNamespaceIdentity(SuballocatedIntVector suballocatedIntVector, int n) {
        if (suballocatedIntVector == null) {
            return -1;
        }
        if (n < 0 || n == suballocatedIntVector.size()) {
            return -1;
        }
        return this.makeNodeIdentity(suballocatedIntVector.elementAt(n));
    }

    public int getFirstNamespaceIdentity(int n, boolean bl) {
        if (bl) {
            if (this._type2(n) == 1) {
                SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n);
                if (suballocatedIntVector == null || suballocatedIntVector.size() < 1) {
                    return -1;
                }
                return this.makeNodeIdentity(suballocatedIntVector.elementAt(0));
            }
            return -1;
        }
        if (this._type2(n) == 1) {
            while (-1 != (n = this._nextNode(n))) {
                int n2 = this._type2(n);
                if (n2 == 13) {
                    return n;
                }
                if (2 == n2) continue;
                break;
            }
            return -1;
        }
        return -1;
    }

    public int getNextNamespaceIdentity(int n, int n2, boolean bl) {
        if (bl) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n);
            if (suballocatedIntVector == null) {
                return -1;
            }
            int n3 = 1 + suballocatedIntVector.indexOf(this.makeNodeHandle(n2));
            if (n3 <= 0 || n3 == suballocatedIntVector.size()) {
                return -1;
            }
            return this.makeNodeIdentity(suballocatedIntVector.elementAt(n3));
        }
        while (-1 != (n2 = this._nextNode(n2))) {
            int n4 = this._type(n2);
            if (n4 == 13) {
                return n2;
            }
            if (n4 == 2) continue;
            break;
        }
        return -1;
    }

    public int getParent(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (n2 > 0) {
            return this.makeNodeHandle(this._parent(n2));
        }
        return -1;
    }

    public int getDocument() {
        return this.m_dtmIdent.elementAt(0);
    }

    public int _document() {
        return this.makeNodeIdentity(this.m_dtmIdent.elementAt(0));
    }

    public int getOwnerDocument(int n) {
        if (9 == this.getNodeType(n)) {
            return -1;
        }
        return this.getDocumentRoot(n);
    }

    public int getDocumentRoot(int n) {
        return this.getDocument();
    }

    public int _documentRoot(int n) {
        return 0;
    }

    public abstract XMLString _stringValue(int var1);

    public abstract int _copyStringValue(int var1, char[] var2, int var3, int var4);

    public abstract int _copyNodeValue(int var1, char[] var2, int var3, int var4);

    public abstract String _stringValueX(int var1);

    public abstract XMLString getStringValue(int var1);

    public int getStringValueChunkCount(int n) {
        this.error(XMLMessages.createXMLMessage("ERR_SYSTEM", "Method not yet supported "));
        return 0;
    }

    public char[] getStringValueChunk(int n, int n2, int[] nArray) {
        this.error(XMLMessages.createXMLMessage("ERR_SYSTEM", "Method not yet supported "));
        return null;
    }

    public int getExpandedTypeID(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (n2 == -1) {
            return -1;
        }
        return this._exptype2(n2);
    }

    public final int getExpandedTypeIDForBT(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (n2 == -1) {
            return -1;
        }
        return this._exptype(n2);
    }

    public int getExpandedTypeID(String string, String string2, int n) {
        return this.m_expandedNameTable.getExpandedTypeID(string, string2, n, false);
    }

    public String getLocalNameFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getLocalName(n);
    }

    public String getNamespaceFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getNamespace(n);
    }

    public int getTypeFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getType(n);
    }

    public int getExpandedNameTableLength() {
        return this.m_expandedNameTable.getSize();
    }

    public int getNamespaceType(int n) {
        int n2 = this.makeNodeIdentity(n);
        int n3 = this._exptype2(n2);
        return this.m_expandedNameTable.getNamespaceID(n3);
    }

    public abstract String getNodeName(int var1);

    public abstract String _nodeName(int var1);

    public abstract String getNodeNameX(int var1);

    public abstract String _nodeNameX(int var1);

    public abstract String getLocalName(int var1);

    public abstract String _localName(int var1);

    public abstract String getPrefix(int var1);

    public abstract String _prefix(int var1);

    public abstract String getNamespaceURI(int var1);

    public abstract String _namespaceURI(int var1);

    public abstract String getNodeValue(int var1);

    public abstract String _nodeValue(int var1);

    public int getNodeType(int n) {
        if (n == -1) {
            return -1;
        }
        return this.m_expandedNameTable.getType(this._exptype2(this.makeNodeIdentity(n)));
    }

    public short getLevel(int n) {
        int n2 = this.makeNodeIdentity(n);
        return (short)(this._level(n2) + 1);
    }

    public int getNodeIdent(int n) {
        return this.makeNodeIdentity(n);
    }

    public int getNodeHandle(int n) {
        return this.makeNodeHandle(n);
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getDocumentBaseURI() {
        return this.m_documentBaseURI;
    }

    public void setDocumentBaseURI(String string) {
        this.m_documentBaseURI = string;
    }

    public String getDocumentSystemIdentifier(int n) {
        return this.m_documentBaseURI;
    }

    public String getDocumentEncoding(int n) {
        return "UTF-8";
    }

    public String getDocumentStandalone(int n) {
        return null;
    }

    public String getDocumentVersion(int n) {
        return null;
    }

    public boolean getDocumentAllDeclarationsProcessed() {
        return true;
    }

    public abstract String getDocumentTypeDeclarationSystemIdentifier();

    public abstract String getDocumentTypeDeclarationPublicIdentifier();

    public abstract int getElementById(String var1);

    public abstract String getUnparsedEntityURI(String var1);

    public abstract String getUnparsedEntityPublicID(String var1);

    public boolean supportsPreStripping() {
        return true;
    }

    public boolean isNodeAfter(int n, int n2) {
        int n3 = this.makeNodeIdentity(n);
        int n4 = this.makeNodeIdentity(n2);
        return n3 != -1 & n4 != -1 & n3 <= n4;
    }

    public boolean isCharacterElementContentWhitespace(int n) {
        return false;
    }

    public boolean isDocumentAllDeclarationsProcessed(int n) {
        return true;
    }

    public abstract boolean isAttributeSpecified(int var1);

    public abstract void dispatchCharactersEvents(int var1, ContentHandler var2, boolean var3) throws SAXException;

    public abstract void _dispatchCharactersEvents(int var1, ContentHandler var2, boolean var3) throws SAXException;

    public abstract void dispatchToEvents(int var1, ContentHandler var2) throws SAXException;

    public Node getNode(int n) {
        return new DTMNodeProxy(this, n);
    }

    public Node _node(int n) {
        return new DTMNodeProxy(this, this.makeNodeHandle(n));
    }

    public int getDTMHandleFromNode(Node node) {
        return -1;
    }

    public int getDTMIdentityFromNode(Node node) {
        return -1;
    }

    public void appendChild(int n, boolean bl, boolean bl2) {
        this.error(XMLMessages.createXMLMessage("ERR_SYSTEM", "Method not yet supported"));
    }

    public void appendTextChild(String string) {
        this.error(XMLMessages.createXMLMessage("ERR_SYSTEM", "Method not yet supported "));
    }

    protected void error(String string) {
        throw new DTMException(string);
    }

    protected boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS && !this.m_isXMLSpacePreserve;
    }

    protected void pushShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWhitespaceStack.push(bl);
        }
    }

    protected void popShouldStripWhitespace() {
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
    }

    protected void pushXMLSpace(boolean bl) {
        this.m_isXMLSpacePreserve = bl;
        this.m_XMLSpaceStack.push(bl);
    }

    protected void popXMLSpace() {
        this.m_isXMLSpacePreserve = this.m_XMLSpaceStack.popAndTop();
    }

    protected boolean peekXMLSpace() {
        if (this.m_XMLSpaceStack.isEmpty()) {
            return false;
        }
        return this.m_XMLSpaceStack.peek();
    }

    protected void setShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        if (null != this.m_shouldStripWhitespaceStack) {
            this.m_shouldStripWhitespaceStack.setTop(bl);
        }
    }

    public void documentRegistration() {
    }

    public void documentRelease() {
    }

    public void migrateTo(DTMManager dTMManager) {
        this.m_mgr = dTMManager;
        if (dTMManager instanceof DTMManagerDefault) {
            this.m_mgrDefault = (DTMManagerDefault)dTMManager;
        }
    }

    public DTMManager getManager() {
        return this.m_mgr;
    }

    public SuballocatedIntVector getDTMIDs() {
        if (this.m_mgr == null) {
            return null;
        }
        return this.m_dtmIdent;
    }

    public QName _schemaTypeName(int n) {
        if (n != -1) {
            int n2;
            XSTypeDefinition xSTypeDefinition = this.m_schemaTypeOverride.getTypeDefinition(n);
            if (xSTypeDefinition == null) {
                n2 = this._exptype2(n);
                xSTypeDefinition = this.m_expandedNameTable.getSchemaType(n2);
            }
            if (xSTypeDefinition != null) {
                if (xSTypeDefinition.getAnonymous()) {
                    return null;
                }
                String string = xSTypeDefinition.getNamespace();
                String string2 = string != null ? (string.equals("http://www.w3.org/2001/XMLSchema") ? "xs" : EMPTY_STR) : EMPTY_STR;
                String string3 = xSTypeDefinition.getName();
                return new QName(string, string3, string2);
            }
            n2 = this._exptype2(n);
            short s = this.m_expandedNameTable.getType(n2);
            if (s == 1) {
                return XDMNode.DEFELEMENTTYPENAME;
            }
            if (s == 2) {
                return XDMNode.DEFATTRIBUTETYPENAME;
            }
            if (s == 3) {
                return XDMNode.DEFTEXTTYPENAME;
            }
            return null;
        }
        return null;
    }

    public QName getSchemaTypeName(int n) {
        return this._schemaTypeName(this.makeNodeIdentity(n));
    }

    public String _schemaTypeNamespace(int n) {
        QName qName = this._schemaTypeName(n);
        return qName != null ? qName.getNamespaceURI() : EMPTY_STR;
    }

    public String getSchemaTypeNamespace(int n) {
        return this._schemaTypeNamespace(this.makeNodeIdentity(n));
    }

    public Object getSchemaTypeObject(int n) {
        int n2 = this.makeNodeIdentity(n);
        if (n2 != -1) {
            XSTypeDefinition xSTypeDefinition = this.getActualXSType(n2);
            return xSTypeDefinition;
        }
        return null;
    }

    public String getSchemaTypeLocalName(int n) {
        return this._schemaTypeLocalName(this.makeNodeIdentity(n));
    }

    public SparseSchemaInfo getSchemaTypeOverride() {
        return this.m_schemaTypeOverride;
    }

    public String _schemaTypeLocalName(int n) {
        QName qName = this._schemaTypeName(n);
        return qName != null ? qName.getLocalPart() : EMPTY_STR;
    }

    public boolean isNodeSchemaType(int n, String string, String string2) {
        return this._isNodeSchemaType(this.makeNodeIdentity(n), this.getNodeType(n), string, string2);
    }

    public boolean getIsNilled(int n) {
        return this._getIsNilled(this.makeNodeIdentity(n));
    }

    public int getBuiltInSimpleType(int n) {
        return this._getBuiltInSimpleType(this.makeNodeIdentity(n));
    }

    public boolean _isNodeSchemaType(int n, int n2, String string, String string2) {
        XSTypeDefinition xSTypeDefinition;
        if (n != -1 && (xSTypeDefinition = this.getActualXSType(n)) != null) {
            string = string != null && string.equals(EMPTY_STR) ? null : string;
            boolean bl = xSTypeDefinition.derivedFrom(string, string2, (short)3);
            return bl;
        }
        switch (n2) {
            case 1: {
                return null != string && null != string2 && string.equals("http://www.w3.org/2001/XMLSchema") && string2.equals("untyped");
            }
            case 2: {
                return null != string && null != string2 && string.equals("http://www.w3.org/2001/XMLSchema") && string2.equals("untypedAtomic");
            }
        }
        return false;
    }

    public int _getBuiltInSimpleType(int n) {
        XSTypeDefinition xSTypeDefinition;
        if (n != -1 && (xSTypeDefinition = this.getActualXSType(n)) != null && 16 == xSTypeDefinition.getTypeCategory()) {
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "boolean", (short)3)) {
                return 17;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "double", (short)3)) {
                return 3;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "float", (short)3)) {
                return 2;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "integer", (short)3)) {
                return 5;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "decimal", (short)3)) {
                return 4;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "dayTimeDuration", (short)3)) {
                return 8;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "untypedAtomic", (short)3)) {
                return 7;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "duration", (short)3)) {
                return 6;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "dateTime", (short)3)) {
                return 9;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "time", (short)3)) {
                return 10;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "date", (short)3)) {
                return 11;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYearMonth", (short)3)) {
                return 12;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYear", (short)3)) {
                return 13;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonthDay", (short)3)) {
                return 14;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gDay", (short)3)) {
                return 15;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonth", (short)3)) {
                return 16;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "hexBinary", (short)3)) {
                return 19;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "base64Binary", (short)3)) {
                return 18;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "anyURI", (short)3)) {
                return 20;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "QName", (short)3)) {
                return 21;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "NOTATION", (short)3)) {
                return 22;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "string", (short)3)) {
                return 1;
            }
            if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "untypedAtomic", (short)3)) {
                return 0;
            }
            return 46;
        }
        return 45;
    }

    public boolean _getIsNilled(int n) {
        int n2 = this.getNodeType(n);
        if (n2 != 1 || n == -1) {
            return false;
        }
        return this.m_schemaTypeOverride.isNilled(n);
    }

    protected XSTypeDefinition getActualXSType(int n) {
        XSTypeDefinition xSTypeDefinition = this.m_schemaTypeOverride.getTypeDefinition(n);
        if (xSTypeDefinition == null) {
            int n2 = this._exptype2(n);
            xSTypeDefinition = this.m_expandedNameTable.getSchemaType(n2);
        }
        return xSTypeDefinition;
    }

    public XDMSequence getTypedValue(int n) {
        return this._typedValue(this.makeNodeIdentity(n));
    }

    public XDMSequence _typedValue(int n) {
        return XDMSequence.EMPTY;
    }

    public final int[][] XYLEM_SPECIALIZATION_exptype_map() {
        return this.m_exptype_map;
    }

    public final int[][] XYLEM_SPECIALIZATION_nextsib_map() {
        return this.m_nextsib_map;
    }

    public final int[][] XYLEM_SPECIALIZATION_firstch_map() {
        return this.m_firstch_map;
    }

    public final int[][] XYLEM_SPECIALIZATION_parent_map() {
        return this.m_parent_map;
    }

    public final int[][] XYLEM_SPECIALIZATION_prevsib_map() {
        return this.m_prevsib_map;
    }

    public final int[] XYLEM_SPECIALIZATION_exptype_map0() {
        return this.m_exptype_map0;
    }

    public final int[] XYLEM_SPECIALIZATION_nextsib_map0() {
        return this.m_nextsib_map0;
    }

    public final int[] XYLEM_SPECIALIZATION_firstch_map0() {
        return this.m_firstch_map0;
    }

    public final int[] XYLEM_SPECIALIZATION_parent_map0() {
        return this.m_parent_map0;
    }

    public final int[] XYLEM_SPECIALIZATION_prevsib_map0() {
        return this.m_prevsib_map0;
    }

    public final int XYLEM_SPECIALIZATION_SHIFT() {
        return this.m_SHIFT;
    }

    public final int XYLEM_SPECIALIZATION_MASK() {
        return this.m_MASK;
    }

    public final int XYLEM_SPECIALIZATION_blocksize() {
        return this.m_blocksize;
    }

    public static final int XYLEM_SPECIALIZATION_TYPESHIFT() {
        return 24;
    }

    public static final int XYLEM_SPECIALIZATION_TYPEMASK() {
        return 0xFFFFFF;
    }
}

