/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.types;

import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.IDerivableType;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.NodeType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.XSequenceType;
import javax.xml.namespace.QName;

public class ElementType
extends NodeType {
    private Type m_elementType;
    private QName m_elementName;
    private QName[] m_subGroupNames;
    private boolean m_nillable;
    private boolean m_isDeclaration;

    public ElementType() {
        this(null, null, false);
    }

    public ElementType(QName qName, Type type) {
        this(qName, type, false);
    }

    public ElementType(QName qName, Type type, boolean bl) {
        this.m_elementName = qName;
        this.m_elementType = type;
        this.m_nillable = bl;
    }

    public ElementType(QName qName, QName[] qNameArray, Type type) {
        this.m_elementName = qName;
        this.m_elementType = type;
        this.m_subGroupNames = qNameArray;
        this.m_nillable = true;
        this.m_isDeclaration = true;
    }

    public boolean isNillable() {
        return this.m_nillable;
    }

    public boolean isDeclaration() {
        return this.m_isDeclaration;
    }

    public QName getElementName() {
        return this.m_elementName;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    public Type getAtomizedType() {
        if (this.m_elementType instanceof AnyAtomicType) {
            return this.m_elementType;
        }
        if (this.m_elementType == UNTYPEDANY) {
            return UNTYPEDATOMIC;
        }
        return UNTYPEDATOMIC;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("element(");
        if (this.m_elementName != null) {
            stringBuffer.append(this.m_elementName.toString());
        } else {
            stringBuffer.append('*');
        }
        stringBuffer.append(", ");
        if (this.m_elementType != null) {
            stringBuffer.append(this.m_elementType.toString());
        } else {
            stringBuffer.append('*');
        }
        if (this.m_nillable) {
            stringBuffer.append(", nillable");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ElementType) {
            ElementType elementType = (ElementType)object;
            return this.elementNameEquals(elementType) && this.elementTypeEquals(elementType) && this.m_nillable == elementType.isNillable();
        }
        return false;
    }

    private boolean elementNameEquals(ElementType elementType) {
        if (this.m_elementName != null) {
            return this.m_elementName.equals(elementType.getElementName());
        }
        return elementType.getElementName() == null;
    }

    private boolean elementTypeEquals(ElementType elementType) {
        if (this.m_elementType != null) {
            return this.m_elementType.equals(elementType.getElementType());
        }
        return elementType.getElementType() == null;
    }

    public int getId() {
        return 53;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int typeMatches(XSequenceType xSequenceType, boolean bl) {
        ItemType itemType = xSequenceType.getBaseType();
        if (itemType == Type.NODE) return 1;
        if (itemType == Type.ITEM) {
            return 1;
        }
        if (!(itemType instanceof ElementType)) return 0;
        ElementType elementType = (ElementType)itemType;
        QName qName = elementType.getElementName();
        Type type = elementType.getElementType();
        boolean bl2 = true;
        if (qName != null) {
            bl2 = qName.equals(this.m_elementName);
        }
        if (bl2) {
            if (type == null) return 1;
            if (!(this.m_elementType instanceof IDerivableType)) return 2;
            if (!((IDerivableType)((Object)this.m_elementType)).isDerivedFrom((IDerivableType)((Object)type))) return 0;
            return 1;
        }
        if (this.m_elementName != null) return 0;
        return 2;
    }

    public QName[] getSubGroupNames() {
        return this.m_subGroupNames;
    }
}

