/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xcollator;

import com.ibm.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xtq.xml.xcollator.Range;
import com.ibm.xtq.xml.xcollator.XCollator;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

abstract class CollatorImplBase
implements XCollator {
    private static final String EMPTY_STRING = "";
    final CollatorDeclarationImpl m_declaration;
    final Locale m_locale;
    final Stack m_messages = new Stack();

    CollatorImplBase(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        this.m_declaration = collatorDeclarationImpl;
        this.m_locale = locale;
    }

    public CollatorDeclaration getDeclaration() {
        return this.m_declaration;
    }

    private final Stack getMessages() {
        return this.m_messages;
    }

    abstract Range[] allOccurances(String var1, String var2);

    abstract Range firstOccurance(String var1, String var2);

    abstract Range lastOccurance(String var1, String var2);

    public boolean contains(String string, String string2) {
        if (string2.equals(EMPTY_STRING)) {
            return true;
        }
        if (string.equals(EMPTY_STRING)) {
            return false;
        }
        return this.firstOccurance(string, string2) != null;
    }

    public boolean startsWith(String string, String string2) {
        if (string2.equals(EMPTY_STRING)) {
            return true;
        }
        if (string.equals(EMPTY_STRING)) {
            return false;
        }
        Range range = this.firstOccurance(string, string2);
        return range != null && range.m_startOffset == 0;
    }

    public boolean endsWith(String string, String string2) {
        if (string2.equals(EMPTY_STRING)) {
            return true;
        }
        if (string.equals(EMPTY_STRING)) {
            return false;
        }
        Range range = this.lastOccurance(string, string2);
        return range != null && range.m_endOffset == string.length();
    }

    public String substringBefore(String string, String string2) {
        if (string2.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        if (string.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        Range range = this.firstOccurance(string, string2);
        if (range == null) {
            return EMPTY_STRING;
        }
        return string.substring(0, range.m_startOffset);
    }

    public String substringAfter(String string, String string2) {
        Range range;
        String string3 = string2.equals(EMPTY_STRING) ? string : (string.equals(EMPTY_STRING) ? EMPTY_STRING : ((range = this.lastOccurance(string, string2)) == null ? EMPTY_STRING : string.substring(range.m_endOffset)));
        return string3;
    }

    static final int formatCompareReturn(int n) {
        n = n > 0 ? 1 : (n < 0 ? -1 : 0);
        return n;
    }

    static Range[] convertFromVector(Vector vector) {
        int n = vector.size();
        Range[] rangeArray = new Range[n];
        for (int i = 0; i < n; ++i) {
            rangeArray[i] = (Range)vector.elementAt(i);
        }
        return rangeArray;
    }
}

