/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.dtm;

import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.URI;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.XMLString;
import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.LibraryUtilities;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XNode;
import com.ibm.xtq.xml.datamodel.XSequence;
import com.ibm.xtq.xml.datamodel.XSequenceBase;
import com.ibm.xtq.xml.datamodel.XString;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.dtm.DTM;
import com.ibm.xtq.xml.dtm.DTMManager;
import com.ibm.xtq.xml.dtm.utils.NodeVector;
import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.xdm.Axis;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMCursor_SAXBuildable;
import com.ibm.xtq.xml.xdm.XDMException;
import com.ibm.xtq.xml.xdm.XDMManager;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.XDMSequence;
import com.ibm.xtq.xml.xdm.XDMTreeWalker;
import com.ibm.xtq.xml.xdm.XType;
import com.ibm.xtq.xml.xdm.dtm.XDMEmptyCursorDTM;
import com.ibm.xtq.xml.xdm.dtm.XDMManagerDTM;
import com.ibm.xtq.xml.xdm.dtm.XDMSelfCursorDTM;
import com.ibm.xtq.xml.xdm.dtm.XDMTreeWalkerDTM;
import com.ibm.xtq.xml.xdm.dtm.XDMTypedSelfCursorDTM;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import javax.xml.transform.SourceLocator;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class XDMCursorDTM
extends XSequenceBase
implements XDMCursor_SAXBuildable,
Cloneable {
    protected int m_docnumber;
    protected DTM m_currentDTM;
    protected int m_startHandle;
    protected int m_currentHandle;
    protected boolean m_atomizedSequence = false;
    protected XNode m_nodeItem = null;

    public XDMCursorDTM(int n, DTMManager dTMManager, int n2) {
        this.m_currentDTM = dTMManager.getDTM(n2);
        this.m_startHandle = n2;
        this.m_docnumber = n;
    }

    public XDMCursorDTM(int n, DTM dTM, int n2) {
        this.m_currentDTM = dTM;
        this.m_startHandle = n2;
        this.m_docnumber = n;
    }

    public XDMCursorDTM(XDMCursorDTM xDMCursorDTM) {
        if (xDMCursorDTM != null) {
            this.m_currentDTM = xDMCursorDTM.m_currentDTM;
            this.m_startHandle = xDMCursorDTM.m_currentHandle;
            this.m_docnumber = xDMCursorDTM.m_docnumber;
        } else {
            this.m_currentHandle = -1;
            this.m_startHandle = -1;
        }
    }

    public abstract boolean isEmpty();

    public XDMCursor getAxisCursor(int n) {
        XDMSelfCursorDTM xDMSelfCursorDTM = null;
        switch (n) {
            case 21: {
                xDMSelfCursorDTM = new XDMEmptyCursorDTM();
                break;
            }
            case 13: {
                xDMSelfCursorDTM = new XDMSelfCursorDTM(this);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                break;
            }
            default: {
                throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Iterator for axis " + Axis.getName(n) + " is not implemented"));
            }
        }
        return xDMSelfCursorDTM;
    }

    public XDMCursor getTypedAxisCursor(int n, int n2) {
        XDMTypedSelfCursorDTM xDMTypedSelfCursorDTM = null;
        switch (n) {
            case 13: {
                xDMTypedSelfCursorDTM = new XDMTypedSelfCursorDTM(this, n2);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                break;
            }
            default: {
                throw new XDMException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Iterator for axis " + Axis.getName(n) + " is not implemented"));
            }
        }
        return xDMTypedSelfCursorDTM;
    }

    public abstract XDMCursor cloneXDMCursor();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public XDMCursor singleNode() {
        return new XDMSelfCursorDTM(this.m_docnumber, this.m_currentDTM, this.m_currentHandle);
    }

    public boolean hasChildNodes() {
        return this.m_currentDTM.hasChildNodes(this.m_currentHandle);
    }

    public XDMCursor getAttributeNode(String string, String string2) {
        return new XDMSelfCursorDTM(this.m_docnumber, this.m_currentDTM, this.m_currentDTM.getAttributeNode(this.m_currentHandle, string, string2));
    }

    public XDMCursor getDocumentRoot() {
        return new XDMSelfCursorDTM(this.m_docnumber, this.m_currentDTM, this.m_currentDTM.getDocumentRoot(this.m_currentHandle));
    }

    public abstract XDMCursor newContext(XDMCursor var1, Object var2, boolean var3);

    public XDMCursor newContext(XDMCursor xDMCursor) {
        XDMCursor xDMCursor2 = this.newContext(xDMCursor, null, true);
        return xDMCursor2;
    }

    public abstract void resetIteration();

    public abstract boolean nextNode();

    public abstract void detach();

    public abstract void allowDetachToRelease(boolean var1);

    public abstract void setShouldCacheNodes();

    public boolean isMutable() {
        return false;
    }

    public abstract int getCurrentPos();

    public abstract boolean setCurrentPos(int var1);

    public abstract XDMCursor item(int var1);

    public void setItem(XDMCursor xDMCursor, int n) {
        this.assertion(false, "setItem not supported by this iterator!");
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XMLMessages.createXMLMessage("ERR_SYSTEM", "Programmer assertion is incorrect! - " + string);
            RuntimeException runtimeException = new RuntimeException(string2);
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public abstract int getLength();

    public abstract XDMCursor cloneWithReset() throws CloneNotSupportedException;

    public abstract boolean isDocOrdered();

    public abstract int getAxis();

    public XMLString getStringValue() {
        return this.m_currentDTM.getStringValue(this.m_currentHandle);
    }

    public String getStringValueX() {
        return ((Object)this.m_currentDTM.getStringValue(this.m_currentHandle)).toString();
    }

    public int copyStringValue(char[] cArray, int n, int n2) {
        XMLString xMLString = this.m_currentDTM.getStringValue(this.m_currentHandle);
        int n3 = xMLString.length();
        if (n3 > n2) {
            return -n3;
        }
        xMLString.getChars(0, n3, cArray, n);
        return n3;
    }

    public int getStringValueChunkCount() {
        return this.m_currentDTM.getStringValueChunkCount(this.m_currentHandle);
    }

    public char[] getStringValueChunk(int n, int[] nArray) {
        return this.m_currentDTM.getStringValueChunk(this.m_currentHandle, n, nArray);
    }

    public int getExpandedTypeID() {
        return this.m_currentDTM.getExpandedTypeID(this.m_currentHandle);
    }

    public int getExpandedTypeID(String string, String string2, int n) {
        return this.m_currentDTM.getExpandedTypeID(string, string2, n);
    }

    public boolean expandedTypeIs(int n) {
        return this.getExpandedTypeID() == n;
    }

    public String getLocalNameFromExpandedNameID(int n) {
        return this.m_currentDTM.getLocalNameFromExpandedNameID(n);
    }

    public String getNamespaceFromExpandedNameID(int n) {
        return this.m_currentDTM.getNamespaceFromExpandedNameID(n);
    }

    public String getNodeName() {
        return this.m_currentDTM.getNodeName(this.m_currentHandle);
    }

    public String getNodeNameX() {
        return this.m_currentDTM.getNodeNameX(this.m_currentHandle);
    }

    public String getLocalName() {
        return this.m_currentDTM.getLocalName(this.m_currentHandle);
    }

    public String getPrefix() {
        return this.m_currentDTM.getPrefix(this.m_currentHandle);
    }

    public String getNamespaceURI() {
        if (this.isEmpty()) {
            return "";
        }
        String string = this.m_currentDTM.getNamespaceURI(this.m_currentHandle);
        return string == null ? "" : string;
    }

    public String getNodeValue() {
        return this.m_currentDTM.getNodeValue(this.m_currentHandle);
    }

    public int getNamespaceURIID() {
        return this.m_currentDTM.getNamespaceURIID(this.m_currentHandle);
    }

    public int copyNodeValue(char[] cArray, int n, int n2) {
        String string = this.m_currentDTM.getNodeValue(this.m_currentHandle);
        int n3 = string.length();
        if (n3 > n2) {
            return -n3;
        }
        string.getChars(0, n3, cArray, n);
        return n3;
    }

    public int getNodeType() {
        return this.m_currentDTM.getNodeType(this.m_currentHandle);
    }

    public boolean isSupported(String string, String string2) {
        return this.m_currentDTM.isSupported(string, string2);
    }

    public String getDocumentBaseURI() {
        return this.m_currentDTM.getDocumentBaseURI();
    }

    public void setDocumentBaseURI(String string) {
        this.m_currentDTM.setDocumentBaseURI(string);
    }

    public String getDocumentSystemIdentifier() {
        return this.m_currentDTM.getDocumentSystemIdentifier(this.m_currentHandle);
    }

    public String getDocumentEncoding() {
        return this.m_currentDTM.getDocumentEncoding(this.m_currentHandle);
    }

    public String getDocumentStandalone() {
        return this.m_currentDTM.getDocumentStandalone(this.m_currentHandle);
    }

    public String getDocumentVersion() {
        return this.m_currentDTM.getDocumentVersion(this.m_currentHandle);
    }

    public boolean getDocumentAllDeclarationsProcessed() {
        return this.m_currentDTM.getDocumentAllDeclarationsProcessed();
    }

    public String getDocumentTypeDeclarationSystemIdentifier() {
        return this.m_currentDTM.getDocumentTypeDeclarationSystemIdentifier();
    }

    public String getDocumentTypeDeclarationPublicIdentifier() {
        return this.m_currentDTM.getDocumentTypeDeclarationPublicIdentifier();
    }

    public XDMCursor getElementById(String string) {
        int n = this.m_currentDTM.getElementById(string);
        return new XDMSelfCursorDTM(this.m_docnumber, this.m_currentDTM, n);
    }

    public NodeVector getElementByIdref(String string) {
        return this.m_currentDTM.getElementByIdref(string);
    }

    public String getUnparsedEntityURI(String string) {
        return this.m_currentDTM.getUnparsedEntityURI(string);
    }

    public String getUnparsedEntityPublicID(String string) {
        return this.m_currentDTM.getUnparsedEntityPublicID(string);
    }

    public boolean supportsPreStripping() {
        return this.m_currentDTM.supportsPreStripping();
    }

    public boolean isSameNode(XDMNode xDMNode) {
        if (this.m_docnumber != xDMNode.getDocNumber()) {
            return false;
        }
        if (xDMNode instanceof XDMCursorDTM) {
            return this.m_currentHandle == ((XDMCursorDTM)xDMNode).m_currentHandle;
        }
        return xDMNode.isSameNode(this);
    }

    public boolean isInSameDocument(XDMNode xDMNode) {
        if (this.m_docnumber != xDMNode.getDocNumber()) {
            return false;
        }
        if (xDMNode instanceof XDMCursorDTM) {
            return this.m_currentDTM.getDocumentRoot(this.m_currentHandle) == this.m_currentDTM.getDocumentRoot(((XDMCursorDTM)xDMNode).m_currentHandle);
        }
        return xDMNode.isSameNode(this);
    }

    public int getDocNumber() {
        return this.m_docnumber;
    }

    public int relativeDocOrder(XDMNode xDMNode) {
        int n = this.m_docnumber - xDMNode.getDocNumber();
        if (n != 0) {
            return n;
        }
        if (xDMNode instanceof XDMCursorDTM) {
            int n2 = ((XDMCursorDTM)xDMNode).getCurrentHandle();
            if (this.m_currentHandle == n2) {
                return 0;
            }
            if (this.m_currentDTM.isNodeAfter(this.m_currentHandle, n2)) {
                return -1;
            }
            return 1;
        }
        return -xDMNode.relativeDocOrder(this);
    }

    public boolean isWhitespaceInElementContent() {
        return this.m_currentDTM.isCharacterElementContentWhitespace(this.m_currentHandle);
    }

    public boolean isDocumentAllDeclarationsProcessed() {
        return this.m_currentDTM.isDocumentAllDeclarationsProcessed(this.m_currentHandle);
    }

    public boolean isAttributeSpecified() {
        return this.m_currentDTM.isAttributeSpecified(this.m_currentHandle);
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler, boolean bl) throws SAXException {
        this.m_currentDTM.dispatchCharactersEvents(this.m_currentHandle, contentHandler, bl);
    }

    public void dispatchToEvents(ContentHandler contentHandler) throws SAXException {
        this.m_currentDTM.dispatchToEvents(this.m_currentHandle, contentHandler);
    }

    public Node getNode() {
        return this.m_currentDTM.getNode(this.m_currentHandle);
    }

    public XDMCursor getXDMCursorFromNode(Node node) {
        int n = this.m_currentDTM.getDTMHandleFromNode(node);
        return new XDMSelfCursorDTM(this.m_docnumber, this.m_currentDTM.getManager(), n);
    }

    public SourceLocator getSourceLocator() {
        return this.m_currentDTM.getSourceLocatorFor(this.m_currentHandle);
    }

    public QName getSchemaTypeName() {
        return this.m_currentDTM.getSchemaTypeName(this.m_currentHandle);
    }

    public String getSchemaTypeNamespace() {
        return this.m_currentDTM.getSchemaTypeNamespace(this.m_currentHandle);
    }

    public String getSchemaTypeLocalName() {
        return this.m_currentDTM.getSchemaTypeLocalName(this.m_currentHandle);
    }

    public boolean isNodeSchemaType(String string, String string2) {
        return this.m_currentDTM.isNodeSchemaType(this.m_currentHandle, string, string2);
    }

    public Object getSchemaTypeObject() {
        return this.m_currentDTM.getSchemaTypeObject(this.m_currentHandle);
    }

    public int getBuiltInSimpleType() {
        return this.m_currentDTM.getBuiltInSimpleType(this.m_currentHandle);
    }

    public boolean isNilled() {
        return this.m_currentDTM.getIsNilled(this.m_currentHandle);
    }

    public XDMSequence getTypedValue() {
        return this.m_currentDTM.getTypedValue(this.m_currentHandle);
    }

    public XDMTreeWalker getTreeWalker() {
        return new XDMTreeWalkerDTM(this);
    }

    public DTM getCurrentDTM() {
        return this.m_currentDTM;
    }

    public ContentHandler getContentHandler() {
        return this.m_currentDTM.getContentHandler();
    }

    public DTDHandler getDTDHandler() {
        return this.m_currentDTM.getDTDHandler();
    }

    public DeclHandler getDeclHandler() {
        return this.m_currentDTM.getDeclHandler();
    }

    public LexicalHandler getLexicalHandler() {
        return this.m_currentDTM.getLexicalHandler();
    }

    public int getCurrentHandle() {
        return this.m_currentHandle;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[...empty...]";
        }
        String string = this.getNodeValue();
        String string2 = string == null ? "" : "\"";
        return new StringBuffer("[").append(this.getNodeTypeName(this.getNodeType())).append(' ').append(this.getNodeName()).append(' ').append("\tValue=").append(string2).append(string).append(string2).append(']').toString();
    }

    private String getNodeTypeName(int n) {
        switch (n) {
            case 0: {
                return "ROOT";
            }
            case 1: {
                return "ELEMENT";
            }
            case 2: {
                return "ATTRIBUTE";
            }
            case 3: {
                return "TEXT";
            }
            case 4: {
                return "CDATA_SECTION";
            }
            case 5: {
                return "ENTITY_REFERENCE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION";
            }
            case 8: {
                return "COMMENT";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 10: {
                return "DOCUMENT_TYPE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT";
            }
            case 12: {
                return "NOTATION";
            }
            case 13: {
                return "NAMESPACE";
            }
        }
        return "UNKNOWN";
    }

    public XItem getCurrentItem() {
        if (this.m_atomizedSequence) {
            int n = this.getNodeType();
            String string = this.getStringValueX();
            switch (n) {
                case 7: 
                case 8: {
                    return new XString(string);
                }
            }
            return new XUntypedAtomic(string);
        }
        return this.getNodeAsXItem();
    }

    private XItem getNodeAsXItem() {
        if (this.m_nodeItem == null) {
            this.m_nodeItem = new XNode(this);
        }
        return this.m_nodeItem;
    }

    protected void checkForRuntimeTypeError(int n) {
        if (!this.m_currentDTM.isNodeSchemaType(this.m_currentHandle, "http://www.w3.org/2001/XMLSchema", XType.getLocalNameFromType(n)) || !this.m_atomizedSequence) {
            throw new TypeError();
        }
    }

    public boolean getCurrentItemAsBoolean() throws TypeError {
        this.checkForRuntimeTypeError(1);
        int n = this.getNodeType();
        if (n != 8 || n != 7) {
            return CastLibrary.toBoolean(this.getStringValueX());
        }
        throw new TypeError();
    }

    public BigDecimal getCurrentItemAsDecimal() throws TypeError {
        this.checkForRuntimeTypeError(9);
        int n = this.getNodeType();
        if (n != 8 || n != 7) {
            return CastLibrary.toDecimal(this.getStringValueX());
        }
        throw new TypeError();
    }

    public double getCurrentItemAsDouble() throws TypeError {
        this.checkForRuntimeTypeError(2);
        int n = this.getNodeType();
        if (n != 8 || n != 7) {
            return CastLibrary.toDouble(this.getStringValueX());
        }
        throw new TypeError();
    }

    public float getCurrentItemAsFloat() throws TypeError {
        this.checkForRuntimeTypeError(8);
        int n = this.getNodeType();
        if (n != 8 || n != 7) {
            return CastLibrary.toFloat(this.getStringValueX());
        }
        throw new TypeError();
    }

    public BigInteger getCurrentItemAsInteger() throws TypeError {
        this.checkForRuntimeTypeError(10);
        int n = this.getNodeType();
        if (n != 8 || n != 7) {
            return CastLibrary.toInteger(this.getStringValueX());
        }
        throw new TypeError();
    }

    public int getCurrentItemAsInt() {
        this.checkForRuntimeTypeError(10);
        int[] nArray = LibraryUtilities.parseIntegerfromStr(this.getStringValueX().toCharArray());
        if (nArray[0] == 1) {
            Assert.assertNotImplemented();
            return Integer.MIN_VALUE;
        }
        return nArray[1];
    }

    public XDMNode getCurrentItemAsNode() throws TypeError {
        return this;
    }

    public String getCurrentItemAsString() throws TypeError {
        this.checkForRuntimeTypeError(3);
        return this.getStringValueX();
    }

    public byte[] getCurrentItemAsBase64Binary() {
        this.checkForRuntimeTypeError(6);
        return LibraryUtilities.parseBase64Binary(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsDate() {
        this.checkForRuntimeTypeError(17);
        return LibraryUtilities.parseDate(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsDateTime() {
        this.checkForRuntimeTypeError(15);
        return LibraryUtilities.parseDateTime(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsDay() {
        this.checkForRuntimeTypeError(21);
        return LibraryUtilities.parseGDay(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsMonth() {
        this.checkForRuntimeTypeError(22);
        return LibraryUtilities.parseGMonth(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsMonthDay() {
        this.checkForRuntimeTypeError(20);
        return LibraryUtilities.parseGMonthDay(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsDuration() {
        this.checkForRuntimeTypeError(14);
        return LibraryUtilities.parseDuration(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsDayTimeDuration() {
        this.checkForRuntimeTypeError(24);
        return LibraryUtilities.parseDayTimeDuration(this.getStringValueX().toCharArray());
    }

    public byte[] getCurrentItemAsHexBinary() {
        this.checkForRuntimeTypeError(7);
        return LibraryUtilities.parseHexBinary(this.getStringValueX().toCharArray());
    }

    public QName getCurrentItemAsQName() {
        this.checkForRuntimeTypeError(12);
        return this.getQNameOrNotationValue();
    }

    public QName getCurrentItemAsNotation() {
        this.checkForRuntimeTypeError(13);
        return this.getQNameOrNotationValue();
    }

    protected QName getQNameOrNotationValue() {
        String string = this.getStringValueX();
        String string2 = Util.getPrefix(string);
        String string3 = Util.getLocalName(string);
        String string4 = XDMCursorDTM.lookupNamespaceURI(this, string2);
        return new QName(string4, string3, string2);
    }

    public int[] getCurrentItemAsTime() {
        this.checkForRuntimeTypeError(16);
        return LibraryUtilities.parseTime(this.getStringValueX().toCharArray());
    }

    public URI getCurrentItemAsURI() {
        this.checkForRuntimeTypeError(11);
        try {
            return new URI(this.getStringValueX());
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new TypeError();
        }
    }

    public int[] getCurrentItemAsYear() {
        this.checkForRuntimeTypeError(19);
        return LibraryUtilities.parseGYear(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsYearMonth() {
        this.checkForRuntimeTypeError(18);
        return LibraryUtilities.parseGYearMonth(this.getStringValueX().toCharArray());
    }

    public int[] getCurrentItemAsYearMonthDuration() {
        this.checkForRuntimeTypeError(23);
        return LibraryUtilities.parseYearMonthDuration(this.getStringValueX().toCharArray());
    }

    public ItemType getCurrentItemType() {
        if (this.m_currentDTM == null) {
            throw new TypeError();
        }
        int n = this.getNodeType();
        if (!this.m_atomizedSequence) {
            switch (n) {
                case 3: {
                    return Type.TEXT;
                }
                case 9: {
                    return Type.DOCUMENT;
                }
                case 13: {
                    return null;
                }
                case 8: {
                    return Type.COMMENT;
                }
                case 7: {
                    return Type.PI;
                }
                case 2: {
                    return Type.ATTRIBUTE;
                }
            }
            return Type.ELEMENT;
        }
        switch (n) {
            case 13: {
                return null;
            }
            case 7: 
            case 8: {
                return Type.STRING;
            }
        }
        return Type.UNTYPEDATOMIC;
    }

    public XItem getSingleton(boolean bl) throws TypeError {
        if (this.isEmpty()) {
            if (bl) {
                return null;
            }
            throw new TypeError();
        }
        if (this.getCurrentPos() > 1) {
            throw new TypeError();
        }
        XDMCursor xDMCursor = this.cloneXDMCursor();
        if (xDMCursor.nextNode()) {
            throw new TypeError();
        }
        return this.getCurrentItem();
    }

    public boolean isSingleton() {
        if (this.isEmpty() || this.getCurrentPos() > 1) {
            return false;
        }
        XDMCursor xDMCursor = this.cloneXDMCursor();
        return !xDMCursor.nextNode();
    }

    public boolean next() {
        return this.nextNode();
    }

    public XSequence setAtomized() {
        this.m_atomizedSequence = true;
        return this;
    }

    public XDMManager getXDMManager() {
        DTMManager dTMManager = this.m_currentDTM.getManager();
        XDMManagerFactory xDMManagerFactory = dTMManager.getManagerFactory();
        return xDMManagerFactory.get(XDMManagerDTM.class);
    }

    public static String lookupNamespaceURI(XDMCursor xDMCursor, String string) {
        XDMCursor xDMCursor2;
        int n = xDMCursor.getNodeType();
        if (n != 1) {
            xDMCursor = xDMCursor.getTypedAxisCursor(10, 1);
        }
        if (!xDMCursor.isEmpty() && !(xDMCursor2 = xDMCursor.getAxisCursor(9)).isEmpty()) {
            do {
                String string2 = xDMCursor2.getNodeName();
                String string3 = "";
                if (string2.indexOf(58) > 0) {
                    string3 = Util.getLocalName(string2);
                }
                if (!string3.equals(string)) continue;
                String string4 = xDMCursor2.getNodeValue();
                return string4;
            } while (xDMCursor2.next());
        }
        return "";
    }
}

