/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;
import java.util.Vector;

public class XDMCacheCursor
extends XDMCursorProxyCursor {
    XDMCursor m_source;
    Vector m_cache = new Vector();
    int m_position = 0;
    int m_length = -1;
    boolean m_isDocOrdered;
    boolean m_keepDocOrdered = false;
    boolean m_keepUnique = false;

    public XDMCacheCursor(XDMCursor xDMCursor, boolean bl, boolean bl2) {
        super(null);
        this.m_source = xDMCursor;
        this.m_keepDocOrdered = bl;
        this.m_keepUnique = bl2;
        this.init(false);
    }

    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        if (bl) {
            return new XDMCacheCursor(this.m_source.newContext(xDMCursor, object, true), this.m_keepDocOrdered, this.m_keepUnique);
        }
        this.m_source = this.m_source.newContext(xDMCursor, object, false);
        this.init(false);
        return this;
    }

    private void init(boolean bl) {
        this.m_cache.clear();
        this.m_position = 0;
        if (bl) {
            this.m_source.resetIteration();
        }
        if (this.m_source.isEmpty()) {
            this.m_length = 0;
            this.m_currentCursor = null;
        } else {
            boolean bl2 = this.m_keepDocOrdered && !this.m_source.isDocOrdered();
            boolean bl3 = this.m_keepUnique && !this.m_source.isUniqueNodes();
            boolean bl4 = bl3 || bl2;
            this.m_currentCursor = this.m_source.singleNode();
            this.m_cache.addElement(this.m_currentCursor);
            if (bl4) {
                while (this.m_source.nextNode()) {
                    this.m_cache.addElement(this.m_source.singleNode());
                }
                if (bl2) {
                    XDMCacheCursor.quicksort(this.m_cache, 0, this.m_cache.size() - 1);
                }
                if (bl3) {
                    int n = 0;
                    int n2 = this.m_cache.size();
                    XDMCursor xDMCursor = (XDMCursor)this.m_cache.get(0);
                    for (int i = 1; i < n2; ++i) {
                        XDMCursor xDMCursor2 = (XDMCursor)this.m_cache.get(i);
                        if (xDMCursor2.isSameNode(xDMCursor)) continue;
                        xDMCursor = xDMCursor2;
                        if (++n == i) continue;
                        this.m_cache.set(n, xDMCursor);
                    }
                    this.m_cache.setSize(n + 1);
                }
                this.m_length = this.m_cache.size();
                this.m_currentCursor = (XDMCursor)this.m_cache.elementAt(0);
            } else {
                this.m_length = -1;
            }
        }
    }

    private static void quicksort(Vector vector, int n, int n2) {
        if (n < n2) {
            int n3 = XDMCacheCursor.partition(vector, n, n2);
            XDMCacheCursor.quicksort(vector, n, n3);
            XDMCacheCursor.quicksort(vector, n3 + 1, n2);
        }
    }

    private static int partition(Vector vector, int n, int n2) {
        XDMCursor xDMCursor = (XDMCursor)vector.get(n + n2 >>> 1);
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (xDMCursor.relativeDocOrder((XDMCursor)vector.get(--n4)) < 0) {
                continue;
            }
            while (xDMCursor.relativeDocOrder((XDMCursor)vector.get(++n3)) > 0) {
            }
            if (n3 >= n4) break;
            vector.set(n4, vector.set(n3, vector.get(n4)));
        }
        return n4;
    }

    public boolean setDocOrdered() {
        if (this.m_keepDocOrdered) {
            this.m_keepDocOrdered = true;
            this.init(true);
        }
        return true;
    }

    public boolean setDocOrderedUnique() {
        if (this.m_keepDocOrdered && this.m_keepUnique) {
            this.m_keepUnique = true;
            this.m_keepDocOrdered = true;
            this.init(true);
        }
        return true;
    }

    public boolean isDocOrdered() {
        return this.m_isDocOrdered;
    }

    public boolean isUniqueNodes() {
        return this.m_keepUnique;
    }

    public boolean nextNode() {
        if (this.m_position + 1 < this.m_length || this.m_position + 1 < this.m_cache.size()) {
            this.m_currentCursor = (XDMCursor)this.m_cache.elementAt(++this.m_position);
            return true;
        }
        if (this.m_source.nextNode()) {
            if (this.m_keepUnique) {
                while (this.m_source.isSameNode(this.m_currentCursor)) {
                    if (this.m_source.nextNode()) continue;
                    this.m_length = this.m_position + 1;
                    return false;
                }
            }
            this.m_currentCursor = this.m_source.singleNode();
            this.m_cache.addElement(this.m_currentCursor);
            ++this.m_position;
            return true;
        }
        this.m_length = this.m_position + 1;
        return false;
    }

    public int getLength() {
        if (this.m_length < 0) {
            while (this.nextNode()) {
            }
        }
        return this.m_length;
    }

    public boolean setCurrentPos(int n) {
        if (--n < this.m_position) {
            this.m_position = n;
        } else {
            while (n > this.m_position && this.nextNode()) {
            }
        }
        return n == this.m_position;
    }

    public void resetIteration() {
        if (this.m_position != 0) {
            this.m_position = 0;
            this.m_currentCursor = (XDMCursor)this.m_cache.elementAt(0);
        }
    }

    public XDMCursor cloneWithReset() throws CloneNotSupportedException {
        XDMCursor xDMCursor = this.cloneXDMCursor();
        xDMCursor.resetIteration();
        return xDMCursor;
    }

    public boolean isMutable() {
        return false;
    }

    public int getCurrentPos() {
        return this.m_position + 1;
    }
}

