/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xylem.drivers.IXylemDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Compiler
implements IXylemDriver {
    static final Logger s_logger;
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();

    public static void main(String[] stringArray) {
        CLP cLP = new CLP();
        Compiler compiler = cLP.m_compiler = new Compiler();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        compiler.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        try {
            List list = compiler.compileFiles(cLP, null, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List compileFiles(CLP cLP, Collection collection, boolean bl, boolean bl2) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (URL uRL : cLP.m_files) {
            s_logger.info("compiling " + uRL.getPath());
            try {
                Module module = this.handleFile(uRL, cLP, bl);
                if (!bl2) continue;
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.error("!", exception);
                throw new Error();
            }
        }
        return bl2 ? linkedList : null;
    }

    protected Module handleFile(URL uRL, CLP cLP, boolean bl) {
        String string;
        String string2 = uRL.toString();
        ModuleSignature moduleSignature = null;
        Module module = null;
        try {
            module = this.compile(uRL, cLP, moduleSignature, cLP.m_signatureSearchPath, this.m_mss);
        }
        catch (Exception exception) {
            s_logger.error("Error occurred during compilation of " + uRL, exception);
            System.exit(-1);
        }
        if (module.getName().equals("")) {
            string = uRL.getPath();
            string = string.substring(string.lastIndexOf("/") + 1);
            string = string.substring(0, string.lastIndexOf(".xylem"));
            module.setName(string);
        }
        if (bl) {
            Object object;
            string = module.getName() + ".cxo";
            try {
                object = new File(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object));
                Module.writeModule(objectOutputStream, module);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                s_logger.error("Error occurred writing of compiled module to " + string, exception);
                System.exit(-1);
            }
            object = ModuleSignatureStore.makeFilename(module.getName()) + ".cxi";
            Compiler.writeOutSignature(module.m_signature, (String)object);
        }
        return module;
    }

    public Module compile(URL uRL, CLP cLP, ModuleSignature moduleSignature, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        try {
            boolean bl = cLP.m_version.equals("1.0");
            Module module = XSLTCompiler.compileRuntimeLibrary(cLP.m_version);
            XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
            xSLTCompilerSettings.setVersion(cLP.m_version);
            Module module2 = XSLTCompiler.compileStylesheetToModule(uRL, module, null, bl, xSLTCompilerSettings);
            return module2;
        }
        catch (Exception exception) {
            s_logger.error("Error occurred compiling stylesheet " + uRL, exception);
            return null;
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.error("Error occurred writing of compiled signature to " + string, exception);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string, File file) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(file, string)));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.error("Error occurred writing of compiled signature to " + string, exception);
            System.exit(-1);
        }
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(Compiler.class);
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Compiler m_compiler;
        public String m_version = "1.0";

        protected int parseOption(String[] stringArray, int n) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: Compiler\n\t[-[show]version]\n\t[-xslt-version 1.0|2.0]");
                super.parseOption(stringArray, n);
                System.out.println("Input files should be be *.xylem or *.xylemi");
                System.out.println("\nRelease: Gustav-Mon-Jan-22-06:03:25-EST-2007");
                return -1;
            }
            if ("-version".equals(stringArray[n]) || "-showversion".equals(stringArray[n])) {
                System.out.println("Release: Gustav-Mon-Jan-22-06:03:25-EST-2007");
                return -1;
            }
            if (stringArray[n].equals("-xslt-version")) {
                int n2 = n + 1;
                if (n2 >= stringArray.length) {
                    s_logger.error("-xslt-version missing parameter");
                    return -1;
                }
                if (stringArray[n2].equals("1.0") || stringArray[n2].equals("2.0")) {
                    this.m_version = stringArray[n2];
                    return n2;
                }
                s_logger.error("-xslt-version bad parameter: " + stringArray[n2]);
                return -1;
            }
            return super.parseOption(stringArray, n);
        }
    }
}

