/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.commandline.CommandLineParserSingleInputFile;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.InputSource;

public class OverlapDetectionXSLTCompiler {
    static final Logger s_logger = Logger.getInstance(OverlapDetectionXSLTCompiler.class);

    public static void main(String[] stringArray) {
        LogManager.initializeLogger();
        CLP cLP = new CLP();
        if (!cLP.parseCommandLine(stringArray)) {
            return;
        }
        try {
            Module module = XSLTCompiler.compileRuntimeLibrary("1.0");
            for (int i = 0; i < cLP.m_inputFiles.size(); ++i) {
                URL uRL = (URL)cLP.m_inputFiles.get(i);
                Module module2 = OverlapDetectionXSLTCompiler.compileIndividualModule(uRL, module, cLP.m_settings);
                module2.removeDeadFunctions();
                File file = (File)cLP.m_outputFiles.get(i);
                if (cLP.m_dumpXylem) {
                    File file2 = new File(file.getAbsolutePath() + ".xylem");
                    s_logger.info("Xylem dump being written to file " + file2);
                    PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                    module2.dump(printWriter);
                    printWriter.close();
                }
                ParamReferenceIdentifier.createParamReferences(module2);
                s_logger.info("Writing file " + file.getAbsolutePath());
                OverlapDetectionXSLTCompiler.writeIndividualModule(module2, file);
            }
            s_logger.info("Done");
        }
        catch (Exception exception) {
            s_logger.error("", exception);
        }
    }

    public static Module compileIndividualModule(URL uRL, Module module, XSLTCompilerSettings xSLTCompilerSettings) throws Exception {
        s_logger.info("Compiling stylesheet: " + uRL);
        XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings);
        xSLTCompiler.setRuntimeLibrary(module);
        InputStream inputStream = uRL.openStream();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toString());
        XTQProgram xTQProgram = xSLTCompiler.buildAST(inputSource, uRL.toString());
        Module module2 = xSLTCompiler.translate(xTQProgram);
        module2.typeCheck(false);
        return module2;
    }

    public static void writeIndividualModule(Module module, File file) throws Exception {
        Object object;
        WriteObjectFileHelper writeObjectFileHelper;
        ObjectOutputStream objectOutputStream;
        ArrayList arrayList = new ArrayList(module.getFunctions());
        Module.sortFunctionList(arrayList);
        Iterator<Object> iterator = arrayList.iterator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final HashMap hashMap = new HashMap();
        ArrayList<Record> arrayList2 = new ArrayList<Record>();
        while (iterator.hasNext()) {
            int n = byteArrayOutputStream.size();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            writeObjectFileHelper = new WriteObjectFileHelper(module, objectOutputStream){

                public void writeInstructionTag(Instruction instruction) throws IOException {
                    Integer n = (Integer)hashMap.get(instruction.getClass());
                    if (n == null) {
                        n = new Integer(hashMap.size());
                        hashMap.put(instruction.getClass(), n);
                    }
                    this.writeInt(n);
                    this.writeType(instruction.getCachedType());
                }
            };
            Function object22 = (Function)iterator.next();
            object = new FunctionSignature(object22);
            boolean bl = module.m_signature.containsFunction(object22.getName());
            if (object22.isDerivative()) {
                ((FunctionSignature)object).setFunctionName(object22.getOriginalFunction().getName());
            }
            object22.write(writeObjectFileHelper);
            objectOutputStream.close();
            int n2 = byteArrayOutputStream.size();
            Record record = new Record((FunctionSignature)object, n, n2 - n, object22.getName(), bl);
            arrayList2.add(record);
        }
        byteArrayOutputStream.close();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
        writeObjectFileHelper = new WriteObjectFileHelper(module, objectOutputStream);
        writeObjectFileHelper.writeInt(arrayList2.size());
        for (Record record : arrayList2) {
            writeObjectFileHelper.writeInt(record.m_offset);
            writeObjectFileHelper.writeInt(record.m_size);
            writeObjectFileHelper.writeString(record.m_originalName);
            writeObjectFileHelper.writeBoolean(record.m_exported);
            record.m_signature.write(writeObjectFileHelper);
        }
        objectOutputStream.writeInt(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            objectOutputStream.writeObject(entry.getValue());
            objectOutputStream.writeObject(entry.getKey());
        }
        objectOutputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        object = new DataOutputStream(fileOutputStream);
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        ((DataOutputStream)object).writeInt(byArray.length);
        ((DataOutputStream)object).flush();
        fileOutputStream.write(byArray);
        fileOutputStream.write(byteArrayOutputStream.toByteArray());
        ((FilterOutputStream)object).close();
    }

    private static class CLP
    extends CommandLineParserSingleInputFile {
        ArrayList m_inputFiles = new ArrayList();
        ArrayList m_outputFiles = new ArrayList();
        XSLTCompilerSettings m_settings = new XSLTCompilerSettings();
        boolean m_dumpXylem = false;

        private CLP() {
        }

        protected int parseOption(String[] stringArray, int n) {
            if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
                System.out.println("Usage: OverlapDetectionXSLTCompiler\n  [-help | -h | -?]          Prints this message\n  [-command commandfile]     Specifies a newline-delimited file with command line args\n  [-version | -showversion]  Prints the Xylem compiler version\n  [-xslt-version 1.0|2.0]    Specifies the version of XSLT to use\n  [-traceserialization]      Makes the translet insert diagnostic PIs into its output\n  [-dumpxylem]               Dumps out generated Xylem IL\n  [-traceimportsandincludes] Prints out the names/sizes of imported/included stylesheets\n  (input.xsl output.o)+      Compiles input.xsl into output.o\n");
                return -1;
            }
            if ("-command".equals(stringArray[n])) {
                if (n == stringArray.length) {
                    s_logger.error("-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(stringArray[++n])) {
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-xslt-version")) {
                if (++n == stringArray.length) {
                    s_logger.error("-xslt-version missing parameter");
                    return -1;
                }
                this.m_settings.setVersion(stringArray[n]);
                if (!stringArray[n].equals("1.0") && !stringArray[n].equals("2.0")) {
                    s_logger.error("invalid version: " + stringArray[n]);
                    return -1;
                }
                return n;
            }
            if (stringArray[n].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (stringArray[n].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return n;
            }
            if (stringArray[n].equals("-dumpxylem")) {
                this.m_dumpXylem = true;
                return n;
            }
            if (stringArray[n].equals("-traceserialization")) {
                this.m_settings.setSerializationTraceEnabled(true);
                return n;
            }
            if (stringArray[n].equals("-traceimportsandincludes")) {
                this.m_settings.setTraceImportsAndIncludes(true);
                return n;
            }
            if (n == stringArray.length) {
                s_logger.error("input filename " + stringArray[n] + " missing corrsponding output filename");
                return -1;
            }
            this.m_inputFile = this.validateInputFilename(stringArray[n], false);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_inputFiles.add(this.m_inputFile);
            this.m_outputFiles.add(new File(stringArray[++n]));
            return n;
        }
    }

    static class Record {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        boolean m_exported;

        Record(FunctionSignature functionSignature, int n, int n2, String string, boolean bl) {
            this.m_signature = functionSignature;
            this.m_offset = n;
            this.m_size = n2;
            this.m_originalName = string;
            this.m_exported = bl;
        }
    }
}

