/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.OptimizationRegimen;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.xylem.optimizers.AutomatonFunctionCallExtractionOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.CloneCursorOnMemoizedFunctionsOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.CurrentNodeListFilterOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.MemoizeAbsolutePathOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.SAXEventOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.StringEqualityOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.XSLTMinimalPartialEvaluationOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationOptimizer;
import com.ibm.xtq.xslt.xylem.output.nodeset.NodeSetDeforester;
import com.ibm.xtq.xslt.xylem.output.nodeset.RecycleNodeSetOptimizer;
import com.ibm.xylem.IdentifierConsolidator;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.Program;
import com.ibm.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xylem.optimizers.DeadParameterEliminatorOptimizer;
import com.ibm.xylem.optimizers.StaticStringTableOptimizer;
import java.io.File;
import java.util.Set;

public class StandardOptimizationRegimen
extends OptimizationRegimen {
    static final Logger s_logger = Logger.getInstance(StandardOptimizationRegimen.class);
    protected Program m_program;
    protected Module m_primaryModule;
    protected XSLTLinkerSettings m_linkerSettings;
    protected File m_dir;
    protected String m_className;
    protected Set m_entryPoints;
    public static final boolean s_isDebug = false;
    protected IdentifierConsolidator m_ic;

    protected void desugar() throws Exception {
        new PolymorphicADTDesugarer(this.m_program).desugar();
    }

    protected void memoizeAbsolutePaths() throws Exception {
        if (!this.m_linkerSettings.isTestInputSpecialization()) {
            MemoizeAbsolutePathOptimizer memoizeAbsolutePathOptimizer = new MemoizeAbsolutePathOptimizer();
            memoizeAbsolutePathOptimizer.run(this.m_program);
        }
    }

    protected void doSAXEventOptimization() throws Exception {
        if (!this.m_linkerSettings.isStreamResultOnly()) {
            s_logger.info("Beginning SAX event optimization for standard serializer");
            SAXEventOptimizer sAXEventOptimizer = new SAXEventOptimizer();
            this.m_program.optimize(sAXEventOptimizer);
            sAXEventOptimizer = null;
            s_logger.info("Completed SAX event optimization for standard serializer");
        }
    }

    protected void doPartialEvaluation() throws Exception {
        if (this.m_linkerSettings.isMinOptimizations()) {
            s_logger.info("skipping partial evaluation");
            s_logger.info("Beginning min version of partial evaluation");
            this.m_ic = new IdentifierConsolidator();
            XSLTMinimalPartialEvaluationOptimizer xSLTMinimalPartialEvaluationOptimizer = new XSLTMinimalPartialEvaluationOptimizer(this.m_entryPoints);
            xSLTMinimalPartialEvaluationOptimizer.m_ic = this.m_ic;
            this.m_program.optimize(xSLTMinimalPartialEvaluationOptimizer);
            xSLTMinimalPartialEvaluationOptimizer = null;
            s_logger.info("Completed min version of partial evaluation");
        } else {
            s_logger.info("Beginning partial evaluation");
            this.m_ic = new IdentifierConsolidator();
            XSLTPartialEvaluationOptimizer xSLTPartialEvaluationOptimizer = new XSLTPartialEvaluationOptimizer(this.m_entryPoints);
            xSLTPartialEvaluationOptimizer.m_ic = this.m_ic;
            this.m_program.optimize(xSLTPartialEvaluationOptimizer);
            xSLTPartialEvaluationOptimizer = null;
            s_logger.info("Completed partial evaluation");
        }
    }

    public void doOptimizations(XSLTLinkerSettings xSLTLinkerSettings, Program program, Set set, File file, String string, Module module) throws Exception {
        Optimizer optimizer;
        this.m_linkerSettings = xSLTLinkerSettings;
        this.m_program = program;
        this.m_entryPoints = set;
        this.m_dir = file;
        this.m_className = string;
        this.m_primaryModule = module;
        s_logger.info("Optimizing");
        this.desugar();
        program.removeFunctionDerivativeInformation();
        File file2 = file;
        boolean bl = false;
        boolean bl2 = true;
        String string2 = "Search.Leftmodule.Listitem";
        if (bl) {
            this.dumpHelper(bl2, string2, file2, "pre-optimize");
        }
        if (bl) {
            this.dumpHelper(true, string2, file2, "pre-optimize");
        }
        this.memoizeAbsolutePaths();
        if (bl) {
            this.dumpHelper(bl2, string2, file2, "post-memoizing");
        }
        if (!xSLTLinkerSettings.isDisableCNLFOptimizer()) {
            optimizer = new CurrentNodeListFilterOptimizer();
            program.optimize(optimizer);
            optimizer = null;
        }
        program.optimize(new StaticStringTableOptimizer());
        if (bl) {
            this.dumpHelper(bl2, string2, file2, "pre-partial-eval");
        }
        this.m_ic = null;
        this.doPartialEvaluation();
        this.doSAXEventOptimization();
        if (bl) {
            this.dumpHelper(bl2, string2, file2, "post-partial-eval");
        }
        AutomatonFunctionCallExtractionOptimizer.doOptimization(program, set);
        program.removeDeadFunctions();
        DeadParameterEliminatorOptimizer.eliminateDeadParameters(program);
        program.removeDeadFunctions();
        program.removeFunctionDerivativeInformation();
        DeadLetEliminatorOptimizer.eliminateDeadLets(program);
        program.optimize(new StringEqualityOptimizer());
        program.optimize(new RecycleNodeSetOptimizer());
        if (xSLTLinkerSettings.isEnableNodeSetDeforester()) {
            optimizer = new NodeSetDeforester(program);
            ((NodeSetDeforester)optimizer).m_identifierConsolidator = this.m_ic;
            ((NodeSetDeforester)optimizer).m_namespaceURIs = XSLTLinker.retrieveXDMStringArray(program.getFunction(module.getName() + "$xdm-uris"));
            ((NodeSetDeforester)optimizer).m_names = XSLTLinker.retrieveXDMStringArray(program.getFunction(module.getName() + "$xdm-names"));
            ((NodeSetDeforester)optimizer).m_types = XSLTLinker.retrieveXDMIntArray(program.getFunction(module.getName() + "$xdm-types"));
            ((NodeSetDeforester)optimizer).doConversion();
        }
        DeadLetEliminatorOptimizer.eliminateDeadLets(program);
        program.removeDeadFunctions();
        program.removeFunctionDerivativeInformation();
        program.optimize(new CloneCursorOnMemoizedFunctionsOptimizer());
        if (bl) {
            this.dumpHelper(bl2, string2, file2, "post-dead-code-elim");
        }
        this.m_linkerSettings = null;
        this.m_program = null;
        this.m_entryPoints = null;
        this.m_dir = null;
        this.m_className = null;
        this.m_primaryModule = null;
    }

    protected void dumpHelper(boolean bl, String string, File file, String string2) {
        if (bl) {
            Program.dumpXylemFile((Module)this.m_program, file, this.m_className, string2);
        } else {
            Program.dumpXylemFunctions(this.m_program.getSimilarFunctions(string), file, this.m_className, string2);
        }
    }
}

