/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.BatchXSLTInterpreter;
import com.ibm.xtq.xslt.drivers.StandaloneXSLTCompilerLinker;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.jaxp.AbstractTransformerFactory;
import com.ibm.xtq.xslt.jaxp.TransformerImpl;
import com.ibm.xtq.xslt.jaxp.compiler.TransformerFactoryImpl;
import com.ibm.xtq.xslt.runtime.Translet;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.parser.FormHandler;
import com.ibm.xtq.xslt.xylem.parser.TypeHandler;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.PostOrderOptimizer;
import com.ibm.xylem.Program;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.AssertTypeInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.parser.ClassLoaderSourceResolver;
import com.ibm.xylem.parser.Parser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Timer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XsltInterpreterCompiler {
    static final Logger s_logger = Logger.getInstance(XsltInterpreterCompiler.class);
    private static String commandfile = "C:\\testfile.txt";
    private static File xslFile;
    private static File xmlFile;
    private static FileOutputStream outFile;
    private static FileOutputStream outFile2;
    private static URL url;
    private static boolean donecompiling;
    BatchXSLTInterpreter interpreter = new BatchXSLTInterpreter();
    StandaloneXSLTCompilerLinker compiler = new StandaloneXSLTCompilerLinker();
    Timer timer;

    public static void main(String[] stringArray) {
        LogManager.initializeLogger();
        try {
            FileReader fileReader = new FileReader(commandfile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            xslFile = new File(string.trim());
            string = bufferedReader.readLine();
            xmlFile = new File(string.trim());
            url = xslFile.toURL();
            string = bufferedReader.readLine();
            outFile = new FileOutputStream(string.trim());
            outFile2 = new FileOutputStream(string.trim() + "2");
            long l = System.currentTimeMillis();
            Timer timer = new Timer();
            new Interpretertask().start();
            s_logger.info("interpreter " + new Long(l - System.currentTimeMillis()).toString());
        }
        catch (Exception exception) {
            s_logger.error("Error occurred compiling stylesheet", exception);
        }
    }

    static {
        donecompiling = false;
    }

    public static class Compilertask
    extends Thread {
        BatchXSLTInterpreter interpreter = new BatchXSLTInterpreter();

        public void run() {
            Thread thread = Thread.currentThread();
            while (this == thread && !donecompiling) {
                s_logger.info("start compiling");
                XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
                XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
                xSLTLinkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(3000);
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(2);
                try {
                    long l = System.currentTimeMillis();
                    XSLTLinker.compileStylesheet(url, null, xSLTCompilerSettings, xSLTLinkerSettings);
                    donecompiling = true;
                    s_logger.info("done compiling");
                    s_logger.info("compiler " + new Long(l - System.currentTimeMillis()).toString());
                }
                catch (Throwable throwable) {
                    s_logger.error(throwable);
                    donecompiling = true;
                }
            }
        }
    }

    public static class Interpretertask
    extends Thread {
        BatchXSLTInterpreter interpreter = new BatchXSLTInterpreter();

        public void run() {
            Thread thread = Thread.currentThread();
            while (this == thread && !donecompiling) {
                s_logger.info("start interpreting");
                XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
                XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
                try {
                    Object object;
                    long l = System.currentTimeMillis();
                    ClassLoaderSourceResolver classLoaderSourceResolver = new ClassLoaderSourceResolver();
                    Parser parser = new Parser(classLoaderSourceResolver, classLoaderSourceResolver.resolve(null, "com/ibm/xtq/xslt/runtime/v1/xsltcxml11.xylem"), new ModuleSignatureStore(new LinkedList()));
                    new TypeHandler().registerTypes(parser);
                    new FormHandler().registerForms(parser);
                    ModuleSignature moduleSignature = parser.parseExternalModuleSignature(classLoaderSourceResolver.resolve(null, "com/ibm/xtq/xslt/runtime/v1/xsltc.xylemi"));
                    Module module = parser.parseModule(moduleSignature);
                    module.typeCheck();
                    Module module2 = XSLTCompiler.compileStylesheetToModule(url, module, null, false, xSLTCompilerSettings);
                    if (module2 == null) {
                        return;
                    }
                    module2.typeCheck();
                    module2.formalizeSignature("");
                    module2.optimize(new PostOrderOptimizer(){

                        protected void optimizeChildren(Instruction instruction) {
                            StreamInstruction streamInstruction;
                            if (instruction instanceof StreamInstruction && (streamInstruction = (StreamInstruction)instruction).isString()) {
                                return;
                            }
                            super.optimizeChildren(instruction);
                        }

                        protected Instruction optimizeStep(Instruction instruction) {
                            LetInstruction letInstruction;
                            if (instruction instanceof CoerceInstruction) {
                                CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
                                TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
                                if (coerceInstruction.getType().equals(coerceInstruction.getOperand().getCachedType().resolveType(typeEnvironment))) {
                                    return coerceInstruction.getOperand();
                                }
                            } else if (instruction instanceof AssertTypeInstruction) {
                                AssertTypeInstruction assertTypeInstruction = (AssertTypeInstruction)instruction;
                                TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
                                if (assertTypeInstruction.getType().equals(assertTypeInstruction.getOperand().getCachedType().resolveType(typeEnvironment))) {
                                    return assertTypeInstruction.getOperand();
                                }
                            } else if (instruction instanceof LetInstruction && (letInstruction = (LetInstruction)instruction).getBody() instanceof LiteralInstruction) {
                                return letInstruction.getBody();
                            }
                            return instruction;
                        }
                    });
                    ModuleSignature moduleSignature2 = new ModuleSignature("");
                    Program program = new Program(moduleSignature2);
                    program.addModule(module2);
                    program.addModule(module);
                    long l2 = System.currentTimeMillis();
                    s_logger.info("compiler " + new Long(l2 - System.currentTimeMillis()).toString());
                    Transformer transformer = XSLTLinker.makeInterpreterTransformer(program, null, xSLTLinkerSettings, xmlFile.toURL(), outFile);
                    while (System.currentTimeMillis() - l2 < 50000L) {
                        long l3 = System.currentTimeMillis();
                        StreamSource streamSource = new StreamSource(xmlFile.toURL().openStream(), xmlFile.toURL().toExternalForm());
                        object = new StreamResult(outFile);
                        s_logger.info("Transforming through interpreter");
                        transformer.transform(streamSource, (Result)object);
                        s_logger.info("Finished interpreted transformation");
                        s_logger.info("interpreterprogram " + new Long(l3 - System.currentTimeMillis()).toString());
                        s_logger.info("done interpreting");
                    }
                    System.exit(0);
                    FileInputStream fileInputStream = new FileInputStream(xmlFile);
                    byte[] byArray = new byte[fileInputStream.available()];
                    int n = fileInputStream.read(byArray);
                    object = new ByteArrayInputStream(byArray);
                    try {
                        Object object2;
                        s_logger.info("using translet");
                        String string = "javax.xml.transform.TransformerFactory";
                        String string2 = "com.ibm.xtq.xslt.jaxp.compiler.TransformerFactoryImpl";
                        Properties properties = System.getProperties();
                        properties.put(string, string2);
                        System.setProperties(properties);
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        transformerFactory.setAttribute("http://www.ibm.com/xmlns/prod/xltxe-j/generate-translet", Boolean.TRUE);
                        Translet translet = null;
                        TransformerImpl transformerImpl = null;
                        Class<?> clazz = null;
                        try {
                            object2 = new ClassLoader(){

                                protected Class findClass(String string) throws ClassNotFoundException {
                                    try {
                                        File file = new File(string + ".class");
                                        FileInputStream fileInputStream = new FileInputStream(file);
                                        byte[] byArray = new byte[(int)file.length()];
                                        fileInputStream.read(byArray);
                                        fileInputStream.close();
                                        return super.defineClass(string, byArray, 0, byArray.length);
                                    }
                                    catch (Exception exception) {
                                        return super.findClass(string);
                                    }
                                }
                            };
                            String string3 = xslFile.getName();
                            int n2 = string3.lastIndexOf(46);
                            n2 = n2 > 0 ? n2 : string3.length();
                            string3 = string3.substring(0, n2);
                            string3 = string3.replace('-', '_');
                            string3 = string3.replace('.', '_');
                            string3 = string3.replace('\\', '_');
                            clazz = ((ClassLoader)object2).loadClass(string3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return;
                        }
                        object2 = null;
                        translet = (Translet)clazz.newInstance();
                        transformerImpl = new TransformerImpl(translet, (AbstractTransformerFactory)((TransformerFactoryImpl)transformerFactory));
                        long l4 = System.currentTimeMillis();
                        object2 = new StringWriter();
                        ((Transformer)transformerImpl).transform(new StreamSource(new ByteArrayInputStream(byArray), xmlFile.getAbsolutePath()), new StreamResult(outFile2));
                        s_logger.info("transformer " + new Long(l4 - System.currentTimeMillis()).toString());
                        s_logger.info(((StringWriter)object2).getBuffer());
                    }
                    catch (Exception exception) {
                        s_logger.info("Message=" + exception.getMessage());
                        exception.printStackTrace(System.out);
                    }
                    s_logger.info("interpreter " + new Long(l - System.currentTimeMillis()).toString());
                }
                catch (Throwable throwable) {
                    s_logger.error("Error occurred compiling stylesheet", throwable);
                }
            }
        }
    }
}

