/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xslt.jaxp.TransformerHandlerImpl;
import com.ibm.xtq.xslt.jaxp.TransformerImpl;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class TrAXFilter
extends XMLFilterImpl {
    private TransformerImpl _transformer;
    private TransformerHandlerImpl _transformerHandler;

    public TrAXFilter(Templates templates) throws TransformerConfigurationException {
        this._transformer = (TransformerImpl)templates.newTransformer();
        this._transformerHandler = new TransformerHandlerImpl((TransformerImpl)templates.newTransformer());
    }

    private void createParent() throws SAXException {
        XMLReader xMLReader = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            if (this._transformer.isSecureProcessing()) {
                try {
                    sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.reportUnrecognizedSecureProcessingProperty(true, sAXParserFactory, sAXNotRecognizedException);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.reportUnrecognizedSecureProcessingProperty(true, sAXParserFactory, sAXNotSupportedException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.reportUnrecognizedSecureProcessingProperty(true, sAXParserFactory, parserConfigurationException);
                }
            }
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            String string = this._transformer.getAllowedDTDProtocols();
            if (string != null) {
                try {
                    sAXParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", string);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    this.reportUnrecognizedProperty(string, sAXParser, sAXNotRecognizedException);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    this.reportUnrecognizedProperty(string, sAXParser, sAXNotSupportedException);
                }
            }
            xMLReader = sAXParser.getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new SAXException(factoryConfigurationError.toString());
        }
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        this.setParent(xMLReader);
    }

    private void reportUnrecognizedSecureProcessingProperty(boolean bl, SAXParserFactory sAXParserFactory, Exception exception) throws SAXException {
        if (bl) {
            try {
                this._transformer.getErrorListener().warning(new TransformerException(XMLMessages.createXMLMessage("ERR_PARSER_PROPERTY_NOT_SUPPORTED", new Object[]{sAXParserFactory.getClass(), "http://javax.xml.XMLConstants/feature/secure-processing", bl}), exception));
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
        }
    }

    private void reportUnrecognizedProperty(String string, SAXParser sAXParser, Exception exception) throws SAXException {
        if (!string.equals("all")) {
            try {
                this._transformer.getErrorListener().warning(new TransformerException(XMLMessages.createXMLMessage("ERR_PARSER_PROPERTY_NOT_SUPPORTED", new Object[]{sAXParser.getClass(), "http://javax.xml.XMLConstants/property/accessExternalDTD", string}), exception));
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.setupParse();
        this.getParent().parse(inputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this._transformerHandler.setResult(new SAXResult(contentHandler));
        if (this.getParent() == null) {
            try {
                this.createParent();
            }
            catch (SAXException sAXException) {
                return;
            }
        }
        this.getParent().setContentHandler(this._transformerHandler);
    }

    private void setupParse() throws SAXException {
        XMLReader xMLReader = this.getParent();
        if (xMLReader == null) {
            try {
                this.createParent();
            }
            catch (SAXException sAXException) {
                throw new SAXException(sAXException.toString());
            }
        }
        xMLReader.setContentHandler(this._transformerHandler);
        xMLReader.setEntityResolver(this);
        xMLReader.setDTDHandler(this);
        xMLReader.setErrorHandler(this);
    }

    public void setParent(XMLReader xMLReader) {
        super.setParent(xMLReader);
        if (null != xMLReader && null != xMLReader.getContentHandler()) {
            this.setContentHandler(xMLReader.getContentHandler());
        }
        try {
            this.setupParse();
        }
        catch (SAXException sAXException) {
            return;
        }
    }
}

