/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime;

import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.Calendar;
import com.ibm.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import com.ibm.xtq.xslt.runtime.NumberFormatInt;
import com.ibm.xtq.xslt.runtime.v2.BasisLibrary2;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatFunctionsLibrary {
    private static final String EMPTYSTRING = "";
    private static final String COMMA = ",";
    private static final String STAR = "*";
    private static final String DASH = "-";
    private static final String ZERO = "0";
    private boolean isTimeZoneSpecified = false;
    private boolean defaultCalendarFallBack = false;
    private boolean defaultLanguageFallBack = false;
    private final NumberFormatFactoryRuleBased s_ICUNumberFormatFactory = NumberFormatFactoryRuleBased.getInstance();
    private NumberFormatInt numberFormatInt = new NumberFormatInt(this.s_ICUNumberFormatFactory);

    public char[] formatDateTime(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        Locale locale;
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]) - 1;
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        int n5 = Integer.parseInt(stringArray[4]);
        int n6 = this.getSeconds(stringArray[5]);
        int n7 = this.getMillieconds(stringArray[5]);
        String string = stringArray[6];
        if (cArray2.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(cArray2))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(cArray2), String.valueOf(cArray4));
        }
        GenericCalendar genericCalendar = this.getCalendar(String.valueOf(cArray3), string, locale);
        GenericDateFormatSymbols genericDateFormatSymbols = this.getDateFormatSymbols(locale);
        genericCalendar.set(1, n);
        genericCalendar.set(2, n2);
        genericCalendar.set(5, n3);
        genericCalendar.set(11, n4);
        genericCalendar.set(12, n5);
        genericCalendar.set(13, n6);
        genericCalendar.set(14, n7);
        StringBuffer stringBuffer = new StringBuffer();
        int n8 = cArray.length;
        block4: for (int i = 0; i < n8; ++i) {
            switch (cArray[i]) {
                case '[': {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    char c = cArray[++i];
                    if (c == '[') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    while (i < n8 && (c = cArray[i]) != ']') {
                        if (!Character.isWhitespace(c)) {
                            stringBuffer2.append(cArray[i]);
                        }
                        ++i;
                    }
                    String string2 = stringBuffer2.toString();
                    if (string2.length() <= 0) continue block4;
                    if (this.isPictureValid(string2)) {
                        stringBuffer.append(this.formatDateTimeVariableMarker(string2, genericCalendar, genericDateFormatSymbols, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", string2);
                    continue block4;
                }
                case ']': {
                    char c;
                    if (++i == n8) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((c = cArray[i]) == ']') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            stringBuffer.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            stringBuffer.insert(0, "[Calendar: AD]");
        }
        return stringBuffer.toString().toCharArray();
    }

    private int getRawOffSetFromTimeZone(String string) {
        int n = string.indexOf("PT");
        int n2 = string.indexOf("H");
        int n3 = string.indexOf("M");
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 != -1 || n3 != -1) {
            if (n2 == -1) {
                n5 = Integer.parseInt(string.substring(n + 2, n3));
            } else if (n3 == -1) {
                n4 = Integer.parseInt(string.substring(n + 2, n2));
            } else {
                n4 = Integer.parseInt(string.substring(n + 2, n2));
                n5 = Integer.parseInt(string.substring(n2 + 1, n3));
            }
        }
        n6 = (n4 * 60 + n5) * 60 * 1000;
        if (string.startsWith(DASH)) {
            n6 *= -1;
        }
        return n6;
    }

    private String getTimeFromOffset(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            return EMPTYSTRING;
        }
        if (n < 0) {
            stringBuffer.append(DASH);
            n *= -1;
        } else {
            stringBuffer.append("+");
        }
        int n2 = n / 60 / 1000;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        if (n3 < 10) {
            stringBuffer.append(ZERO + String.valueOf(n3));
        } else {
            stringBuffer.append(String.valueOf(n3));
        }
        if (n4 < 10) {
            stringBuffer.append(":0" + String.valueOf(n4));
        } else {
            stringBuffer.append(":" + String.valueOf(n4));
        }
        return stringBuffer.toString();
    }

    private String applyPresentationModifier(String string, String string2, NumberFormatInt numberFormatInt, Locale locale) {
        return numberFormatInt.applyPresentationModifier(string, string2, locale);
    }

    private String formatYear(int n, String string, boolean bl, Locale locale) {
        String string2 = this.getModifier(string, bl);
        String string3 = this.formatValueHelper(n, string2, locale);
        if (bl) {
            string3 = this.adjustWidthForYear(string3, string);
        }
        return string3;
    }

    private String formatMonth(int n, String string, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        String string2 = this.getModifier(string, bl);
        int n2 = -1;
        int n3 = -1;
        if (bl && (n2 = this.getMinimumWidth(string)) > (n3 = this.getMaximumWidth(string))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if (string2.startsWith("N") || string2.startsWith("n")) {
            String string3 = genericDateFormatSymbols.getMonths()[n];
            int n4 = string3.length();
            if (bl && n3 != -1 && n4 > n3) {
                string3 = genericDateFormatSymbols.getShortMonths()[n];
            }
            String string4 = this.applyPresentationModifier(string2, string3, this.numberFormatInt, locale);
            return string4;
        }
        String string5 = this.formatValueHelper(n + 1, string2, locale);
        if (bl) {
            string5 = this.adjustWidthForValue(string5, n2, n3);
        }
        return string5;
    }

    private String formatDateTimeVariableMarker(String string, GenericCalendar genericCalendar, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        boolean bl = this.isWidthSpecified(string);
        char c = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        switch (c) {
            case 'Y': {
                stringBuffer.append(this.formatYear(genericCalendar.get(1), string, bl, locale));
                break;
            }
            case 'M': {
                stringBuffer.append(this.formatMonth(genericCalendar.get(2), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'D': {
                stringBuffer.append(this.formatValue(genericCalendar.get(5), string, locale));
                break;
            }
            case 'd': {
                stringBuffer.append(this.formatValue(genericCalendar.get(6), string, locale));
                break;
            }
            case 'F': {
                stringBuffer.append(this.formatDayOfWeek(genericCalendar.get(7), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'W': {
                stringBuffer.append(this.formatValue(genericCalendar.get(3), string, locale));
                break;
            }
            case 'w': {
                stringBuffer.append(this.formatValue(genericCalendar.get(4), string, locale));
                break;
            }
            case 'H': {
                stringBuffer.append(this.formatValue(genericCalendar.get(11), string, locale));
                break;
            }
            case 'h': {
                int n = genericCalendar.get(10);
                if (n == 0) {
                    n = 12;
                }
                stringBuffer.append(this.formatValue(n, string, locale));
                break;
            }
            case 'P': {
                stringBuffer.append(this.formatAMPM(genericCalendar.get(9), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'm': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(12), string, locale));
                break;
            }
            case 's': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(13), string, locale));
                break;
            }
            case 'f': {
                stringBuffer.append(this.formatMillisecondValue(genericCalendar.get(14), string, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                String string2 = this.getTimeFromOffset(genericCalendar.get(15));
                String string3 = this.getModifier(string, bl);
                if (string3.equals(EMPTYSTRING)) {
                    if (string2.equals(EMPTYSTRING)) {
                        string2 = "Z";
                    }
                } else if (string2.equals(EMPTYSTRING)) {
                    string2 = "GMT";
                }
                stringBuffer.append(string2);
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append("GMT" + this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                stringBuffer.append(this.formatEras(genericCalendar.get(0), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_SPECIFIER", String.valueOf(c));
            }
        }
        return stringBuffer.toString();
    }

    private String formatDateVariableMarker(String string, GenericCalendar genericCalendar, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        boolean bl = this.isWidthSpecified(string);
        char c = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        switch (c) {
            case 'Y': {
                stringBuffer.append(this.formatYear(genericCalendar.get(1), string, bl, locale));
                break;
            }
            case 'M': {
                stringBuffer.append(this.formatMonth(genericCalendar.get(2), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'D': {
                stringBuffer.append(this.formatValue(genericCalendar.get(5), string, locale));
                break;
            }
            case 'd': {
                stringBuffer.append(this.formatValue(genericCalendar.get(6), string, locale));
                break;
            }
            case 'F': {
                stringBuffer.append(this.formatDayOfWeek(genericCalendar.get(7), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'W': {
                stringBuffer.append(this.formatValue(genericCalendar.get(3), string, locale));
                break;
            }
            case 'w': {
                stringBuffer.append(this.formatValue(genericCalendar.get(4), string, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append(this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append("GMT" + this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                stringBuffer.append(this.formatEras(genericCalendar.get(0), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_SPECIFIER", String.valueOf(c));
            }
        }
        return stringBuffer.toString();
    }

    private String formatDayOfWeek(int n, String string, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        String string2 = this.getModifier(string, bl);
        int n2 = -1;
        int n3 = -1;
        if (bl && (n2 = this.getMinimumWidth(string)) > (n3 = this.getMaximumWidth(string))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if (string2.startsWith("N") || string2.startsWith("n")) {
            String string3 = genericDateFormatSymbols.getWeekdays()[n];
            int n4 = string3.length();
            if (bl && n3 != -1 && n4 > n3) {
                string3 = genericDateFormatSymbols.getShortWeekdays()[n];
            }
            String string4 = this.applyPresentationModifier(string2, string3, this.numberFormatInt, locale);
            return string4;
        }
        String string5 = this.formatValueHelper(n, string2, locale);
        if (bl) {
            string5 = this.adjustWidthForValue(string5, n2, n3);
        }
        return string5;
    }

    private String formatAMPM(int n, String string, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        String string2 = this.getModifier(string, bl);
        if (string2.equals(EMPTYSTRING) && !bl) {
            string2 = "n";
        }
        String string3 = this.numberFormatInt.applyPresentationModifier(string2, genericDateFormatSymbols.getAmPmStrings()[n], locale);
        return string3;
    }

    private String formatTimeValue(int n, String string, Locale locale) {
        boolean bl = this.isWidthSpecified(string);
        String string2 = this.getModifier(string, bl);
        if (string2.equals(EMPTYSTRING)) {
            string2 = "01";
        }
        String string3 = this.formatValueHelper(n, string2, locale);
        if (bl) {
            string3 = this.adjustWidth(string3, string);
        }
        return string3;
    }

    private String formatMillisecondValue(int n, String string, Locale locale) {
        String string2;
        boolean bl = this.isWidthSpecified(string);
        String string3 = this.getModifier(string, bl);
        if (bl) {
            int n2;
            int n3 = this.getMinimumWidth(string);
            int n4 = this.getMaximumWidth(string);
            if (string3.equals(EMPTYSTRING) || !this.containsLetter(string3)) {
                string3 = "001";
            }
            if ((n2 = (string2 = this.formatValueHelper(n, string3, locale)).length()) > n4) {
                string2 = string2.substring(0, n4);
            } else if (n2 < n3 && !this.containsLetter(string2)) {
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = n3 - n2;
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append('0');
                }
                string2 = string2 + stringBuffer.toString();
            }
        } else if (string3.equals(EMPTYSTRING)) {
            string2 = this.formatValueHelper(n, "001", locale);
        } else if (!this.containsLetter(string3)) {
            string2 = this.formatValueHelper(n, "001", locale);
            int n6 = string3.length();
            if (n6 > 3) {
                StringBuffer stringBuffer = new StringBuffer();
                int n7 = n6 - 3;
                for (int i = 0; i < n7; ++i) {
                    stringBuffer.append('0');
                }
                string2 = string2 + stringBuffer.toString();
            } else if (n6 < 3) {
                string2 = string2.substring(0, n6);
            }
        } else {
            string2 = this.formatValueHelper(n, string3, locale);
        }
        return string2;
    }

    private String formatValue(int n, String string, Locale locale) {
        boolean bl = this.isWidthSpecified(string);
        String string2 = this.getModifier(string, bl);
        String string3 = this.formatValueHelper(n, string2, locale);
        if (bl) {
            string3 = this.adjustWidth(string3, string);
        }
        return string3;
    }

    private String formatValueHelper(int n, String string, Locale locale) {
        String string2 = string.equals(EMPTYSTRING) ? String.valueOf(n) : (string.endsWith("o") ? this.numberFormatInt.formatValue(n, string, 1, EMPTYSTRING, EMPTYSTRING, locale.getLanguage(), "yes") : this.numberFormatInt.formatValue(n, string, 1, EMPTYSTRING, EMPTYSTRING, locale.getLanguage(), EMPTYSTRING));
        return string2;
    }

    private String formatEras(int n, String string, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        return genericDateFormatSymbols.getEras()[n];
    }

    public char[] formatDate(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        Locale locale;
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]) - 1;
        int n3 = Integer.parseInt(stringArray[2]);
        String string = stringArray[3];
        if (cArray2.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(cArray2))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(cArray2), String.valueOf(cArray4));
        }
        GenericCalendar genericCalendar = this.getCalendar(String.valueOf(cArray3), string, locale);
        GenericDateFormatSymbols genericDateFormatSymbols = this.getDateFormatSymbols(locale);
        genericCalendar.set(1, n);
        genericCalendar.set(2, n2);
        genericCalendar.set(5, n3);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = cArray.length;
        block4: for (int i = 0; i < n4; ++i) {
            switch (cArray[i]) {
                case '[': {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    char c = cArray[++i];
                    if (c == '[') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    while (i < n4 && (c = cArray[i]) != ']') {
                        if (!Character.isWhitespace(c)) {
                            stringBuffer2.append(cArray[i]);
                        }
                        ++i;
                    }
                    String string2 = stringBuffer2.toString();
                    if (string2.length() <= 0) continue block4;
                    if (this.isPictureValid(string2)) {
                        stringBuffer.append(this.formatDateVariableMarker(string2, genericCalendar, genericDateFormatSymbols, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", string2);
                    continue block4;
                }
                case ']': {
                    char c;
                    if (++i == n4) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((c = cArray[i]) == ']') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            stringBuffer.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            stringBuffer.insert(0, "[Calendar: AD]");
        }
        return stringBuffer.toString().toCharArray();
    }

    public char[] formatTime(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        Locale locale;
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = this.getSeconds(stringArray[2]);
        int n4 = this.getMillieconds(stringArray[2]);
        String string = stringArray[3];
        if (cArray2.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(cArray2))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(cArray2), String.valueOf(cArray4));
        }
        GenericCalendar genericCalendar = this.getCalendar(String.valueOf(cArray3), string, locale);
        GenericDateFormatSymbols genericDateFormatSymbols = this.getDateFormatSymbols(locale);
        genericCalendar.set(11, n);
        genericCalendar.set(12, n2);
        genericCalendar.set(13, n3);
        genericCalendar.set(14, n4);
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = cArray.length;
        block4: for (int i = 0; i < n5; ++i) {
            switch (cArray[i]) {
                case '[': {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    char c = cArray[++i];
                    if (c == '[') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    while (i < n5 && (c = cArray[i]) != ']') {
                        if (!Character.isWhitespace(c)) {
                            stringBuffer2.append(cArray[i]);
                        }
                        ++i;
                    }
                    String string2 = stringBuffer2.toString();
                    if (string2.length() <= 0) continue block4;
                    if (this.isPictureValid(string2)) {
                        stringBuffer.append(this.formatTimeVariableMarker(string2, genericCalendar, genericDateFormatSymbols, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", string2);
                    continue block4;
                }
                case ']': {
                    char c;
                    if (++i == n5) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((c = cArray[i]) == ']') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            stringBuffer.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            stringBuffer.insert(0, "[Calendar: AD]");
        }
        return stringBuffer.toString().toCharArray();
    }

    private String formatTimeVariableMarker(String string, GenericCalendar genericCalendar, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        boolean bl = this.isWidthSpecified(string);
        char c = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        switch (c) {
            case 'H': {
                stringBuffer.append(this.formatValue(genericCalendar.get(11), string, locale));
                break;
            }
            case 'h': {
                int n = genericCalendar.get(10);
                if (n == 0) {
                    n = 12;
                }
                stringBuffer.append(this.formatValue(n, string, locale));
                break;
            }
            case 'P': {
                stringBuffer.append(this.formatAMPM(genericCalendar.get(9), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'm': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(12), string, locale));
                break;
            }
            case 's': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(13), string, locale));
                break;
            }
            case 'f': {
                stringBuffer.append(this.formatMillisecondValue(genericCalendar.get(14), string, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                String string2 = this.getTimeFromOffset(genericCalendar.get(15));
                String string3 = this.getModifier(string, bl);
                if (string3.equals(EMPTYSTRING)) {
                    if (string2.equals(EMPTYSTRING)) {
                        string2 = "Z";
                    }
                } else if (string2.equals(EMPTYSTRING)) {
                    string2 = "GMT";
                }
                stringBuffer.append(string2);
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append("GMT" + this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                stringBuffer.append(this.formatEras(genericCalendar.get(0), string, bl, genericDateFormatSymbols, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_SPECIFIER", String.valueOf(c));
            }
        }
        return stringBuffer.toString();
    }

    private boolean isWidthSpecified(String string) {
        return string.indexOf(COMMA) != -1;
    }

    private boolean isLanguageSupported(String string) {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!string.equals(localeArray[i].getLanguage())) continue;
            return true;
        }
        return false;
    }

    private String adjustWidth(String string, String string2) {
        String string3;
        int n;
        int n2;
        int n3 = this.getMinimumWidth(string2);
        if (n3 > (n2 = this.getMaximumWidth(string2))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if ((n = (string3 = String.valueOf(string)).length()) < n3) {
            int n4 = n3 - n;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string3);
            string3 = stringBuffer.toString();
        } else if (n > n2) {
            string3 = string3.substring(0, n2);
        }
        return string3;
    }

    private String adjustWidthForYear(String string, String string2) {
        int n;
        int n2 = this.getMinimumWidth(string2);
        if (n2 > (n = this.getMaximumWidth(string2))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        return this.adjustWidthForValue(string, n2, n);
    }

    private String adjustWidthForValue(String string, int n, int n2) {
        String string2;
        int n3 = string.length();
        if (n3 < n) {
            if (Character.isDigit(string.charAt(0))) {
                int n4 = n - n3;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
                string2 = stringBuffer.toString();
            } else {
                int n5 = n - n3;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string);
                string2 = stringBuffer.toString();
            }
        } else {
            string2 = n3 > n2 ? string.substring(n3 - n2) : string;
        }
        return string2;
    }

    private int getSeconds(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return Integer.parseInt(string);
        }
        return Integer.parseInt(string.substring(0, n));
    }

    private boolean hasOridnal(String string) {
        if (string.indexOf("o") == -1) {
            return false;
        }
        if (string.endsWith("o")) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case 'N': 
                    case 'W': 
                    case 'n': 
                    case 'w': {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean containsLetter(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isPictureValid(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ',' || c == '-' || c == '*') continue;
            return false;
        }
        return true;
    }

    private int getMillieconds(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return 0;
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    private int getMinimumWidth(String string) {
        String string2;
        int n = -1;
        int n2 = string.indexOf(COMMA);
        int n3 = string.indexOf(DASH);
        if (n2 != -1 && !(string2 = n3 == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n3)).equals(EMPTYSTRING) && !string2.equals(STAR)) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_WIDTH_SPECIFIER", string2);
            }
        }
        return n;
    }

    private int getMaximumWidth(String string) {
        String string2 = EMPTYSTRING;
        int n = -1;
        int n2 = string.indexOf(COMMA);
        int n3 = string.indexOf(DASH);
        if (n2 != -1) {
            if (n3 != -1) {
                string2 = string.substring(n3 + 1);
            }
            if (!string2.equals(EMPTYSTRING)) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_WIDTH_SPECIFIER", string2);
                }
            }
        }
        return n;
    }

    private GenericCalendar getCalendar(String string, String string2, Locale locale) {
        GenericCalendar genericCalendar;
        if (this.s_ICUNumberFormatFactory != null) {
            if (string.equals(EMPTYSTRING) || string.equals("AD")) {
                com.ibm.icu.util.GregorianCalendar gregorianCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                genericCalendar = new GenericCalendarICUImpl((Calendar)gregorianCalendar);
            } else if (string.equals("BE")) {
                genericCalendar = new GenericCalendarICUImpl((Calendar)new BuddhistCalendar(locale));
            } else if (string.equals("ISO")) {
                com.ibm.icu.util.GregorianCalendar gregorianCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                genericCalendar = new GenericCalendarICUImpl((Calendar)gregorianCalendar);
            } else {
                this.defaultCalendarFallBack = true;
                com.ibm.icu.util.GregorianCalendar gregorianCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                genericCalendar = new GenericCalendarICUImpl((Calendar)gregorianCalendar);
            }
            if (!string2.equals(EMPTYSTRING)) {
                this.isTimeZoneSpecified = true;
                ((com.ibm.icu.util.TimeZone)genericCalendar.getTimeZone()).setRawOffset(this.getRawOffSetFromTimeZone(string2));
            }
        } else {
            if (string.equals("AD")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                genericCalendar = new GenericCalendarJavaImpl(gregorianCalendar);
            } else if (string.equals("ISO")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                genericCalendar = new GenericCalendarJavaImpl(gregorianCalendar);
            } else {
                this.defaultCalendarFallBack = true;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                genericCalendar = new GenericCalendarJavaImpl(gregorianCalendar);
            }
            if (!string2.equals(EMPTYSTRING)) {
                this.isTimeZoneSpecified = true;
                ((TimeZone)genericCalendar.getTimeZone()).setRawOffset(this.getRawOffSetFromTimeZone(string2));
            }
        }
        return genericCalendar;
    }

    private GenericDateFormatSymbols getDateFormatSymbols(Locale locale) {
        GenericDateFormatSymbols genericDateFormatSymbols = this.s_ICUNumberFormatFactory != null ? new DateFormatSymbolsICUImpl(new com.ibm.icu.text.DateFormatSymbols(locale)) : new DateFormatSymbolsJavaImpl(new DateFormatSymbols(locale));
        return genericDateFormatSymbols;
    }

    private String getModifier(String string, boolean bl) {
        String string2 = bl ? string.substring(1, string.indexOf(COMMA)) : (string.length() > 1 ? string.substring(1) : EMPTYSTRING);
        return string2;
    }

    private class DateFormatSymbolsICUImpl
    implements GenericDateFormatSymbols {
        final com.ibm.icu.text.DateFormatSymbols m_dfs;

        public DateFormatSymbolsICUImpl(com.ibm.icu.text.DateFormatSymbols dateFormatSymbols) {
            this.m_dfs = dateFormatSymbols;
        }

        public String[] getAmPmStrings() {
            return this.m_dfs.getAmPmStrings();
        }

        public String[] getMonths() {
            return this.m_dfs.getMonths();
        }

        public String[] getShortMonths() {
            return this.m_dfs.getShortMonths();
        }

        public String[] getWeekdays() {
            return this.m_dfs.getWeekdays();
        }

        public String[] getShortWeekdays() {
            return this.m_dfs.getShortWeekdays();
        }

        public String[] getEras() {
            return this.m_dfs.getEras();
        }
    }

    private class DateFormatSymbolsJavaImpl
    implements GenericDateFormatSymbols {
        final DateFormatSymbols m_dfs;

        public DateFormatSymbolsJavaImpl(DateFormatSymbols dateFormatSymbols) {
            this.m_dfs = dateFormatSymbols;
        }

        public String[] getAmPmStrings() {
            return this.m_dfs.getAmPmStrings();
        }

        public String[] getMonths() {
            return this.m_dfs.getMonths();
        }

        public String[] getShortMonths() {
            return this.m_dfs.getShortMonths();
        }

        public String[] getWeekdays() {
            return this.m_dfs.getWeekdays();
        }

        public String[] getShortWeekdays() {
            return this.m_dfs.getShortWeekdays();
        }

        public String[] getEras() {
            return this.m_dfs.getEras();
        }
    }

    private static interface GenericCalendar {
        public int get(int var1);

        public void set(int var1, int var2);

        public Object getTimeZone();
    }

    private class GenericCalendarICUImpl
    implements GenericCalendar {
        final Calendar m_cal;

        public GenericCalendarICUImpl(Calendar calendar) {
            this.m_cal = calendar;
        }

        public int get(int n) {
            return this.m_cal.get(n);
        }

        public Object getDisplayName(Locale locale) {
            return this.m_cal.getDisplayName(locale);
        }

        public void set(int n, int n2) {
            this.m_cal.set(n, n2);
        }

        public Object getTimeZone() {
            return this.m_cal.getTimeZone();
        }
    }

    private class GenericCalendarJavaImpl
    implements GenericCalendar {
        final GregorianCalendar m_cal;

        public GenericCalendarJavaImpl(GregorianCalendar gregorianCalendar) {
            this.m_cal = gregorianCalendar;
        }

        public int get(int n) {
            return this.m_cal.get(n);
        }

        public Object getDisplayName(Locale locale) {
            return "hello";
        }

        public void set(int n, int n2) {
            this.m_cal.set(n, n2);
        }

        public Object getTimeZone() {
            return this.m_cal.getTimeZone();
        }
    }

    private static interface GenericDateFormatSymbols {
        public String[] getMonths();

        public String[] getEras();

        public String[] getAmPmStrings();

        public String[] getShortMonths();

        public String[] getWeekdays();

        public String[] getShortWeekdays();
    }
}

