/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime.v2;

import com.ibm.icu.lang.UCharacter;
import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.common.utils.XML11Char;
import com.ibm.xtq.common.utils.XMLChar;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XDouble;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XSequence;
import com.ibm.xtq.xml.datamodel.XString;
import com.ibm.xtq.xml.types.IDerivableType;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeError;
import com.ibm.xtq.xml.types.TypeFactory;
import com.ibm.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xtq.xml.xcollator.XCollator;
import com.ibm.xtq.xml.xcollator.XCollatorCache;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xml.xdm.XDMNode;
import com.ibm.xtq.xml.xdm.ref.XDMUnionCursor;
import com.ibm.xtq.xslt.runtime.AbstractTranslet;
import com.ibm.xtq.xslt.runtime.DateFormatFunctionsLibrary;
import com.ibm.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import com.ibm.xtq.xslt.runtime.NumberFormatInt;
import com.ibm.xtq.xslt.runtime.TransletException;
import com.ibm.xtq.xslt.translator.FunctionOperatorTable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIDocumentImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.regex.Match;
import org.apache.xerces.impl.xpath.regex.ParseException;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.ItemPSVI;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSException;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.unicode.UnicodeNormalizer;
import org.apache.xml.serializer.unicode.UnicodeNormalizerFactory;
import org.apache.xml.serializer.utils.SystemIDResolver;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class BasisLibrary2
implements Constants,
TypeConstants {
    private static final String EMPTYSTRING = "";
    private static final String GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    private static final String UNPARSED_ENTITY_CHECKING = "http://apache.org/xml/features/validation/unparsed-entity-checking";
    private static final String IGNORE_XSI_TYPE = "http://apache.org/xml/features/validation/schema/ignore-xsi-type-until-elemdecl";
    private static final String ID_IDREF_CHECKING = "http://apache.org/xml/features/validation/id-idref-checking";
    private static final String IDC_CHECKING = "http://apache.org/xml/features/validation/identity-constraint-checking";
    private static final String ROOT_TYPE_DEF = "http://apache.org/xml/properties/validation/schema/root-type-definition";
    private static DecimalFormat defaultFormatter;
    private static Properties m_properties;
    private static String m_propertiesName;
    private static int prefixIndex;
    private static ResourceBundle m_bundle;
    public static final String ERROR_MESSAGES_KEY = "error-messages";
    private static final NumberFormatFactoryRuleBased s_ICUNumberFormatFactory;
    private static final CollatorFactory s_collFactory;
    private static final XCollatorCache s_xcollatorCache;
    private static final byte SIMPLE = 0;
    private static final byte POLYMORPHIC = 1;
    private static final byte XTQHP = 2;
    private static final StringList SUPPORTED_SCHEMA_VERSION;
    private static UnicodeNormalizer s_unicodeNormalizer;

    public static int positionF(XDMCursor xDMCursor) {
        return xDMCursor.getCurrentPos();
    }

    public static String generate_idF(XDMCursor xDMCursor, AbstractTranslet abstractTranslet) {
        if (xDMCursor == null || xDMCursor.isEmpty()) {
            return EMPTYSTRING;
        }
        return abstractTranslet.generate_id_support(xDMCursor);
    }

    public static char[] system_propertyF(char[] cArray) {
        String string = new String(cArray);
        int n = string.indexOf("xsl:");
        if (n == 0) {
            String string2 = string.substring(string.indexOf(":") + 1);
            String string3 = (String)m_properties.get(string2);
            if (string3 != null) {
                return string3.toCharArray();
            }
            return new String(EMPTYSTRING).toCharArray();
        }
        BasisLibrary2.runTimeError("ERR_SYSTEM_PROPERTY_INVALID_QNAME");
        return null;
    }

    public static XDMCursor getSingleNode(XDMCursor xDMCursor) {
        return xDMCursor.singleNode();
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    public static String generatePrefix() {
        return "ns" + prefixIndex++;
    }

    private static String formatMessage(String string, Object[] objectArray) {
        String string2 = MessageFormat.format(m_bundle.getString(string), objectArray);
        return string2;
    }

    public static void runTimeWarning(String string, Object[] objectArray) {
        String string2 = BasisLibrary2.formatMessage(string, objectArray);
        BasisLibrary2.consoleOutput(string2);
    }

    public static void runTimeError(String string) {
        throw new RuntimeException(m_bundle.getString(string));
    }

    public static void runTimeError(String string, Object[] objectArray) {
        String string2 = MessageFormat.format(m_bundle.getString(string), objectArray);
        throw new RuntimeException(string2);
    }

    public static void runTimeError(String string, Object object) {
        BasisLibrary2.runTimeError(string, new Object[]{object});
    }

    public static void runTimeError(String string, Object object, Object object2) {
        BasisLibrary2.runTimeError(string, new Object[]{object, object2});
    }

    public static void consoleOutput(String string) {
        System.out.println(string);
    }

    public static String replace(String string, char c, String string2) {
        return string.indexOf(c) < 0 ? string : BasisLibrary2.replace(string, String.valueOf(c), new String[]{string2});
    }

    public static String replace(String string, String string2, String[] stringArray) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = string2.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.append(stringArray[n2]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static char[] prefix_from_QNameF(QName qName) {
        return qName.getPrefix().toCharArray();
    }

    public static char[] local_name_from_QNameF(QName qName) {
        return qName.getLocalPart().toCharArray();
    }

    public static char[] namespace_uri_from_QNameF(QName qName) {
        return qName.getNamespaceURI().toCharArray();
    }

    public static char[] namespace_uri_for_prefixF(char[] cArray, XDMCursor xDMCursor) {
        String string = new String(cArray);
        if (string.equals(EMPTYSTRING)) {
            return xDMCursor.getNamespaceURI().toCharArray();
        }
        try {
            return BasisLibrary2.lookupNamespace(xDMCursor, string).toCharArray();
        }
        catch (TransletException transletException) {
            throw new RuntimeException(transletException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            return new char[0];
        }
    }

    public static char[] in_scope_prefixesF(XDMCursor xDMCursor) {
        StringBuffer stringBuffer = new StringBuffer();
        XDMCursor xDMCursor2 = xDMCursor.getAxisCursor(13);
        if (!xDMCursor2.isEmpty()) {
            do {
                XDMCursor xDMCursor3;
                if ((xDMCursor3 = xDMCursor2.getAxisCursor(9)).isEmpty()) continue;
                do {
                    stringBuffer.append(xDMCursor3.getLocalName());
                    stringBuffer.append('@');
                } while (xDMCursor3.nextNode());
            } while (xDMCursor2.next());
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1).toString().toCharArray();
    }

    public static char[] stringFromCodepoints(int n) {
        char[] cArray;
        if (n < 65536) {
            cArray = new char[1];
            if (n < 31 && n != 9 && n != 10 && n != 13) {
                BasisLibrary2.runTimeError("CONTRO_CODES");
            }
            cArray[0] = (char)n;
        } else {
            cArray = new char[2];
            if (n > 0x10FFFF) {
                BasisLibrary2.runTimeError("INVALID_XML_CHARACTER");
            }
            StringBuffer stringBuffer = new StringBuffer();
            cArray[0] = (char)((n -= 65536) / 1024 + 55296);
            cArray[1] = (char)(n % 1024 + 56320);
        }
        return cArray;
    }

    public static boolean matchesF(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = new String(cArray);
        String string2 = new String(cArray2);
        String string3 = new String(cArray3);
        try {
            RegularExpression regularExpression = new RegularExpression(string2.trim(), string3 + "H");
            return regularExpression.matches(string);
        }
        catch (ParseException parseException) {
            if (parseException.getMessage().indexOf("Unknown Option") != -1) {
                BasisLibrary2.runTimeError("ERR_REG_FLAGS", string3);
            } else {
                BasisLibrary2.runTimeError("ERR_INVALID_REG_EXP");
            }
            return false;
        }
    }

    public static char[] replaceF(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        String string = new String(cArray);
        String string2 = new String(cArray2);
        String string3 = new String(cArray3);
        String string4 = new String(cArray4);
        Match match = new Match();
        StringBuffer stringBuffer = new StringBuffer();
        RegularExpression regularExpression = new RegularExpression(string2, string4);
        while (!string.equals(EMPTYSTRING) && regularExpression.matches(string, match)) {
            String string5 = BasisLibrary2.varSubstitution(string3, match);
            if (match.getBeginning(0) == match.getEnd(0)) {
                BasisLibrary2.runTimeError("ER_MATCHES_ZERO_LENGTH_STRING");
            }
            int n = string.length();
            stringBuffer.append(string.substring(0, match.getBeginning(0)));
            stringBuffer.append(string5);
            int n2 = match.getEnd(0);
            if (0 == n2 && n > 1) {
                string = string.substring(1);
                continue;
            }
            if (n == 1) {
                string = EMPTYSTRING;
                continue;
            }
            string = string.substring(n2);
        }
        return stringBuffer.append(string).toString().toCharArray();
    }

    private static String varSubstitution(String string, Match match) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = match.getNumberOfGroups();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == '$') {
                if (++i < n && (c = string.charAt(i)) >= '1' && c <= '9') {
                    int n3 = c - 48;
                    if (n3 >= n2) continue;
                    stringBuffer.append(match.getCapturedText(n3));
                    continue;
                }
                BasisLibrary2.runTimeError("ER_INVALID_REPLACE_STRING");
                continue;
            }
            if (c2 == '\\') {
                if (++i < n) {
                    c = string.charAt(i);
                    if (c != '\\' && c != '$') continue;
                    stringBuffer.append(c);
                    continue;
                }
                BasisLibrary2.runTimeError("ER_INVALID_REPLACE_STRING");
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static int[] tokenizeF(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = new String(cArray);
        String string2 = new String(cArray2);
        String string3 = new String(cArray3);
        Match match = new Match();
        int[] nArray = new int[2];
        RegularExpression regularExpression = new RegularExpression(string2, string3);
        int n = 0;
        int n2 = 0;
        while (!string.equals(EMPTYSTRING) && regularExpression.matches(string, match)) {
            if (match.getBeginning(0) == match.getEnd(0)) {
                BasisLibrary2.runTimeError("ER_MATCHES_ZERO_LENGTH_STRING");
            }
            int n3 = string.length();
            int n4 = match.getBeginning(0);
            int n5 = match.getEnd(0);
            string = 0 == n5 && n3 > 1 ? string.substring(1) : (n3 == 1 ? EMPTYSTRING : string.substring(n5));
            nArray[n2++] = n;
            nArray[n2++] = n4;
            n += n5;
            int[] nArray2 = new int[n2 + 2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        if (string.equals(EMPTYSTRING)) {
            nArray[n2++] = cArray.length;
            nArray[n2] = 0;
        } else {
            nArray[n2++] = n;
            nArray[n2] = cArray.length - n;
        }
        return nArray;
    }

    public static Object[] analyze_stringF(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = new String(cArray3);
        for (int i = 0; i < cArray3.length; ++i) {
            if ("smix".indexOf(String.valueOf(cArray3[i])) >= 0) continue;
            BasisLibrary2.runTimeError("INVALID_FLAG_OPTIONS_ERR", string);
        }
        String string2 = new String(cArray);
        String string3 = new String(cArray2);
        Match match = new Match();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            RegularExpression regularExpression = new RegularExpression(string3, string);
            if (regularExpression.matches(EMPTYSTRING, match)) {
                BasisLibrary2.runTimeError("REGEX_MATCH_ZERO_STRING_ERR", string3);
            }
            while (!string2.equals(EMPTYSTRING) && regularExpression.matches(string2, match)) {
                int n = match.getBeginning(0);
                int n2 = match.getEnd(0);
                if (n != 0) {
                    arrayList.add(Boolean.FALSE);
                    arrayList.add(string2.substring(0, n));
                }
                arrayList.add(Boolean.TRUE);
                int n3 = match.getNumberOfGroups();
                String[] stringArray = new String[n3];
                for (int i = 0; match.getNumberOfGroups() > i; ++i) {
                    String string4 = match.getCapturedText(i);
                    stringArray[i] = string4 == null ? EMPTYSTRING : string4;
                }
                arrayList.add(stringArray);
                string2 = string2.substring(n2);
            }
        }
        catch (ParseException parseException) {
            BasisLibrary2.runTimeError("INVALID_REGEX_ERR", string3);
        }
        if (!string2.equals(EMPTYSTRING)) {
            arrayList.add(Boolean.FALSE);
            arrayList.add(string2);
        }
        return arrayList.toArray();
    }

    public static int[] getTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        int n = gregorianCalendar.get(15) / 1000 / 60;
        int n2 = n / 60;
        int n3 = n % 60;
        return new int[]{n2, n3};
    }

    public static char[] resolve_uriF(char[] cArray, char[] cArray2) {
        String string = new String(cArray2);
        String string2 = new String(cArray);
        if (!SystemIDResolver.isAbsoluteURI(string)) {
            BasisLibrary2.runTimeError("ERR_RESOLVE_URI_NOT_ABSOLUTE_URI");
        }
        if (SystemIDResolver.isAbsoluteURI(string2)) {
            return string2.toCharArray();
        }
        if (string.equals(EMPTYSTRING)) {
            return cArray2;
        }
        return (BasisLibrary2.getBaseFromURI(string) + string2).toCharArray();
    }

    private static String getBaseFromURI(String string) {
        int n = string.lastIndexOf(92) + 1;
        int n2 = string.lastIndexOf(47) + 1;
        int n3 = string.indexOf("//") + 2;
        if (n3 > 0 && n3 == n2) {
            return string + "/";
        }
        return string.substring(0, Math.max(n, n2));
    }

    public static char[] escape_uriF(char[] cArray, boolean bl) {
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                stringBuffer.append(c);
                continue;
            }
            if ("#-_.!~*'()".indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            if (!bl && ";/?:@&=+$,[]%".indexOf(c) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            BasisLibrary2.escapeURI(c, stringBuffer);
        }
        return stringBuffer.toString().toCharArray();
    }

    public static char[] escape_html_uriF(char[] cArray) {
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = c;
            if (c2 >= ' ' && c2 <= '~') {
                stringBuffer.append(c);
                continue;
            }
            BasisLibrary2.escapeURI(c, stringBuffer);
        }
        return stringBuffer.toString().toCharArray();
    }

    private static void escapeURI(char c, StringBuffer stringBuffer) {
        stringBuffer.append('%');
        char c2 = c;
        stringBuffer.append("0123456789ABCDEF".charAt(c2 / 16));
        stringBuffer.append("0123456789ABCDEF".charAt(c2 % 16));
    }

    private static void normalize(int n, StringBuffer stringBuffer) {
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
    }

    private static void appendDate(Calendar calendar, StringBuffer stringBuffer) {
        stringBuffer.append(calendar.get(1)).append("-");
        int n = calendar.get(2) + 1;
        BasisLibrary2.normalize(n, stringBuffer);
        stringBuffer.append("-");
        n = calendar.get(5);
        BasisLibrary2.normalize(n, stringBuffer);
    }

    private static void appendTime(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(10);
        BasisLibrary2.normalize(n, stringBuffer);
        stringBuffer.append(":");
        n = calendar.get(12);
        BasisLibrary2.normalize(n, stringBuffer);
        stringBuffer.append(":");
        n = calendar.get(13);
        BasisLibrary2.normalize(n, stringBuffer);
    }

    private static void appendTimeZone(Calendar calendar, StringBuffer stringBuffer) {
        int n = calendar.get(15) + calendar.get(16);
        if (n < 0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        n = Math.abs(n);
        int n2 = n / 3600000;
        int n3 = n % 3600000;
        BasisLibrary2.normalize(n2, stringBuffer);
        stringBuffer.append(":");
        BasisLibrary2.normalize(n3, stringBuffer);
    }

    public static String current_dateTimeF(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        BasisLibrary2.appendDate(calendar, stringBuffer);
        stringBuffer.append("T");
        BasisLibrary2.appendTime(calendar, stringBuffer);
        BasisLibrary2.appendTimeZone(calendar, stringBuffer);
        return stringBuffer.toString();
    }

    public static String current_dateF(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        BasisLibrary2.appendDate(calendar, stringBuffer);
        BasisLibrary2.appendTimeZone(calendar, stringBuffer);
        return stringBuffer.toString();
    }

    public static String current_timeF(Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        BasisLibrary2.appendTime(calendar, stringBuffer);
        BasisLibrary2.appendTimeZone(calendar, stringBuffer);
        return stringBuffer.toString();
    }

    public static XDayTimeDuration implicit_timezoneF() {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(15) + calendar.get(16);
        if (n < 0) {
            stringBuffer.append("-");
        }
        stringBuffer.append("PT");
        n = Math.abs(n);
        int n2 = n / 3600000;
        int n3 = n % 3600000;
        stringBuffer.append(n2).append("H");
        if (n3 != 0) {
            stringBuffer.append(n3).append("M");
        }
        return XDayTimeDuration.parseTMP(stringBuffer.toString());
    }

    public static char upper_caseF(char c) {
        char c2 = c;
        return (char)UCharacter.toUpperCase((int)c2);
    }

    public static char lower_caseF(char c) {
        char c2 = c;
        return (char)UCharacter.toLowerCase((int)c2);
    }

    public static double getRoundValue_double(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 0.0) {
            return d;
        }
        if (d >= -0.5 && d < 0.0) {
            return -0.0;
        }
        return Math.round(d);
    }

    public static float getRoundValue_float(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        if (Float.isInfinite(f)) {
            if (f < 0.0f) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        if ((double)f == 0.0) {
            return f;
        }
        if ((double)f >= -0.5 && f < 0.0f) {
            return -0.0f;
        }
        return Math.round((double)f);
    }

    public static double round_half_to_evenF(double d) {
        return Math.rint(d);
    }

    public static float round_half_to_evenF(float f) {
        return (float)Math.rint(f);
    }

    public static BigDecimal round_half_to_evenF(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, 6);
    }

    public static BigInteger round_half_to_evenF(BigInteger bigInteger) {
        return bigInteger;
    }

    public static double round_half_to_evenF(double d, int n) {
        double d2 = Math.pow(10.0, n);
        long l = Math.round(Math.abs(d * d2 * 10.0));
        long l2 = l % 10L;
        double d3 = l / 10L;
        if (l2 > 5L || l2 == 5L && d3 % 2.0 != 0.0) {
            d3 += 1.0;
        }
        d3 /= d2;
        if (d < 0.0) {
            d3 = 0.0 - d3;
        }
        return d3;
    }

    public static double round_half_to_evenF(double d, BigInteger bigInteger) {
        return BasisLibrary2.round_half_to_evenF(d, bigInteger.intValue());
    }

    public static float round_half_to_evenF(float f, BigInteger bigInteger) {
        return (float)BasisLibrary2.round_half_to_evenF(f, bigInteger.intValue());
    }

    public static BigDecimal round_half_to_evenF(BigDecimal bigDecimal, BigInteger bigInteger) {
        int n = bigInteger.intValue();
        return BasisLibrary2.round_half_to_evenF(bigDecimal, n);
    }

    public static BigDecimal round_half_to_evenF(BigDecimal bigDecimal, int n) {
        BigDecimal bigDecimal2 = bigDecimal.movePointRight(n);
        BigDecimal bigDecimal3 = bigDecimal2.setScale(0, 6);
        return bigDecimal3.movePointLeft(n);
    }

    public static BigInteger round_half_to_evenF(BigInteger bigInteger, BigInteger bigInteger2) {
        return new BigInteger(String.valueOf(BasisLibrary2.round_half_to_evenF(bigInteger.doubleValue(), bigInteger2.intValue())));
    }

    public static double round_half_to_evenF(int n, int n2) {
        return BasisLibrary2.round_half_to_evenF((double)n, n2);
    }

    public static double round_half_to_evenF(float f, int n) {
        return BasisLibrary2.round_half_to_evenF((double)f, n);
    }

    public static String nameF(XDMNode xDMNode) {
        if (xDMNode == null) {
            return EMPTYSTRING;
        }
        return xDMNode.getNodeNameX();
    }

    public static char[] unparsed_entity_uriF(char[] cArray, XDMCursor xDMCursor) {
        String string = new String(cArray);
        if (xDMCursor != null) {
            String string2 = xDMCursor.getUnparsedEntityURI(string);
            if (string2 == null) {
                return new String(EMPTYSTRING).toCharArray();
            }
            return string2.toCharArray();
        }
        BasisLibrary2.runTimeError("ERR_UNPARSED_ENTITY_URI_NO_CONTEXT_NODE");
        return null;
    }

    public static char[] unparsed_entity_public_idF(char[] cArray, XDMCursor xDMCursor) {
        String string = new String(cArray);
        if (xDMCursor != null) {
            String string2 = xDMCursor.getUnparsedEntityPublicID(string);
            if (string2 == null) {
                return new String(EMPTYSTRING).toCharArray();
            }
            return string2.toCharArray();
        }
        BasisLibrary2.runTimeError("ERR_UNPARSED_ENTITY_PUBLIC_ID_NO_CONTEXT_NODE");
        return null;
    }

    private static char[] unparsed_file(char[] cArray, char[] cArray2, char[] cArray3) throws MalformedURLException, UnsupportedEncodingException, IOException, WrongURIException, InvalidXMLException {
        int n;
        BufferedInputStream bufferedInputStream;
        URLConnection uRLConnection;
        String string;
        Object object;
        String string2 = new String(cArray);
        if (string2.indexOf(35) != -1) {
            throw new WrongURIException();
        }
        String string3 = new String(cArray2);
        String string4 = string2;
        if (!SystemIDResolver.isAbsoluteURI(string2)) {
            if (!SystemIDResolver.isAbsolutePath(string2)) {
                object = new String(cArray3);
                try {
                    string4 = SystemIDResolver.getAbsoluteURI(string2, (String)object);
                }
                catch (TransformerException transformerException) {
                    string4 = BasisLibrary2.getBaseFromURI((String)object) + string2;
                }
            } else {
                string4 = SystemIDResolver.getAbsoluteURI(string4);
            }
        }
        if ((string = BasisLibrary2.detectedEncoding(uRLConnection = ((URL)(object = new URL(string4))).openConnection(), bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream()))) != null) {
            string3 = string;
        }
        string3 = string3.toUpperCase(Locale.ENGLISH);
        BasisLibrary2.consumeBOM(bufferedInputStream, string3);
        String string5 = Encodings.convertMime2JavaEncoding(string3);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string5);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) != -1) {
            if (XML11Char.isXML11Invalid(n)) {
                int n2;
                if (XMLChar.isHighSurrogate(n) && (n2 = inputStreamReader.read()) != -1) {
                    if (XMLChar.isLowSurrogate(n2) && XMLChar.isSupplemental(XMLChar.supplemental((char)n, (char)n2))) {
                        stringBuffer.append((char)n);
                        stringBuffer.append((char)n2);
                        continue;
                    }
                    throw new InvalidXMLException();
                }
                throw new InvalidXMLException();
            }
            stringBuffer.append((char)n);
        }
        inputStreamReader.close();
        return stringBuffer.toString().toCharArray();
    }

    public static char[] unparsed_textF(char[] cArray, char[] cArray2, char[] cArray3) {
        try {
            return BasisLibrary2.unparsed_file(cArray, cArray2, cArray3);
        }
        catch (MalformedURLException malformedURLException) {
            BasisLibrary2.runTimeError("INVALID_URI");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            BasisLibrary2.runTimeError("INVALID_ENCODING");
        }
        catch (IOException iOException) {
            BasisLibrary2.runTimeError("INVALID_ENCODING");
        }
        catch (WrongURIException wrongURIException) {
            BasisLibrary2.runTimeError("INVALID_URI");
        }
        catch (InvalidXMLException invalidXMLException) {
            BasisLibrary2.runTimeError("INVALID_XML");
        }
        return null;
    }

    public static boolean unparsed_text_availableF(char[] cArray, char[] cArray2, char[] cArray3) {
        try {
            BasisLibrary2.unparsed_file(cArray, cArray2, cArray3);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String detectedEncoding(URLConnection uRLConnection, InputStream inputStream) {
        String string = uRLConnection.getContentType();
        int n = string != null ? string.indexOf(59) : -1;
        String string2 = null;
        String string3 = null;
        if (n != -1) {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
            if (string3.startsWith("charset=")) {
                if ((string3 = string3.substring(8).trim()).charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"' || string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'') {
                    string3 = string3.substring(1, string3.length() - 1);
                }
            } else {
                string3 = null;
            }
        } else {
            if (string == null) {
                return null;
            }
            string2 = string.trim();
        }
        String string4 = null;
        if (string2.equals("text/xml")) {
            string4 = string3 != null ? string3 : "US-ASCII";
        } else if (string2.equals("application/xml")) {
            string4 = string3 != null ? string3 : BasisLibrary2.getEncodingName(inputStream);
        } else if (string2.endsWith("+xml")) {
            string4 = BasisLibrary2.getEncodingName(inputStream);
        }
        return string4;
    }

    private static String getEncodingName(InputStream inputStream) {
        try {
            byte[] byArray = new byte[4];
            inputStream.mark(4);
            int n = inputStream.read(byArray, 0, 4);
            inputStream.reset();
            if (n != 4) {
                return null;
            }
            int n2 = byArray[0] & 0xFF;
            int n3 = byArray[1] & 0xFF;
            if (n2 == 254 && n3 == 255) {
                return "UTF-16BE";
            }
            if (n2 == 255 && n3 == 254) {
                return "UTF-16LE";
            }
            int n4 = byArray[2] & 0xFF;
            if (n2 == 239 && n3 == 187 && n4 == 191) {
                return "UTF-8";
            }
            int n5 = byArray[3] & 0xFF;
            if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
                return "ISO-10646-UCS-4";
            }
            if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
                return "ISO-10646-UCS-4";
            }
            if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
                return "ISO-10646-UCS-4";
            }
            if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
                return "ISO-10646-UCS-4";
            }
            if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
                return "UTF-16BE";
            }
            if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
                return "UTF-16LE";
            }
            if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
                return "CP037";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void consumeBOM(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[3];
        int n = 0;
        inputStream.mark(3);
        if (string.equals("UTF-8")) {
            n = inputStream.read(byArray, 0, 3);
            if (n == 3) {
                int n2 = byArray[0] & 0xFF;
                int n3 = byArray[1] & 0xFF;
                int n4 = byArray[2] & 0xFF;
                if (n2 != 239 || n3 != 187 || n4 != 191) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        } else if (string.equals("UTF-16BE")) {
            n = inputStream.read(byArray, 0, 2);
            if (n == 2) {
                int n5 = byArray[0] & 0xFF;
                int n6 = byArray[1] & 0xFF;
                if (n5 != 254 || n6 != 255) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        } else if (string.equals("UTF-16LE")) {
            n = inputStream.read(byArray, 0, 2);
            if (n == 2) {
                int n7 = byArray[0] & 0xFF;
                int n8 = byArray[1] & 0xFF;
                if (n7 != 255 || n8 != 254) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        }
    }

    public static QName resolve_QNameF(char[] cArray, XDMCursor xDMCursor) {
        String string = new String(cArray);
        String string2 = EMPTYSTRING;
        String string3 = EMPTYSTRING;
        try {
            int n = string.indexOf(":");
            if (n == -1) {
                string2 = EMPTYSTRING;
                string3 = string;
            } else {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            String string4 = BasisLibrary2.lookupNamespace(xDMCursor, string2);
            return new QName(string4, string3, string2);
        }
        catch (TransletException transletException) {
            throw new RuntimeException(transletException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            if (string2.equals(EMPTYSTRING)) {
                return new QName(string3);
            }
            BasisLibrary2.runTimeError("ERR_NO_NAMESPACE_FOR_PREFIX");
            return null;
        }
    }

    private static String lookupNamespace(XDMCursor xDMCursor, String string) throws TransletException {
        XDMCursor xDMCursor2 = xDMCursor.getAxisCursor(9);
        if (!xDMCursor2.isEmpty()) {
            do {
                if (!xDMCursor2.getLocalName().equals(string)) continue;
                return xDMCursor2.getNodeValue();
            } while (xDMCursor2.nextNode());
        }
        BasisLibrary2.runTimeError("NAMESPACE_PREFIX_ERR", string);
        return null;
    }

    public static String getStringValue(XSequence xSequence) {
        if (xSequence == null || xSequence.isEmpty()) {
            return EMPTYSTRING;
        }
        StringBuffer stringBuffer = new StringBuffer();
        XItem xItem = xSequence.getCurrentItem();
        stringBuffer.append(((Object)xItem).toString());
        while (xSequence.next()) {
            stringBuffer.append(' ');
            xItem = xSequence.getCurrentItem();
            stringBuffer.append(((Object)xItem).toString());
        }
        return stringBuffer.toString();
    }

    public static final boolean g_compareF(int n, XSequence xSequence, XSequence xSequence2) throws TypeError {
        if (xSequence.isEmpty() || xSequence2.isEmpty()) {
            return false;
        }
        do {
            XItem xItem = xSequence.getCurrentItem();
            do {
                XItem xItem2;
                if (!BasisLibrary2.g_compareItems(n, xItem, xItem2 = xSequence2.getCurrentItem())) continue;
                return true;
            } while (xSequence2.next());
            xSequence2.resetIteration();
        } while (xSequence.next());
        return false;
    }

    private static final boolean g_compareItems(int n, XItem xItem, XItem xItem2) throws TypeError {
        XItem xItem3 = xItem;
        XItem xItem4 = xItem2;
        BasisLibrary2.g_castItems(xItem, xItem2, xItem3, xItem4);
        return BasisLibrary2.g_compareCastedItems(n, xItem3, xItem4);
    }

    private static final void g_castItems(XItem xItem, XItem xItem2, XItem xItem3, XItem xItem4) throws TypeError {
        int n = xItem.getPrimitiveId();
        int n2 = xItem2.getPrimitiveId();
        if (n == 0 && n2 == 0) {
            xItem3 = new XString(((Object)xItem3).toString());
            xItem4 = new XString(((Object)xItem4).toString());
        } else {
            if (n == 0 && n2 != 0) {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        xItem3 = new XDouble(xItem3.toDouble());
                        xItem4 = new XDouble(xItem4.toDouble());
                    }
                }
                throw new TypeError();
            }
            if (n != 0 && n2 == 0) {
                switch (n) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        xItem3 = new XDouble(xItem3.toDouble());
                        xItem4 = new XDouble(xItem4.toDouble());
                    }
                }
                throw new TypeError();
            }
        }
    }

    private static final boolean g_compareCastedItems(int n, XItem xItem, XItem xItem2) {
        switch (n) {
            case 13: {
                return xItem.equals(xItem2);
            }
            case 14: {
                return xItem.notEquals(xItem2);
            }
            case 15: {
                return xItem.lessThan(xItem2);
            }
            case 16: {
                return xItem.lessOrEquals(xItem2);
            }
            case 17: {
                return xItem.greaterThan(xItem2);
            }
            case 18: {
                return xItem.greaterOrEquals(xItem2);
            }
        }
        throw new TypeError();
    }

    public static final XDMCursor[] docOrderF(XDMCursor[] xDMCursorArray) {
        int n = xDMCursorArray.length;
        if (n > 1) {
            BasisLibrary2.quickSort(xDMCursorArray, 0, n - 1);
            return BasisLibrary2.removeDuplicates(xDMCursorArray);
        }
        return xDMCursorArray;
    }

    public static String qNameToString(QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getPrefix();
        String string3 = qName.getLocalPart();
        if (string.equals(EMPTYSTRING) || string2.equals(EMPTYSTRING)) {
            return qName.getLocalPart();
        }
        if (string3.equals(EMPTYSTRING)) {
            return string2;
        }
        return string2 + ":" + string3;
    }

    private static final void quickSort(XDMCursor[] xDMCursorArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        XDMCursor xDMCursor = xDMCursorArray[n];
        while (n < n2) {
            while (xDMCursorArray[n2].relativeDocOrder(xDMCursor) >= 0 && n < n2) {
                --n2;
            }
            if (n != n2) {
                xDMCursorArray[n] = xDMCursorArray[n2];
                ++n;
            }
            while (xDMCursorArray[n].relativeDocOrder(xDMCursor) <= 0 && n < n2) {
                ++n;
            }
            if (n == n2) continue;
            xDMCursorArray[n2] = xDMCursorArray[n];
            --n2;
        }
        xDMCursorArray[n] = xDMCursor;
        int n5 = n;
        n = n3;
        n2 = n4;
        if (n < n5) {
            BasisLibrary2.quickSort(xDMCursorArray, n, n5 - 1);
        }
        if (n2 > n5) {
            BasisLibrary2.quickSort(xDMCursorArray, n5 + 1, n2);
        }
    }

    private static final XDMCursor[] removeDuplicates(XDMCursor[] xDMCursorArray) {
        int n = xDMCursorArray.length;
        int n2 = 0;
        XDMCursor[] xDMCursorArray2 = new XDMCursor[n];
        xDMCursorArray2[0] = xDMCursorArray[0];
        for (int i = 1; i < n; ++i) {
            if (xDMCursorArray2[n2].relativeDocOrder(xDMCursorArray[i]) == 0) continue;
            xDMCursorArray2[++n2] = xDMCursorArray[i];
        }
        XDMCursor[] xDMCursorArray3 = new XDMCursor[n2 + 1];
        System.arraycopy(xDMCursorArray2, 0, xDMCursorArray3, 0, n2 + 1);
        return xDMCursorArray3;
    }

    public static final QName construct_QNameF(char[] cArray, char[] cArray2) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = EMPTYSTRING;
        int n = string2.indexOf(":");
        if (n != -1) {
            string3 = string2.substring(0, n);
        }
        String string4 = string2.substring(n + 1);
        return new QName(string, string4, string3);
    }

    public static XDMCursor idF(XDMCursor xDMCursor, char[] cArray) {
        int n;
        String string = String.valueOf(cArray);
        int n2 = 0;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    linkedList.add(string.substring(n2, i));
                    n2 = i + 1;
                }
            }
        }
        if (n2 < string.length()) {
            linkedList.add(string.substring(n2));
        }
        XDMCursor xDMCursor2 = xDMCursor.getElementById((String)linkedList.get(0));
        for (n = 1; n < linkedList.size(); ++n) {
            xDMCursor2 = new XDMUnionCursor(xDMCursor2, xDMCursor.getElementById((String)linkedList.get(n)));
        }
        xDMCursor2.resetIteration();
        do {
            n = 0;
        } while (xDMCursor2.nextNode());
        xDMCursor2.resetIteration();
        return xDMCursor2;
    }

    public static QName validateQNameF(char[] cArray, boolean bl, boolean bl2, Hashtable hashtable) {
        String string = new String(cArray);
        if (bl) {
            if (!XMLChar.isValidQNameButNotNCName(string)) {
                BasisLibrary2.runTimeError("INVALID_QNAME_BUT_NOT_NCNAME_ERR", string);
            }
        } else if (!XMLChar.isValidQName(string)) {
            BasisLibrary2.runTimeError("INVALID_QNAME_ERR", string);
        }
        QName qName = BasisLibrary2.construct_QNameF(new char[0], cArray);
        String string2 = qName.getPrefix();
        String string3 = EMPTYSTRING;
        if (string2 == null || string2.length() == 0) {
            string2 = EMPTYSTRING;
            if (bl2 && (string3 = (String)hashtable.get(string2)) == null) {
                string3 = EMPTYSTRING;
            }
        } else {
            string3 = (String)hashtable.get(string2);
            if (string3 == null) {
                BasisLibrary2.runTimeError("UNRESOLVED_PREFIX_ERR", string2);
            }
        }
        return new QName(string3, qName.getLocalPart(), string2);
    }

    public static char[] getNodeName_StringF(XDMCursor xDMCursor) {
        String string = xDMCursor.getNamespaceURI();
        String string2 = xDMCursor.getLocalName();
        if (string != null && !string.equals(EMPTYSTRING)) {
            string2 = string + ":" + string2;
        }
        return string2.toCharArray();
    }

    public static void nameSpaceChecking(QName qName, XDMCursor[] xDMCursorArray) {
        String string = qName.getPrefix();
        if (string.length() > 0) {
            return;
        }
        String string2 = null;
        for (int i = 0; i < xDMCursorArray.length; ++i) {
            boolean bl;
            String string3 = xDMCursorArray[i].getNodeName();
            boolean bl2 = bl = string3.startsWith("xmlns") && string3.indexOf(":") == -1;
            if (!bl) continue;
            string2 = xDMCursorArray[i].getNodeValue();
        }
        if (string2 != null && string2.length() > 0 && !string2.equals(qName.getNamespaceURI())) {
            BasisLibrary2.runTimeError("INVALID_NAMESPACES", qName.getLocalPart(), string2);
        }
    }

    public static void defineCollator(String string, String object, String string2, String string3, String string4, String string5, String string6) {
        Object object2;
        if (string6 == null || string6.length() == 0) {
            object2 = CollatorFactory.getLangSupported((String)object);
            if (((String)object).equals(EMPTYSTRING)) {
                object = object2;
            } else {
                int n = CollatorFactory.compareLangCountryVariant((String)object, (String)object2);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        BasisLibrary2.runTimeWarning("COLLATION_LANG_ASSUMED", new Object[]{string, object, object2});
                        object = object2;
                        break;
                    }
                    default: {
                        BasisLibrary2.runTimeWarning("COLLATION_LANG_IGNORED", new Object[]{string, object});
                        object = EMPTYSTRING;
                    }
                }
            }
        }
        object2 = CollatorFactory.getCollatorDeclaration(string, (String)object, string2, string3, string4, string5, string6);
        XCollator xCollator = CollatorFactory.createCollatorFromDeclaration((CollatorDeclaration)object2);
        s_xcollatorCache.cache(object2.getName(), xCollator);
        s_xcollatorCache.cache(object2.getKey(), xCollator);
    }

    private static XCollator getCollatorFromURI(String string) {
        XCollator xCollator = s_xcollatorCache.get(string);
        return xCollator;
    }

    public static int fn_compare_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "compare", string3);
        }
        Object object = xCollator.getComparator(string);
        Object object2 = xCollator.getComparator(string2);
        int n = xCollator.compare(object, object2);
        return n;
    }

    public static int fn_index_of_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "index-of", string3);
        }
        String string4 = xCollator.substringBefore(string, string2);
        char[] cArray4 = string4.toCharArray();
        int n = cArray4.length;
        return n;
    }

    public static boolean fn_starts_with_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "starts-with", string3);
        }
        boolean bl = xCollator.startsWith(string, string2);
        return bl;
    }

    public static boolean fn_contains_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "contains", string3);
        }
        boolean bl = xCollator.contains(string, string2);
        return bl;
    }

    public static boolean fn_ends_with_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "ends-with", string3);
        }
        boolean bl = xCollator.endsWith(string, string2);
        return bl;
    }

    public static char[] fn_substring_before_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "substring-before", string3);
        }
        String string4 = xCollator.substringBefore(string, string2);
        char[] cArray4 = string4.toCharArray();
        return cArray4;
    }

    public static char[] fn_substring_after_3(char[] cArray, char[] cArray2, char[] cArray3) {
        String string = String.valueOf(cArray);
        String string2 = String.valueOf(cArray2);
        String string3 = String.valueOf(cArray3);
        XCollator xCollator = BasisLibrary2.getCollatorFromURI(string3);
        if (xCollator == null) {
            BasisLibrary2.runTimeError("COLLATION_NOT_REC_IN_XPATH_EXPR", "substring-after", string3);
        }
        String string4 = xCollator.substringAfter(string, string2);
        char[] cArray4 = string4.toCharArray();
        return cArray4;
    }

    public static char[] fn_format_date_5(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        return new DateFormatFunctionsLibrary().formatDate(stringArray, cArray, cArray2, cArray3, cArray4);
    }

    public static char[] fn_format_dateTime_5(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        return new DateFormatFunctionsLibrary().formatDateTime(stringArray, cArray, cArray2, cArray3, cArray4);
    }

    public static char[] fn_format_time_5(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        return new DateFormatFunctionsLibrary().formatTime(stringArray, cArray, cArray2, cArray3, cArray4);
    }

    public static char[] format_number(int[] nArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char[] cArray5, char[] cArray6) {
        int n;
        int n2;
        char c;
        int n3;
        String string = new String(cArray2);
        int n4 = Integer.parseInt(string);
        String string2 = new String(cArray3);
        String string3 = new String(cArray4);
        String string4 = new String(cArray5);
        String string5 = new String(cArray6);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (cArray3.length == 0) {
            n4 = 0;
        }
        NumberFormatInt numberFormatInt = NumberFormatInt.getInstance();
        for (n3 = 0; n3 < cArray.length && !BasisLibrary2.isCharInFormatToken(c = cArray[n3]); ++n3) {
            stringBuffer.append(c);
        }
        int n5 = 0;
        int n6 = cArray.length;
        for (n2 = n6 - 1; 0 <= n2 && !BasisLibrary2.isCharInFormatToken(cArray[n2]); --n2) {
        }
        n5 = n2 + 1;
        int n7 = 0;
        int n8 = 0;
        String string6 = "1";
        for (n = 0; n < nArray.length; ++n) {
            if (n > 0) {
                if (n7 < n8) {
                    for (int i = n7; i < n8; ++i) {
                        stringBuffer.append(cArray[i]);
                    }
                } else {
                    stringBuffer.append('.');
                }
            }
            if (n3 < cArray.length && BasisLibrary2.isCharInFormatToken(cArray[n3])) {
                while (n3 < cArray.length && BasisLibrary2.isCharInFormatToken(c = cArray[n3])) {
                    stringBuffer2.append(c);
                    ++n3;
                }
                string6 = new String(stringBuffer2);
                stringBuffer2.setLength(0);
            }
            long l = nArray[n];
            String string7 = numberFormatInt.formatValue(l, string6, n4, string2, string3, string4, string5);
            stringBuffer.append(string7);
            int n9 = n3;
            int n10 = n3;
            while (n3 < cArray.length && !BasisLibrary2.isCharInFormatToken(c = cArray[n3])) {
                n10 = ++n3;
            }
            if (n10 >= cArray.length) continue;
            n7 = n9;
            n8 = n10;
        }
        for (n = n5; n < n6; ++n) {
            stringBuffer.append(cArray[n]);
        }
        String string8 = new String(stringBuffer);
        return string8.toCharArray();
    }

    private static boolean isCharInFormatToken(char c) {
        boolean bl = false;
        switch (c) {
            case '0': 
            case '1': 
            case 'A': 
            case 'I': 
            case 'N': 
            case 'W': 
            case 'a': 
            case 'i': 
            case 'n': 
            case 'o': 
            case 'w': 
            case '\u03b1': 
            case '\u0430': 
            case '\u05d0': 
            case '\u0e51': 
            case '\u10d0': 
            case '\u30a2': 
            case '\u30a4': {
                bl = true;
            }
        }
        if (!bl) {
            bl = Character.isDigit(c);
        }
        return bl;
    }

    private static String lookupNamespace(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    private static QName getQNameFromString(String string, boolean bl, String string2, String string3, String[] stringArray) {
        String string4;
        int n = string.lastIndexOf(58);
        if (n != -1) {
            String string5 = string.substring(0, n);
            String string6 = string.substring(n + 1);
            String string7 = null;
            if (!string5.equals("xmlns") && (string7 = BasisLibrary2.lookupNamespace(string5, stringArray)) == null && bl) {
                ASTMsg aSTMsg = new ASTMsg("NAMESPACE_UNDEF_ERR", 0, 0, string5);
                throw new DynamicError(aSTMsg.toString());
            }
            return new QName(string7, string6, string5);
        }
        if (string.equals("xmlns")) {
            string4 = null;
            string2 = null;
        } else {
            string4 = string3 == null ? BasisLibrary2.lookupNamespace(EMPTYSTRING, stringArray) : string3;
        }
        return new QName(string4, string, string2);
    }

    public static boolean functionAvailableF(String string, boolean bl, int n, boolean bl2, String[] stringArray, boolean bl3) {
        QName qName = BasisLibrary2.getQNameFromString(string, true, "fn", "http://www.w3.org/2005/xpath-functions", stringArray);
        return BasisLibrary2.functionAvailable(qName, bl, n, bl2, bl3);
    }

    public static boolean functionAvailable(QName qName, boolean bl, int n, boolean bl2, boolean bl3) {
        boolean bl4;
        String string = qName.getNamespaceURI();
        if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
            bl4 = false;
            for (int i = 0; i < TypeFactory.getTypeSize(); ++i) {
                IDerivableType iDerivableType = TypeFactory.getTypeFromId(i);
                if (!iDerivableType.getQName().equals(qName)) continue;
                bl4 = true;
                break;
            }
            if (!bl4) {
                // empty if block
            }
        } else if (string.equals("http://xtqhp")) {
            bl4 = BasisLibrary2.isFuncInTable(n, qName, (byte)2);
        } else if (string.equals("http://www.w3.org/2005/xpath-functions")) {
            bl4 = BasisLibrary2.isFuncInTable(n, qName, (byte)0);
            if (!bl4) {
                bl4 = BasisLibrary2.isFuncInTable(n, qName, (byte)1);
            }
            if (!bl4) {
                bl4 = qName.getLocalPart().equals("concat");
            }
        } else {
            bl4 = !bl3 ? false : false;
        }
        return bl4;
    }

    private static boolean isFuncInTable(int n, QName qName, byte by) {
        boolean bl = false;
        FunctionOperatorTable functionOperatorTable = FunctionOperatorTable.getInstance();
        block0 : switch (by) {
            case 1: {
                for (int i = 0; i < functionOperatorTable.getPolymorphicFunctionLength(); ++i) {
                    String string = functionOperatorTable.getPolymorphicFunctionName(i);
                    if (!string.equals(qName.getLocalPart()) || n != -1 && functionOperatorTable.getPolymorphicFunctionDeclLength(i) - 3 != n) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < functionOperatorTable.getSimpleFunctionLength(); ++i) {
                    String string = functionOperatorTable.getSimpleFunctionName(i);
                    if (!string.equals(qName.getLocalPart()) || n != -1 && functionOperatorTable.getSimpleFunctionDeclLength(i) - 3 != n) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < functionOperatorTable.getXtqhpFunctionLength(); ++i) {
                    String string = functionOperatorTable.getXtqhpFunctionName(i);
                    if (!string.equals(qName.getLocalPart()) || n != -1 && functionOperatorTable.getXtqhpFunctionDeclLength(i) - 3 != n) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
        }
        return bl;
    }

    public static XSModel getSchemaModel(char[] cArray, String[] stringArray) {
        String string = String.valueOf(cArray);
        XSModel xSModel = null;
        try {
            XSImplementation xSImplementation = (XSImplementation)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("XS-Loader"));
            XSLoader xSLoader = xSImplementation.createXSLoader(SUPPORTED_SCHEMA_VERSION);
            DOMConfiguration dOMConfiguration = xSLoader.getConfig();
            dOMConfiguration.setParameter("validate", Boolean.TRUE);
            dOMConfiguration.setParameter("error-handler", new DOMErrorHandler(){

                public boolean handleError(DOMError dOMError) {
                    System.out.println(dOMError.getMessage());
                    return false;
                }
            });
            InlineSchemaResolver inlineSchemaResolver = new InlineSchemaResolver(stringArray);
            dOMConfiguration.setParameter("resource-resolver", inlineSchemaResolver);
            xSModel = xSLoader.load(new SyntheticSchemaInput(string));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return xSModel;
    }

    public static Validator getSchemaValidator(char[] cArray, String[] stringArray) {
        String string = String.valueOf(cArray);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature(GRAMMAR_POOL_ONLY, false);
            schemaFactory.setResourceResolver(new InlineSchemaResolver(stringArray));
            Schema schema = schemaFactory.newSchema(new StreamSource(new StringReader(string)));
            Validator validator = schema.newValidator();
            return validator;
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException.toString());
        }
    }

    public static XDMCursor validateElemOrDocByType(Validator validator, XDMCursor xDMCursor, QName qName) {
        return BasisLibrary2.handleAllElemDocValidation(validator, xDMCursor, true, qName);
    }

    public static XDMCursor validateElemOrDoc(Validator validator, XDMCursor xDMCursor, boolean bl) {
        return BasisLibrary2.handleAllElemDocValidation(validator, xDMCursor, bl, null);
    }

    private static XDMCursor handleAllElemDocValidation(Validator validator, XDMCursor xDMCursor, boolean bl, QName qName) {
        try {
            int n;
            Object object;
            boolean bl2;
            Node node = xDMCursor.getNode();
            Node node2 = null;
            DOMSource dOMSource = new DOMSource(node);
            DOMResult dOMResult = new DOMResult(node);
            short s = node.getNodeType();
            boolean bl3 = bl2 = s == 11;
            if (bl2) {
                object = node.getChildNodes();
                for (n = 0; n < object.getLength(); ++n) {
                    Node node3 = object.item(n);
                    short s2 = node3.getNodeType();
                    if (s2 == 1) {
                        if (node2 != null) {
                            BasisLibrary2.runTimeError("TYPE_ERR_VALIDATE_DOCUMENT_MORE_ELEM");
                        }
                        node2 = node3;
                        continue;
                    }
                    if (s2 != 3) continue;
                    BasisLibrary2.runTimeError("TYPE_ERR_VALIDATE_DOCUMENT_TEXT");
                }
                if (node2 == null) {
                    BasisLibrary2.runTimeError("TYPE_ERR_VALIDATE_DOCUMENT_NO_ELEM");
                }
            } else {
                node2 = node;
            }
            validator.setFeature(UNPARSED_ENTITY_CHECKING, false);
            validator.setFeature(DYNAMIC_VALIDATION, false);
            validator.setProperty(ROOT_TYPE_DEF, qName);
            validator.setFeature(IGNORE_XSI_TYPE, true);
            validator.setFeature(ID_IDREF_CHECKING, bl2);
            validator.setFeature(IDC_CHECKING, bl2);
            validator.validate(dOMSource, dOMResult);
            object = (ItemPSVI)((Object)node2);
            n = object.getValidity();
            if (n != 2) {
                if (qName != null) {
                    BasisLibrary2.runTimeError("TYPE_ERR_TYPE_ATTRIBUTE");
                } else if (bl) {
                    BasisLibrary2.runTimeError("TYPE_ERR_VALIDATION_STRICT");
                } else if (n == 1) {
                    BasisLibrary2.runTimeError("TYPE_ERR_VALIDATION_LAX");
                }
            }
            return xDMCursor.cloneXDMCursor();
        }
        catch (SAXException sAXException) {
            throw new DynamicError(sAXException.toString());
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException.toString());
        }
    }

    public static XDMCursor preserveElementPSVI(XDMCursor xDMCursor, XDMCursor xDMCursor2) {
        ((PSVIElementNSImpl)xDMCursor.getNode()).setPSVI((ElementPSVI)((Object)xDMCursor2.getNode()));
        return xDMCursor;
    }

    public static XDMCursor validateAttributeByType(XDMManagerFactory xDMManagerFactory, XSTypeDefinition xSTypeDefinition, XDMCursor xDMCursor) {
        return BasisLibrary2.handleAllAttributeValidation(xDMManagerFactory, null, (XSSimpleType)xSTypeDefinition, xDMCursor, true, true);
    }

    public static XDMCursor validateAttribute(XDMManagerFactory xDMManagerFactory, XSModel xSModel, XDMCursor xDMCursor, boolean bl) {
        Node node = xDMCursor.getNode();
        XSAttributeDeclaration xSAttributeDeclaration = xSModel.getAttributeDeclaration(node.getLocalName(), node.getNamespaceURI());
        XSSimpleType xSSimpleType = xSAttributeDeclaration != null ? (XSSimpleType)xSAttributeDeclaration.getTypeDefinition() : null;
        return BasisLibrary2.handleAllAttributeValidation(xDMManagerFactory, xSAttributeDeclaration, xSSimpleType, xDMCursor, bl, false);
    }

    private static XDMCursor handleAllAttributeValidation(XDMManagerFactory xDMManagerFactory, final XSAttributeDeclaration xSAttributeDeclaration, final XSSimpleType xSSimpleType, XDMCursor xDMCursor, boolean bl, boolean bl2) {
        boolean bl3;
        Node node = xDMCursor.getNode();
        final String string = node.getNodeValue();
        final ValidatedInfo validatedInfo = new ValidatedInfo();
        boolean bl4 = bl3 = xSSimpleType != null;
        if (bl3) {
            boolean bl5;
            try {
                Object object = xSSimpleType.validate(string, null, validatedInfo);
                if (xSAttributeDeclaration != null) {
                    XSAttributeDecl xSAttributeDecl = (XSAttributeDecl)xSAttributeDeclaration;
                    bl5 = xSAttributeDeclaration.getConstraintType() != 2 || ValidatedInfo.isComparable(validatedInfo, xSAttributeDecl.getValInfo()) && object.equals(xSAttributeDeclaration.getActualVC());
                } else {
                    bl5 = true;
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                bl5 = false;
            }
            if (!bl5) {
                if (bl2) {
                    BasisLibrary2.runTimeError("TYPE_ERR_TYPE_ATTRIBUTE");
                } else if (bl) {
                    BasisLibrary2.runTimeError("TYPE_ERR_VALIDATION_STRICT");
                } else {
                    BasisLibrary2.runTimeError("TYPE_ERR_VALIDATION_LAX");
                }
            }
        } else if (bl) {
            BasisLibrary2.runTimeError("TYPE_ERR_VALIDATION_STRICT_NO_MATCH_TOP_LEVEL");
        }
        PSVIAttrNSImpl pSVIAttrNSImpl = (PSVIAttrNSImpl)new PSVIDocumentImpl().createAttributeNS(node.getNamespaceURI(), node.getNodeName());
        pSVIAttrNSImpl.setValue(bl3 ? validatedInfo.normalizedValue : string);
        pSVIAttrNSImpl.setPSVI(new AttributePSVI(){

            public XSAttributeDeclaration getAttributeDeclaration() {
                return xSAttributeDeclaration;
            }

            public String getValidationContext() {
                return null;
            }

            public short getValidity() {
                return bl3 ? (short)2 : 0;
            }

            public short getValidationAttempted() {
                return bl3 ? (short)2 : 0;
            }

            public StringList getErrorCodes() {
                return new StringListImpl(new String[0]);
            }

            public String getSchemaNormalizedValue() {
                return bl3 ? validatedInfo.normalizedValue : string;
            }

            public Object getActualNormalizedValue() throws XSException {
                return bl3 ? validatedInfo.actualValue : string;
            }

            public short getActualNormalizedValueType() throws XSException {
                return bl3 ? validatedInfo.actualValueType : (short)1;
            }

            public ShortList getItemValueTypes() throws XSException {
                return validatedInfo.itemValueTypes;
            }

            public XSTypeDefinition getTypeDefinition() {
                return xSSimpleType;
            }

            public XSSimpleTypeDefinition getMemberTypeDefinition() {
                return validatedInfo.memberType;
            }

            public String getSchemaDefault() {
                return xSAttributeDeclaration != null ? xSAttributeDeclaration.getConstraintValue() : null;
            }

            public boolean getIsSchemaSpecified() {
                return false;
            }
        });
        return xDMManagerFactory.getXDM(new DOMSource(pSVIAttrNSImpl), true, null, false, false, false, true);
    }

    public static XDMCursor preserveAttributePSVI(XDMCursor xDMCursor, XDMCursor xDMCursor2) {
        ((PSVIAttrNSImpl)xDMCursor.getNode()).setPSVI((AttributePSVI)((Object)xDMCursor2.getNode()));
        return xDMCursor;
    }

    public static char[] normalizeUnicode(char[] cArray, char[] cArray2) {
        int n;
        int n2 = cArray2.length;
        if (n2 == 0) {
            return cArray;
        }
        if (s_unicodeNormalizer == null) {
            s_unicodeNormalizer = UnicodeNormalizerFactory.getUnicodeNormalizer();
        }
        switch (n2) {
            case 0: {
                return cArray;
            }
            case 3: {
                if (cArray2[2] == 'C') {
                    n = 2;
                    break;
                }
                n = 3;
                break;
            }
            case 4: {
                if (cArray2[3] == 'C') {
                    n = 4;
                    break;
                }
                n = 5;
                break;
            }
            default: {
                return cArray;
            }
        }
        int n3 = cArray.length;
        if (s_unicodeNormalizer.alreadyNormalized(cArray, 0, n3, n)) {
            return cArray;
        }
        int n4 = n3 * 3 + 3;
        char[] cArray3 = new char[n4];
        int n5 = s_unicodeNormalizer.normalizeUnicode(cArray, 0, n3, cArray3, 0, n4, n);
        char[] cArray4 = new char[n5];
        System.arraycopy(cArray3, 0, cArray4, 0, n5);
        return cArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = NumberFormat.getInstance(Locale.getDefault());
        ((NumberFormat)object).setMaximumFractionDigits(Integer.MAX_VALUE);
        defaultFormatter = object instanceof DecimalFormat ? (DecimalFormat)object : new DecimalFormat();
        defaultFormatter.setGroupingUsed(false);
        m_properties = new Properties();
        m_propertiesName = "system.properties";
        object = null;
        Object object2 = null;
        try {
            try {
                object = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return BasisLibrary2.class.getResourceAsStream(m_propertiesName);
                    }
                });
                object2 = new BufferedInputStream((InputStream)object);
                m_properties.load((InputStream)object2);
            }
            catch (IOException iOException) {
                BasisLibrary2.runTimeError(iOException.getMessage());
            }
            catch (SecurityException securityException) {
                BasisLibrary2.runTimeError(securityException.getMessage());
            }
            finally {
                if (object2 != null) {
                    ((BufferedInputStream)object2).close();
                }
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            BasisLibrary2.runTimeError(iOException.getMessage());
        }
        prefixIndex = 0;
        object = "com.ibm.xtq.xslt.runtime.res.RuntimeMessages";
        m_bundle = ResourceBundle.getBundle((String)object);
        s_ICUNumberFormatFactory = NumberFormatFactoryRuleBased.getInstance();
        s_collFactory = new CollatorFactory();
        s_xcollatorCache = new XCollatorCache();
        object2 = CollatorFactory.getPredefinedCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint");
        s_xcollatorCache.cache("http://www.w3.org/2005/xpath-functions/collation/codepoint", (XCollator)object2);
        XCollator xCollator = CollatorFactory.getPredefinedCollator("@/SystemDefault");
        s_xcollatorCache.cache("@/SystemDefault", xCollator);
        SUPPORTED_SCHEMA_VERSION = new StringListImpl(new String[]{"1.0"});
    }

    private static class InlineSchemaResolver
    implements LSResourceResolver {
        String[] _inlineSchemas;

        public InlineSchemaResolver(String[] stringArray) {
            this._inlineSchemas = stringArray;
        }

        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            SyntheticSchemaInput syntheticSchemaInput = null;
            if (!string.equals("http://www.w3.org/2001/XMLSchema")) {
                throw new UnsupportedOperationException();
            }
            for (int i = 0; i < this._inlineSchemas.length; i += 3) {
                if (!this._inlineSchemas[i].equals(string4)) continue;
                String string6 = this._inlineSchemas[i + 1];
                String string7 = this._inlineSchemas[i + 2];
                syntheticSchemaInput = new SyntheticSchemaInput(string7);
                syntheticSchemaInput.setSystemId(string6);
                break;
            }
            return syntheticSchemaInput;
        }
    }

    static class InvalidXMLException
    extends Exception {
        private static final long serialVersionUID = 5690174603272359781L;

        public InvalidXMLException() {
        }

        public InvalidXMLException(String string) {
            super(string);
        }
    }

    private static class StringListImpl
    implements StringList {
        private String[] _stringListValues;

        public StringListImpl(String[] stringArray) {
            this._stringListValues = stringArray;
        }

        public boolean contains(String string) {
            for (int i = 0; i < this._stringListValues.length; ++i) {
                if (!string.equals(this._stringListValues[i])) continue;
                return true;
            }
            return false;
        }

        public int getLength() {
            return this._stringListValues.length;
        }

        public String item(int n) {
            return n >= 0 && n < this._stringListValues.length ? this._stringListValues[n] : null;
        }
    }

    private static class SyntheticSchemaInput
    implements LSInput {
        private String _syntheticSchema;
        private String _systemId;

        public SyntheticSchemaInput(String string) {
            this._syntheticSchema = string;
        }

        public void setSystemId(String string) {
            this._systemId = string;
        }

        public String getSystemId() {
            return this._systemId;
        }

        public void setPublicId(String string) {
            throw new UnsupportedOperationException();
        }

        public String getPublicId() {
            return null;
        }

        public void setCertifiedText(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public boolean getCertifiedText() {
            return false;
        }

        public void setByteStream(InputStream inputStream) {
            throw new UnsupportedOperationException();
        }

        public InputStream getByteStream() {
            return null;
        }

        public void setCharacterStream(Reader reader) {
            throw new UnsupportedOperationException();
        }

        public Reader getCharacterStream() {
            return null;
        }

        public void setStringData(String string) {
            throw new UnsupportedOperationException();
        }

        public String getStringData() {
            return this._syntheticSchema;
        }

        public void setEncoding(String string) {
            throw new UnsupportedOperationException();
        }

        public String getEncoding() {
            return null;
        }

        public void setBaseURI(String string) {
            throw new UnsupportedOperationException();
        }

        public String getBaseURI() {
            return null;
        }
    }

    static class WrongURIException
    extends Exception {
        private static final long serialVersionUID = -4714863748084013149L;

        public WrongURIException() {
        }

        public WrongURIException(String string) {
            super(string);
        }
    }
}

