/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v1;

import com.ibm.xtq.ast.nodes.ApplyTemplates;
import com.ibm.xtq.ast.nodes.AttributeSet;
import com.ibm.xtq.ast.nodes.CallTemplate;
import com.ibm.xtq.ast.nodes.CollationElement;
import com.ibm.xtq.ast.nodes.CompAttrConstructor;
import com.ibm.xtq.ast.nodes.CompElemConstructor;
import com.ibm.xtq.ast.nodes.Copy;
import com.ibm.xtq.ast.nodes.CopyOf;
import com.ibm.xtq.ast.nodes.DirAttributeConstructor;
import com.ibm.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xtq.ast.nodes.DirPIConstructor;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Fallback;
import com.ibm.xtq.ast.nodes.ForEach;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.If;
import com.ibm.xtq.ast.nodes.Key;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Number;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.Redirect;
import com.ibm.xtq.ast.nodes.Sort;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.UnsupportedElement;
import com.ibm.xtq.ast.nodes.UseAttributeSets;
import com.ibm.xtq.ast.nodes.ValueOf;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.When;
import com.ibm.xtq.ast.nodes.WithParam;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.scontext.XStaticContext;
import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.FunctionOperatorHelper;
import com.ibm.xtq.xslt.translator.StylesheetHelper;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.v1.CastHelper;
import com.ibm.xtq.xslt.typechecker.v1.XPathTypeChecker;
import com.ibm.xtq.xslt.typechecker.v1.types.NodeSetType;
import com.ibm.xtq.xslt.typechecker.v1.types.NodeType;
import com.ibm.xtq.xslt.typechecker.v1.types.ReferenceType;
import com.ibm.xtq.xslt.typechecker.v1.types.ResultTreeType;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;

public class XSLTTypeChecker
extends XPathTypeChecker {
    private static final String AttributeSetPrefix = "$as$";
    private XSLTCompiler _xsltc;
    Stack _attrSetStack = null;

    public XSLTTypeChecker(XSLTCompiler xSLTCompiler) {
        super(xSLTCompiler);
        this._xsltc = xSLTCompiler;
    }

    public XSLTCompiler getXSLTC() {
        return this._xsltc;
    }

    public boolean isAttrVisitor() {
        return false;
    }

    public boolean visitNode(Expr expr, int n) {
        try {
            this.setStylesheetVersion(expr.getProgramVersion());
            switch (n) {
                case 16: {
                    return this.unsupportedElement(expr);
                }
                case 194: {
                    return this.applyImports(expr);
                }
                case 195: {
                    return this.applyTemplates(expr);
                }
                case 159: {
                    return this.xslAttribute(expr);
                }
                case 196: {
                    return this.attributeSet(expr);
                }
                case 105: {
                    return this.callTemplate(expr);
                }
                case 197: {
                    return this.choose(expr);
                }
                case 134: {
                    return this.comment(expr);
                }
                case 198: {
                    return this.copy(expr);
                }
                case 199: {
                    return this.copyOf(expr);
                }
                case 220: {
                    return this.decimalFormat(expr);
                }
                case 157: {
                    return this.xslElement(expr);
                }
                case 200: {
                    return this.fallback(expr);
                }
                case 201: {
                    return this.forEach(expr);
                }
                case 32: {
                    break;
                }
                case 56: {
                    return this.xslIf(expr);
                }
                case 221: {
                    return this.xslImport(expr);
                }
                case 222: {
                    return this.include(expr);
                }
                case 223: {
                    return this.key(expr);
                }
                case 226: {
                    return this.message(expr);
                }
                case 224: {
                    return this.namespaceAlias(expr);
                }
                case 206: {
                    return this.number(expr);
                }
                case 207: {
                    return this.otherwise(expr);
                }
                case 212: {
                    return this.output(expr);
                }
                case 34: {
                    return this.param(expr);
                }
                case 141: 
                case 162: {
                    return this.processingInstruction(expr);
                }
                case 211: {
                    return this.sort(expr);
                }
                case 231: 
                case 232: {
                    return this.stripSpace(expr);
                }
                case 3: {
                    return this.stylesheet(expr);
                }
                case 227: {
                    return this.template(expr);
                }
                case 228: {
                    return this.text(expr);
                }
                case 214: {
                    return this.valueOf(expr);
                }
                case 29: {
                    return this.variable(expr);
                }
                case 215: {
                    return this.when(expr);
                }
                case 217: {
                    return this.withParam(expr);
                }
                case 108: {
                    return this.literalElement(expr);
                }
                case 116: {
                    return this.literalAttribute(expr);
                }
                case 235: {
                    return this.redirectExtension(expr);
                }
                case 213: {
                    return this.useAttributeSets(expr, false);
                }
            }
        }
        catch (TypeCheckError typeCheckError) {
            throw new WrappedRuntimeException(typeCheckError);
        }
        return true;
    }

    public void visitTree(Expr expr) {
        int n = expr.getId();
        if (this.visitNode(expr, n)) {
            int n2;
            int n3 = expr.jjtGetNumChildren();
            ArrayList<QName> arrayList = null;
            XStaticContext xStaticContext = this._parser.getStaticContext();
            for (n2 = 0; n2 < n3; ++n2) {
                Expr expr2 = (Expr)expr.jjtGetChild(n2);
                xStaticContext.setCurrentNode(expr2);
                this.visitTree(expr2);
                QName qName = this.updateScope(expr2);
                if (qName == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<QName>(2);
                }
                arrayList.add(qName);
            }
            xStaticContext.setCurrentNode(expr);
            if (arrayList != null) {
                n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    this.removeVariable((QName)arrayList.get(i));
                }
            }
            if (n == 34) {
                this.setParamType(expr);
            } else if (n == 29) {
                this.setVariableType(expr);
            }
        }
    }

    public void leaveNode(Expr expr, int n) {
    }

    private boolean unsupportedElement(Expr expr) throws TypeCheckError {
        UnsupportedElement unsupportedElement = (UnsupportedElement)expr;
        List list = unsupportedElement.getFallbacks();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Fallback fallback = (Fallback)list.get(i);
                this.visitTree(fallback);
            }
        }
        return false;
    }

    private boolean applyImports(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean applyTemplates(Expr expr) throws TypeCheckError {
        Expr expr2;
        ApplyTemplates applyTemplates = (ApplyTemplates)expr;
        XTQProgram xTQProgram = this._parser.getTopLevelXTQProgram();
        QName qName = applyTemplates.getModeName();
        if (qName != null) {
            StylesheetHelper.getMode(xTQProgram, qName, null);
        }
        if ((expr2 = applyTemplates.getExpression()) != null) {
            Type type = this.visitExpression(expr2);
            if (type == Type.Node || type == Type.Reference) {
                CastHelper.setExpressionCastType(expr2, Type.NodeSet);
                type = Type.NodeSet;
            }
            if (type != Type.NodeSet && type != Type.ResultTree) {
                ErrorMsg errorMsg = new ErrorMsg("INVALID_SELECT_EXPR_TYPE", (Object)type.toString(), expr);
                this._parser.reportError(3, errorMsg);
            }
        }
        return true;
    }

    private boolean xslAttribute(Expr expr) throws TypeCheckError {
        CompAttrConstructor compAttrConstructor = (CompAttrConstructor)expr;
        if (!compAttrConstructor.isIgnore()) {
            if (compAttrConstructor.getNameExpr() == null) {
                return true;
            }
            this.attributeValueTemplate(compAttrConstructor.getNameExpr());
            Expr expr2 = compAttrConstructor.getNamespaceExpr();
            if (expr2 != null) {
                this.attributeValueTemplate(expr2);
            }
        }
        return !compAttrConstructor.isIgnore();
    }

    private boolean attributeValue(Expr expr) throws TypeCheckError {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Expr expr2;
            Node node = expr.jjtGetChild(i);
            if (!(node instanceof Expr) || this.visitExpression(expr2 = (Expr)node).identicalTo(Type.String)) continue;
            CastHelper.setExpressionCastType(expr2, Type.String);
        }
        return false;
    }

    private boolean attributeValueTemplate(Expr expr) throws TypeCheckError {
        if (expr.getId() == 40) {
            for (int i = 0; i < expr.jjtGetNumChildren(); ++i) {
                Expr expr2 = (Expr)expr.jjtGetChild(i);
                if (this.visitExpression(expr2).identicalTo(Type.String)) continue;
                CastHelper.setExpressionCastType(expr2, Type.String);
            }
        } else if (!this.visitExpression(expr).identicalTo(Type.String)) {
            CastHelper.setExpressionCastType(expr, Type.String);
        }
        return false;
    }

    private boolean attributeSet(Expr expr) throws TypeCheckError {
        AttributeSet attributeSet = (AttributeSet)expr;
        if (attributeSet.isIgnore()) {
            return false;
        }
        this.checkAttributeSet(attributeSet);
        String string = AttributeSetPrefix + this._xsltc.nextAttributeSetSerial();
        ASTDecorator.setAttributeSetMethodName(attributeSet, string);
        return true;
    }

    private void checkAttributeSet(AttributeSet attributeSet) throws TypeCheckError {
        Object object;
        if (this.isRecursiveAttrSet(attributeSet)) {
            this._attrSetStack = null;
            object = new ErrorMsg("ERR_ATTR_SET_USE_SELF");
            this._parser.reportError(3, (ASTBaseMsg)object);
        }
        this._attrSetStack.push(attributeSet.getQName());
        object = attributeSet.getUseSets();
        if (object != null) {
            this.useAttributeSets((Expr)object, true);
        }
        this._attrSetStack.pop();
    }

    private boolean isRecursiveAttrSet(AttributeSet attributeSet) {
        int n;
        if (null == this._attrSetStack) {
            this._attrSetStack = new Stack();
        }
        return !this._attrSetStack.empty() && (n = this._attrSetStack.search(attributeSet.getQName())) > -1;
    }

    private boolean callTemplate(Expr expr) throws TypeCheckError {
        CallTemplate callTemplate = (CallTemplate)expr;
        QName qName = callTemplate.getQName();
        Template template = this._parser.getStaticContext().lookupTemplate(qName);
        if (template == null) {
            ErrorMsg errorMsg = new ErrorMsg("TEMPLATE_UNDEF_ERR", (Object)qName, expr);
            this._parser.reportError(3, errorMsg);
        }
        return true;
    }

    private boolean choose(Expr expr) throws TypeCheckError {
        return true;
    }

    private boolean comment(Expr expr) throws TypeCheckError {
        return true;
    }

    private boolean copy(Expr expr) throws TypeCheckError {
        Copy copy = (Copy)expr;
        UseAttributeSets useAttributeSets = copy.getUseSets();
        if (useAttributeSets != null) {
            this.useAttributeSets(useAttributeSets, false);
        }
        return true;
    }

    private boolean useAttributeSets(Expr expr, boolean bl) throws TypeCheckError {
        UseAttributeSets useAttributeSets = (UseAttributeSets)expr;
        List list = useAttributeSets.getReferenceSets();
        XStaticContext xStaticContext = this._parser.getStaticContext();
        for (int i = 0; i < list.size(); ++i) {
            QName qName = (QName)list.get(i);
            AttributeSet attributeSet = xStaticContext.lookupAttributeSet(qName);
            if (attributeSet == null) {
                ErrorMsg errorMsg = new ErrorMsg("ATTRIBSET_UNDEF_ERR", (Object)qName.toString(), expr);
                this._parser.reportError(3, errorMsg);
            }
            if (!bl) continue;
            this.checkAttributeSet(attributeSet);
        }
        return false;
    }

    private boolean copyOf(Expr expr) throws TypeCheckError {
        CopyOf copyOf = (CopyOf)expr;
        Expr expr2 = copyOf.getExpression();
        Type type = this.visitExpression(expr2);
        if (!(type instanceof NodeType || type instanceof NodeSetType || type instanceof ReferenceType || type instanceof ResultTreeType)) {
            CastHelper.setExpressionCastType(expr2, Type.String);
        }
        return false;
    }

    private boolean decimalFormat(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean xslElement(Expr expr) throws TypeCheckError {
        CompElemConstructor compElemConstructor = (CompElemConstructor)expr;
        if (!compElemConstructor.isIgnore()) {
            Expr expr2;
            Expr expr3 = compElemConstructor.getNameExpr();
            if (expr3 != null) {
                this.attributeValueTemplate(expr3);
            }
            if ((expr2 = compElemConstructor.getNamespaceExpr()) != null) {
                this.attributeValueTemplate(expr2);
            }
        }
        return true;
    }

    private boolean fallback(Expr expr) throws TypeCheckError {
        return ((Fallback)expr).isActive();
    }

    private boolean forEach(Expr expr) throws TypeCheckError {
        ForEach forEach = (ForEach)expr;
        Expr expr2 = forEach.getExpression();
        Type type = this.visitExpression(expr2);
        if (type == Type.Reference || type == Type.Node) {
            CastHelper.setExpressionCastType(expr2, Type.NodeSet);
        } else if (type != Type.NodeSet && type != Type.ResultTree) {
            ErrorMsg errorMsg = new ErrorMsg("INVALID_SELECT_EXPR_TYPE", (Object)type.toString(), expr);
            this._parser.reportError(3, errorMsg);
        }
        return true;
    }

    private boolean xslIf(Expr expr) throws TypeCheckError {
        If if_ = (If)expr;
        Expr expr2 = if_.getExpression();
        if (this.visitExpression(expr2) != Type.Boolean) {
            CastHelper.setExpressionCastType(expr2, Type.Boolean);
        }
        return true;
    }

    private boolean xslImport(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean include(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean key(Expr expr) throws TypeCheckError {
        Key key = (Key)expr;
        Expr expr2 = key.getMatch();
        Assert._assert(!this.m_inKey, "InKey flag shoule have false value)");
        this.m_inKey = true;
        this.visitExpression(expr2);
        this.m_inKey = false;
        Expr expr3 = key.getUse();
        this.m_inKey = true;
        Type type = this.visitExpression(expr3);
        this.m_inKey = false;
        if (type != Type.String && type != Type.NodeSet) {
            CastHelper.setExpressionCastType(expr3, Type.String);
        }
        return false;
    }

    private boolean message(Expr expr) throws TypeCheckError {
        return true;
    }

    private boolean namespaceAlias(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean number(Expr expr) throws TypeCheckError {
        Expr expr2;
        Expr expr3;
        Expr expr4;
        Expr expr5;
        Expr expr6;
        Expr expr7;
        Object object;
        Number number = (Number)expr;
        Expr expr8 = number.getValueExpr();
        if (expr8 != null && (object = this.visitExpression(expr8)) != Type.Real) {
            CastHelper.setExpressionCastType(expr8, Type.Real);
        }
        if ((object = number.getCount()) != null) {
            this.visitExpression((Expr)object);
        }
        if ((expr7 = number.getFrom()) != null) {
            this.visitExpression(expr7);
        }
        if ((expr6 = number.getFormat()) != null) {
            this.attributeValueTemplate(expr6);
        }
        if ((expr5 = number.getLang()) != null) {
            this.attributeValueTemplate(expr5);
        }
        if ((expr4 = number.getLetterValue()) != null) {
            this.attributeValueTemplate(expr4);
        }
        if ((expr3 = number.getGroupingSeparator()) != null) {
            this.attributeValueTemplate(expr3);
        }
        if ((expr2 = number.getGroupingSize()) != null) {
            this.attributeValueTemplate(expr2);
        }
        return false;
    }

    private boolean otherwise(Expr expr) throws TypeCheckError {
        return true;
    }

    private boolean output(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean param(Expr expr) throws TypeCheckError {
        Object object;
        VariableBase variableBase;
        Param param = (Param)expr;
        Expr expr2 = param.getExpression();
        if (param.isLocal() && (variableBase = this.lookupVariable((QName)(object = param.getQName()))) != null && variableBase.jjtGetParent() == param.jjtGetParent()) {
            ErrorMsg errorMsg = new ErrorMsg("VARIABLE_REDEF_ERR", object, (Expr)param);
            this._parser.reportError(3, errorMsg);
        }
        if (expr2 != null) {
            object = this.visitExpression(expr2);
            if (object != Type.Reference) {
                CastHelper.setExpressionCastType(expr2, Type.Reference);
            }
        } else if (param.hasContents()) {
            return true;
        }
        ASTDecorator1.setVariableType((Param)expr, Type.Reference);
        return false;
    }

    private void setParamType(Expr expr) {
        ASTDecorator1.setVariableType((Param)expr, Type.Reference);
    }

    private boolean processingInstruction(Expr expr) throws TypeCheckError {
        DirPIConstructor dirPIConstructor = (DirPIConstructor)expr;
        this.attributeValueTemplate(dirPIConstructor.getName());
        return true;
    }

    private boolean sort(Expr expr) throws TypeCheckError {
        Sort sort = (Sort)expr;
        Expr expr2 = sort.getSelect();
        Type type = this.visitExpression(expr2);
        if (type != Type.String) {
            CastHelper.setExpressionCastType(expr2, Type.String);
        }
        if (sort.getLang() != null) {
            this.attributeValueTemplate(sort.getLang());
        }
        if (sort.getDataType() != null) {
            this.attributeValueTemplate(sort.getDataType());
        }
        if (sort.getOrder() != null) {
            this.attributeValueTemplate(sort.getOrder());
        }
        if (sort.getCaseOrder() != null) {
            this.attributeValueTemplate(sort.getCaseOrder());
        }
        return false;
    }

    private boolean stripSpace(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean stylesheet(Expr expr) throws TypeCheckError {
        Expr expr2;
        FunctionDecl functionDecl;
        Enumeration enumeration;
        Object object;
        Enumeration enumeration2;
        boolean bl;
        XTQProgram xTQProgram = (XTQProgram)expr;
        XSLTCompiler xSLTCompiler = this.getXSLTC();
        XStaticContext xStaticContext = this._parser.getStaticContext();
        QName qName = StylesheetHelper.makeStylesheetName(this._xsltc, "__stylesheet_");
        ASTDecorator.setStylesheetNextModeSerial(xTQProgram, 1);
        XTQProgram xTQProgram2 = xStaticContext.addXTQProgram(qName, xTQProgram);
        if (xTQProgram2 != null) {
            ErrorMsg errorMsg = new ErrorMsg("MULTIPLE_STYLESHEET_ERR", (Object)expr);
            this._parser.reportError(3, errorMsg);
        }
        if (bl = xStaticContext.hasGlobals()) {
            enumeration2 = xStaticContext.getGlobals().elements();
            while (enumeration2.hasMoreElements()) {
                object = (VariableBase)enumeration2.nextElement();
                this.updateScope((Expr)object);
            }
        }
        if (bl) {
            enumeration2 = xStaticContext.getGlobals().elements();
            xSLTCompiler.setInGlobal(true);
            while (enumeration2.hasMoreElements()) {
                object = (VariableBase)enumeration2.nextElement();
                xStaticContext.setCurrentNode((Expr)object);
                this.visitTree((Expr)object);
            }
            xSLTCompiler.setInGlobal(false);
        }
        enumeration2 = xStaticContext.getStylesheetFunctions();
        object = this.getCompiler().getFOHelper();
        if (null != enumeration2 && ((Hashtable)((Object)enumeration2)).size() > 0) {
            enumeration = ((Hashtable)((Object)enumeration2)).elements();
            while (enumeration.hasMoreElements()) {
                functionDecl = (FunctionDecl)enumeration.nextElement();
                if (functionDecl.isOverride() || !((FunctionOperatorHelper)object).isExtensionFunction(functionDecl)) continue;
                ((Hashtable)((Object)enumeration2)).remove(functionDecl);
            }
        }
        xStaticContext.setCurrentNode(xTQProgram);
        if (null != enumeration2 && ((Hashtable)((Object)enumeration2)).size() > 0) {
            enumeration = ((Hashtable)((Object)enumeration2)).elements();
            while (enumeration.hasMoreElements()) {
                functionDecl = (FunctionDecl)enumeration.nextElement();
                xStaticContext.setCurrentNode(functionDecl);
                this.visitTree(functionDecl);
            }
        }
        xStaticContext.setCurrentNode(xTQProgram);
        int n = xTQProgram.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            expr2 = (Expr)xTQProgram.jjtGetChild(i);
            int n2 = expr2.getId();
            if (n2 == 29 || n2 == 45 || n2 == 105) continue;
            xStaticContext.setCurrentNode(expr2);
            this.visitTree(expr2);
        }
        xStaticContext.setCurrentNode(xTQProgram);
        if (bl) {
            Enumeration enumeration3 = xStaticContext.getGlobals().elements();
            while (enumeration3.hasMoreElements()) {
                expr2 = (VariableBase)enumeration3.nextElement();
                this.removeVariable(((VariableBase)expr2).getQName());
            }
        }
        this.reconcileCollationElements();
        return false;
    }

    private void reconcileCollationElements() {
        XStaticContext xStaticContext = this._parser.getStaticContext();
        String[] stringArray = xStaticContext.getCollationElementNames();
        if (stringArray.length > 0) {
            Object object;
            String string = null;
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                CollationElement collationElement = xStaticContext.getCollationElement((String)object);
                String string2 = collationElement.getDeclaration().getName();
                if (!collationElement.isDuplicateName()) continue;
                String string3 = XMLMessages.createXMLMessage("TWO_COLLATIONS_WITH_THE_SAME_NAME", new Object[]{string2});
                ErrorMsg errorMsg = new ErrorMsg(string3, collationElement, false);
                this._parser.reportError(4, errorMsg);
            }
            if (bl) {
                xStaticContext.setDefaultCollationName(string);
            } else {
                String string4 = XMLMessages.createXMLMessage("TWO_DEFAULT_COLLATIONS", new Object[0]);
                object = new ErrorMsg(string4, xStaticContext.getCollationElement(string), false);
                this._parser.reportError(3, (ASTBaseMsg)object);
            }
        }
    }

    private boolean template(Expr expr) throws TypeCheckError {
        Template template = (Template)expr;
        Expr expr2 = template.getPattern();
        if (expr2 != null) {
            this.visitExpression(expr2);
        }
        return true;
    }

    private boolean text(Expr expr) throws TypeCheckError {
        return false;
    }

    private boolean valueOf(Expr expr) throws TypeCheckError {
        ValueOf valueOf = (ValueOf)expr;
        Expr expr2 = valueOf.getExpression();
        Type type = this.visitExpression(expr2);
        if (type != null && type != Type.Node) {
            if (type == Type.NodeSet) {
                CastHelper.setExpressionCastType(expr2, Type.Node);
            } else if (type != Type.String) {
                CastHelper.setExpressionCastType(expr2, Type.String);
            }
        }
        return false;
    }

    private boolean variable(Expr expr) throws TypeCheckError {
        QName qName;
        VariableBase variableBase;
        VarDecl varDecl = (VarDecl)expr;
        Expr expr2 = varDecl.getExpression();
        if (varDecl.isLocal() && (variableBase = this.lookupVariable(qName = varDecl.getQName())) != null && variableBase.jjtGetParent() == varDecl.jjtGetParent()) {
            ErrorMsg errorMsg = new ErrorMsg("VARIABLE_REDEF_ERR", (Object)qName, (Expr)varDecl);
            this._xsltc.getParser().reportError(3, errorMsg);
        }
        if (expr2 != null) {
            ASTDecorator1.setVariableType(varDecl, this.visitExpression(expr2));
        } else {
            if (varDecl.hasContents()) {
                return true;
            }
            ASTDecorator1.setVariableType(varDecl, Type.Reference);
        }
        return false;
    }

    private void setVariableType(Expr expr) {
        ASTDecorator1.setVariableType((VarDecl)expr, Type.ResultTree);
    }

    private boolean when(Expr expr) throws TypeCheckError {
        When when = (When)expr;
        Expr expr2 = when.getExpression();
        if (this.visitExpression(expr2) != Type.Boolean) {
            CastHelper.setExpressionCastType(expr2, Type.Boolean);
        }
        return true;
    }

    private boolean withParam(Expr expr) throws TypeCheckError {
        WithParam withParam = (WithParam)expr;
        Expr expr2 = withParam.getExpression();
        if (expr2 != null) {
            Type type = this.visitExpression(expr2);
            if (type != Type.Reference) {
                CastHelper.setExpressionCastType(expr2, Type.Reference);
            }
            return false;
        }
        return true;
    }

    private boolean literalElement(Expr expr) throws TypeCheckError {
        DirElemConstructor dirElemConstructor = (DirElemConstructor)expr;
        List list = dirElemConstructor.getAttributeElements();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Expr expr2 = (Expr)list.get(i);
                this.visitNode(expr2, expr2.getId());
            }
        }
        return true;
    }

    private boolean literalAttribute(Expr expr) throws TypeCheckError {
        DirAttributeConstructor dirAttributeConstructor = (DirAttributeConstructor)expr;
        this.attributeValue(dirAttributeConstructor);
        return true;
    }

    private boolean redirectExtension(Expr expr) throws TypeCheckError {
        Object object;
        Redirect redirect = (Redirect)expr;
        Expr expr2 = redirect.getSelect();
        if (expr2 != null && (object = this.visitExpression(expr2)) != Type.String) {
            CastHelper.setExpressionCastType(expr2, Type.String);
        }
        if ((object = redirect.getFile()) != null) {
            this.attributeValueTemplate((Expr)object);
        }
        return true;
    }
}

