/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v1.types;

import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import java.util.ArrayList;
import java.util.List;

public final class MethodType
extends Type {
    private final Type _resultType;
    private final List _argsType;

    public MethodType(Type type) {
        this._argsType = null;
        this._resultType = type;
    }

    public MethodType(Type type, Type type2) {
        if (type2 != Type.Void) {
            this._argsType = new ArrayList();
            this._argsType.add(type2);
        } else {
            this._argsType = null;
        }
        this._resultType = type;
    }

    public MethodType(Type type, Type type2, Type type3) {
        this._argsType = new ArrayList(2);
        this._argsType.add(type2);
        this._argsType.add(type3);
        this._resultType = type;
    }

    public MethodType(Type type, Type type2, Type type3, Type type4) {
        this._argsType = new ArrayList(3);
        this._argsType.add(type2);
        this._argsType.add(type3);
        this._argsType.add(type4);
        this._resultType = type;
    }

    public MethodType(Type type, List list) {
        this._resultType = type;
        this._argsType = list.size() > 0 ? list : null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("method{");
        if (this._argsType != null) {
            int n = this._argsType.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this._argsType.get(i));
                if (i == n - 1) continue;
                stringBuffer.append(',');
            }
        } else {
            stringBuffer.append("void");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean identicalTo(Type type) {
        boolean bl = false;
        if (type instanceof MethodType) {
            MethodType methodType = (MethodType)type;
            if (this._resultType.identicalTo(methodType._resultType)) {
                int n = this.argsCount();
                bl = n == methodType.argsCount();
                for (int i = 0; i < n && bl; ++i) {
                    Type type2 = (Type)this._argsType.get(i);
                    Type type3 = (Type)methodType._argsType.get(i);
                    bl = type2.identicalTo(type3);
                }
            }
        }
        return bl;
    }

    public int distanceTo(Type type) {
        int n = Integer.MAX_VALUE;
        if (type instanceof MethodType) {
            MethodType methodType = (MethodType)type;
            if (this._argsType != null) {
                int n2 = this._argsType.size();
                if (n2 == methodType._argsType.size()) {
                    n = 0;
                    for (int i = 0; i < n2; ++i) {
                        Type type2;
                        Type type3 = (Type)this._argsType.get(i);
                        int n3 = type3.distanceTo(type2 = (Type)methodType._argsType.get(i));
                        if (n3 == Integer.MAX_VALUE) {
                            n = n3;
                            break;
                        }
                        n += type3.distanceTo(type2);
                    }
                }
            } else if (methodType._argsType == null) {
                n = 0;
            }
        }
        return n;
    }

    public Type resultType() {
        return this._resultType;
    }

    public List argsType() {
        return this._argsType;
    }

    public int argsCount() {
        return this._argsType == null ? 0 : this._argsType.size();
    }
}

