/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.autof;

import com.ibm.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.translator.XylemXSLTC;
import com.ibm.xtq.xslt.xylem.autof.OverlapDetectionXSLTCompiler;
import com.ibm.xtq.xslt.xylem.autof.OverlapDetector;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.Program;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class OverlapDetectionXSLTC
extends XylemXSLTC {
    static final Logger s_logger = Logger.getInstance(OverlapDetectionXSLTCompiler.class);

    public static void main(String[] stringArray) {
        Serializable serializable;
        LogManager.initializeLogger();
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        final boolean[] blArray3 = new boolean[1];
        s_classes = new ArrayList();
        s_resources = new ArrayList();
        XylemXSLTC.XylemXSLTCommandLineParser xylemXSLTCommandLineParser = new XylemXSLTC.XylemXSLTCommandLineParser(){

            protected int parseOption(String[] stringArray, int n) {
                if (stringArray[n].equals("-nocompile")) {
                    blArray2[0] = true;
                } else if (stringArray[n].equals("-nolink")) {
                    blArray[0] = true;
                } else if (stringArray[n].equals("-nocleanxo")) {
                    blArray3[0] = true;
                } else {
                    if (stringArray[n].equals("-help")) {
                        super.parseOption(stringArray, n);
                        System.out.println("                  [-nocompile]");
                        System.out.println("                  [-noclean]");
                        System.out.println("                  [-nolink]");
                        return -1;
                    }
                    return super.parseOption(stringArray, n);
                }
                return n;
            }
        };
        if (!xylemXSLTCommandLineParser.parseCommandLine(stringArray)) {
            return;
        }
        xylemXSLTCommandLineParser.m_linkerSettings.setOverlapDetection(true);
        xylemXSLTCommandLineParser.m_linkerSettings.setOverlapDetectionArgLast(true);
        if (xylemXSLTCommandLineParser.m_files.size() != xylemXSLTCommandLineParser.m_classNames.size()) {
            String string = "missing file or classname argument. Got" + xylemXSLTCommandLineParser.m_files.size() + " files, and " + xylemXSLTCommandLineParser.m_classNames.size() + " classnames )";
            s_logger.error(string);
            throw new RuntimeException(string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<File> arrayList = new ArrayList<File>(xylemXSLTCommandLineParser.m_files.size());
        for (int i = 0; i < xylemXSLTCommandLineParser.m_classNames.size(); ++i) {
            String string = (String)xylemXSLTCommandLineParser.m_classNames.get(i);
            serializable = new File(xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), string + ".xo");
            arrayList.add((File)serializable);
            if (hashSet.add(string)) continue;
            String string2 = "Duplicate classname '" + string + "' in command line";
            s_logger.error(string2);
            throw new RuntimeException(string2);
        }
        try {
            Module module = XSLTCompiler.compileRuntimeLibrary("1.0");
            if (!blArray2[0]) {
                s_logger.info("Phase I: Compiling individual stylesheets...");
                for (int i = 0; i < xylemXSLTCommandLineParser.m_files.size(); ++i) {
                    serializable = (URL)xylemXSLTCommandLineParser.m_files.get(i);
                    File file = (File)arrayList.get(i);
                    Module module2 = OverlapDetectionXSLTCompiler.compileIndividualModule((URL)serializable, module, xylemXSLTCommandLineParser.m_compilerSettings, s_sourceLoader, s_topResolve);
                    module2.removeDeadFunctions();
                    String string = (String)xylemXSLTCommandLineParser.m_classNames.get(i);
                    if (xylemXSLTCommandLineParser.m_linkerSettings.isDumpXylem()) {
                        Program.dumpXylemFile(module2, xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), string);
                    }
                    ParamReferenceIdentifier.createParamReferences(module2);
                    s_logger.info("Writing temp-file file " + file);
                    OverlapDetectionXSLTCompiler.writeIndividualModule(module2, file);
                }
            }
            if (!blArray[0]) {
                s_logger.info("Phase II: Detect Overlap and Link");
                OverlapDetector.detectOverlapAndLink(module, xylemXSLTCommandLineParser.m_classNames.toArray(new String[0]), arrayList.toArray(new File[0]), xylemXSLTCommandLineParser.m_compilerSettings, xylemXSLTCommandLineParser.m_linkerSettings);
            }
            if (xylemXSLTCommandLineParser.m_jarFileName != null) {
                try {
                    OverlapDetectionXSLTC.outputToJar(xylemXSLTCommandLineParser.m_linkerSettings.getOutputDir(), xylemXSLTCommandLineParser.m_jarFileName);
                }
                catch (IOException iOException) {
                    s_logger.error("IOException outputting jar file", iOException);
                    System.exit(-1);
                }
            }
        }
        catch (Throwable throwable) {
            s_logger.error("", throwable);
            throw new RuntimeException(throwable.getMessage());
        }
        finally {
            if (!blArray3[0]) {
                s_logger.info("cleaning up temp files ...");
                for (File file : arrayList) {
                    try {
                        if (file.delete()) continue;
                        throw new RuntimeException();
                    }
                    catch (Exception exception) {
                        s_logger.error("could not delete " + file);
                    }
                }
            }
            s_logger.info("Done");
        }
    }
}

