/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.autof;

import com.ibm.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xtq.xslt.drivers.XDMTypeUpdater;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.xylem.autof.FunctionComparator;
import com.ibm.xtq.xslt.xylem.autof.FunctionReader;
import com.ibm.xtq.xslt.xylem.autof.FunctionRecord;
import com.ibm.xtq.xslt.xylem.autof.ModuleRecord;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.TailRecursiveOptimizer;
import com.ibm.xylem.TopLevelModuleImportDirective;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.types.IntType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class OverlapDetector {
    static final Logger s_logger = Logger.getInstance(OverlapDetector.class);

    public static void main(String[] stringArray) {
        Module module;
        Object object;
        String[] stringArray2;
        LogManager.initializeLogger();
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        xSLTLinkerSettings.setOverlapDetection(true);
        xSLTLinkerSettings.setOverlapDetectionArgLast(true);
        if (stringArray.length == 0) {
            s_logger.info("Usage: OverlapDetectionXSLTLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringArray2 = stringArray[n];
            if (stringArray2.equals("-split")) {
                if (++n == stringArray.length) {
                    s_logger.error("-split requires parameter");
                    return;
                }
                xSLTCompilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n++]));
                continue;
            }
            if (stringArray2.equals("-newsplit")) {
                if (++n == stringArray.length) {
                    s_logger.error("-newsplit requires parameter");
                    return;
                }
                xSLTLinkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(Integer.parseInt(stringArray[n++]));
                continue;
            }
            if (stringArray2.equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n;
                continue;
            }
            if (stringArray2.equals("-disablejavac")) {
                xSLTLinkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++n;
                continue;
            }
            if (stringArray2.equals("-generateBCEL")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(2);
                ++n;
                continue;
            }
            if (stringArray2.equals("-suppressComments")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++n;
                continue;
            }
            if (!stringArray2.equals("-command")) break;
            if (++n == stringArray.length) {
                s_logger.error("-split requires parameter");
                return;
            }
            try {
                String string;
                object = new ArrayList();
                FileReader fileReader = new FileReader(stringArray[n]);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() <= 0) continue;
                    ((ArrayList)object).add(string);
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
                s_logger.error("Could not read command file " + stringArray[n], iOException);
                return;
            }
            stringArray = ((ArrayList)object).toArray(stringArray);
            n = 0;
            break;
        }
        if ((stringArray.length - n) % 2 != 0) {
            throw new StaticError("ERR_SYSTEM", "Uneven args starting at " + stringArray[n]);
        }
        stringArray2 = new String[(stringArray.length - n) / 2];
        object = new File[stringArray2.length];
        for (int i = 0; i < stringArray.length - n; i += 2) {
            object[i / 2] = new File(stringArray[i + n]);
            stringArray2[i / 2] = stringArray[i + n + 1];
        }
        try {
            module = XSLTCompiler.compileRuntimeLibrary("1.0");
        }
        catch (Exception exception) {
            s_logger.error("", exception);
            throw new RuntimeException();
        }
        OverlapDetector.detectOverlapAndLink(module, stringArray2, (File[])object, xSLTCompilerSettings, xSLTLinkerSettings);
    }

    public static void detectOverlapAndLink(Module module, String[] stringArray, File[] fileArray, XSLTCompilerSettings xSLTCompilerSettings, XSLTLinkerSettings xSLTLinkerSettings) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        FunctionReader functionReader = new FunctionReader();
        try {
            functionReader.readFunctions(stringArray, fileArray, hashMap, hashMap2);
            Module module2 = new Module(stringArray[0], null, new ModuleSignature(""));
            XDMTypeUpdater[] xDMTypeUpdaterArray = OverlapDetector.mergeXDMTables(module2, stringArray, hashMap2);
            AutoFunctorizingXSLTLinker.Statistics statistics = new AutoFunctorizingXSLTLinker.Statistics(stringArray);
            s_logger.info("Detecting overlap");
            OverlapDetector.detectOverlap(module2, hashMap, hashMap2, xDMTypeUpdaterArray, functionReader, statistics);
            statistics.summarize();
            functionReader.finish();
            module2.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", module.m_signature, "xslt1"));
            AutoFunctorizingXSLTLinker.handleStandardExports(module2);
            Iterator iterator = hashMap2.values().iterator();
            while (iterator.hasNext()) {
                ((ModuleRecord)iterator.next()).m_rofh.close();
            }
            hashMap2 = null;
            hashMap = null;
            module2.clearTypeInformation(true);
            module2.removeFunctionDerivativeInformation();
            ParamReferenceIdentifier.fixParamReferences(module2);
            functionReader = null;
            XSLTCompiler.postASTProcessing(module2, null, xSLTCompilerSettings.getPrereductionSplitLimit(), xSLTCompilerSettings.isStreamResultOnly());
            XSLTLinker.compileProgram(module2, module, stringArray.length, Arrays.asList(stringArray), xSLTLinkerSettings);
            s_logger.info("Done");
        }
        catch (Throwable throwable) {
            s_logger.error("", throwable);
            if (functionReader != null) {
                functionReader.forceFinish();
            }
            throw new RuntimeException();
        }
    }

    private static XDMTypeUpdater[] mergeXDMTables(Module module, String[] stringArray, HashMap hashMap) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray2;
        XDMTypeUpdater[] xDMTypeUpdaterArray = new XDMTypeUpdater[stringArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2 = (String[])hashMap.get(stringArray[i]);
            object4 = stringArray2.m_names;
            object3 = stringArray2.m_uris;
            object2 = stringArray2.m_types;
            object = new int[((String[])object4).length];
            for (int j = 0; j < ((String[])object4).length; ++j) {
                object[j] = -1;
                for (int k = 0; k < arrayList.size(); ++k) {
                    if (!XSLTLinker.areStringRefsEqual(arrayList.get(k), object4[j]) || !XSLTLinker.areStringRefsEqual(arrayList2.get(k), object3[j]) || !arrayList3.get(k).equals(new Integer(object2[j]))) continue;
                    object[j] = k;
                    break;
                }
                if (object[j] != -1) continue;
                object[j] = arrayList.size();
                arrayList.add(object4[j]);
                arrayList2.add(object3[j]);
                arrayList3.add(new Integer(object2[j]));
            }
            xDMTypeUpdaterArray[stringArray2.m_index] = new XDMTypeUpdater();
            xDMTypeUpdaterArray[stringArray2.m_index].m_newIndices = object;
        }
        String[] stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        stringArray2 = new String[arrayList2.size()];
        arrayList2.toArray(stringArray2);
        object4 = XSLTLinker.makeStringArrayBody(stringArray3);
        object3 = XSLTLinker.makeStringArrayBody(stringArray2);
        object2 = XSLTLinker.makeIntArrayBody(arrayList3);
        try {
            Function function = new Function("xdm-names", new Binding[0], (Instruction)object4);
            object = function;
            module.addFunction(function);
            ((Function)object).typeCheck(module, null, new LinkedList());
            module.forceFunctionGeneration((Function)object);
            object = new Function("xdm-uris", new Binding[0], (Instruction)object3);
            module.addFunction((Function)object);
            ((Function)object).typeCheck(module, null, new LinkedList());
            module.forceFunctionGeneration((Function)object);
            object = new Function("xdm-types", new Binding[0], (Instruction)object2);
            module.addFunction((Function)object);
            ((Function)object).typeCheck(module, null, new LinkedList());
            module.forceFunctionGeneration((Function)object);
        }
        catch (Exception exception) {
            s_logger.error("!", exception);
            throw new Error();
        }
        return xDMTypeUpdaterArray;
    }

    public static void detectOverlap(Module module, HashMap hashMap, HashMap hashMap2, XDMTypeUpdater[] xDMTypeUpdaterArray, FunctionReader functionReader, AutoFunctorizingXSLTLinker.Statistics statistics) throws Exception {
        Object object;
        Object object22;
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object22 : hashMap.keySet()) {
            object = ((FunctionSignature)object22).getFunctionName();
            int n = 0;
            while (hashSet.contains(object)) {
                object = (String)object + "$" + ++n;
            }
            hashMap3.put(object22, (String)object);
            hashSet.add(object);
        }
        object22 = new ArrayList(hashMap.keySet());
        Collections.sort(object22, FunctionComparator.CMP);
        Iterator<Object> iterator = ((ArrayList)object22).iterator();
        block2: while (iterator.hasNext()) {
            Object object3;
            Object object4;
            object = (FunctionSignature)iterator.next();
            ArrayList arrayList = (ArrayList)hashMap.get(object);
            Iterator iterator2 = arrayList.iterator();
            Instruction[] instructionArray = new Instruction[arrayList.size()];
            Function[] functionArray = new Function[arrayList.size()];
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            while (iterator2.hasNext()) {
                object4 = (FunctionRecord)iterator2.next();
                Function function = null;
                function = functionReader.getFunction((FunctionRecord)object4);
                if (function.getName().equals("main")) {
                    function.setName("main-functor");
                } else if (!(function.getName().equals("setupOutput") || function.getName().equals("whitespaceRules") || function.getName().equals("setupCharacterMaps") || function.getName().equals("get-ns-prefix-counter"))) {
                    if (((FunctionRecord)object4).m_exported) {
                        if (module.getFunction(function.getName()) != null) continue block2;
                        module.addFunction(function);
                        module.forceFunctionGeneration(function);
                        continue block2;
                    }
                    function.setName((String)hashMap3.get(((FunctionRecord)object4).m_signature));
                }
                object3 = (ModuleRecord)hashMap2.get(((FunctionRecord)object4).m_moduleName);
                nArray[n] = object3.m_index;
                xDMTypeUpdaterArray[object3.m_index].optimizeFunction(function);
                new TailRecursiveOptimizer((ModuleRecord)object3, hashMap3){
                    final /* synthetic */ ModuleRecord val$mr;
                    final /* synthetic */ HashMap val$unifiedFunctionNameMap;
                    {
                        this.val$mr = moduleRecord;
                        this.val$unifiedFunctionNameMap = hashMap;
                    }

                    protected Instruction optimizeStep2(Instruction instruction) {
                        if (instruction instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                            FunctionSignature functionSignature = (FunctionSignature)this.val$mr.m_functionNames.get(functionCallInstruction.getFunction());
                            String string = (String)this.val$unifiedFunctionNameMap.get(functionSignature);
                            Instruction[] instructionArray = new Instruction[instruction.getChildInstructionCount() + 1];
                            System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 0, functionCallInstruction.m_parameters.length);
                            instructionArray[functionCallInstruction.m_parameters.length] = new IdentifierInstruction("__functorindex__");
                            functionCallInstruction.m_parameters = instructionArray;
                            functionCallInstruction.setFunction(string);
                        }
                        return instruction;
                    }
                }.optimizeFunction(function);
                functionArray[n] = function;
                instructionArray[n++] = function.getBody();
            }
            object4 = functionArray[0];
            boolean bl = false;
            if (((Function)object4).getName().equals("build_key")) {
                bl = true;
            }
            object3 = new Binding[((Function)object4).m_parameters.length + 1];
            System.arraycopy(((Function)object4).m_parameters, 0, object3, 0, ((Function)object4).m_parameters.length);
            object3[((Function)object4).m_parameters.length] = new Binding((Object)"__functorindex__", IntType.s_intType);
            ((Function)object4).m_parameters = object3;
            int[] nArray2 = new int[1];
            Instruction instruction = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(instructionArray, true, module, (Function)object4, nArray, hashMap2.size(), bl, nArray2);
            statistics.add((FunctionSignature)object, nArray, nArray2[0]);
            ((Function)object4).setBody(instruction);
            module.addFunction((Function)object4);
        }
    }
}

