/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.optimizers;

import com.ibm.xtq.xml.xdm.Axis;
import com.ibm.xtq.xslt.xylem.instructions.AbsoluteCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CacheCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CurrentNodeListCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CurrentNodeListFilterInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ForwardPositionCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorForStepInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetTypedAxisCursorForStepInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SameDocumentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.StepCursorInstruction;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IdentityHashMap;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class MemoizeAbsolutePathOptimizer
extends Optimizer {
    public static final boolean s_supportPredicates = false;
    protected int m_phase = 0;
    protected Module m_program;
    protected IdentityHashMap m_absolutePaths = new IdentityHashMap();
    protected HashMap m_absolutePathCounts = new HashMap();
    protected HashMap[] m_generatedFunctions = new HashMap[]{new HashMap(), new HashMap()};
    protected int m_threshold = 1;

    protected boolean scanXPath(Instruction instruction, ArrayList arrayList, boolean bl) {
        BindingEnvironment bindingEnvironment = this.getCurrentFunction().getBindingEnvironment();
        if ((instruction = NavigationUtilities.resolveReducedIdentifier(instruction, bindingEnvironment)) instanceof GetTypedAxisCursorInstruction) {
            GetTypedAxisCursorInstruction getTypedAxisCursorInstruction = (GetTypedAxisCursorInstruction)instruction;
            int n = getTypedAxisCursorInstruction.getAxis();
            if (n != 3 && n != 2 && n != 5 && n != 4) {
                return false;
            }
            arrayList.add(new Step(n, getTypedAxisCursorInstruction.getNodeType()));
            return true;
        }
        if (instruction instanceof GetAxisCursorInstruction) {
            GetAxisCursorInstruction getAxisCursorInstruction = (GetAxisCursorInstruction)instruction;
            int n = getAxisCursorInstruction.getAxis();
            if (n != 3 && n != 2 && n != 5 && n != 4) {
                return false;
            }
            arrayList.add(new Step(n));
            return true;
        }
        if (instruction instanceof StepCursorInstruction) {
            StepCursorInstruction stepCursorInstruction = (StepCursorInstruction)instruction;
            if (this.scanXPath(stepCursorInstruction.getOperand1(), arrayList, false)) {
                return this.scanXPath(stepCursorInstruction.getOperand2(), arrayList, bl);
            }
            return false;
        }
        if (instruction instanceof CoerceInstruction) {
            CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
            return this.scanXPath(coerceInstruction.getOperand(), arrayList, bl);
        }
        if (instruction instanceof CurrentNodeListCursorInstruction) {
            if (!bl) {
                return false;
            }
            CurrentNodeListCursorInstruction currentNodeListCursorInstruction = (CurrentNodeListCursorInstruction)instruction;
            CurrentNodeListFilterInstruction currentNodeListFilterInstruction = (CurrentNodeListFilterInstruction)NavigationUtilities.resolveReducedIdentifier(currentNodeListCursorInstruction.getOperand2(), bindingEnvironment);
            if (!this.hasPositionalDependencies(currentNodeListFilterInstruction.getBody(), currentNodeListFilterInstruction.getContextPositionVar(), currentNodeListFilterInstruction.getContextLastVar())) {
                Instruction instruction2 = currentNodeListCursorInstruction.getOperand1();
                Instruction instruction3 = currentNodeListCursorInstruction.getOperand3();
                if (this.scanXPath(instruction2, new ArrayList(), true)) {
                    if ((instruction2 = NavigationUtilities.resolveReducedIdentifier(instruction2, bindingEnvironment)) instanceof GetAxisCursorInstruction) {
                        GetAxisCursorInstruction getAxisCursorInstruction = (GetAxisCursorInstruction)instruction2;
                        arrayList.add(new Filter(getAxisCursorInstruction.getAxis(), currentNodeListCursorInstruction.getOperand2(), instruction3));
                        return true;
                    }
                    if (instruction2 instanceof GetTypedAxisCursorInstruction) {
                        GetTypedAxisCursorInstruction getTypedAxisCursorInstruction = (GetTypedAxisCursorInstruction)instruction2;
                        arrayList.add(new Filter(getTypedAxisCursorInstruction.getAxis(), getTypedAxisCursorInstruction.getNodeType(), currentNodeListCursorInstruction.getOperand2(), instruction3));
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    protected boolean hasPositionalDependencies(Instruction instruction, Object object, Object object2) {
        if (instruction instanceof IdentifierInstruction) {
            Object object3 = ((IdentifierInstruction)instruction).getVariable();
            return object3 == object || object3 == object2;
        }
        int n = instruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            if (!this.hasPositionalDependencies(instruction.getChildInstruction(i), object, object2)) continue;
            return true;
        }
        return false;
    }

    protected void increment(Object object) {
        Object object2 = this.m_absolutePathCounts.get(object);
        int n = object2 != null ? (Integer)object2 + 1 : 1;
        object2 = new Integer(n);
        if (n == this.m_threshold) {
            this.generateMemoFunctionForPath((ArrayList)object);
        }
        this.m_absolutePathCounts.put(object, object2);
    }

    protected boolean isInOrderPath(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Step step = (Step)arrayList.get(i);
            if (!step.isReverse()) continue;
            return false;
        }
        return true;
    }

    protected Function[] generateMemoFunctionForPath(ArrayList arrayList) {
        Step step;
        Object object;
        Object object2;
        Function function = (Function)this.m_generatedFunctions[0].get(arrayList);
        if (function != null) {
            return new Function[]{function, (Function)this.m_generatedFunctions[1].get(arrayList)};
        }
        Instruction instruction = null;
        Instruction instruction2 = null;
        String string = OptimizerUtilities.generateIntermediateIdentifier();
        if (arrayList.size() > 1) {
            object2 = OptimizerUtilities.generateIntermediateIdentifier();
            object = new ArrayList(arrayList);
            step = (Step)((ArrayList)object).remove(((ArrayList)object).size() - 1);
            int n = ((Step)((ArrayList)object).get(((ArrayList)object).size() - 1)).getAxis();
            boolean bl = this.isInOrderPath((ArrayList)object) && (n == 4 || n == 5);
            Function[] functionArray = this.generateMemoFunctionForPath((ArrayList)object);
            StepCursorInstruction stepCursorInstruction = new StepCursorInstruction(new IdentifierInstruction(object2), new IdentifierInstruction(string));
            StepCursorInstruction stepCursorInstruction2 = new StepCursorInstruction(new IdentifierInstruction(object2), new IdentifierInstruction(string));
            String string2 = OptimizerUtilities.generateIntermediateIdentifier();
            if (step.hasNonWildcardNameTest()) {
                instruction = new CacheCursorInstruction(new IdentifierInstruction(string2));
            }
            if (bl) {
                if (instruction != null) {
                    String string3 = string2;
                    string2 = OptimizerUtilities.generateIntermediateIdentifier();
                    instruction = new LetInstruction(string3, new ForwardPositionCursorInstruction(new IdentifierInstruction(string2)), instruction);
                } else {
                    instruction = new ForwardPositionCursorInstruction(new IdentifierInstruction(string2));
                }
                instruction2 = new ForwardPositionCursorInstruction(new IdentifierInstruction(string2));
            }
            instruction = instruction != null ? new LetInstruction(string2, stepCursorInstruction, instruction) : stepCursorInstruction;
            instruction2 = instruction2 != null ? new LetInstruction(string2, stepCursorInstruction2, instruction2) : stepCursorInstruction2;
            instruction = new LetInstruction(object2, new FunctionCallInstruction(functionArray[0].getName(), new Instruction[]{new IdentifierInstruction("__current__")}), instruction);
            instruction2 = new LetInstruction(object2, new FunctionCallInstruction(functionArray[1].getName(), new Instruction[]{new IdentifierInstruction("__current__")}), instruction2);
        } else {
            step = (Step)arrayList.get(0);
            instruction = new AbsoluteCursorInstruction(new IdentifierInstruction("__current__"), new IdentifierInstruction(string));
            instruction2 = new AbsoluteCursorInstruction(new IdentifierInstruction("__current__"), new IdentifierInstruction(string));
        }
        object2 = step.generate(new IdentifierInstruction("__current__"));
        object = step.generate(new IdentifierInstruction("__current__"));
        instruction = new LetInstruction(string, (Instruction)object2, instruction);
        instruction2 = new LetInstruction(string, (Instruction)object, instruction2);
        String string4 = OptimizerUtilities.generateIntermediateIdentifier("absolutepath");
        function = new Function(string4, new Binding[]{new Binding((Object)"__current__", CursorType.s_cursorType)}, instruction);
        function.setMemoizeResult(true);
        this.m_program.addFunction(function, false);
        this.m_generatedFunctions[0].put(arrayList, function);
        string4 = OptimizerUtilities.generateIntermediateIdentifier("absolutepathNoMem");
        Function function2 = new Function(string4, new Binding[]{new Binding((Object)"__current__", CursorType.s_cursorType)}, instruction2);
        this.m_program.addFunction(function2, false);
        this.m_generatedFunctions[1].put(arrayList, function2);
        return new Function[]{function, function2};
    }

    protected void updatePathCounts(ArrayList arrayList) {
        if (arrayList.size() == 1) {
            this.increment(arrayList);
        } else {
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                arrayList2.add(iterator.next());
                this.increment(arrayList2.clone());
            }
        }
    }

    protected Instruction optimizeStep(Instruction instruction) {
        try {
            if (instruction instanceof AbsoluteCursorInstruction) {
                AbsoluteCursorInstruction absoluteCursorInstruction = (AbsoluteCursorInstruction)instruction;
                Instruction instruction2 = absoluteCursorInstruction.getOperand2();
                if (this.m_phase == 0) {
                    ArrayList arrayList = new ArrayList();
                    if (this.scanXPath(instruction2, arrayList, true)) {
                        this.updatePathCounts(arrayList);
                        this.m_absolutePaths.put(absoluteCursorInstruction, arrayList);
                    }
                } else {
                    ArrayList arrayList = (ArrayList)this.m_absolutePaths.get(absoluteCursorInstruction);
                    if (arrayList != null) {
                        Object object;
                        Iterator iterator = arrayList.iterator();
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        int n = 0;
                        ArrayList<LetInstruction> arrayList3 = new ArrayList<LetInstruction>();
                        Object object2 = null;
                        while (iterator.hasNext()) {
                            String string;
                            String string2;
                            Object object3;
                            object = iterator.next();
                            if (object instanceof Remainder) {
                                object3 = OptimizerUtilities.generateIntermediateIdentifier();
                                arrayList3.add(new LetInstruction(object3, new StepCursorInstruction(new IdentifierInstruction(object2), ((Remainder)object).m_rest), null));
                                object2 = object3;
                                continue;
                            }
                            object3 = (Step)object;
                            arrayList2.add(object3);
                            Function function = (Function)this.m_generatedFunctions[0].get(arrayList2);
                            if (function == null) {
                                if (n == 0) {
                                    return super.optimizeStep(instruction);
                                }
                                string2 = OptimizerUtilities.generateIntermediateIdentifier();
                                arrayList3.add(new LetInstruction(string2, ((Step)object3).generate(absoluteCursorInstruction.getOperand1().cloneReduced()), null));
                                string = OptimizerUtilities.generateIntermediateIdentifier();
                                arrayList3.add(new LetInstruction(string, new StepCursorInstruction(new IdentifierInstruction(object2), new IdentifierInstruction(string2)), null));
                                object2 = string;
                            } else {
                                object2 = OptimizerUtilities.generateIntermediateIdentifier();
                                string2 = OptimizerUtilities.generateIntermediateIdentifier();
                                arrayList3.add(new LetInstruction(string2, new SameDocumentInstruction(absoluteCursorInstruction.getOperand1().cloneReduced(), new IdentifierInstruction("__root__")), null));
                                arrayList3.add(new LetInstruction(object2, new ChooseInstruction(new IdentifierInstruction(string2), (Instruction)new FunctionCallInstruction(function.getName(), new Instruction[]{absoluteCursorInstruction.getOperand1().cloneReduced()}), new FunctionCallInstruction(((Function)this.m_generatedFunctions[1].get(arrayList2)).getName(), new Instruction[]{absoluteCursorInstruction.getOperand1().cloneReduced()})), null));
                                if (object3 instanceof Filter) {
                                    string = OptimizerUtilities.generateIntermediateIdentifier();
                                    Filter filter = (Filter)object3;
                                    arrayList3.add(new LetInstruction(string, filter.getFilterExpr().cloneReduced(), null));
                                    CurrentNodeListCursorInstruction currentNodeListCursorInstruction = new CurrentNodeListCursorInstruction(new IdentifierInstruction(object2), new IdentifierInstruction(string), filter.getFilterContextExpr().cloneReduced());
                                    object2 = OptimizerUtilities.generateIntermediateIdentifier();
                                    arrayList3.add(new LetInstruction(object2, currentNodeListCursorInstruction, null));
                                }
                            }
                            ++n;
                        }
                        object = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), OptimizerUtilities.reconstructLets(new IdentifierInstruction(object2), arrayList3, false), null);
                        ((Instruction)object).typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList());
                        return object;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.optimizeStep(instruction);
    }

    public void run(Module module) {
        this.m_program = module;
        module.optimize(this);
        this.m_phase = 1;
        module.optimize(this);
    }

    public void optimizeFunction(Function function) {
        if (!this.m_generatedFunctions[0].values().contains(function) && !this.m_generatedFunctions[1].values().contains(function) && function.getBindingEnvironment().getVariableBinding("__root__") != null) {
            super.optimizeFunction(function);
        }
    }

    public static class Filter
    extends Step {
        private Instruction m_filter;
        private Instruction m_context;

        Filter(int n, int n2, Instruction instruction, Instruction instruction2) {
            super(n, n2);
            this.m_filter = instruction;
            this.m_context = instruction2;
        }

        Filter(int n, Instruction instruction, Instruction instruction2) {
            super(n);
            this.m_filter = instruction;
            this.m_context = instruction2;
        }

        public int hashCode() {
            return super.hashCode() * this.m_filter.hashCode() * this.m_context.hashCode();
        }

        public Instruction getFilterExpr() {
            return this.m_filter;
        }

        public Instruction getFilterContextExpr() {
            return this.m_context;
        }

        public boolean equals(Object object) {
            if (object instanceof Filter) {
                Filter filter = (Filter)object;
                return super.equals(object) && this.m_filter.equals(filter.m_filter) && this.m_context.equals(filter.m_context);
            }
            return false;
        }

        public String toString() {
            return super.toString() + '[' + this.m_filter + ',' + this.m_context + ']';
        }
    }

    public static class Remainder {
        Instruction m_rest;

        Remainder(Instruction instruction) {
            this.m_rest = instruction;
        }
    }

    public static class Step {
        private int m_type;
        private int m_axis;
        private boolean m_isTyped;

        Step(int n, int n2) {
            this.m_axis = n;
            this.m_type = n2;
            this.m_isTyped = true;
        }

        Step(int n) {
            this.m_axis = n;
            this.m_isTyped = false;
        }

        public int hashCode() {
            return this.m_axis * this.m_type;
        }

        public boolean isTyped() {
            return this.m_isTyped;
        }

        public boolean hasNonWildcardNameTest() {
            return this.m_isTyped && this.m_type >= 14;
        }

        public boolean isReverse() {
            return Axis.getIsReverse(this.m_axis);
        }

        public int getAxis() {
            return this.m_axis;
        }

        public boolean equals(Object object) {
            Step step = (Step)object;
            return step.getClass() == this.getClass() && step.m_axis == this.m_axis && step.m_isTyped == this.m_isTyped && (!this.m_isTyped || step.m_type == this.m_type);
        }

        public Instruction generate(Instruction instruction) {
            if (this.m_isTyped) {
                return new GetTypedAxisCursorForStepInstruction(this.m_axis, this.m_type, instruction);
            }
            return new GetAxisCursorForStepInstruction(this.m_axis, instruction);
        }

        public String toString() {
            return Axis.getName(this.m_axis) + "::" + (this.m_isTyped ? "(" + this.m_type + ")" : "node()");
        }
    }
}

