/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.optimizers;

import com.ibm.xtq.common.utils.XMLChar;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.types.SAXEventsLibrary;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.IntType;

public class SAXEventOptimizer
extends Optimizer {
    private static Type s_saxEventStreamType = null;

    private Integer getIntegerFromInstruction(Instruction instruction) {
        if (instruction instanceof LiteralInstruction) {
            LiteralInstruction literalInstruction = (LiteralInstruction)instruction;
            Object object = literalInstruction.getValue();
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                return n;
            }
            return null;
        }
        if (instruction instanceof IdentifierInstruction) {
            Object object;
            IBinding iBinding;
            LetInstruction letInstruction;
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            BindingEnvironment bindingEnvironment = identifierInstruction.getBindingEnvironment();
            if (bindingEnvironment == null) {
                bindingEnvironment = this.m_currentFunction.m_bindingEnvironment;
            }
            if ((letInstruction = (iBinding = bindingEnvironment.getVariableBinding(object = identifierInstruction.getVariable())).getLet()) != null) {
                Instruction instruction2 = letInstruction.getValue();
                Integer n = this.getIntegerFromInstruction(instruction2);
                return n;
            }
            return null;
        }
        if (instruction instanceof CoerceInstruction) {
            CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
            Type type = coerceInstruction.getType();
            return this.getIntegerFromInstruction(coerceInstruction.getOperand());
        }
        if (instruction instanceof CharStreamToJavaStringInstruction) {
            CharStreamToJavaStringInstruction charStreamToJavaStringInstruction = (CharStreamToJavaStringInstruction)instruction;
            int n = charStreamToJavaStringInstruction.getChildInstructionCount();
            if (n == 1) {
                Instruction instruction3 = charStreamToJavaStringInstruction.getChildInstruction(0);
                Integer n2 = this.getIntegerFromInstruction(instruction3);
                return n2;
            }
            return null;
        }
        return null;
    }

    private String getStringFromInstruction(Instruction instruction) {
        if (instruction instanceof IdentifierInstruction) {
            Object object;
            IBinding iBinding;
            LetInstruction letInstruction;
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            BindingEnvironment bindingEnvironment = identifierInstruction.getBindingEnvironment();
            if (bindingEnvironment == null) {
                bindingEnvironment = this.m_currentFunction.m_bindingEnvironment;
            }
            if ((letInstruction = (iBinding = bindingEnvironment.getVariableBinding(object = identifierInstruction.getVariable())).getLet()) != null) {
                Instruction instruction2 = letInstruction.getValue();
                String string = this.getStringFromInstruction(instruction2);
                return string;
            }
            return null;
        }
        if (instruction instanceof CoerceInstruction) {
            CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
            if (coerceInstruction.getType().equals(CharType.s_charType.getStreamType())) {
                return this.getStringFromInstruction(coerceInstruction.getOperand());
            }
            return null;
        }
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            String string = streamInstruction.getStringContent();
            if (null != string) {
                return string;
            }
            if (streamInstruction.getElementType().equals(CharType.s_charType)) {
                int n = streamInstruction.getChildInstructionCount();
                if (1 == n) {
                    String string2 = this.getStringFromInstruction(streamInstruction.getChildInstruction(0));
                    return string2;
                }
                if (n > 1) {
                    int n2;
                    String[] stringArray = new String[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        stringArray[n2] = this.getStringFromInstruction(streamInstruction.getChildInstruction(n2));
                    }
                    String string3 = stringArray[0];
                    for (n2 = 1; n2 < n && string3 != null; ++n2) {
                        string3 = stringArray[n2] != null ? string3 + stringArray[n2] : null;
                    }
                    if (string3 != null) {
                        return string3;
                    }
                }
            }
            return null;
        }
        if (instruction instanceof CharStreamToJavaStringInstruction) {
            CharStreamToJavaStringInstruction charStreamToJavaStringInstruction = (CharStreamToJavaStringInstruction)instruction;
            int n = charStreamToJavaStringInstruction.getChildInstructionCount();
            if (n == 1) {
                Instruction instruction3 = charStreamToJavaStringInstruction.getChildInstruction(0);
                String string = this.getStringFromInstruction(instruction3);
                return string;
            }
            return null;
        }
        return null;
    }

    private void initialize() {
        if (null == s_saxEventStreamType) {
            s_saxEventStreamType = SAXEventsLibrary.getSAXEventStream();
        }
    }

    public void optimizeFunction(Function function) {
        this.initialize();
        super.optimizeFunction(function);
    }

    public Instruction optimize(Instruction instruction) {
        return super.optimize(instruction);
    }

    public static int getTextOptFlags(String string, int n, int n2) {
        int n3 = 0;
        if (string == null) {
            return n3;
        }
        boolean bl = true;
        boolean bl2 = true;
        bl = true;
        int n4 = n + n2;
        block5: for (int i = n; i < n4 && bl; ++i) {
            char c = string.charAt(i);
            if (bl2 && !XMLChar.isSpace(c)) {
                bl2 = false;
            }
            switch (c) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    bl = false;
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    bl = false;
                    continue block5;
                }
                default: {
                    if (' ' <= c && c <= '~') continue block5;
                    bl = false;
                }
            }
        }
        if (bl) {
            n3 |= 1;
        }
        if (bl2) {
            n3 |= 8;
        }
        return n3;
    }

    private int getAttrOptFlags(Instruction instruction) {
        if (instruction instanceof IdentifierInstruction) {
            Object object;
            IBinding iBinding;
            LetInstruction letInstruction;
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            BindingEnvironment bindingEnvironment = identifierInstruction.getBindingEnvironment();
            if (bindingEnvironment == null) {
                bindingEnvironment = this.m_currentFunction.m_bindingEnvironment;
            }
            if ((letInstruction = (iBinding = bindingEnvironment.getVariableBinding(object = identifierInstruction.getVariable())).getLet()) != null) {
                Instruction instruction2 = letInstruction.getValue();
                int n = this.getAttrOptFlags(instruction2);
                return n;
            }
            return 0;
        }
        if (instruction instanceof StreamInstruction) {
            String string;
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            Type type = streamInstruction.getElementType();
            if (type.equals(CharType.s_charType) && (string = streamInstruction.getStringContent()) != null) {
                int n = SAXEventOptimizer.getTextOptFlags(string, 0, string.length());
                return n;
            }
            int n = streamInstruction.getChildInstructionCount();
            int n2 = 9;
            for (int i = 0; i < n; ++i) {
                Instruction instruction3 = streamInstruction.getChildInstruction(i);
                n2 &= this.getAttrOptFlags(instruction3);
            }
            return n2;
        }
        if (instruction instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction;
            Instruction instruction4 = letInstruction.getBody();
            int n = this.getAttrOptFlags(instruction4);
            return n;
        }
        if (instruction instanceof CharStreamToJavaStringInstruction) {
            CharStreamToJavaStringInstruction charStreamToJavaStringInstruction = (CharStreamToJavaStringInstruction)instruction;
            int n = charStreamToJavaStringInstruction.getChildInstructionCount();
            if (n == 1) {
                Instruction instruction5 = charStreamToJavaStringInstruction.getChildInstruction(0);
                return this.getAttrOptFlags(instruction5);
            }
            return 0;
        }
        return 0;
    }

    public Instruction optimizeStep(Instruction instruction) {
        if (instruction instanceof ConstructorInstantiationInstruction) {
            int n;
            Instruction instruction2;
            String string;
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction;
            String string2 = constructorInstantiationInstruction.getConstructorName();
            if ("addAttrText".equals(string2) && (string = this.getStringFromInstruction(instruction2 = constructorInstantiationInstruction.getChildInstruction(0))) != null && ((n = SAXEventOptimizer.getTextOptFlags(string, 0, string.length())) & 1) > 0) {
                ConstructorInstantiationInstruction constructorInstantiationInstruction2 = (ConstructorInstantiationInstruction)constructorInstantiationInstruction.cloneWithoutTypeInformation();
                AbstractDataType.Constructor constructor = constructorInstantiationInstruction.getConstructor();
                constructorInstantiationInstruction2.setConstructor(constructor);
                Instruction instruction3 = SAXEventOptimizer.getOptFlagInstruction(n);
                constructorInstantiationInstruction2.setChildInstruction(1, instruction3);
                return constructorInstantiationInstruction2;
            }
        } else if (instruction instanceof JavaMethodInvocationInstruction) {
            JavaMethodInvocationInstruction javaMethodInvocationInstruction = (JavaMethodInvocationInstruction)instruction;
            int n = javaMethodInvocationInstruction.getChildInstructionCount();
            String string = javaMethodInvocationInstruction.getFunction();
            if ("addAttributeContent".equals(string)) {
                if (n == 3) {
                    int n2;
                    String string3 = javaMethodInvocationInstruction.getClassName();
                    Instruction instruction4 = javaMethodInvocationInstruction.getChildInstruction(0);
                    Type type = instruction4.getCachedType();
                    string3 = null;
                    Instruction[] instructionArray = javaMethodInvocationInstruction.getParameters();
                    Instruction instruction5 = instructionArray[0];
                    String string4 = this.getStringFromInstruction(instruction5);
                    if (string4 != null && ((n2 = SAXEventOptimizer.getTextOptFlags(string4, 0, string4.length())) & 1) > 0) {
                        Instruction instruction6 = javaMethodInvocationInstruction.cloneWithoutTypeInformation();
                        Instruction instruction7 = SAXEventOptimizer.getOptFlagInstruction(n2);
                        instruction6.setChildInstruction(2, instruction7);
                        return instruction6;
                    }
                }
            } else if ("characters".equals(string) && n == 4) {
                int n3;
                Instruction[] instructionArray = javaMethodInvocationInstruction.getParameters();
                Instruction instruction8 = javaMethodInvocationInstruction.getChildInstruction(1);
                Instruction instruction9 = javaMethodInvocationInstruction.getChildInstruction(2);
                Instruction instruction10 = javaMethodInvocationInstruction.getChildInstruction(3);
                String string5 = this.getStringFromInstruction(instruction8);
                Integer n4 = this.getIntegerFromInstruction(instruction9);
                Integer n5 = this.getIntegerFromInstruction(instruction10);
                if (string5 != null && n4 != null && n5 != null && ((n3 = SAXEventOptimizer.getTextOptFlags(string5, n4, n5)) & 1) > 0) {
                    Instruction instruction11;
                    JavaMethodInvocationInstruction javaMethodInvocationInstruction2 = (JavaMethodInvocationInstruction)javaMethodInvocationInstruction.cloneWithoutTypeInformation();
                    Instruction[] instructionArray2 = new Instruction[instructionArray.length + 1];
                    System.arraycopy(instructionArray, 0, instructionArray2, 0, instructionArray.length);
                    if (!(instruction9 instanceof LiteralInstruction)) {
                        instructionArray2[1] = instruction9 = new LiteralInstruction(IntType.s_intType, n4);
                    }
                    if (!(instruction10 instanceof LiteralInstruction)) {
                        instructionArray2[2] = instruction10 = new LiteralInstruction(IntType.s_intType, n5);
                    }
                    instructionArray2[3] = instruction11 = SAXEventOptimizer.getOptFlagInstruction(n3);
                    javaMethodInvocationInstruction2.m_parameters = instructionArray2;
                    return javaMethodInvocationInstruction2;
                }
            }
        }
        return instruction;
    }

    private static Instruction getOptFlagInstruction(int n) {
        LiteralInstruction literalInstruction = new LiteralInstruction(IntType.s_intType, new Integer(n));
        return literalInstruction;
    }
}

