/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.parser;

import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.xylem.instructions.AbsoluteCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ArithmeticInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CacheCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CeilingInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ComparisonInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ContainsInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CountInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CurrentNodeListCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CurrentNodeListFilterInstruction;
import com.ibm.xtq.xslt.xylem.instructions.DerivedFromXTypeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.Document2Instruction;
import com.ibm.xtq.xslt.xylem.instructions.DocumentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.DupFilterCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.EmptyCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ExpandedTypeIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.FloorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ForwardPositionCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GenerateIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorForStepInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetDocNumberInsruction;
import com.ibm.xtq.xslt.xylem.instructions.GetDocumentRootInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetDocumentURIInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetLastInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeTypeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeValueCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaAnyAtomicTypeMatchesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaAttributeDeclarationMatchesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaElementDeclarationMatchesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaSimpleTypeMatchesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaTypeLocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaTypeMatchesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaTypeNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaTypeNamespaceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaUntypedTypeMatchesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetSchemaXTypeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetStringValueInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetTypedAxisCursorForStepInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetTypedAxisCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.IsEmptyInstruction;
import com.ibm.xtq.xslt.xylem.instructions.IsNilledInstruction;
import com.ibm.xtq.xslt.xylem.instructions.LocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.MessageInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NamespaceURIInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NegationInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NodeSetInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NodeStreamCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NormalizeSpaceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NthCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.PositionInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameLocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameNamespaceURIInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameTriplesInstruction;
import com.ibm.xtq.xslt.xylem.instructions.RandomPrefixInstruction;
import com.ibm.xtq.xslt.xylem.instructions.RelativeDocOrderInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SameDocumentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SchemaDataTypeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SingleNodeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.StartsWithInstruction;
import com.ibm.xtq.xslt.xylem.instructions.StepCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.TerminateInstruction;
import com.ibm.xtq.xslt.xylem.instructions.TranslateStreamInstruction;
import com.ibm.xtq.xslt.xylem.instructions.UnionCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.XDMManagerFactoryInstruction;
import com.ibm.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nametable.GetNamespaceURIIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nametable.IDToLocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nametable.IDToNamespaceURIInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nametable.NamespacePrefixToIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nametable.NamespaceURIToIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateAttributeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateCommentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateDocumentFragmentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateElementInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateProcessingInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateTextInstruction;
import com.ibm.xtq.xslt.xylem.xpath20.parser.Parser;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Type;
import com.ibm.xylem.parser.IFormHandler;
import com.ibm.xylem.parser.ParserException;
import java.io.StringReader;
import java.lang.reflect.Constructor;

public class FormHandler
implements IFormHandler {
    static final Logger s_logger = Logger.getInstance(FormHandler.class);
    private static BasicForm[] s_basicForms = new BasicForm[]{new BasicForm("qname", 3, QNameInstruction.class), new BasicForm("step-cursor", 2, StepCursorInstruction.class), new BasicForm("absolute-cursor", 2, AbsoluteCursorInstruction.class), new BasicForm("current-node-list-cursor", 3, CurrentNodeListCursorInstruction.class), new BasicForm("get-node-name", 1, GetNodeNameInstruction.class), new BasicForm("get-schema-type-name", 1, GetSchemaTypeNameInstruction.class), new BasicForm("get-schema-type-namespace", 1, GetSchemaTypeNamespaceInstruction.class), new BasicForm("get-schema-type-local-name", 1, GetSchemaTypeLocalNameInstruction.class), new BasicForm("get-schema-type-match", 3, GetSchemaTypeMatchesInstruction.class), new BasicForm("get-schema-xpath-data-type", 1, GetSchemaXTypeInstruction.class), new BasicForm("get-schema-type-match-any-atomic", 1, GetSchemaAnyAtomicTypeMatchesInstruction.class), new BasicForm("get-schema-type-match-untyped", 1, GetSchemaUntypedTypeMatchesInstruction.class), new BasicForm("get-schema-type-match-simple", 1, GetSchemaSimpleTypeMatchesInstruction.class), new BasicForm("get-schema-attribute-declaration-match", 2, GetSchemaAttributeDeclarationMatchesInstruction.class), new BasicForm("get-schema-element-declaration-match", 2, GetSchemaElementDeclarationMatchesInstruction.class), new BasicForm("schema-xpath-data-type", 2, SchemaDataTypeInstruction.class), new BasicForm("is-derived-from-type", 3, DerivedFromXTypeInstruction.class), new BasicForm("get-string-value", 1, GetStringValueInstruction.class), new BasicForm("get-node-type", 1, GetNodeTypeInstruction.class), new BasicForm("normalize-space", 1, NormalizeSpaceInstruction.class), new BasicForm("expanded-type-id", 1, ExpandedTypeIDInstruction.class), new BasicForm("document", 1, DocumentInstruction.class), new BasicForm("document2", 2, Document2Instruction.class), new BasicForm("count", 1, CountInstruction.class), new BasicForm("get-last", 1, GetLastInstruction.class), new BasicForm("forward-position-cursor", 1, ForwardPositionCursorInstruction.class), new BasicForm("contains", 2, ContainsInstruction.class), new BasicForm("position", 1, PositionInstruction.class), new BasicForm("single-node", 1, SingleNodeInstruction.class), new BasicForm("create-element!", 3, CreateElementInstruction.class), new BasicForm("create-document-fragment!", 2, CreateDocumentFragmentInstruction.class), new BasicForm("create-text!", 2, CreateTextInstruction.class), new BasicForm("create-comment!", 2, CreateCommentInstruction.class), new BasicForm("create-processing-instruction!", 3, CreateProcessingInstruction.class), new BasicForm("create-attribute!", 3, CreateAttributeInstruction.class), new BasicForm("random-prefix", 0, RandomPrefixInstruction.class), new BasicForm("get-document-uri", 1, GetDocumentURIInstruction.class), new BasicForm("nodeset", 1, NodeSetInstruction.class), new BasicForm("get-document-root", 1, GetDocumentRootInstruction.class), new BasicForm("get-document-number", 1, GetDocNumberInsruction.class), new BasicForm("namespace-uri", 1, NamespaceURIInstruction.class), new BasicForm("local-name", 1, LocalNameInstruction.class), new BasicForm("qname-namespace-uri", 1, QNameNamespaceURIInstruction.class), new BasicForm("qname-local-name", 1, QNameLocalNameInstruction.class), new BasicForm("generate-id", 1, GenerateIDInstruction.class), new BasicForm("starts-with", 2, StartsWithInstruction.class), new BasicForm("union-cursor", 2, UnionCursorInstruction.class), new BasicForm("nth-cursor", 2, NthCursorInstruction.class), new BasicForm("translate-stream", 3, TranslateStreamInstruction.class), new BasicForm("floor", 1, FloorInstruction.class), new BasicForm("ceiling", 1, CeilingInstruction.class), new BasicForm("negation", 1, NegationInstruction.class), new BasicForm("relative-doc-order", 2, RelativeDocOrderInstruction.class), new BasicForm("same-document?", 2, SameDocumentInstruction.class), new BasicForm("empty-cursor", 0, EmptyCursorInstruction.class), new BasicForm("node-stream-cursor", 1, NodeStreamCursorInstruction.class), new BasicForm("dup-filter-cursor", 1, DupFilterCursorInstruction.class), new BasicForm("namespace-uri-to-id", 1, NamespaceURIToIDInstruction.class), new BasicForm("id-to-namespace-uri", 1, IDToNamespaceURIInstruction.class), new BasicForm("namespace-prefix-to-id", 1, NamespacePrefixToIDInstruction.class), new BasicForm("id-to-local-name", 1, IDToLocalNameInstruction.class), new BasicForm("get-namespace-uri-id", 1, GetNamespaceURIIDInstruction.class), new BasicForm("nilled", 1, IsNilledInstruction.class), new BasicForm("is-empty", 1, IsEmptyInstruction.class)};

    public static String getFormName(int n) {
        if (n >= 0 && n < FormHandler.getSize()) {
            return s_basicForms[n].getFormName();
        }
        return null;
    }

    public static Class getFormClass(int n) {
        if (n >= 0 && n < FormHandler.getSize()) {
            return s_basicForms[n].getFormClass();
        }
        return null;
    }

    public static int getSize() {
        return s_basicForms.length;
    }

    public Instruction parseForm(String string, com.ibm.xylem.parser.Parser parser, ITypeStore iTypeStore) throws ParserException {
        Object object;
        int n;
        s_logger.debug("processing " + string);
        for (n = 0; n < s_basicForms.length; ++n) {
            object = s_basicForms[n];
            if (!((BasicForm)object).m_name.equals(string)) continue;
            Class[] classArray = new Class[((BasicForm)object).m_parameters];
            Object[] objectArray = new Instruction[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = Instruction.class;
                objectArray[i] = parser.parseExpression(iTypeStore);
            }
            parser.parseCloseParen();
            try {
                return (Instruction)((BasicForm)object).m_class.getConstructor(classArray).newInstance(objectArray);
            }
            catch (Exception exception) {
                System.err.println("Invoking constructor w/ params:");
                for (int i = 0; i < objectArray.length; ++i) {
                    System.err.println(i + ": " + objectArray[i]);
                }
                throw new StaticError("ERR_SYSTEM", "Failed to invoke " + objectArray.length + "-argument constructor in " + ((BasicForm)object).m_class + "\n params=" + objectArray, exception);
            }
        }
        if (string.equals("xpath-data-type")) {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            while ((c = parser.readStripComments()) != ')') {
                stringBuffer.append(c);
            }
            String string2 = stringBuffer.toString().trim();
            if (string2.length() >= 2 && string2.charAt(0) == '\"' && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            try {
                XType xType = new Parser(new StringReader(string2)).Type();
                return new XPathDataTypeLiteralInstruction(xType);
            }
            catch (Exception exception) {
                s_logger.warn("Unable to parse XML type expression: " + string2, exception);
                return new XPathDataTypeLiteralInstruction(null);
            }
        }
        if (string.equals("coerce")) {
            Type type = parser.parseTypeName(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Instruction[] instructionArray = parser.parseRemainingExpressions(iTypeStore);
            return new CoerceInstruction((Instruction)object, type);
        }
        if (string.equals("get-axis-cursor")) {
            String string3 = parser.parseIdentifier();
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new GetAxisCursorInstruction(Integer.parseInt(string3), (Instruction)object);
        }
        if (string.equals("comparison")) {
            String string4 = parser.parseIdentifier();
            object = parser.parseExpression(iTypeStore);
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new ComparisonInstruction(Integer.parseInt(string4), (Instruction)object, instruction);
        }
        if (string.equals("arithmetic")) {
            String string5 = parser.parseIdentifier();
            object = parser.parseExpression(iTypeStore);
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            int n2 = 0;
            if (string5.equals("+")) {
                n2 = 4;
            } else if (string5.equals("-")) {
                n2 = 5;
            } else if (string5.equals("*")) {
                n2 = 30;
            } else if (string5.equals("/")) {
                n2 = 31;
            } else if (string5.equals("%")) {
                n2 = 33;
            } else {
                throw new ParserException("Invalid operator: " + string5, parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
            }
            return new ArithmeticInstruction(n2, (Instruction)object, instruction);
        }
        if (string.equals("equal?") || string.equals("unequal?")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new EqualityInstruction(instruction, (Instruction)object, string.equals("unequal?"));
        }
        if (string.equals("message")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new MessageInstruction((Instruction)object, instruction);
        }
        if (string.equals("terminate")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Type type = parser.parseTypeName(iTypeStore);
            parser.parseCloseParen();
            return new TerminateInstruction((Instruction)object, instruction, type);
        }
        if (string.equals("QNameTriples")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Instruction instruction2 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new QNameTriplesInstruction(instruction, (Instruction)object, instruction2);
        }
        if (string.equals("current-node-list-filter")) {
            Object object2 = parser.parseName();
            object = parser.parseName();
            Object object3 = parser.parseName();
            Object object4 = parser.parseName();
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new CurrentNodeListFilterInstruction(instruction, object2, object, object3, object4);
        }
        if (string.equals("get-node-value-cursor")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            int n3 = parser.parseInteger();
            Instruction instruction3 = parser.parseExpression(iTypeStore);
            boolean bl = parser.parseBooleanLiteral();
            parser.parseCloseParen();
            return new GetNodeValueCursorInstruction(instruction, n3, instruction3, bl);
        }
        if (string.equals("get-typed-axis-cursor")) {
            n = parser.parseInteger();
            int n4 = parser.parseInteger();
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new GetTypedAxisCursorInstruction(n, n4, instruction);
        }
        if (string.equals("get-typed-axis-cursor-for-step")) {
            n = parser.parseInteger();
            int n5 = parser.parseInteger();
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new GetTypedAxisCursorForStepInstruction(n, n5, instruction);
        }
        if (string.equals("get-axis-cursor-for-step")) {
            n = parser.parseInteger();
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            return new GetAxisCursorForStepInstruction(n, (Instruction)object);
        }
        if (string.equals("unwrap")) {
            Object obj;
            Instruction instruction = parser.parseExpression(iTypeStore);
            parser.parseOpenParen();
            object = parser.parseName();
            Object object5 = parser.parseName();
            parser.parseCloseParen();
            Instruction instruction4 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            try {
                Class<?> clazz = Class.forName("com.ibm.xylem.xsltc.input.sax.instructions.UnwrapInstruction");
                Constructor<?> constructor = clazz.getDeclaredConstructor(Class.forName("com.ibm.xylem.Instruction"), Class.forName("java.lang.Object"), Class.forName("java.lang.Object"), Class.forName("com.ibm.xylem.Instruction"));
                obj = constructor.newInstance(instruction, object, object5, instruction4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException();
            }
            return (Instruction)obj;
        }
        if (string.equals("create-element-preserve!")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            Instruction instruction5 = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            CreateElementInstruction createElementInstruction = new CreateElementInstruction(instruction, (Instruction)object, instruction5);
            createElementInstruction.setPreserveTypeAnnotations(true);
            return createElementInstruction;
        }
        if (string.equals("create-document-fragment-preserve!")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            object = parser.parseExpression(iTypeStore);
            parser.parseCloseParen();
            CreateDocumentFragmentInstruction createDocumentFragmentInstruction = new CreateDocumentFragmentInstruction(instruction, (Instruction)object);
            createDocumentFragmentInstruction.setPreserveTypeAnnotations(true);
            return createDocumentFragmentInstruction;
        }
        if (string.equals("cache-cursor")) {
            Instruction instruction = parser.parseExpression(iTypeStore);
            boolean bl = parser.parseBooleanLiteral();
            boolean bl2 = parser.parseBooleanLiteral();
            parser.parseCloseParen();
            CacheCursorInstruction cacheCursorInstruction = new CacheCursorInstruction(instruction, bl, bl2);
            return cacheCursorInstruction;
        }
        if (string.equals("get-xdm-manager-factory")) {
            parser.parseCloseParen();
            XDMManagerFactoryInstruction xDMManagerFactoryInstruction = new XDMManagerFactoryInstruction();
            return xDMManagerFactoryInstruction;
        }
        return null;
    }

    public void registerForms(com.ibm.xylem.parser.Parser parser) {
        for (int i = 0; i < s_basicForms.length; ++i) {
            parser.registerForm(s_basicForms[i].m_name, this);
        }
        parser.registerForm("xpath-data-type", this);
        parser.registerForm("coerce", this);
        parser.registerForm("get-axis-cursor", this);
        parser.registerForm("comparison", this);
        parser.registerForm("get-typed-axis-cursor", this);
        parser.registerForm("get-typed-axis-cursor-for-step", this);
        parser.registerForm("get-axis-cursor-for-step", this);
        parser.registerForm("get-namespace-axis-cursor", this);
        parser.registerForm("current-node-list-filter", this);
        parser.registerForm("get-node-value-cursor", this);
        parser.registerForm("sql", this);
        parser.registerForm("message", this);
        parser.registerForm("equal?", this);
        parser.registerForm("unequal?", this);
        parser.registerForm("arithmetic", this);
        parser.registerForm("terminate", this);
        parser.registerForm("QNameTriples", this);
        parser.registerForm("unwrap", this);
        parser.registerForm("create-element-preserve!", this);
        parser.registerForm("create-document-fragment-preserve!", this);
        parser.registerForm("cache-cursor", this);
        parser.registerForm("get-xdm-manager-factory", this);
    }

    public static class BasicForm {
        private String m_name;
        int m_parameters;
        private Class m_class;

        BasicForm(String string, int n, Class clazz) {
            this.m_name = string;
            this.m_parameters = n;
            this.m_class = clazz;
        }

        public String getFormName() {
            return this.m_name;
        }

        public Class getFormClass() {
            return this.m_class;
        }
    }
}

