/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.xpath20.analysis;

import com.ibm.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xtq.xslt.xylem.xpath20.analysis.Annotation;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.EmptyXType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.FunctionDeclaration;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.SequenceXType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.XTypeStore;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.Program;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.ConversionEngine;
import com.ibm.xylem.annot.FunctionCallSpec;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.IAnnotator;
import com.ibm.xylem.annot.IConverter;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import java.util.Collections;
import java.util.List;

public class Analyzer
implements IAnnotator {
    protected XTypeStore m_typeStore;
    private static final NamedType s_xdtType = new NamedType("XPath20Datum");
    private static final StreamType s_xdtStream = new StreamType(s_xdtType);

    public Analyzer(XTypeStore xTypeStore) {
        this.m_typeStore = xTypeStore;
    }

    public IAnnotation analyzeExpression(AnnotationEnvironment annotationEnvironment, Instruction instruction, Object object) {
        BindingEnvironment bindingEnvironment;
        TypeEnvironment typeEnvironment = annotationEnvironment.getTypeEnvironment();
        Type type = instruction.getType(typeEnvironment, bindingEnvironment = annotationEnvironment.getBindingEnvironment()).resolveType(typeEnvironment);
        if (type.equals(s_xdtStream)) {
            if (instruction instanceof StreamInstruction) {
                StreamInstruction streamInstruction = (StreamInstruction)instruction;
                XType xType = EmptyXType.s_emptyXType;
                for (int i = 0; i < streamInstruction.getChildInstructionCount(); ++i) {
                    Instruction instruction2 = streamInstruction.getChildInstruction(i);
                    Annotation annotation = (Annotation)annotationEnvironment.get(instruction2);
                    if (annotation == null || annotation.getXType() == null) {
                        return null;
                    }
                    xType = xType instanceof EmptyXType ? annotation.getXType() : new SequenceXType(xType, annotation.getXType());
                }
                return new Annotation(xType);
            }
            if (instruction instanceof ApplyInstruction) {
                ApplyInstruction applyInstruction = (ApplyInstruction)instruction;
            } else if (instruction instanceof IdentifierInstruction) {
                IAnnotation iAnnotation = annotationEnvironment.get(instruction);
                return iAnnotation;
            }
        } else if (type.equals(s_xdtType) && instruction instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction;
            XPathDataTypeLiteralInstruction xPathDataTypeLiteralInstruction = (XPathDataTypeLiteralInstruction)NavigationUtilities.resolveReducedIdentifier(constructorInstantiationInstruction.m_parameters[constructorInstantiationInstruction.m_parameters.length - 1], bindingEnvironment);
            return new Annotation(xPathDataTypeLiteralInstruction.getXType());
        }
        return null;
    }

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, List list) {
        return null;
    }

    public IAnnotation interceptFunctionCall(AnnotationEnvironment annotationEnvironment, FunctionCallInstruction functionCallInstruction) {
        FunctionDeclaration functionDeclaration;
        BindingEnvironment bindingEnvironment;
        TypeEnvironment typeEnvironment = annotationEnvironment.getTypeEnvironment();
        Type type = functionCallInstruction.getType(typeEnvironment, bindingEnvironment = annotationEnvironment.getBindingEnvironment()).resolveType(typeEnvironment);
        if (type.equals(s_xdtStream) && (functionDeclaration = this.m_typeStore.lookupFunction(functionCallInstruction.getFunction())) != null) {
            return new Annotation(functionDeclaration.getReturnType());
        }
        return null;
    }

    public void preAnalysis(Program program) {
    }

    public IConverter getConverter() {
        return new IConverter(){

            public Instruction convert(Instruction instruction, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
                return instruction;
            }

            public List getBindingList(Object object, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
                return null;
            }

            public List getIdentifierList(Object object, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
                return Collections.singletonList(new IdentifierInstruction(object));
            }

            public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            }

            public void addConversionSupport(Module module) {
            }

            public void preConversion(Program program) {
            }

            public Type getValueType(IAnnotation iAnnotation, ConversionEngine conversionEngine) {
                return null;
            }

            public void insertLoopBinding(IAnnotation iAnnotation, IAnnotation iAnnotation2, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            }

            public void insertValueDecomposition(Object object, IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
            }
        };
    }

    public boolean isFunctionReturnNotAnnotated(FunctionCallSpec functionCallSpec) {
        return false;
    }
}

