/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.Serializable;

public final class Binding
implements IBinding,
Serializable {
    private static final long serialVersionUID = -6921253073966497695L;
    protected Object m_name;
    protected Type m_type;
    protected TypeEnvironment m_typeEnvironment;
    protected ISpecialForm m_origin;

    public Binding(Object object, Type type, ISpecialForm iSpecialForm) {
        this.m_type = type;
        this.m_origin = iSpecialForm;
        this.setName(object);
    }

    public Binding(Object object, Type type, TypeEnvironment typeEnvironment) {
        this.m_type = type;
        this.m_typeEnvironment = typeEnvironment;
        this.setName(object);
    }

    public Binding(Object object, ISpecialForm iSpecialForm) {
        this(object, (Type)new TypeVariable(), iSpecialForm);
    }

    public Binding(Object object) {
        this(object, (Type)new TypeVariable(), (ISpecialForm)null);
    }

    public Binding(Object object, Type type) {
        this(object, type, (ISpecialForm)null);
    }

    public int compareTo(Object object) {
        return Binding.compare(this, object);
    }

    public static int compare(IBinding iBinding, Object object) {
        if (!(object instanceof IBinding)) {
            throw new XylemError("ERR_SYSTEM", "Can't compare a binding to a non-binding!");
        }
        Object object2 = iBinding.getName();
        Object object3 = ((IBinding)object).getName();
        if (object2 instanceof Integer && object3 instanceof Integer) {
            return ((Integer)object2).compareTo((Integer)object3);
        }
        if (object2 instanceof String && object3 instanceof String) {
            return ((String)object2).compareTo((String)object3);
        }
        if (object2 instanceof Integer) {
            return -1;
        }
        return 1;
    }

    public static Binding[] getBindings(Object[] objectArray) {
        Binding[] bindingArray = new Binding[objectArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(objectArray[i]);
        }
        return bindingArray;
    }

    public static Binding[] getBindings(Type[] typeArray) {
        Binding[] bindingArray = new Binding[typeArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding((Object)("a" + i), typeArray[i]);
        }
        return bindingArray;
    }

    public static Binding[] getBindings2(Type[] typeArray) {
        Binding[] bindingArray = new Binding[typeArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding((Object)ReductionHelper.generateIntermediateIdentifier2(), typeArray[i]);
        }
        return bindingArray;
    }

    public static Binding[] cloneBindings(IBinding[] iBindingArray) {
        Binding[] bindingArray = new Binding[iBindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            bindingArray[i] = new Binding(iBindingArray[i].getName(), iBindingArray[i].getBindingType());
        }
        return bindingArray;
    }

    public static Object[] getNames(IBinding[] iBindingArray) {
        Object[] objectArray = new Object[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            objectArray[i] = iBindingArray[i].getName();
        }
        return objectArray;
    }

    public static Instruction[] getIdentifiers(IBinding[] iBindingArray) {
        Instruction[] instructionArray = new IdentifierInstruction[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            instructionArray[i] = new IdentifierInstruction(iBindingArray[i].getName());
        }
        return instructionArray;
    }

    public static String generateVariableName(IBinding iBinding, CodeGeneration codeGeneration) {
        Object object = iBinding.getName();
        return codeGeneration.getSafeName(object.toString());
    }

    public static Type resolveBindingType(IBinding iBinding, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
        return type.resolveType(typeEnvironment);
    }

    public Object getName() {
        return this.m_name;
    }

    public void setName(Object object) {
        if (object == null) {
            throw new XylemError("ERR_SYSTEM", "You almost certainly don't mean to make a binding with name null.");
        }
        if (!(object instanceof String) && !(object instanceof Integer)) {
            throw new XylemError("ERR_SYSTEM", "You almost certainly did not mean to make a binding name using a " + object.getClass());
        }
        if (object instanceof Binding) {
            object = ((Binding)object).getName();
        }
        this.m_name = object;
    }

    public Type getBindingType() {
        return this.m_type;
    }

    public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    public void setType(Type type) {
        this.m_type = type;
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.m_typeEnvironment;
    }

    public void setTypeEnvironment(TypeEnvironment typeEnvironment) {
        this.m_typeEnvironment = typeEnvironment;
    }

    public Object clone() {
        return new Binding(this.m_name, this.m_type, this.m_typeEnvironment);
    }

    public String toString() {
        return "[" + this.hashCode() + "] " + this.m_name + ": " + this.m_type;
    }

    public LetInstruction getLet() {
        return null;
    }

    public ISpecialForm getOrigin() {
        return this.m_origin;
    }

    public static final Type[] getTypeArrayFromBindingArray(IBinding[] iBindingArray) {
        Type[] typeArray = new Type[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            typeArray[i] = iBindingArray[i].getBindingType();
        }
        return typeArray;
    }
}

