/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import java.io.Serializable;

public class Functor
implements Serializable {
    private static final long serialVersionUID = 3253739645996929876L;
    static final Logger s_logger = Logger.getInstance(Functor.class);
    protected ModuleSignature[] m_parameters;
    protected String[] m_parameterNames;
    protected Module m_body;
    protected String m_name;
    protected ModuleSignature m_signature;

    public Functor(String string, Module module, ModuleSignature[] moduleSignatureArray, String[] stringArray, ModuleSignature moduleSignature) {
        this.m_name = string;
        this.m_body = module;
        this.m_parameters = moduleSignatureArray;
        this.m_signature = moduleSignature;
        this.m_parameterNames = stringArray;
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_body.addModuleImportDirective(new FunctorParameterDirective(stringArray[i], moduleSignatureArray[i]));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Module getBody() {
        return this.m_body;
    }

    public ModuleSignature[] getParameters() {
        return this.m_parameters;
    }

    public String[] getParameterNames() {
        return this.m_parameterNames;
    }

    public ModuleSignature getSignature() {
        return this.m_signature;
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("functor", n);
        prettyPrinter.printToken("(" + this.m_name, n + 1);
        prettyPrinter.print("@");
        prettyPrinter.print(this.m_signature);
        for (int i = 0; i < this.m_parameters.length; ++i) {
            prettyPrinter.printToken(this.m_parameterNames[i], n + 2);
            prettyPrinter.print("@");
            prettyPrinter.print(this.m_parameters[i]);
        }
        prettyPrinter.printFormClose(n + 1);
        this.m_body.prettyPrintModuleInternals(prettyPrinter, n);
        prettyPrinter.printFormClose(n);
    }

    public void typeCheck() throws TypeCheckException {
        s_logger.debug("type checking functor " + this.m_name);
        this.m_body.typeCheck();
    }

    public void clearTypeInformation() {
        this.m_body.clearTypeInformation(true);
    }

    public void reduce() {
        this.m_body.reduce();
    }

    public class FunctorParameterDirective
    extends ModuleImportDirective {
        private static final long serialVersionUID = 1617730064793711035L;

        FunctorParameterDirective(String string, ModuleSignature moduleSignature) {
            super(string, moduleSignature);
        }

        public Instruction translateFunctionCall(ModuleFunctionCallInstruction moduleFunctionCallInstruction, Module module) {
            Instruction[] instructionArray = moduleFunctionCallInstruction.m_parameters;
            Instruction[] instructionArray2 = new Instruction[instructionArray.length + 1];
            System.arraycopy(instructionArray, 0, instructionArray2, 0, instructionArray.length);
            instructionArray2[instructionArray.length] = new IdentifierInstruction("__functorinstance__");
            return new FunctionCallInstruction(Functor.this.m_name + "$functor$" + this.m_localName + "$" + moduleFunctionCallInstruction.getFunction(), instructionArray2);
        }

        public void toString(PrettyPrinter prettyPrinter, int n) {
        }
    }
}

