/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xtq.bcel.generic.ClassGenException;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.Function;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleLinker;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.ConventionalFunctionGenerationStyle;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.StreamOptimizedFunctionGenerationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.optimizers.SplitFunctions;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.StreamType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class Program
extends Module {
    private static final long serialVersionUID = 6499428922689211647L;
    protected HashSet m_baseParameters = new HashSet();
    protected String m_generatedBaseClass = null;
    protected String m_className = "";
    static final Logger s_logger;

    public Program(ModuleSignature moduleSignature) {
        super("", null, moduleSignature);
    }

    public Program() {
    }

    protected void generateRequiredFunctions(CodeGeneration codeGeneration) {
        Iterator iterator = this.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (function.m_isClassMethod) continue;
            Type[] typeArray = new Type[function.m_parameters.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray[i] = function.m_parameters[i].getBindingType();
            }
            Type type = function.getReturnType().resolveType(function.getTypeEnvironment());
            codeGeneration.requestFunctionGeneration(new ConventionalFunctionGenerationStyle(function));
            try {
                if (!(type instanceof StreamType) || !function.getBody().supportsCodeGenerationOptimization(StreamOptimizationStyle.s_streamOptimizationStyle, function.getTypeEnvironment(), function.getBindingEnvironment())) continue;
                codeGeneration.requestFunctionGeneration(new StreamOptimizedFunctionGenerationStyle(function));
            }
            catch (Exception exception) {
                s_logger.error("could not codegen for '" + function.getName() + "' ", exception);
            }
        }
    }

    public void setGeneratedBaseClass(String string) {
        this.m_generatedBaseClass = string;
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    public DataFlowCodeGenerationHelper generateCodeBasedOnDataFlow(Writer writer, Writer writer2) throws IOException {
        return this.generateCodeBasedOnDataFlow(writer, writer2, false);
    }

    public DataFlowCodeGenerationHelper generateCodeBasedOnDataFlow(Writer writer, Writer writer2, boolean bl) throws IOException {
        CodeGenerationSettings codeGenerationSettings = new CodeGenerationSettings();
        if (bl) {
            codeGenerationSettings.setTargetLanguage(3);
        }
        DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper = new DataFlowCodeGenerationHelper(this.m_className, codeGenerationSettings);
        this.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, writer, writer2);
        return dataFlowCodeGenerationHelper;
    }

    public void generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, Writer writer, Writer writer2) throws IOException {
        Object object;
        Object object22;
        dataFlowCodeGenerationHelper.m_constantsClassPrefix = this.m_className + "_";
        ArrayList arrayList = new ArrayList(this.m_adts.values());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((AbstractDataType)object).getName().compareTo(((AbstractDataType)object2).getName());
            }
        });
        for (Object object22 : arrayList) {
            try {
                s_logger.debug("Generating adt=" + object22);
                ((AbstractDataType)object22).generateDeclarationCode(dataFlowCodeGenerationHelper);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (dataFlowCodeGenerationHelper.isTargetCPP()) {
            for (Object object22 : arrayList) {
                ((AbstractDataType)object22).generateCode(dataFlowCodeGenerationHelper);
            }
        }
        object22 = new ArrayList(this.m_classes.values());
        Collections.sort(object22, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ClassType)object).getName().compareTo(((ClassType)object2).getName());
            }
        });
        Iterator<Object> iterator = ((ArrayList)object22).iterator();
        while (iterator.hasNext()) {
            object = (ClassType)iterator.next();
            ((ClassType)object).generateCode(dataFlowCodeGenerationHelper, (Module)this);
        }
        this.generateRequiredFunctions(dataFlowCodeGenerationHelper);
        object = new HashSet();
        HashMap hashMap = new HashMap(63);
        while (!dataFlowCodeGenerationHelper.functionGenerationRequestsIsEmpty()) {
            iterator = dataFlowCodeGenerationHelper.functionGenerationRequestsIterator();
            Object object3 = (FunctionGenerationStyle)iterator.next();
            s_logger.debug("gen'ing f=" + ((FunctionGenerationStyle)object3).getSignature() + " using fgs=" + object3.getClass());
            iterator.remove();
            if (((HashSet)object).contains(((FunctionGenerationStyle)object3).getSignature())) continue;
            ((HashSet)object).add(((FunctionGenerationStyle)object3).getSignature());
            Function function = ((FunctionGenerationStyle)object3).getFunction();
            if (!hashMap.isEmpty()) {
                hashMap = new HashMap(63);
            }
            CodeGenerationTracker codeGenerationTracker = new CodeGenerationTracker(hashMap, function);
            dataFlowCodeGenerationHelper.startFunction((FunctionGenerationStyle)object3);
            try {
                ((FunctionGenerationStyle)object3).generateFunctionBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker);
            }
            catch (Exception exception) {
                s_logger.error("function generation failed for '" + ((FunctionGenerationStyle)object3).getSignature() + " using fgs=" + object3.getClass() + " dumping program to " + this.m_className + ".exception.xylem", exception);
                Program.dumpXylemFile(this, null, this.m_className + ".exception");
                throw new Error();
            }
            dataFlowCodeGenerationHelper.endFunction();
        }
        if (dataFlowCodeGenerationHelper.isTargetJava()) {
            for (Object object3 : arrayList) {
                ((AbstractDataType)object3).generateCode(dataFlowCodeGenerationHelper);
            }
        }
        dataFlowCodeGenerationHelper.generateConstantsSection(writer);
        dataFlowCodeGenerationHelper.generateMainProgram(writer);
        dataFlowCodeGenerationHelper.generateRecycleMethod(writer);
        dataFlowCodeGenerationHelper.generateStaticSection(writer);
        dataFlowCodeGenerationHelper.generatePostClassSection(this.m_generatedBaseClass, writer2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper) throws IOException {
        Object object2;
        ArrayList arrayList = new ArrayList(this.m_adts.values());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((AbstractDataType)object).getName().compareTo(((AbstractDataType)object2).getName());
            }
        });
        ArrayList arrayList2 = new ArrayList(this.m_classes.values());
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ClassType)object).getName().compareTo(((ClassType)object2).getName());
            }
        });
        for (Object object2 : arrayList2) {
            ((ClassType)object2).generateCode(bCELCodeGenerationHelper, (Module)this);
        }
        this.generateRequiredFunctions(bCELCodeGenerationHelper);
        object2 = new HashSet();
        HashMap hashMap = new HashMap(63);
        InstructionList instructionList = new InstructionList();
        block8: while (!bCELCodeGenerationHelper.functionGenerationRequestsIsEmpty()) {
            Iterator iterator = bCELCodeGenerationHelper.functionGenerationRequestsIterator();
            Object object3 = (FunctionGenerationStyle)iterator.next();
            s_logger.debug("gen'ing f=" + ((FunctionGenerationStyle)object3).getSignature() + " using fgs=" + object3.getClass());
            iterator.remove();
            if (((HashSet)object2).contains(((FunctionGenerationStyle)object3).getSignature())) continue;
            ((HashSet)object2).add(((FunctionGenerationStyle)object3).getSignature());
            Function function = ((FunctionGenerationStyle)object3).getFunction();
            while (true) {
                int n;
                int n2;
                InstructionHandle instructionHandle;
                CodeGenerationSettings codeGenerationSettings;
                bCELCodeGenerationHelper.startFunction((FunctionGenerationStyle)object3);
                if (!hashMap.isEmpty()) {
                    hashMap = new HashMap(63);
                }
                CodeGenerationTracker codeGenerationTracker = new CodeGenerationTracker(hashMap, function);
                try {
                    ((FunctionGenerationStyle)object3).generateFunction(bCELCodeGenerationHelper, codeGenerationTracker, instructionList);
                    continue block8;
                }
                catch (BCELCodeGenerationHelper.BCELFunctionSizeException bCELFunctionSizeException) {
                    codeGenerationSettings = bCELCodeGenerationHelper.getSettings();
                    if (codeGenerationSettings.getBCELAutoSplitFunctions()) {
                        s_logger.warn("Automatically splitting function " + function.getName() + " with bcel size " + bCELFunctionSizeException.size);
                        bCELCodeGenerationHelper.setAutoSplitterInvoked(true);
                        instructionHandle = instructionList.getEnd();
                        n2 = 1;
                        for (n = (instructionHandle.getPosition() + instructionHandle.getInstruction().getLength()) / 2; n > 60000; n /= 2) {
                            ++n2;
                        }
                        new SplitFunctions((Module)this, codeGenerationSettings.getOrderSafeSplit()).splitOnce(function, n2);
                        continue;
                    }
                    throw bCELFunctionSizeException;
                }
                catch (ClassGenException classGenException) {
                    codeGenerationSettings = bCELCodeGenerationHelper.getSettings();
                    if (codeGenerationSettings.getBCELAutoSplitFunctions()) {
                        s_logger.warn("Automatically splitting function " + function.getName() + " due to bcel error " + classGenException);
                        bCELCodeGenerationHelper.setAutoSplitterInvoked(true);
                        instructionHandle = instructionList.getEnd();
                        n2 = 1;
                        for (n = (instructionHandle.getPosition() + instructionHandle.getInstruction().getLength()) / 2; n > 60000; n /= 2) {
                            ++n2;
                        }
                        new SplitFunctions((Module)this, codeGenerationSettings.getOrderSafeSplit()).splitOnce(function, n2);
                        continue;
                    }
                    throw classGenException;
                }
                finally {
                    function.setTryFlag(false);
                    function.setExceptionHandle(null);
                    instructionList.dispose();
                    bCELCodeGenerationHelper.endFunction();
                    continue;
                }
                break;
            }
        }
        for (Object object3 : arrayList) {
            ((AbstractDataType)object3).generateCode(bCELCodeGenerationHelper);
        }
        bCELCodeGenerationHelper.finish();
    }

    protected String innerToString() {
        return "program";
    }

    public static final void dumpXylemFile(Module module, File file, String string, String string2) {
        Program.dumpXylemFile(module, file, string + "-" + string2);
    }

    public static final void dumpXylemFile(Module module, URL uRL, String string, boolean bl) {
        File file = new File(uRL.getPath());
        String string2 = file.getName();
        string2 = string2.substring(0, string2.lastIndexOf(".cxo"));
        file = file.getParentFile();
        Program.dumpXylemFile(module, file, string2 + "-" + string);
    }

    public static final void dumpXylemFile(Module module, File file, String string) {
        try {
            File file2 = new File(file, string + ".xylem");
            s_logger.debug("Dumping program to file " + file2);
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println(";;;; Xylem code; roughly follows -*- Scheme -*- syntax.");
            module.dump(printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            s_logger.error("i/o error", iOException);
        }
    }

    public static final void dumpXylemFunctions(Function[] functionArray, File file, String string, String string2) {
        Program.dumpXylemFunctions(functionArray, file, string + "-" + string2);
    }

    public static final void dumpXylemFunctions(Function[] functionArray, File file, String string) {
        try {
            File file2 = new File(file, string + ".xylem");
            s_logger.debug("Dumping functions to file " + file2);
            FileWriter fileWriter = new FileWriter(file2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            PrettyPrinter prettyPrinter = new PrettyPrinter(printWriter);
            for (int i = 0; i < functionArray.length; ++i) {
                functionArray[i].toString(prettyPrinter, 0);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            s_logger.error("i/o error", iOException);
        }
    }

    protected void write(ObjectOutput objectOutput) throws IOException {
        Object object;
        Object object22;
        WriteObjectFileHelper writeObjectFileHelper = new WriteObjectFileHelper(this, objectOutput);
        writeObjectFileHelper.writeString(this.m_name);
        this.m_signature.write(writeObjectFileHelper);
        Program.writeTypes(this, writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_modules.size());
        for (Object object22 : this.m_modules.values()) {
            writeObjectFileHelper.writeString(((Module)object22).m_signature.getName());
            ((Module)object22).m_signature.write(writeObjectFileHelper);
        }
        for (Object object22 : this.m_modules.values()) {
            Module.writeModule(objectOutput, (Module)object22);
        }
        object22 = this.getFunctions();
        writeObjectFileHelper.writeInt(object22.size());
        Iterator<Object> iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            ((Function)object).write(writeObjectFileHelper);
        }
        object = this.getTypeAliases();
        writeObjectFileHelper.writeInt(object.size());
        iterator = object.iterator();
        Set set = this.getTypeAliasNames();
        Iterator iterator2 = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator2.next();
            writeObjectFileHelper.writeString(string);
            Type type = (Type)iterator.next();
            writeObjectFileHelper.writeType(type);
        }
    }

    protected void read(ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) throws Exception {
        Object object;
        int n;
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(this, objectInput, moduleSignatureStore);
        s_logger.debug("reading  program");
        this.m_name = readObjectFileHelper.readString();
        this.m_signature = new ModuleSignature();
        this.m_signature.read(readObjectFileHelper);
        moduleSignatureStore.registerModuleSignature(this.m_name, this.m_signature);
        Program.readTypes(this, readObjectFileHelper);
        int n2 = readObjectFileHelper.readInt();
        s_logger.debug("reading " + n2 + " signatures");
        for (n = 0; n < n2; ++n) {
            object = new ModuleSignature();
            String string = readObjectFileHelper.readString();
            s_logger.debug("reading " + string + " signature");
            ((ModuleSignature)object).read(readObjectFileHelper);
            moduleSignatureStore.registerModuleSignature(string, (ModuleSignature)object);
        }
        s_logger.debug("reading " + n2 + " modules");
        for (n = 0; n < n2; ++n) {
            object = Module.readModule(objectInput, moduleSignatureStore);
            s_logger.debug("read " + ((AbstractTypeStore)object).getName() + " signature");
            this.addModule((Module)object);
        }
        n2 = readObjectFileHelper.readInt();
        for (n = 0; n < n2; ++n) {
            object = new Function();
            ((Function)object).read(readObjectFileHelper);
            this.addFunction((Function)object);
        }
        n2 = readObjectFileHelper.readInt();
        for (int i = 0; i < n2; ++i) {
            object = readObjectFileHelper.readString();
            Type type = readObjectFileHelper.readType();
            this.addTypeAlias((String)object, type);
        }
        ModuleLinker.reflattenModules(this);
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(Program.class);
    }
}

