/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;

public class TopLevelModuleImportDirective
extends ModuleImportDirective {
    private static final long serialVersionUID = -7849431194450199173L;
    protected String m_moduleName;

    public TopLevelModuleImportDirective() {
    }

    public TopLevelModuleImportDirective(String string, ModuleSignature moduleSignature, String string2) {
        super(string, moduleSignature);
        this.m_moduleName = string2;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public Instruction translateFunctionCall(ModuleFunctionCallInstruction moduleFunctionCallInstruction, Module module) {
        return new FunctionCallInstruction(TopLevelModuleImportDirective.translateFunctionName(moduleFunctionCallInstruction.getFunction(), module.getModuleImportDirective(moduleFunctionCallInstruction.getModule())), moduleFunctionCallInstruction.m_parameters);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("import-module", n);
        prettyPrinter.print(" " + this.getLocalName());
        prettyPrinter.print(this.m_signature);
        prettyPrinter.printFormClose(n);
    }

    public void setSignature(ModuleSignature moduleSignature) {
        this.m_signature = moduleSignature;
    }

    public void read(ReadObjectFileHelper readObjectFileHelper) throws Exception {
        super.read(readObjectFileHelper);
        this.m_moduleName = readObjectFileHelper.readString();
        this.m_signature = readObjectFileHelper.m_mss.resolveModuleSignature(this.m_moduleName);
        if (this.m_signature == null) {
            throw new XylemError("ERR_SYSTEM", " no sig for '" + this.m_moduleName + "'");
        }
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_moduleName);
    }
}

