/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot;

import com.ibm.xylem.Binding;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.AnnotationTable;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.ICallSpec;
import com.ibm.xylem.annot.IFunctionAnnotationInfo;
import com.ibm.xylem.annot.LambdaAnnotationInfo;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;

public class LambdaApplySpec
implements ICallSpec {
    private IAnnotation[] m_paramAnnotations;
    private Binding[] m_lambdaBindings;
    private Instruction m_lambda;
    private String m_identifier;
    private boolean m_isPure;

    public LambdaApplySpec(String string, Instruction instruction, IBinding[] iBindingArray, IAnnotation[] iAnnotationArray, boolean bl) {
        this.m_paramAnnotations = iAnnotationArray;
        this.m_lambdaBindings = (Binding[])iBindingArray;
        this.m_lambda = instruction;
        this.m_identifier = string;
        if (string == null) {
            this.m_identifier = "lambda$" + System.identityHashCode(this.m_lambda);
        }
        this.m_isPure = bl;
    }

    public LambdaApplySpec(String string, Instruction instruction, IAnnotation[] iAnnotationArray, boolean bl) {
        this(string, instruction, ((ISpecialForm)((Object)instruction)).getChildInstructionBindings(0), iAnnotationArray, bl);
    }

    public LambdaApplySpec(ApplyInstruction applyInstruction, AnnotationEnvironment annotationEnvironment) {
        this("lambda$" + ((IdentifierInstruction)applyInstruction.getLambda()).getVariable(), NavigationUtilities.resolveReducedIdentifier(applyInstruction.getLambda(), annotationEnvironment.getBindingEnvironment()), annotationEnvironment.get(applyInstruction.getOperands()), applyInstruction.isPure());
    }

    public boolean isPure() {
        return this.m_isPure;
    }

    public IAnnotation[] getParamAnnotations() {
        return this.m_paramAnnotations;
    }

    public Binding[] getParamBindings() {
        return this.m_lambdaBindings;
    }

    public Instruction getLambda() {
        return this.m_lambda;
    }

    public String getName() {
        return this.m_identifier;
    }

    public IFunctionAnnotationInfo newInfo(AnnotationTable annotationTable, AnnotationEnvironment annotationEnvironment) {
        return new LambdaAnnotationInfo(this, annotationEnvironment);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LambdaApplySpec)) {
            return false;
        }
        LambdaApplySpec lambdaApplySpec = (LambdaApplySpec)object;
        if (this.m_lambda != lambdaApplySpec.m_lambda) {
            return false;
        }
        if (this.getParamAnnotations().length != lambdaApplySpec.getParamAnnotations().length) {
            return false;
        }
        for (int i = 0; i < this.getParamAnnotations().length; ++i) {
            if (!(this.getParamAnnotations()[i] == null ? lambdaApplySpec.getParamAnnotations()[i] != null : !this.getParamAnnotations()[i].equals(lambdaApplySpec.getParamAnnotations()[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return System.identityHashCode(this.m_lambda);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LAS: " + this.m_identifier);
        stringBuffer.append("(");
        IAnnotation[] iAnnotationArray = this.getParamAnnotations();
        for (int i = 0; i < this.getParamBindings().length; ++i) {
            stringBuffer.append(this.getParamBindings()[i].getName());
            stringBuffer.append("@");
            stringBuffer.append(i < iAnnotationArray.length ? this.getParamAnnotations()[i] + "" : "UNDEF!");
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

