/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.annot.meta;

import com.ibm.xylem.Binding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.annot.AnnotationEnvironment;
import com.ibm.xylem.annot.AnnotationTable;
import com.ibm.xylem.annot.ConversionEngine;
import com.ibm.xylem.annot.IAnnotation;
import com.ibm.xylem.annot.meta.EmptyStreamMetaAnnotation;
import com.ibm.xylem.annot.meta.MetaAnnotation;
import com.ibm.xylem.annot.meta.ReturnValueMetaAnnotation;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StreamMetaAnnotation
extends MetaAnnotation {
    private Type m_originalType;
    private IAnnotation m_atomicAnnotation;
    private StreamMetaAnnotation m_base;

    public static IAnnotation newStream(StreamInstruction streamInstruction, AnnotationEnvironment annotationEnvironment, AnnotationTable annotationTable) {
        return null;
    }

    private StreamMetaAnnotation(Type type, IAnnotation iAnnotation) {
        this.m_originalType = type;
        this.m_atomicAnnotation = iAnnotation.clonePassthru();
        this.m_base = null;
    }

    private StreamMetaAnnotation(StreamMetaAnnotation streamMetaAnnotation) {
        this.m_base = streamMetaAnnotation;
        this.m_atomicAnnotation = streamMetaAnnotation.m_atomicAnnotation.clonePassthru();
    }

    public boolean propagateDependancies(IAnnotation iAnnotation) {
        if (!(iAnnotation instanceof StreamMetaAnnotation)) {
            return this.m_atomicAnnotation.propagateDependancies(iAnnotation);
        }
        return this.m_atomicAnnotation.propagateDependancies(((StreamMetaAnnotation)iAnnotation).m_atomicAnnotation);
    }

    public boolean equals(Object object) {
        while (object instanceof ReturnValueMetaAnnotation) {
            object = ((ReturnValueMetaAnnotation)object).getReturnAnnotation();
        }
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof EmptyStreamMetaAnnotation) {
            return object.equals(this);
        }
        if (!(object instanceof StreamMetaAnnotation)) {
            return false;
        }
        return this.m_atomicAnnotation.equals(((StreamMetaAnnotation)object).m_atomicAnnotation);
    }

    public List getBindingList(Object object, IAnnotation iAnnotation, ConversionEngine conversionEngine) {
        List list = conversionEngine.getBindingList(object, this.m_atomicAnnotation);
        for (Binding binding : list) {
            binding.setType(StreamType.makeStreamType(binding.getBindingType()));
        }
        return list;
    }

    public void insertAnnotationOperation(IAnnotation iAnnotation, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (iAnnotation != this) {
            throw new XylemError("ERR_SYSTEM", "!");
        }
        if (this.m_base != null) {
            this.insertPassthru(this, this.m_base, annotationEnvironment, conversionEngine);
        } else {
            conversionEngine.insertAnnotationOperation(this.m_atomicAnnotation);
            Iterator iterator = this.getBindingList(this.getVariable(), this, conversionEngine).iterator();
            Iterator iterator2 = conversionEngine.getBindingList(this.m_atomicAnnotation.getVariable(), this.m_atomicAnnotation).iterator();
            while (iterator.hasNext()) {
                Binding binding = (Binding)iterator.next();
                Binding binding2 = (Binding)iterator2.next();
                if (binding2.getBindingType() instanceof StreamType) {
                    conversionEngine.insertBinding(binding.getName(), new IdentifierInstruction(binding2.getName()));
                    continue;
                }
                conversionEngine.insertBinding(binding.getName(), new StreamInstruction(binding2.getBindingType(), new IdentifierInstruction(binding2.getName())));
            }
        }
    }

    public void setVariable(Object object) {
        super.setVariable(object);
        this.m_atomicAnnotation.setVariable(object);
    }

    public Type getOriginalType() {
        return this.m_originalType;
    }

    public IAnnotation cloneAsFunctionParam() {
        return new StreamMetaAnnotation(this.m_originalType, this.m_atomicAnnotation.cloneAsFunctionParam());
    }

    public IAnnotation clonePassthru() {
        return new StreamMetaAnnotation(this);
    }

    public IAnnotation getLoopBindingAnnotation() {
        return this.m_atomicAnnotation.getLoopBindingAnnotation();
    }

    public IAnnotation getLoopValueAnnotation() {
        return this.clonePassthru();
    }

    public void propagateDependanciesToBase() {
        throw new XylemError("ERR_SYSTEM", "!");
    }

    public boolean propagateDependanciesTo(MetaAnnotation metaAnnotation) {
        if (metaAnnotation instanceof StreamMetaAnnotation) {
            return ((StreamMetaAnnotation)metaAnnotation).m_atomicAnnotation.propagateDependancies(this.m_atomicAnnotation);
        }
        if (metaAnnotation instanceof EmptyStreamMetaAnnotation) {
            return false;
        }
        return this.m_atomicAnnotation.propagateDependancies(metaAnnotation);
    }

    public String toString() {
        return "(StreamAnnot " + this.getVariable() + " base=" + (this.m_base == null ? "null" : this.m_base.getVariable()) + " " + this.m_atomicAnnotation + ")";
    }

    public IAnnotation getAtomicAnnotation() {
        return this.m_atomicAnnotation;
    }

    public IAnnotation unionValues(AnnotationEnvironment annotationEnvironment, ArrayList arrayList) {
        for (IAnnotation iAnnotation : arrayList) {
            while (iAnnotation instanceof ReturnValueMetaAnnotation) {
                iAnnotation = ((ReturnValueMetaAnnotation)iAnnotation).getReturnAnnotation();
            }
            if (iAnnotation instanceof EmptyStreamMetaAnnotation) {
                ((EmptyStreamMetaAnnotation)iAnnotation).define(this);
                continue;
            }
            if (this.equals(iAnnotation)) continue;
            throw new XylemError("ERR_SYSTEM", "not supported " + this + " " + iAnnotation);
        }
        return this;
    }

    public Instruction convert(Instruction instruction, AnnotationEnvironment annotationEnvironment, ConversionEngine conversionEngine) {
        if (this.m_base == null && instruction instanceof StreamInstruction) {
            return null;
        }
        return super.convert(instruction, annotationEnvironment, conversionEngine);
    }
}

