/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen;

import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionInstantiation;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.ClosureGenerationUtilities;
import com.ibm.xylem.codegen.CodeGeneration;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.types.LambdaType;
import java.util.Iterator;
import java.util.List;

public class LambdaFunctionGenerationStyle
extends FunctionGenerationStyle {
    protected List m_paramInfo;
    protected LambdaType m_lambdaType;
    protected IBinding[] m_bindings;
    protected LiteralInstruction[] m_literalParameters;
    static final Logger s_logger = Logger.getInstance(LambdaFunctionGenerationStyle.class);

    public LambdaFunctionGenerationStyle(Function function, List list, LambdaType lambdaType, IBinding[] iBindingArray, LiteralInstruction[] literalInstructionArray) {
        super(function);
        this.m_paramInfo = list;
        this.m_lambdaType = lambdaType;
        this.m_bindings = iBindingArray;
        this.m_literalParameters = literalInstructionArray;
    }

    public void generateFunctionBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker) {
        Object object2;
        s_logger.debug("generateFunctionBODFlow m_function=" + this.m_function);
        TypeEnvironment typeEnvironment = this.prepareTypeEnvironment();
        Function function = this.m_function;
        String string = this.generateClassName(dataFlowCodeGenerationHelper);
        StringBuffer stringBuffer = new StringBuffer();
        FunctionInstantiation.generateParamSpecs(dataFlowCodeGenerationHelper, stringBuffer, codeGenerationTracker, this.m_lambdaType.getElementTypes(), this.m_bindings);
        this.generateFunctionHeader(dataFlowCodeGenerationHelper);
        String string2 = this.m_lambdaType.getImplementationName(dataFlowCodeGenerationHelper);
        dataFlowCodeGenerationHelper.append("final static class " + string + " extends " + string2 + " {\n" + "public " + this.m_lambdaType.getReturnType().getImplementationName(dataFlowCodeGenerationHelper) + " invoke(" + stringBuffer + ") {\n");
        function.switchOverTypeEnvironment(typeEnvironment);
        for (int i = 0; i < this.m_literalParameters.length; ++i) {
            if (this.m_literalParameters[i] == null) continue;
            codeGenerationTracker.registerExtantBinding(function.m_parameters[i], this.m_literalParameters[i].generateValue(dataFlowCodeGenerationHelper));
        }
        for (Object object2 : this.m_paramInfo) {
            codeGenerationTracker.registerExtantBinding((IBinding)object2, dataFlowCodeGenerationHelper.generateNewLocalVariableName(Binding.generateVariableName((IBinding)object2, dataFlowCodeGenerationHelper)));
        }
        this.generateProfileHitCode(dataFlowCodeGenerationHelper, codeGenerationTracker);
        dataFlowCodeGenerationHelper.m_mmh.generateFunctionEntry(dataFlowCodeGenerationHelper, codeGenerationTracker, function);
        object2 = function.getBody().generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, null, false);
        dataFlowCodeGenerationHelper.m_mmh.generateFunctionExit(dataFlowCodeGenerationHelper, codeGenerationTracker, function);
        this.generateProfileExitCode(dataFlowCodeGenerationHelper, codeGenerationTracker, (String)object2, false, null, null);
        dataFlowCodeGenerationHelper.append("return " + (String)object2 + ";\n}\n");
        ClosureGenerationUtilities.generateClosureSuffix(string, this.m_paramInfo, codeGenerationTracker, dataFlowCodeGenerationHelper);
        this.generateFunctionFooter(dataFlowCodeGenerationHelper);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        LambdaFunctionGenerationStyle lambdaFunctionGenerationStyle = (LambdaFunctionGenerationStyle)object;
        if (lambdaFunctionGenerationStyle.m_literalParameters.length != this.m_literalParameters.length) {
            return false;
        }
        for (int i = 0; i < this.m_literalParameters.length; ++i) {
            LiteralInstruction literalInstruction = this.m_literalParameters[i];
            LiteralInstruction literalInstruction2 = lambdaFunctionGenerationStyle.m_literalParameters[i];
            if (!(literalInstruction == null && literalInstruction2 != null || literalInstruction2 == null && literalInstruction != null) && literalInstruction2.equals(literalInstruction)) continue;
            return false;
        }
        return ((Object)lambdaFunctionGenerationStyle.m_paramInfo).equals(this.m_paramInfo) && lambdaFunctionGenerationStyle.m_lambdaType.equals(this.m_lambdaType);
    }

    public String generateClassName(CodeGeneration codeGeneration) {
        int n;
        Integer n2 = (Integer)codeGeneration.generationMemosGet(this.getSignature());
        if (n2 != null) {
            n = n2;
        } else {
            n = codeGeneration.generationMemosSize();
            codeGeneration.generationMemosPut(this.computeSignature(), new Integer(n));
        }
        return this.m_function.generateFunctionName(codeGeneration) + "$Lambda" + n;
    }

    public void generateFunction(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionList instructionList) {
        TypeEnvironment typeEnvironment = this.prepareTypeEnvironment();
        Function function = this.m_function;
        String string = bCELCodeGenerationHelper.getClassName() + "$" + this.generateClassName(bCELCodeGenerationHelper);
        Type[] typeArray = this.m_lambdaType.getElementTypes();
        com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = typeArray[i].getImplementationType(bCELCodeGenerationHelper);
        }
        String string2 = this.m_lambdaType.getImplementationName(bCELCodeGenerationHelper);
        ClassGenerationHelper classGenerationHelper = bCELCodeGenerationHelper.makeClassGenerationHelper(string, string2);
        com.ibm.xtq.bcel.generic.Type type = this.m_lambdaType.getReturnType().getImplementationType(bCELCodeGenerationHelper);
        MethodGen methodGen = new MethodGen(17, type, typeArray2, null, "invoke", classGenerationHelper.m_cg.getClassName(), instructionList, classGenerationHelper.m_cpg);
        function.switchOverTypeEnvironment(typeEnvironment);
        for (int i = 0; i < this.m_bindings.length; ++i) {
            if (this.m_bindings[i] == null) continue;
            int n = codeGenerationTracker.allocateRegister(typeArray2[i]);
            codeGenerationTracker.registerExtantBinding(this.m_bindings[i], n, this.m_bindings[i].getBindingType().getImplementationType(bCELCodeGenerationHelper));
        }
        ClosureGenerationUtilities.generateClosureSuffix(string, string2, this.m_paramInfo, codeGenerationTracker, bCELCodeGenerationHelper, classGenerationHelper);
        InstructionListBuilder instructionListBuilder = new InstructionListBuilder(bCELCodeGenerationHelper, instructionList, classGenerationHelper, methodGen);
        instructionListBuilder.useStaticThisField();
        function.getBody().generateCode(bCELCodeGenerationHelper, codeGenerationTracker, "function_retval", instructionList.append(InstructionConstants.NOP), instructionListBuilder);
        instructionListBuilder.appendReturn(type);
        bCELCodeGenerationHelper.addMethodToClass(methodGen, classGenerationHelper);
        bCELCodeGenerationHelper.completeClassGeneration(classGenerationHelper);
    }

    protected String computeSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.computeSignature());
        for (int i = 0; i < this.m_literalParameters.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(this.m_literalParameters[i]);
        }
        Iterator iterator = this.m_paramInfo.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(',');
            stringBuffer.append(((IBinding)iterator.next()).getBindingType());
        }
        stringBuffer.append(this.m_lambdaType.prettyPrint());
        return stringBuffer.toString();
    }
}

