/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.codegen.bcel;

import com.ibm.xtq.bcel.classfile.FieldOrMethod;
import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.bcel.classfile.Method;
import com.ibm.xtq.bcel.generic.ATHROW;
import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.BranchHandle;
import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.ClassGen;
import com.ibm.xtq.bcel.generic.CodeExceptionGen;
import com.ibm.xtq.bcel.generic.DLOAD;
import com.ibm.xtq.bcel.generic.DSTORE;
import com.ibm.xtq.bcel.generic.ExceptionThrower;
import com.ibm.xtq.bcel.generic.FieldGen;
import com.ibm.xtq.bcel.generic.GOTO;
import com.ibm.xtq.bcel.generic.IfInstruction;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.InstructionConstants;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.InstructionTargeter;
import com.ibm.xtq.bcel.generic.JsrInstruction;
import com.ibm.xtq.bcel.generic.LDC;
import com.ibm.xtq.bcel.generic.LLOAD;
import com.ibm.xtq.bcel.generic.LSTORE;
import com.ibm.xtq.bcel.generic.LocalVariableGen;
import com.ibm.xtq.bcel.generic.LocalVariableInstruction;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xtq.bcel.generic.RET;
import com.ibm.xtq.bcel.generic.ReferenceType;
import com.ibm.xtq.bcel.generic.ReturnInstruction;
import com.ibm.xtq.bcel.generic.Select;
import com.ibm.xtq.bcel.generic.StoreInstruction;
import com.ibm.xtq.bcel.generic.TargetLostException;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Type;
import com.ibm.xylem.codegen.CodeGenerationHelper;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.FunctionGenerationStyle;
import com.ibm.xylem.codegen.bcel.ClassCollector;
import com.ibm.xylem.codegen.bcel.ClassGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.Resource;
import com.ibm.xylem.codegen.bcel.StaticFieldPopulator;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.SlotType;
import com.ibm.xylem.utils.XylemError;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BCELCodeGenerationHelper
extends CodeGenerationHelper {
    static final Logger s_logger = Logger.getInstance(BCELCodeGenerationHelper.class);
    private static final boolean REALLOCATE_LOCALS = false;
    private static final int REALLOCATION_THRESHOLD = 100;
    private static final int METHOD_SIZE_LIMIT = 65535;
    private static final int MAX_BRANCH_TARGET_OFFSET = Short.MAX_VALUE;
    private static final int MIN_BRANCH_TARGET_OFFSET = Short.MIN_VALUE;
    public static final String s_partitionLabel = "P";
    private int m_staticMethodIndex = 0;
    private int m_memberIdentifiers = 0;
    private int m_functionCount = 0;
    private HashMap m_constants = new HashMap();
    public File m_basePath = null;
    protected FunctionGenerationStyle m_currentFGS;
    public String m_constantsClassPrefix = "";
    private String m_baseClassName;
    public ClassGenerationHelper m_cgh;
    protected InstructionListBuilder m_staticILB;
    protected InstructionListBuilder m_constructorILB;
    protected ClassGenerationHelper m_tlsCGH;
    protected int m_staticFieldCount = 0;
    private int m_constantClassIndex = 0;
    protected int m_innerClassCount = 0;
    public ClassCollector m_cc;
    private boolean m_autoSplitterInvoked = false;
    static final int s_indexMax = 4096;
    public static final ArrayType s_charArrayType = new ArrayType(BasicType.CHAR, 1);
    protected int m_staticStack = 0;
    protected HashMap m_externalizedStrings = new HashMap();
    private HashMap m_threadLocalVariables = new HashMap();
    private HashMap m_threadLocalVariableClassNames = new HashMap();
    static final int s_maxPoolSize = 4096;
    protected HashMap m_typedConstantPools = new HashMap();
    private ArrayList m_recyclableFields = new ArrayList();

    public BCELCodeGenerationHelper(String string, String string2, CodeGenerationSettings codeGenerationSettings, ClassCollector classCollector) {
        this.setSettings(codeGenerationSettings);
        this.setClassName(string);
        this.m_baseClassName = string2;
        this.m_constantsClassPrefix = this.getClassName() + "_";
        this.m_cgh = this.makeNewPartition();
        this.m_cc = classCollector;
        ClassGenerationHelper classGenerationHelper = this.makeNewPartition();
        this.m_staticILB = new InstructionListBuilder(this, new InstructionList(), classGenerationHelper);
        this.m_staticILB.setStaticContext();
        if (codeGenerationSettings.isThreadSafe()) {
            this.m_tlsCGH = this.makeClassGenerationHelper(this.m_constantsClassPrefix + "ThreadLocalVariables", null);
            this.m_tlsCGH.m_cg.setAccessFlags(17);
            this.m_constructorILB = new InstructionListBuilder(this, new InstructionList(), this.m_tlsCGH);
        } else {
            this.m_constructorILB = new InstructionListBuilder(this, new InstructionList(), classGenerationHelper);
        }
    }

    public void addMethodToClass(MethodGen methodGen, ClassGenerationHelper classGenerationHelper) {
        methodGen.removeNOPs();
        methodGen.setMaxStack(512);
        methodGen.setMaxLocals();
        InstructionList instructionList = methodGen.getInstructionList();
        InstructionHandle instructionHandle = instructionList.getEnd();
        instructionList.setPositions();
        int n = instructionHandle.getPosition() + instructionHandle.getInstruction().getLength();
        if (n > Short.MAX_VALUE && n < 65535) {
            this.widenConditionalBranchTargetOffsets(instructionList);
        }
        Method method = methodGen.getMethod();
        this.traceMethod(methodGen, method);
        classGenerationHelper.m_cg.addMethod(method);
    }

    private boolean widenConditionalBranchTargetOffsets(InstructionList instructionList) {
        Instruction instruction;
        InstructionHandle instructionHandle;
        boolean bl = false;
        int n = 0;
        block7: for (instructionHandle = instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            switch (instruction.getOpcode()) {
                case 167: 
                case 168: {
                    n += 2;
                    continue block7;
                }
                case 170: 
                case 171: {
                    n += 3;
                    continue block7;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    n += 5;
                }
            }
        }
        for (instructionHandle = instructionList.getStart(); instructionHandle != null; instructionHandle = instructionHandle.getNext()) {
            instruction = instructionHandle.getInstruction();
            if (!(instruction instanceof IfInstruction)) continue;
            IfInstruction ifInstruction = (IfInstruction)instruction;
            BranchHandle branchHandle = (BranchHandle)instructionHandle;
            InstructionHandle instructionHandle2 = ifInstruction.getTarget();
            int n2 = instructionHandle2.getPosition() - branchHandle.getPosition();
            if (n2 - n >= Short.MIN_VALUE && n2 + n <= Short.MAX_VALUE) continue;
            InstructionHandle instructionHandle3 = branchHandle.getNext();
            IfInstruction ifInstruction2 = ifInstruction.negate();
            BranchHandle branchHandle2 = instructionList.append((InstructionHandle)branchHandle, ifInstruction2);
            BranchHandle branchHandle3 = instructionList.append((InstructionHandle)branchHandle2, new GOTO(instructionHandle2));
            if (instructionHandle3 == null) {
                instructionHandle3 = instructionList.append((InstructionHandle)branchHandle3, InstructionConstants.NOP);
            }
            branchHandle2.updateTarget(instructionHandle2, instructionHandle3);
            if (branchHandle.hasTargeters()) {
                InstructionTargeter[] instructionTargeterArray = branchHandle.getTargeters();
                for (int i = 0; i < instructionTargeterArray.length; ++i) {
                    InstructionTargeter instructionTargeter = instructionTargeterArray[i];
                    if (instructionTargeter instanceof LocalVariableGen) {
                        LocalVariableGen localVariableGen = (LocalVariableGen)instructionTargeter;
                        if (localVariableGen.getStart() == branchHandle) {
                            localVariableGen.setStart(branchHandle2);
                            continue;
                        }
                        if (localVariableGen.getEnd() != branchHandle) continue;
                        localVariableGen.setEnd(branchHandle3);
                        continue;
                    }
                    instructionTargeter.updateTarget(branchHandle, branchHandle2);
                }
            }
            try {
                instructionList.delete(branchHandle);
            }
            catch (TargetLostException targetLostException) {
                String string = "An instruction that was part of a block of byte code that was outlined is still referred to in the original method.";
                throw new XylemError("ERR_SYSTEM", string);
            }
            instructionHandle = branchHandle3;
            bl = true;
        }
        return bl;
    }

    private static void reallocateLocals(MethodGen methodGen) {
        int n = BCELCodeGenerationHelper.calculateParamSize(methodGen);
        int n2 = BCELCodeGenerationHelper.calculateNumLocals(methodGen, n);
        if (n2 < 100) {
            methodGen.setMaxLocals(Math.max(n2 + n, n));
        } else {
            int n3;
            FlowGraph flowGraph = BCELCodeGenerationHelper.buildFlowGraph(methodGen, n);
            BCELCodeGenerationHelper.determineLiveVariableRanges(flowGraph);
            int[] nArray = new int[flowGraph.numLocals];
            int[] nArray2 = new int[flowGraph.numLocals];
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < flowGraph.numLocals; ++n3) {
                if (flowGraph.doubleMap.get(n3)) {
                    nArray2[n5++] = n3++;
                    continue;
                }
                nArray[n4++] = n3;
            }
            BCELCodeGenerationHelper.buildInterferenceGraph(nArray2, n5, flowGraph);
            BCELCodeGenerationHelper.buildInterferenceGraph(nArray, n4, flowGraph);
            BCELCodeGenerationHelper.colourInterferenceGraph(nArray2, n5, flowGraph, true);
            BCELCodeGenerationHelper.colourInterferenceGraph(nArray, n4, flowGraph, false);
            BCELCodeGenerationHelper.rewriteMethod(flowGraph, methodGen, n);
            n3 = flowGraph.numDoubles * 2 + flowGraph.numSingles;
            methodGen.setMaxLocals(n + n3);
        }
    }

    private static int calculateParamSize(MethodGen methodGen) {
        com.ibm.xtq.bcel.generic.Type[] typeArray = methodGen.getArgumentTypes();
        int n = methodGen.isStatic() ? 0 : 1;
        for (int i = 0; i < typeArray.length; ++i) {
            n += typeArray[i].getSize();
        }
        return n;
    }

    private static int calculateNumLocals(MethodGen methodGen, int n) {
        InstructionList instructionList = methodGen.getInstructionList();
        int n2 = -1;
        for (InstructionHandle instructionHandle = instructionList.getEnd(); instructionHandle != null; instructionHandle = instructionHandle.getPrev()) {
            Instruction instruction;
            Instruction instruction2 = instructionHandle.getInstruction();
            if (instruction2 instanceof LocalVariableInstruction) {
                instruction = (LocalVariableInstruction)instruction2;
                if (((LocalVariableInstruction)instruction).getIndex() < n2) continue;
                n2 = ((LocalVariableInstruction)instruction).getIndex();
                if (instruction2 instanceof DLOAD || instruction2 instanceof LLOAD || instruction2 instanceof DSTORE || instruction2 instanceof LSTORE) {
                    ++n2;
                }
                if (n2 - n + 1 < 100) continue;
                return 100;
            }
            if (!(instruction2 instanceof RET)) continue;
            instruction = (RET)instruction2;
            if (((RET)instruction).getIndex() >= n2) {
                n2 = ((RET)instruction).getIndex();
            }
            if (n2 - n + 1 < 100) continue;
            return 100;
        }
        return n2 - n + 1;
    }

    private static FlowGraph buildFlowGraph(MethodGen methodGen, int n) {
        Object object;
        int n2;
        Object object2;
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.numLocals = 100;
        InstructionList instructionList = methodGen.getInstructionList();
        flowGraph.positionalMap = new Block[instructionList.getEnd().getPosition() + 1];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n3 = -1;
        int n4 = -1;
        Block block = null;
        Block block2 = null;
        for (object2 = instructionList.getStart(); object2 != null; object2 = ((InstructionHandle)object2).getNext()) {
            LocalVariableInstruction localVariableInstruction;
            int n5;
            n4 = ((InstructionHandle)object2).getPosition();
            if (((InstructionHandle)object2).hasTargeters()) {
                InstructionTargeter[] instructionTargeterArray = ((InstructionHandle)object2).getTargeters();
                boolean bl = false;
                for (int i = 0; i < instructionTargeterArray.length; ++i) {
                    if (!(instructionTargeterArray[i] instanceof BranchInstruction) && (!(instructionTargeterArray[i] instanceof CodeExceptionGen) || ((CodeExceptionGen)instructionTargeterArray[i]).getHandlerPC().getPosition() != ((InstructionHandle)object2).getPosition())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    if (block != null) {
                        block.setEndOffset(n3);
                        block.addFollowerOffset(n4);
                        block2 = block;
                    }
                    block = null;
                }
            }
            if (block == null) {
                if (flowGraph.positionalMap[n4] == null) {
                    flowGraph.positionalMap[n4] = new Block(n4);
                }
                block = flowGraph.positionalMap[n4];
                if (block2 != null) {
                    block2.next = block;
                }
            }
            n2 = 0;
            object = ((InstructionHandle)object2).getInstruction();
            if (object instanceof InstructionTargeter) {
                n2 = 1;
                if (object instanceof Select) {
                    InstructionHandle[] instructionHandleArray = ((Select)object).getTargets();
                    for (int i = 0; i < instructionHandleArray.length; ++i) {
                        block.addFollowerOffset(instructionHandleArray[i].getPosition());
                    }
                    block.addFollowerOffset(((Select)object).getTarget().getPosition());
                } else if (object instanceof BranchInstruction) {
                    block.addFollowerOffset(((BranchInstruction)object).getTarget().getPosition());
                } else {
                    throw new RuntimeException("Unknown InstructionTargeter instruction");
                }
                if (object instanceof IfInstruction) {
                    block.addFollowerOffset(((InstructionHandle)object2).getNext().getPosition());
                } else if (object instanceof JsrInstruction) {
                    arrayList.add(new Integer(((InstructionHandle)object2).getNext().getPosition()));
                }
            } else if (object instanceof RET) {
                n2 = 1;
                arrayList2.add(new Integer(n4));
                RET rET = (RET)object;
                int n6 = rET.getIndex() - n;
                if (n6 >= 0) {
                    if (!block.isVarLive(n6)) {
                        block.addToLoadSet(n6);
                    }
                    if (n6 >= flowGraph.numLocals) {
                        flowGraph.numLocals = n6 + 1;
                    }
                }
            } else if (object instanceof ReturnInstruction || object instanceof ATHROW) {
                n2 = 1;
            } else if (object instanceof LocalVariableInstruction && (n5 = (localVariableInstruction = (LocalVariableInstruction)object).getIndex() - n) >= 0) {
                if (!block.isVarLive(n5)) {
                    if (localVariableInstruction instanceof StoreInstruction) {
                        block.addToStoreSet(n5);
                    } else {
                        block.addToLoadSet(n5);
                    }
                }
                if (object instanceof DLOAD || object instanceof LLOAD) {
                    flowGraph.doubleMap.set(n5);
                    if (block.storeSet.get(n5 + 1)) {
                        block.addToStoreSet(n5);
                    } else {
                        block.addToLoadSet(n5);
                        block.addToLoadSet(n5 + 1);
                    }
                } else if (object instanceof DSTORE || object instanceof LSTORE) {
                    flowGraph.doubleMap.set(n5);
                    if (block.loadSet.get(n5 + 1)) {
                        block.addToLoadSet(n5);
                    } else {
                        block.addToStoreSet(n5);
                        block.addToStoreSet(n5 + 1);
                    }
                }
                if (n5 >= flowGraph.numLocals - 1) {
                    flowGraph.numLocals = n5 + 1;
                    if (flowGraph.doubleMap.get(n5)) {
                        ++flowGraph.numLocals;
                    }
                }
            }
            if (object instanceof ExceptionThrower) {
                Class[] classArray = ((ExceptionThrower)object).getExceptions();
                CodeExceptionGen[] codeExceptionGenArray = methodGen.getExceptionHandlers();
                for (int i = 0; i < codeExceptionGenArray.length; ++i) {
                    if (n4 < codeExceptionGenArray[i].getStartPC().getPosition() || n4 > codeExceptionGenArray[i].getEndPC().getPosition()) continue;
                    boolean bl = false;
                    ObjectType objectType = codeExceptionGenArray[i].getCatchType();
                    if (objectType == null) {
                        bl = true;
                    } else {
                        for (int j = 0; j < classArray.length; ++j) {
                            try {
                                if (!Class.forName(objectType.getClassName()).isAssignableFrom(classArray[j])) continue;
                                bl = true;
                                break;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new RuntimeException(classNotFoundException.toString());
                            }
                        }
                    }
                    if (!bl) continue;
                    block.addFollowerOffset(codeExceptionGenArray[i].getHandlerPC().getPosition());
                    n2 = 1;
                }
                if (n2 != 0 && !(object instanceof ATHROW) && !(object instanceof ReturnInstruction)) {
                    block.addFollowerOffset(((InstructionHandle)object2).getNext().getPosition());
                }
            }
            if (n2 != 0) {
                block.setEndOffset(n4);
                block2 = block;
                block = null;
            }
            n3 = n4;
        }
        if (block != null) {
            block.setEndOffset(n4);
        }
        object2 = arrayList2.iterator();
        while (object2.hasNext()) {
            n2 = (Integer)object2.next();
            object = arrayList.iterator();
            while (object.hasNext()) {
                int n7 = (Integer)object.next();
                flowGraph.positionalMap[n2].addFollowerOffset(n7);
            }
        }
        flowGraph.entryBlock = flowGraph.positionalMap[0];
        flowGraph.replacementMap = new int[flowGraph.numLocals];
        for (n2 = 0; n2 < flowGraph.numLocals; ++n2) {
            flowGraph.replacementMap[n2] = -1;
        }
        flowGraph.adjacencyMatrix = new boolean[flowGraph.numLocals][flowGraph.numLocals];
        return flowGraph;
    }

    private static void determineLiveVariableRanges(FlowGraph flowGraph) {
        boolean bl = true;
        while (bl) {
            bl = false;
            Block block = flowGraph.entryBlock;
            while (block != null) {
                Object object;
                block.outSet = new BitSet();
                Iterator iterator = block.followerOffsets.iterator();
                while (iterator.hasNext()) {
                    object = flowGraph.positionalMap[(Integer)iterator.next()];
                    block.outSet.or(((Block)object).inSet);
                }
                block.liveSet.or(block.outSet);
                object = new BitSet();
                ((BitSet)object).or(block.outSet);
                ((BitSet)object).andNot(block.storeSet);
                ((BitSet)object).or(block.loadSet);
                if (!((BitSet)object).equals(block.inSet)) {
                    bl = true;
                    block.inSet = object;
                }
                block = block.next;
            }
        }
    }

    private static void buildInterferenceGraph(int[] nArray, int n, FlowGraph flowGraph) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            Block block = flowGraph.entryBlock;
            while (block != null) {
                if (block.isVarLive(n2)) {
                    for (int j = i + 1; j < n; ++j) {
                        int n3 = nArray[j];
                        if (!block.isVarLive(n3)) continue;
                        flowGraph.adjacencyMatrix[n3][n2] = true;
                    }
                }
                block = block.next;
            }
        }
    }

    private static void colourInterferenceGraph(int[] nArray, int n, FlowGraph flowGraph, boolean bl) {
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            BitSet bitSet = new BitSet(bl ? flowGraph.numDoubles : flowGraph.numSingles);
            for (n3 = 0; n3 < i; ++n3) {
                if (!flowGraph.adjacencyMatrix[nArray[i]][nArray[n3]] || (n2 = flowGraph.replacementMap[nArray[n3]]) < 0) continue;
                bitSet.set(n2);
            }
            for (n3 = i + 1; n3 < n; ++n3) {
                if (!flowGraph.adjacencyMatrix[nArray[n3]][nArray[i]] || (n2 = flowGraph.replacementMap[nArray[n3]]) < 0) continue;
                bitSet.set(n2);
            }
            n3 = 0;
            while (bitSet.get(n3)) {
                ++n3;
            }
            flowGraph.replacementMap[nArray[i]] = n3;
            if (bl) {
                if (n3 <= flowGraph.numDoubles - 1) continue;
                flowGraph.numDoubles = n3 + 1;
                continue;
            }
            if (n3 <= flowGraph.numSingles - 1) continue;
            flowGraph.numSingles = n3 + 1;
        }
    }

    private static void rewriteMethod(FlowGraph flowGraph, MethodGen methodGen, int n) {
        InstructionHandle instructionHandle = methodGen.getInstructionList().getStart();
        Block block = flowGraph.entryBlock;
        while (block != null) {
            while (instructionHandle != null && instructionHandle.getPosition() >= block.startOffset && instructionHandle.getPosition() <= block.endOffset) {
                int n2;
                int n3;
                int n4;
                Instruction instruction;
                Instruction instruction2 = instructionHandle.getInstruction();
                if (instruction2 instanceof LocalVariableInstruction) {
                    instruction = (LocalVariableInstruction)instruction2;
                    n4 = ((LocalVariableInstruction)instruction).getIndex();
                    n3 = n4 - n;
                    if (n3 >= 0 && (n2 = BCELCodeGenerationHelper.getReplacement(n3, flowGraph, n)) != n4) {
                        ((LocalVariableInstruction)instruction).setIndex(n2);
                    }
                } else if (instruction2 instanceof RET && (n3 = (n4 = ((RET)(instruction = (RET)instruction2)).getIndex()) - n) >= 0 && (n2 = BCELCodeGenerationHelper.getReplacement(n3, flowGraph, n)) != n4) {
                    ((RET)instruction).setIndex(n2);
                }
                instructionHandle = instructionHandle.getNext();
            }
            block = block.next;
        }
    }

    private static int getReplacement(int n, FlowGraph flowGraph, int n2) {
        int n3 = flowGraph.replacementMap[n] == -1 ? (flowGraph.doubleMap.get(n - 1) ? flowGraph.numSingles + n2 + flowGraph.replacementMap[n - 1] * 2 + 1 : n + n2) : (flowGraph.doubleMap.get(n) ? flowGraph.numSingles + n2 + flowGraph.replacementMap[n] * 2 : n2 + flowGraph.replacementMap[n]);
        return n3;
    }

    public com.ibm.xtq.bcel.generic.Type[] makeBCELTypeArray(IBinding[] iBindingArray) {
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[iBindingArray.length];
        for (int i = 0; i < iBindingArray.length; ++i) {
            typeArray[i] = iBindingArray[i].getBindingType().getImplementationType(this);
        }
        return typeArray;
    }

    public ClassGenerationHelper makeNewPartition() {
        ClassGenerationHelper classGenerationHelper = this.makeClassGenerationHelper(this.m_constantsClassPrefix + s_partitionLabel + this.m_constantClassIndex, this.m_constantsClassPrefix + s_partitionLabel + (this.m_constantClassIndex + 1));
        classGenerationHelper.m_cg.setAccessFlags(1057);
        ++this.m_constantClassIndex;
        return classGenerationHelper;
    }

    public String generateInnerClassName() {
        return this.getClassName() + "$" + ++this.m_innerClassCount;
    }

    public ClassGenerationHelper makeClassGenerationHelper(String string, String string2) {
        return new ClassGenerationHelper(new ClassGen(string, string2 == null ? "java.lang.Object" : string2, "<generated>", 33, null));
    }

    public ClassGenerationHelper makeClassGenerationHelperForInterface(String string, String string2) {
        ClassGenerationHelper classGenerationHelper = new ClassGenerationHelper(new ClassGen(string, "java.lang.Object", "<generated>", 33, null));
        classGenerationHelper.m_cg.addInterface(string2);
        return classGenerationHelper;
    }

    public void completeClassGeneration(final ClassGenerationHelper classGenerationHelper) {
        JavaClass javaClass = (JavaClass)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classGenerationHelper.m_cg.getJavaClass();
            }
        });
        this.m_cc.acceptGeneratedClass(javaClass);
    }

    public ClassGenerationHelper startFunctionGeneration() {
        if (this.m_cgh.m_cpg.getSize() > 32768 || this.m_functionCount >= this.getSettings().getMaxFunctionsPerPartition()) {
            this.m_functionCount = 0;
            this.m_cgh.addDefaultConstructor(this, null);
            this.completeClassGeneration(this.m_cgh);
            this.m_cgh = this.makeNewPartition();
        } else {
            ++this.m_functionCount;
        }
        return this.m_cgh;
    }

    public void finish() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        this.generateLambdaTypes();
        this.generateSlotTypes();
        this.m_cgh.addDefaultConstructor(this, null);
        this.completeClassGeneration(this.m_cgh);
        this.checkForStaticFlush(true);
        ClassGenerationHelper classGenerationHelper = this.makeClassGenerationHelper(this.m_constantsClassPrefix + s_partitionLabel + this.m_constantClassIndex, this.m_baseClassName);
        classGenerationHelper.m_cg.setAccessFlags(1057);
        classGenerationHelper.addDefaultConstructor(this, null);
        this.completeClassGeneration(classGenerationHelper);
        ClassGenerationHelper classGenerationHelper2 = this.makeClassGenerationHelper(this.getClassName(), this.m_constantsClassPrefix + s_partitionLabel + "0");
        classGenerationHelper2.m_cg.setAccessFlags(1057);
        this.generateRecycleMethod(classGenerationHelper2);
        if (this.getSettings().isThreadSafe()) {
            object4 = this.makeClassGenerationHelper(this.m_constantsClassPrefix + "ThreadLocal", ThreadLocal.class.getName());
            ((ClassGenerationHelper)object4).m_cg.setAccessFlags(49);
            ((ClassGenerationHelper)object4).addDefaultConstructor(this, null);
            serializable = new InstructionList();
            object3 = new InstructionListBuilder(this, (InstructionList)serializable, (ClassGenerationHelper)object4);
            object2 = new MethodGen(4, BasicType.OBJECT, BasicType.NO_ARGS, null, "initialValue", ((ClassGenerationHelper)object4).m_cg.getClassName(), (InstructionList)serializable, ((ClassGenerationHelper)object4).m_cpg);
            ((InstructionListBuilder)object3).appendNewAndInvokeConstructor(this.m_tlsCGH.m_cg.getClassName());
            ((InstructionListBuilder)object3).appendAReturn();
            this.addMethodToClass((MethodGen)object2, (ClassGenerationHelper)object4);
            this.completeClassGeneration((ClassGenerationHelper)object4);
            object = new FieldGen(1, new ObjectType(ThreadLocal.class.getName()), "m_tls", classGenerationHelper2.m_cpg);
            classGenerationHelper2.m_cg.addField(((FieldGen)object).getField());
            ((InstructionList)serializable).dispose();
            object3 = new InstructionListBuilder(this, (InstructionList)serializable, classGenerationHelper2);
            ((InstructionListBuilder)object3).appendALoad(0);
            ((InstructionListBuilder)object3).appendNewAndInvokeConstructor(((ClassGenerationHelper)object4).m_cg.getClassName());
            ((InstructionListBuilder)object3).appendPutField((com.ibm.xtq.bcel.generic.Type)new ObjectType(ThreadLocal.class.getName()), "m_tls", classGenerationHelper2.m_cg.getClassName());
            classGenerationHelper2.addDefaultConstructor(this, (InstructionList)serializable);
            this.m_tlsCGH.addDefaultConstructor(this, this.m_constructorILB.m_il);
            this.completeClassGeneration(this.m_tlsCGH);
        } else {
            classGenerationHelper2.addDefaultConstructor(this, null);
        }
        object4 = new InstructionList();
        serializable = new MethodGen(8, BasicType.VOID, BasicType.NO_ARGS, null, "<clinit>", this.getClassName(), (InstructionList)object4, classGenerationHelper2.m_cpg);
        if (this.m_externalizedStrings.size() > 0) {
            object3 = this.getClassName() + "_strings";
            object2 = new ByteArrayOutputStream();
            try {
                object = new DataOutputStream((OutputStream)object2);
                ((DataOutputStream)object).writeInt(this.m_externalizedStrings.size());
                for (Map.Entry entry : this.m_externalizedStrings.entrySet()) {
                    ((DataOutputStream)object).writeUTF((String)entry.getKey());
                    String[] stringArray = (String[])entry.getValue();
                    ((DataOutputStream)object).writeUTF(stringArray[0]);
                    ((DataOutputStream)object).writeUTF(stringArray[1]);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.m_cc.acceptGeneratedResource(new Resource((ByteArrayOutputStream)object2, (String)object3){
                final /* synthetic */ ByteArrayOutputStream val$baos;
                final /* synthetic */ String val$resourceName;
                {
                    this.val$baos = byteArrayOutputStream;
                    this.val$resourceName = string;
                }

                public void dump(OutputStream outputStream) throws IOException {
                    outputStream.write(this.val$baos.toByteArray());
                }

                public String getName() {
                    return this.val$resourceName;
                }
            });
            ((InstructionList)object4).append(new LDC(classGenerationHelper2.m_cpg.addString(this.getClassName())));
            ((InstructionList)object4).append(classGenerationHelper2.m_if.createInvoke(Class.class.getName(), "forName", new ObjectType(Class.class.getName()), new com.ibm.xtq.bcel.generic.Type[]{BasicType.STRING}, (short)184));
            ((InstructionList)object4).append(classGenerationHelper2.m_if.createInvoke(StaticFieldPopulator.class.getName(), "populateStaticFields", BasicType.VOID, new com.ibm.xtq.bcel.generic.Type[]{new ObjectType(Class.class.getName())}, (short)184));
        }
        int n = this.m_staticMethodIndex;
        for (int i = 0; i < n; ++i) {
            ((InstructionList)object4).append(classGenerationHelper2.m_if.createInvoke(this.getClassName(), "__xylem_initStatic" + (this.m_staticMethodIndex - n + i), BasicType.VOID, BasicType.NO_ARGS, (short)184));
        }
        ((InstructionList)object4).append(InstructionConstants.RETURN);
        this.addMethodToClass((MethodGen)serializable, classGenerationHelper2);
        ((InstructionList)object4).dispose();
        this.completeClassGeneration(classGenerationHelper2);
    }

    private void traceMethod(MethodGen methodGen, Method method) {
        int n = method.getCode().getLength();
        if (n > 65535 - this.getSettings().getReservedBytes()) {
            if (!this.getSettings().getBCELAutoSplitFunctions()) {
                s_logger.error("Method " + methodGen.getName() + " in class " + methodGen.getClassName() + " has size " + n);
            }
            throw new BCELFunctionSizeException(n);
        }
        if (this.getSettings().isByteCodeLineNumbers()) {
            methodGen.getMethod();
            InstructionList instructionList = methodGen.getInstructionList();
            int[] nArray = instructionList.getInstructionPositions();
            InstructionHandle[] instructionHandleArray = instructionList.getInstructionHandles();
            for (int i = 0; i < nArray.length; ++i) {
                methodGen.addLineNumber(instructionHandleArray[i], nArray[i]);
            }
        }
    }

    public void reallyTraceMethod(MethodGen methodGen) {
        Serializable serializable;
        try {
            serializable = methodGen.getMethod();
            System.out.println(((FieldOrMethod)serializable).getName() + "---");
            System.out.println(((Method)serializable).getCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        methodGen.getMethod();
        serializable = methodGen.getInstructionList();
        int[] nArray = ((InstructionList)serializable).getInstructionPositions();
        InstructionHandle[] instructionHandleArray = ((InstructionList)serializable).getInstructionHandles();
        for (int i = 0; i < nArray.length; ++i) {
            methodGen.addLineNumber(instructionHandleArray[i], nArray[i]);
        }
    }

    public String generateNewMemberVariableName(Object object) {
        if (object == null) {
            return this.generateNewMemberVariableName();
        }
        String string = object.toString();
        return "m" + ++this.m_memberIdentifiers + "_" + string.replace('-', '_').replace('.', '_');
    }

    public String generateNewMemberVariableName() {
        return "m" + ++this.m_memberIdentifiers;
    }

    public void startFunction(FunctionGenerationStyle functionGenerationStyle) {
        this.m_currentFGS = functionGenerationStyle;
    }

    public String getCurrentFunction() {
        return this.m_currentFGS == null ? null : this.m_currentFGS.getFunction().getName();
    }

    public FunctionGenerationStyle getCurrentFunctionGenerationStyle() {
        return this.m_currentFGS;
    }

    public void endFunction() {
        this.m_currentFGS = null;
    }

    protected void flushFunctions() {
        this.m_functionCount = 0;
        ++this.m_constantClassIndex;
    }

    protected void checkForStaticFlush(boolean bl) {
        if (!bl && this.m_staticILB.m_il.getLength() < 4096 && this.m_staticILB.m_cgh.m_cpg.getSize() < 60000) {
            return;
        }
        InstructionList instructionList = this.m_staticILB.getInstructionList();
        ClassGenerationHelper classGenerationHelper = this.m_staticILB.getClassGenerationHelper();
        String string = classGenerationHelper.m_cg.getClassName();
        MethodGen methodGen = new MethodGen(8, BasicType.VOID, BasicType.NO_ARGS, null, "__xylem_initStatic" + this.m_staticMethodIndex, string, instructionList, classGenerationHelper.m_cpg);
        this.m_staticILB.appendReturn();
        this.addMethodToClass(methodGen, classGenerationHelper);
        instructionList.dispose();
        ++this.m_staticMethodIndex;
        classGenerationHelper.addDefaultConstructor(this, this.getSettings().isThreadSafe() ? null : this.m_constructorILB.getInstructionList());
        this.completeClassGeneration(classGenerationHelper);
        if (!bl) {
            classGenerationHelper = this.makeNewPartition();
            if (!this.getSettings().isThreadSafe()) {
                this.m_constructorILB = new InstructionListBuilder(this, new InstructionList(), classGenerationHelper);
            }
        }
        if (bl) {
            this.m_staticILB = null;
        } else {
            this.m_staticILB = new InstructionListBuilder(this, instructionList, classGenerationHelper);
            this.m_staticILB.setStaticContext();
        }
    }

    public void generateLambdaTypes() {
        Iterator iterator = this.lambdaTypeGenerationRequestsIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LambdaType lambdaType = this.lambdaTypeGenerationRequestsGet(string);
            ClassGenerationHelper classGenerationHelper = this.makeClassGenerationHelper(this.getClassName() + "$" + string, null);
            classGenerationHelper.m_cg.setAccessFlags(1033);
            Type[] typeArray = lambdaType.getElementTypes();
            com.ibm.xtq.bcel.generic.Type[] typeArray2 = new com.ibm.xtq.bcel.generic.Type[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                typeArray2[i] = typeArray[i].getImplementationType(this);
            }
            InstructionList instructionList = new InstructionList();
            MethodGen methodGen = new MethodGen(1, com.ibm.xtq.bcel.generic.Type.VOID, BasicType.NO_ARGS, null, "<init>", string, instructionList, classGenerationHelper.m_cpg);
            instructionList.append(InstructionFactory.createLoad(com.ibm.xtq.bcel.generic.Type.OBJECT, 0));
            instructionList.append(classGenerationHelper.m_if.createInvoke("java.lang.Object", "<init>", com.ibm.xtq.bcel.generic.Type.VOID, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)183));
            instructionList.append(InstructionFactory.createReturn(com.ibm.xtq.bcel.generic.Type.VOID));
            this.addMethodToClass(methodGen, classGenerationHelper);
            instructionList.dispose();
            methodGen = new MethodGen(1025, lambdaType.getReturnType().getImplementationType(this), typeArray2, null, "invoke", string, instructionList, classGenerationHelper.m_cpg);
            classGenerationHelper.m_cg.addMethod(methodGen.getMethod());
            this.completeClassGeneration(classGenerationHelper);
        }
    }

    public final void generateSlotTypes() {
        Iterator iterator = this.slotTypeGenerationRequestsIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SlotType slotType = this.slotTypeGenerationRequestsGet(string);
            ClassGenerationHelper classGenerationHelper = this.makeClassGenerationHelper(this.getClassName() + "$" + string, null);
            classGenerationHelper.m_cg.setAccessFlags(9);
            Type type = slotType.getElementType();
            com.ibm.xtq.bcel.generic.Type type2 = type.getImplementationType(this);
            InstructionList instructionList = new InstructionList();
            MethodGen methodGen = new MethodGen(1, com.ibm.xtq.bcel.generic.Type.VOID, new com.ibm.xtq.bcel.generic.Type[]{type2}, null, "<init>", string, instructionList, classGenerationHelper.m_cpg);
            instructionList.append(InstructionFactory.createLoad(com.ibm.xtq.bcel.generic.Type.OBJECT, 0));
            instructionList.append(classGenerationHelper.m_if.createInvoke("java.lang.Object", "<init>", com.ibm.xtq.bcel.generic.Type.VOID, com.ibm.xtq.bcel.generic.Type.NO_ARGS, (short)183));
            instructionList.append(InstructionFactory.createLoad(com.ibm.xtq.bcel.generic.Type.OBJECT, 0));
            instructionList.append(InstructionFactory.createLoad(type2, 1));
            instructionList.append(classGenerationHelper.m_if.createPutField(this.getClassName() + "$" + string, "m_value", type2));
            instructionList.append(InstructionFactory.createReturn(com.ibm.xtq.bcel.generic.Type.VOID));
            this.addMethodToClass(methodGen, classGenerationHelper);
            instructionList.dispose();
            FieldGen fieldGen = new FieldGen(1, type2, "m_value", classGenerationHelper.m_cpg);
            classGenerationHelper.m_cg.addField(fieldGen.getField());
            this.completeClassGeneration(classGenerationHelper);
        }
    }

    public boolean insertConstant(String string, com.ibm.xtq.bcel.generic.Type type, InstructionListBuilder instructionListBuilder) {
        String[] stringArray = (String[])this.m_constants.get(string);
        if (stringArray == null) {
            return false;
        }
        instructionListBuilder.appendGetStatic(stringArray[0], stringArray[1], type);
        return true;
    }

    public InstructionListBuilder startConstantGeneration() {
        ++this.m_staticStack;
        return this.m_staticILB;
    }

    public void finishConstantGeneration(String string, com.ibm.xtq.bcel.generic.Type type, InstructionListBuilder instructionListBuilder) {
        String string2 = "s_" + this.generateNewMemberVariableName();
        FieldGen fieldGen = new FieldGen(9, type, string2, this.m_staticILB.m_cgh.m_cpg);
        this.m_staticILB.m_cgh.m_cg.addField(fieldGen.getField());
        String string3 = this.m_staticILB.m_cgh.m_cg.getClassName();
        this.m_staticILB.appendPutStatic(string3, string2, type);
        if (string != null) {
            this.m_constants.put(string, new String[]{string3, string2});
        }
        instructionListBuilder.appendGetStatic(string3, string2, type);
        --this.m_staticStack;
        if (this.m_staticStack == 0) {
            this.checkForStaticFlush(false);
        }
    }

    public InstructionHandle appendExternalizedStringConstant(String string, InstructionListBuilder instructionListBuilder) {
        Object object;
        String[] stringArray = (String[])this.m_externalizedStrings.get(string);
        if (stringArray == null) {
            object = this.m_staticILB.m_cgh.m_cg.getClassName();
            String string2 = "s_" + this.generateNewMemberVariableName();
            FieldGen fieldGen = new FieldGen(9, BasicType.STRING, string2, this.m_staticILB.m_cgh.m_cpg);
            this.m_staticILB.m_cgh.m_cg.addField(fieldGen.getField());
            stringArray = new String[]{object, string2};
            this.m_externalizedStrings.put(string, stringArray);
        }
        object = instructionListBuilder.appendGetStatic(stringArray[0], stringArray[1], BasicType.STRING);
        if (this.m_staticStack == 0) {
            this.checkForStaticFlush(false);
        }
        return object;
    }

    public void allocateThreadLocalVariable(String string, com.ibm.xtq.bcel.generic.Type type, boolean bl) {
        if (!this.m_threadLocalVariables.containsKey(string)) {
            this.m_threadLocalVariables.put(string, type);
            ClassGenerationHelper classGenerationHelper = this.m_tlsCGH == null ? this.m_staticILB.getClassGenerationHelper() : this.m_tlsCGH;
            this.m_threadLocalVariableClassNames.put(string, classGenerationHelper.m_cg.getClassName());
            String string2 = "m_tls_" + string;
            classGenerationHelper.m_cg.addField(new FieldGen(1, type, string2, classGenerationHelper.m_cpg).getField());
            if (bl) {
                this.m_recyclableFields.add(new Object[]{string, type});
            }
        }
    }

    public InstructionHandle generateThreadLocalVarGet(InstructionListBuilder instructionListBuilder, String string) {
        com.ibm.xtq.bcel.generic.Type type = (com.ibm.xtq.bcel.generic.Type)this.m_threadLocalVariables.get(string);
        String string2 = (String)this.m_threadLocalVariableClassNames.get(string);
        String string3 = "m_tls_" + string;
        InstructionHandle instructionHandle = this.generateThreadLocalVarStartPut(instructionListBuilder);
        instructionListBuilder.appendGetField(string2, string3, type);
        return instructionHandle;
    }

    public InstructionHandle generateThreadLocalVarStartPut(InstructionListBuilder instructionListBuilder) {
        if (this.getSettings().isThreadSafe() && instructionListBuilder != this.m_constructorILB) {
            InstructionHandle instructionHandle = instructionListBuilder.appendGetField("m_tls", new ObjectType(ThreadLocal.class.getName()));
            instructionListBuilder.appendInvokeMethod(ThreadLocal.class.getName(), "get", BasicType.OBJECT);
            instructionListBuilder.appendCast(BasicType.OBJECT, new ObjectType(this.m_tlsCGH.m_cg.getClassName()));
            return instructionHandle;
        }
        return instructionListBuilder.appendThis();
    }

    public void generateThreadLocalVarFinishPut(InstructionListBuilder instructionListBuilder, String string) {
        com.ibm.xtq.bcel.generic.Type type = (com.ibm.xtq.bcel.generic.Type)this.m_threadLocalVariables.get(string);
        String string2 = (String)this.m_threadLocalVariableClassNames.get(string);
        String string3 = "m_tls_" + string;
        instructionListBuilder.appendPutField(type, string3, string2);
    }

    public DataFlowCodeGenerationHelper.ConstantEntry addConstantElement(String string, Type type) {
        return this.getConstantPool(type).addEntries(new String[]{string});
    }

    public String getConstantPoolName(Type type) {
        return this.getConstantPool((Type)type).m_name;
    }

    private TypedConstantPool getConstantPool(Type type) {
        TypedConstantPool typedConstantPool = (TypedConstantPool)this.m_typedConstantPools.get(type);
        if (typedConstantPool == null) {
            if (type == CharType.s_charType) {
                typedConstantPool = new CharConstantPool();
                this.m_typedConstantPools.put(type, typedConstantPool);
            } else {
                typedConstantPool = new TypedConstantPool();
                this.m_typedConstantPools.put(type, typedConstantPool);
            }
        }
        return typedConstantPool;
    }

    public int getConstantClassIndex() {
        return this.m_constantClassIndex;
    }

    public String getConstantsClassPrefix() {
        return this.m_constantsClassPrefix;
    }

    public InstructionListBuilder getConstructorILB() {
        return this.m_constructorILB;
    }

    public boolean getAutoSplitterInvoked() {
        return this.m_autoSplitterInvoked;
    }

    public void setAutoSplitterInvoked(boolean bl) {
        this.m_autoSplitterInvoked = bl;
    }

    public void generateRecycleMethod(ClassGenerationHelper classGenerationHelper) {
        InstructionList instructionList = new InstructionList();
        String string = this.getClassName();
        MethodGen methodGen = new MethodGen(1, BasicType.VOID, BasicType.NO_ARGS, null, "recycle", string, instructionList, classGenerationHelper.m_cpg);
        InstructionListBuilder instructionListBuilder = new InstructionListBuilder(this, instructionList, classGenerationHelper);
        for (Object[] objectArray : this.m_recyclableFields) {
            String string2 = (String)objectArray[0];
            com.ibm.xtq.bcel.generic.Type type = (com.ibm.xtq.bcel.generic.Type)objectArray[1];
            this.generateThreadLocalVarStartPut(instructionListBuilder);
            if (type instanceof ReferenceType) {
                instructionListBuilder.appendNull();
            } else if (type.equals(BasicType.DOUBLE)) {
                instructionListBuilder.appendConstant(0.0);
            } else if (type.equals(BasicType.LONG)) {
                instructionListBuilder.appendConstant(0.0);
            } else if (type.equals(BasicType.FLOAT)) {
                instructionListBuilder.appendConstant(0.0);
            } else {
                instructionListBuilder.appendConstant(0);
            }
            this.generateThreadLocalVarFinishPut(instructionListBuilder, string2);
        }
        instructionList.append(InstructionFactory.createReturn(BasicType.VOID));
        this.addMethodToClass(methodGen, classGenerationHelper);
        instructionList.dispose();
    }

    public static class BCELFunctionSizeException
    extends RuntimeException {
        public int size;

        BCELFunctionSizeException(int n) {
            this.size = n;
        }
    }

    private static class Block {
        static final int UNKNOWN_OFFSET = -1;
        BitSet loadSet = new BitSet();
        BitSet storeSet = new BitSet();
        BitSet liveSet = new BitSet();
        BitSet inSet = new BitSet();
        BitSet outSet = new BitSet();
        int startOffset;
        int endOffset = -1;
        Block next;
        Set followerOffsets = new TreeSet();

        Block(int n) {
            this.startOffset = n;
        }

        void setEndOffset(int n) {
            this.endOffset = n;
        }

        void addFollowerOffset(int n) {
            this.followerOffsets.add(new Integer(n));
        }

        void addToStoreSet(int n) {
            this.storeSet.set(n);
            this.liveSet.set(n);
        }

        void addToLoadSet(int n) {
            this.loadSet.set(n);
            this.liveSet.set(n);
        }

        boolean isVarLive(int n) {
            return this.liveSet.get(n);
        }
    }

    class CharConstantPool
    extends TypedConstantPool {
        CharConstantPool() {
        }

        int addEntry(String string) {
            this.m_buffer.append(string.substring(1, string.length() - 1));
            return this.m_entries++;
        }
    }

    private static class FlowGraph {
        Block entryBlock;
        Block[] positionalMap;
        int numSingles;
        int numDoubles;
        int numLocals;
        int[] replacementMap;
        BitSet doubleMap = new BitSet();
        boolean[][] adjacencyMatrix;

        private FlowGraph() {
        }
    }

    class TypedConstantPool {
        ArrayList m_pastBuffers = new ArrayList();
        StringBuffer m_buffer = new StringBuffer();
        int m_entries = 0;
        String m_name = BCELCodeGenerationHelper.this.generateNewMemberVariableName("pool");
        int m_poolIndex = 0;
        HashMap m_cache = new HashMap();

        TypedConstantPool() {
        }

        DataFlowCodeGenerationHelper.ConstantEntry addEntries(String[] stringArray) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length + this.m_entries > 4096) {
                ++this.m_poolIndex;
                this.m_entries = 0;
                this.m_pastBuffers.add(this.m_buffer);
                this.m_buffer = new StringBuffer();
            }
            if (this.m_cache.containsKey(stringBuffer.toString())) {
                return (DataFlowCodeGenerationHelper.ConstantEntry)this.m_cache.get(stringBuffer.toString());
            }
            n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = this.addEntry(stringArray[i]);
                if (n != -1) continue;
                n = n2;
            }
            DataFlowCodeGenerationHelper.ConstantEntry constantEntry = new DataFlowCodeGenerationHelper.ConstantEntry(this.m_name + this.m_poolIndex, n);
            this.m_cache.put(stringBuffer.toString(), constantEntry);
            return constantEntry;
        }

        int addEntry(String string) {
            this.m_buffer.append(string);
            this.m_buffer.append(',');
            if (this.m_entries % 100 == 0) {
                this.m_buffer.append('\n');
            }
            return this.m_entries++;
        }
    }
}

