/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.commandline;

import com.ibm.xylem.AbstractTypeStore;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.codegen.JavaC;
import com.ibm.xylem.codegen.JavaCSettings;
import com.ibm.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xylem.commandline.SearchPathSourceResolver;
import com.ibm.xylem.drivers.Linker;
import com.ibm.xylem.optimizers.VDTMapOptimizer;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.parser.ParserSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class XylemC
extends CommandLineParserSingleInputFile {
    static final Logger s_logger;
    public static XylemC XYLEMC;
    public ArrayList m_files = new ArrayList();
    int m_dumpLevel = 0;
    boolean m_compileOnly = false;
    String m_packageName = null;
    boolean m_javac = true;
    protected File m_outputDir = new File(".");
    boolean m_isPerf = false;
    public int m_optimizationLevel;
    protected ModuleSignatureStore m_mss;
    protected ArrayList m_filesToLink = new ArrayList();

    protected int parseOption(String[] stringArray, int n) {
        if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
            System.out.println("Usage: XylemC [-disablejavac] [-c] [-O] [-O2] [-I searchpath] [-package packagename] [-output dirname] (file.xylem | file.xylemi)*");
            System.out.println(" -d/--dump to dump final xylem, twice (-d -d) to also dump intermediate xylem");
            return -1;
        }
        if ("-c".equals(stringArray[n])) {
            this.m_compileOnly = true;
            return n;
        }
        if ("-d".equals(stringArray[n]) || "--dump".equals(stringArray[n])) {
            ++this.m_dumpLevel;
            return n;
        }
        if ("-javac".equals(stringArray[n]) || "--javac".equals(stringArray[n])) {
            s_logger.info("-javac is now the default; use -disablejavac to prevent classfile generation");
            return n;
        }
        if ("-disablejavac".equals(stringArray[n]) || "--disablejavac".equals(stringArray[n])) {
            this.m_javac = false;
            return n;
        }
        if ("-perf".equals(stringArray[n]) || "--perf".equals(stringArray[n])) {
            this.m_isPerf = true;
            return n;
        }
        if ("-package".equals(stringArray[n]) || "--package".equals(stringArray[n])) {
            if (++n == stringArray.length) {
                s_logger.error("-package missing parameter");
                return -1;
            }
            this.m_packageName = stringArray[n];
            return n;
        }
        if ("-output".equals(stringArray[n]) || "--output".equals(stringArray[n])) {
            if (++n == stringArray.length) {
                s_logger.error("-output missing parameter");
                return -1;
            }
            this.m_outputDir = new File(stringArray[n]);
            if (!this.m_outputDir.exists() || !this.m_outputDir.isDirectory()) {
                s_logger.error("Directory " + this.m_outputDir + " does not exist");
                return -1;
            }
            return n;
        }
        if ("-I".equals(stringArray[n])) {
            if (++n == stringArray.length) {
                s_logger.error("-I missing parameter");
                return -1;
            }
            for (String string : XylemC.separatePath(stringArray[n])) {
                File file = new File(string);
                if (!file.exists() || !file.isDirectory()) {
                    s_logger.warn("Directory " + string + " not found; ignoring");
                    continue;
                }
                try {
                    this.m_signatureSearchPath.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            return n;
        }
        if ("-O".equals(stringArray[n])) {
            this.m_optimizationLevel = 1;
            return n;
        }
        if ("-O2".equals(stringArray[n])) {
            this.m_optimizationLevel = 2;
            return n;
        }
        this.m_inputFile = this.validateInputFilename(stringArray[n], false);
        if (this.m_inputFile == null) {
            return -1;
        }
        this.m_files.add(this.m_inputFile);
        return n;
    }

    public static void main(String[] stringArray) {
        new XylemC(stringArray);
    }

    public XylemC(String[] stringArray) {
        this.init(stringArray);
        this.run();
    }

    private XylemC() {
    }

    public void init(String[] stringArray) {
        if (!this.parseCommandLine(stringArray)) {
            return;
        }
        try {
            this.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        this.m_mss = new ModuleSignatureStore(this.m_signatureSearchPath);
    }

    public void run() {
        for (Serializable serializable : this.m_files) {
            this.m_signatureSearchPath.addFirst(serializable);
            this.handleFile((URL)serializable, this.m_optimizationLevel);
            this.m_signatureSearchPath.removeFirst();
        }
        if (!this.m_compileOnly && !this.m_filesToLink.isEmpty()) {
            Serializable serializable;
            serializable = this.link(this.m_filesToLink, this.m_mss, null, null, this.m_packageName, this.m_outputDir, this.m_isPerf);
            if (serializable == null) {
                System.exit(-1);
            } else {
                JavaC.compile(((File)serializable).getParentFile(), new String[]{((File)serializable).getName()}, this.m_outputDir, null, new JavaCSettings());
            }
        }
    }

    protected void handleFile(URL uRL, int n) {
        String string = uRL.toString();
        if (string.endsWith(".xylem")) {
            Object object;
            String string2;
            Object object2;
            ModuleSignature moduleSignature = null;
            try {
                object2 = uRL.getPath();
                moduleSignature = this.m_mss.resolveModuleSignature(((String)object2).substring(0, ((String)object2).length() - 6));
            }
            catch (Exception exception) {
                s_logger.error("Error reading compiled interface file", exception);
                System.exit(-1);
            }
            object2 = null;
            try {
                object2 = this.compile(uRL, moduleSignature, this.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.error("Error occurred during compilation of " + uRL, exception);
                System.exit(-1);
            }
            if (((AbstractTypeStore)object2).getName().equals("")) {
                string2 = uRL.getPath();
                string2 = string2.substring(string2.lastIndexOf("/") + 1);
                string2 = string2.substring(0, string2.lastIndexOf(".xylem"));
                ((AbstractTypeStore)object2).setName(string2);
            }
            string2 = ((AbstractTypeStore)object2).getName() + ".cxo";
            try {
                object = new File(string2);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object));
                Module.writeModule(objectOutputStream, (Module)object2);
                objectOutputStream.flush();
                objectOutputStream.close();
                this.m_filesToLink.add(((File)object).toURL());
            }
            catch (Exception exception) {
                s_logger.error("Error occurred writing of compiled module to " + string2, exception);
                System.exit(-1);
            }
            object = ModuleSignatureStore.makeFilename(((AbstractTypeStore)object2).getName()) + ".cxi";
            XylemC.writeOutSignature(((Module)object2).m_signature, (String)object);
        } else if (string.endsWith(".xylemi")) {
            ModuleSignature moduleSignature = null;
            try {
                moduleSignature = XylemC.compileSignature(uRL, this.m_signatureSearchPath, this.m_mss);
            }
            catch (Exception exception) {
                s_logger.error("Error occurred during compilation of signature " + uRL, exception);
                System.exit(-1);
            }
            String string3 = ModuleSignatureStore.makeFilename(moduleSignature.getName()) + ".cxi";
            XylemC.writeOutSignature(moduleSignature, string3);
        } else if (string.endsWith(".cxo")) {
            this.m_filesToLink.add(uRL);
        } else {
            s_logger.warn("Ignoring file with unrecognized extension: " + uRL);
        }
    }

    public File link(List list, ModuleSignatureStore moduleSignatureStore, Collection collection, String string, String string2, File file, boolean bl) {
        Linker linker = new Linker();
        if (this.m_dumpLevel >= 1) {
            linker.m_dumpXylem = true;
        }
        if (this.m_dumpLevel >= 2) {
            linker.m_dumpIntermediateXylem = true;
        }
        linker.m_mss = moduleSignatureStore;
        linker.m_outputDir = file;
        linker.m_isPerf = bl;
        return linker.linkFiles(list, string, string2, collection, this.m_optimizationLevel);
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.error("Error occurred writing of compiled signature to " + string, exception);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string, File file) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(file, string)));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.error("Error occurred writing of compiled signature to " + string, exception);
            System.exit(-1);
        }
    }

    public static final ModuleSignature compileSignature(URL uRL, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        Parser parser = new Parser(new SearchPathSourceResolver(list), parserSource, moduleSignatureStore);
        return XylemC.compileSignature(uRL, parser);
    }

    public static final ModuleSignature compileSignature(URL uRL, Parser parser) throws Exception {
        ParserSource parserSource = new ParserSource(uRL);
        ModuleSignature moduleSignature = parser.parseExternalModuleSignature(parserSource);
        return moduleSignature;
    }

    public Module compile(URL uRL, ModuleSignature moduleSignature, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        return this.compile(moduleSignature, new Parser(new SearchPathSourceResolver(list), new ParserSource(uRL), moduleSignatureStore));
    }

    public Module compile(ModuleSignature moduleSignature, Parser parser) throws Exception {
        Module module = parser.parseModule(moduleSignature);
        if (moduleSignature == null) {
            module.exportAllSymbols();
        }
        module.typeCheck();
        if (moduleSignature == null) {
            for (String string : new HashSet(module.m_signature.m_functionSignatures.keySet())) {
                module.m_signature.addFunctionSignature(new FunctionSignature(module.getFunction(string)));
            }
        }
        module.reduce();
        if (module.getVDTMap() != null) {
            Object object = new VDTMapOptimizer(module.getVDTMap());
            module.optimize((Optimizer)object);
            ((VDTMapOptimizer)object).doUpdate(module);
            object = null;
        }
        return module;
    }

    static {
        LogManager.initializeLogger();
        s_logger = Logger.getInstance(XylemC.class);
        XYLEMC = new XylemC();
    }
}

