/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.commandline;

import com.ibm.xylem.Function;
import com.ibm.xylem.IContext;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleImportDirective;
import com.ibm.xylem.ModuleLinker;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.Program;
import com.ibm.xylem.commandline.XylemC;
import com.ibm.xylem.instructions.EvalInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.utils.XylemError;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class XylemInterpreter
extends XylemC {
    protected boolean m_debugger;
    protected String m_function;
    protected ArrayList m_args;

    public XylemInterpreter(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        new XylemInterpreter(stringArray);
    }

    public void init(String[] stringArray) {
        this.m_function = "main";
        this.m_args = new ArrayList();
        this.m_debugger = false;
        super.init(stringArray);
    }

    public Module compile(ModuleSignature moduleSignature, Parser parser) throws Exception {
        return super.compile(moduleSignature, parser);
    }

    protected int parseOption(String[] stringArray, int n) {
        if (stringArray[n].equals("-debug")) {
            this.m_debugger = true;
            return n;
        }
        if (stringArray[n].equals("-function")) {
            this.m_function = stringArray[++n];
            return n;
        }
        if (stringArray[n].equals("-arg")) {
            String string;
            if ((string = stringArray[++n]).equals("{")) {
                StringBuffer stringBuffer = new StringBuffer();
                while (!stringArray[++n].equals("}")) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append(" ");
                }
                string = stringBuffer.toString();
            }
            this.m_args.add(string);
            return n;
        }
        if (stringArray[n].equals("-help") || stringArray[n].equals("-?") || stringArray[n].equals("-h")) {
            System.out.println("Usage: XylemInterpreter [-debug] [-function main] ([-arg {script}])* (file.xylem | file.xylemi | file.cxo)*");
            return -1;
        }
        return super.parseOption(stringArray, n);
    }

    public void run() {
        for (URL uRL : this.m_files) {
            this.m_signatureSearchPath.addFirst(uRL);
            this.handleFile(uRL, this.m_optimizationLevel);
            this.m_signatureSearchPath.removeFirst();
        }
        this.evaluate();
    }

    public void evaluate() {
        Object object;
        Module module4;
        Module module2;
        Serializable serializable2;
        Module module3 = null;
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (Serializable serializable2 : this.m_filesToLink) {
            try {
                module2 = Module.loadCompiled((URL)serializable2, this.m_mss);
                if (module2 instanceof Program) {
                    module3 = (Program)module2;
                    continue;
                }
                linkedList.add(module2);
            }
            catch (Exception exception) {
                s_logger.error("!", exception);
                throw new Error();
            }
        }
        if (module3 == null) {
            serializable2 = new ModuleSignature("");
            module3 = new Program((ModuleSignature)serializable2);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            module3.addModule((Module)iterator.next());
        }
        try {
            module3.typeCheckReduced();
        }
        catch (Exception exception) {
            s_logger.error("!", exception);
            throw new Error(exception.getMessage());
        }
        Program.dumpXylemFile(module3, null, "program-preflatten");
        ModuleLinker.reflattenModules((Program)module3);
        Program.dumpXylemFile(module3, null, "program-postflatten");
        serializable2 = null;
        module2 = null;
        for (Module module4 : module3.getModules()) {
            s_logger.info("checking " + module4.getName());
            if (serializable2 != null || (serializable2 = module3.getFunction(ModuleImportDirective.translateFunctionName(this.m_function, module4))) == null) continue;
            module2 = module4;
        }
        module4 = null;
        if (serializable2 == null) {
            Program.dumpXylemFile(module3, null, "program");
            throw new XylemError("ERR_SYSTEM", "function '" + this.m_function + "' not found");
        }
        try {
            module3.exportAllSymbols();
            module3.clearTypeInformation(true);
            module3.typeCheckReduced();
            module3.removeDeadFunctions();
            module3.instantiateReducedPolymorphicFunctions();
            module3.removeDeadFunctions();
            new PolymorphicADTDesugarer(module3).desugar();
            object = ((Function)serializable2).getName();
            ((Program)module3).setClassName((String)object);
            module3.removeDeadFunctions();
            module3.typeCheckReduced();
            ((Function)serializable2).typeCheckReduced(module3, new LinkedList());
        }
        catch (Exception exception) {
            Program.dumpXylemFile(module3, null, "program");
            s_logger.error("error typechecking module", exception);
            throw new XylemError("ERR_SYSTEM", "!");
        }
        object = null;
        Environment environment = new Environment();
        if (this.m_debugger) {
            object = new Debugger(module3);
            object.enterContext((IContext)((Object)serializable2));
        }
        if (this.m_args.size() != ((Function)serializable2).m_parameters.length) {
            throw new XylemError("ERR_SYSTEM", "Wrong number of args for " + ((Function)serializable2).getName() + ", " + "got " + this.m_args.size() + ", need " + ((Function)serializable2).m_parameters.length);
        }
        for (int i = 0; i < ((Function)serializable2).m_parameters.length; ++i) {
            EvalInstruction evalInstruction = new EvalInstruction(((Function)serializable2).m_parameters[i].getBindingType(), (String)this.m_args.get(i));
            Object object2 = ((Instruction)evalInstruction).evaluate(environment, (Function)serializable2, (IDebuggerInterceptor)object, false);
            environment.bind(((Function)serializable2).m_parameters[i], ((Instruction)evalInstruction).evaluate(environment, (Function)serializable2, (IDebuggerInterceptor)object, false));
        }
        Object object3 = ((Function)serializable2).getBody().evaluate(environment, (Function)serializable2, (IDebuggerInterceptor)object, false);
        if (this.m_debugger) {
            object.leaveContext((IContext)((Object)serializable2), object3);
        } else {
            System.out.println("result = " + object3);
        }
    }
}

