/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingDependencyInfo;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IMatchDestructable;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.ConventionalGenerationState;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.GenerationState;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.StreamInADTOptimizedGenerationState;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class IdentifierInstruction
extends Instruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction,
IMatchDestructable {
    private Object m_variable;
    private IBinding m_binding;
    private static final Logger s_logger = Logger.getInstance(IdentifierInstruction.class);

    public IdentifierInstruction() {
    }

    public IdentifierInstruction(Object object) {
        if (object == null || object instanceof Instruction || object instanceof Binding) {
            throw new IllegalArgumentException("" + object);
        }
        this.m_variable = object;
        if (null == this.m_variable) {
            throw new Error("II.<init>: null m_variable");
        }
    }

    public IdentifierInstruction(BindingEnvironment bindingEnvironment, IBinding iBinding) {
        this.m_variable = iBinding.getName();
        try {
            this.typeCheckKnownBinding(bindingEnvironment, iBinding);
        }
        catch (TypeCheckException typeCheckException) {
            throw new XylemError("ERR_SYSTEM", "Type Check Exception: " + typeCheckException);
        }
    }

    public Object getVariable() {
        return this.m_variable;
    }

    public IBinding getBinding() {
        return this.m_binding;
    }

    public IBinding getBinding(BindingEnvironment bindingEnvironment) {
        return bindingEnvironment.getVariableBinding(this.m_variable);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_binding = bindingEnvironment.getVariableBinding(this.m_variable);
        if (this.m_binding == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Unbound variable: " + this.m_variable), this);
        }
        return this.setCachedType(this.m_binding.getBindingType());
    }

    private Type typeCheckKnownBinding(BindingEnvironment bindingEnvironment, IBinding iBinding) throws TypeCheckException {
        super.doDefaultTypeCheck(null, bindingEnvironment, new LinkedList());
        this.m_binding = iBinding;
        return this.setCachedType(this.m_binding.getBindingType());
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (bindingEnvironment == null) {
            throw new XylemError("ERR_SYSTEM", "no binding environment: " + this.m_variable + " " + this.m_variable.getClass());
        }
        IBinding iBinding = bindingEnvironment.getVariableBinding(this.m_variable);
        if (iBinding == null) {
            throw new XylemError("ERR_SYSTEM", "cannot find binding: " + this.m_variable + " " + this.m_variable.getClass());
        }
        Type type = iBinding.getBindingType(typeEnvironment, bindingEnvironment);
        if (type == null) {
            throw new XylemError("ERR_SYSTEM", "ii:" + this);
        }
        return type;
    }

    public Instruction cloneWithoutTypeInformation() {
        return new IdentifierInstruction(this.m_variable);
    }

    public void clearTypeInformation() {
        super.clearTypeInformation();
        this.m_binding = null;
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        IBinding iBinding;
        IBinding iBinding2 = iBinding = bindingEnvironment != null ? this.getBinding(bindingEnvironment) : this.getBinding();
        if (iBinding == null) {
            throw new XylemError("ERR_SYSTEM", "no binding for " + this);
        }
        if (iBinding.getLet() == null || !(iBinding.getLet().getValue() instanceof LiteralInstruction)) {
            set.add(iBinding);
        }
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        IBinding iBinding = bindingEnvironment != null ? this.getBinding(bindingEnvironment) : this.getBinding();
        set.add(iBinding);
        if (iBinding == null) {
            System.out.println(":" + this.m_variable + ": bound to null");
        }
    }

    public void dump(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.space();
        prettyPrinter.print(this.m_variable);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IdentifierInstruction)) {
            return false;
        }
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)object;
        if (!this.m_variable.equals(identifierInstruction.m_variable)) {
            return false;
        }
        return this.getBinding() == identifierInstruction.getBinding();
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        return codeGenerationTracker.generateConventionally(this, dataFlowCodeGenerationHelper, bl);
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this, bCELCodeGenerationHelper, instructionHandle, instructionListBuilder);
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        GenerationState generationState = codeGenerationTracker.getGenerationState(this.getBinding(codeGenerationTracker.m_bindingEnvironment));
        if (generationState instanceof StreamInADTOptimizedGenerationState || ((ConventionalGenerationState)generationState).getNumDependencies() != 1 || !((ConventionalGenerationState)generationState).getInstruction().supportsCodeGenerationOptimization(StreamInADTOptimizationStyle.s_streamInADTOptimizationStyle, codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment)) {
            throw new UnsupportedOperationException();
        }
        Instruction instruction = ((ConventionalGenerationState)generationState).getInstruction();
        ((IStreamInADTOptimizationInstruction)((Object)instruction)).generateCode(bCELCodeGenerationHelper, nArray, binding, codeGenerationTracker, bl, instructionHandle, instructionListBuilder);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        return codeGenerationTracker.generateAddToStreamInADT(this, string, binding, dataFlowCodeGenerationHelper, bl2);
    }

    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        codeGenerationTracker.generateAddToStream(this, string, (StreamType)codeGenerationTracker.resolveType(this), dataFlowCodeGenerationHelper, bl);
    }

    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        codeGenerationTracker.generateAddToStream(this, nArray, instructionListBuilder, (StreamType)codeGenerationTracker.resolveType(this), bCELCodeGenerationHelper, instructionHandle);
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, Instruction instruction, int n, BindingEnvironment bindingEnvironment) {
        ArrayList<BindingDependencyInfo> arrayList;
        if (bindingEnvironment == null && (bindingEnvironment = this.getBindingEnvironment()) == null) {
            throw new XylemError("ERR_SYSTEM", "???" + this);
        }
        IBinding iBinding = this.getBinding();
        if (iBinding == null) {
            iBinding = bindingEnvironment.getVariableBinding(this.m_variable);
        }
        if (bindingArray != null) {
            boolean bl = false;
            for (int i = 0; i < bindingArray.length; ++i) {
                if (bindingArray[i] != iBinding) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        if ((arrayList = (ArrayList<BindingDependencyInfo>)hashMap.get(iBinding)) == null) {
            arrayList = new ArrayList<BindingDependencyInfo>();
            hashMap.put(iBinding, arrayList);
        }
        arrayList.add(new BindingDependencyInfo(this, instruction, n));
    }

    public void determineDataDependencies(Set set) {
        set.add(this.m_variable);
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        IBinding iBinding = reductionHelper.lookupConvertedBinding(this.getBinding());
        this.m_binding = null;
        this.m_variable = iBinding.getName();
        if (this.m_variable == null) {
            throw new Error("generateReduced: null m_variable");
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            IBinding iBinding = this.getBinding(bindingEnvironment);
            if (null == iBinding) {
                s_logger.debug("II(): this=" + this + "\n  Null binding for " + this.m_variable + "\n  in " + bindingEnvironment);
                throw new Error("null binding (" + this.m_variable + ") exception...");
            }
            if (iBinding.getLet() == null) {
                return false;
            }
            return iBinding.getLet().getValue().supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        if (codeGenerationOptimizationStyle instanceof StreamInADTOptimizationStyle) {
            IBinding iBinding = this.getBinding(bindingEnvironment);
            if (null == iBinding) {
                s_logger.debug("II(): this=" + this + "\n  Null binding for " + this.m_variable + "\n  in " + bindingEnvironment);
                throw new Error("null binding (" + this.m_variable + ") exception...");
            }
            if (iBinding.getLet() == null) {
                return false;
            }
            return iBinding.getLet().getValue().supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        return false;
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printIdentifier(this.m_variable, n);
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        if (null != iDebuggerInterceptor && iDebuggerInterceptor.getVerbosityLevel() == 0) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        IBinding iBinding = this.m_binding == null ? this.getBinding(function.getBindingEnvironment()) : this.m_binding;
        Object object2 = object = environment.lookupBinding(iBinding);
        if (null != iDebuggerInterceptor && iDebuggerInterceptor.getVerbosityLevel() == 0) {
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
        }
        return object2;
    }

    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        IBinding iBinding;
        IBinding iBinding2 = iBinding = bindingEnvironment == null ? this.getBinding() : this.getBinding(bindingEnvironment);
        if (iBinding != null) {
            return iBinding.getLet() != null && iBinding.getLet().getValue().isStatic(bindingEnvironment);
        }
        return false;
    }

    public Instruction replaceBindings(Map map) {
        Object v = map.get(this.m_variable);
        if (v != null) {
            return new IdentifierInstruction(v);
        }
        return this;
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Instruction instruction = (Instruction)map.get(this.m_variable);
        if (instruction != null) {
            return instruction;
        }
        return this;
    }

    public Instruction cloneShallow() {
        return this;
    }

    public Instruction removeAliases(HashMap hashMap) {
        Object v = hashMap.get(this.m_variable);
        if (v != null) {
            return new IdentifierInstruction(v);
        }
        return this;
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_variable = readObjectFileHelper.readBindingName();
        if (null == this.m_variable) {
            throw new Error("read: null m_variable");
        }
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeBindingName(this.m_variable);
    }

    public Type typeCheckDestruction(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) throws TypeCheckException {
        Object object = this.getVariable();
        IBinding iBinding = bindingEnvironment.getVariableBinding(object);
        if (iBinding == null) {
            TypeVariable typeVariable = new TypeVariable();
            this.m_binding = new Binding(object, typeVariable);
            bindingEnvironment.setVariableBinding(this.m_binding);
            return typeVariable;
        }
        this.m_bindingEnvironment = bindingEnvironment;
        this.m_binding = iBinding;
        return iBinding.getBindingType();
    }

    public Instruction desugarDestruction(Instruction instruction, ReductionHelper reductionHelper, IMatchDestructable.Generator generator, IMatchDestructable.Generator generator2, BindingEnvironment bindingEnvironment) {
        if (this.m_bindingEnvironment != null) {
            IBinding iBinding = reductionHelper.lookupConvertedBinding(this.getBinding());
            Object object = reductionHelper.generateReducedIdentifier("");
            LetInstruction letInstruction = new LetInstruction(object, new DeepEqualityInstruction(instruction, new IdentifierInstruction(iBinding.getName())), new ChooseInstruction(new IdentifierInstruction(object), generator.generate(), generator2.generate()));
            return letInstruction;
        }
        Object object = reductionHelper.generateReducedIdentifier(this.getVariable());
        LetInstruction letInstruction = new LetInstruction(object, instruction, null);
        reductionHelper.registerConvertedBinding(this.m_binding, letInstruction);
        bindingEnvironment.setVariableBinding(letInstruction);
        letInstruction.setBody(generator.generate());
        return letInstruction;
    }

    public Instruction cloneReduced() {
        return this;
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

