/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.GenerationState;
import com.ibm.xylem.codegen.ILazyStreamFixedIndexOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.LazyAdditionGenerationState;
import com.ibm.xylem.codegen.LazyStreamFixedIndexGenerationState;
import com.ibm.xylem.codegen.StreamInADTOptimizationStyle;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.LazyStream;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.LazyStreamType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class LazyStreamElementInstruction
extends Instruction
implements ISpecialForm,
IStreamOptimizationInstruction,
IStreamInADTOptimizationInstruction,
IBinding {
    protected Instruction m_source;
    protected Instruction m_index;
    protected Instruction m_body;
    protected Instruction m_otherwise;
    protected Object m_var;
    protected Type m_elementType = new TypeVariable();

    public LazyStreamElementInstruction() {
    }

    public LazyStreamElementInstruction(Instruction instruction, Instruction instruction2, Object object, Instruction instruction3, Instruction instruction4) {
        this.m_source = instruction;
        this.m_index = instruction2;
        this.m_var = object;
        this.m_body = instruction3;
        this.m_otherwise = instruction4;
    }

    public Instruction getIndex() {
        return this.m_index;
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        ReductionHelper reductionHelper2;
        this.m_source = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_source, bindingEnvironment);
        this.m_index = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_index, bindingEnvironment);
        if (this.m_otherwise != null) {
            reductionHelper2 = (ReductionHelper)reductionHelper.clone();
            this.m_otherwise = reductionHelper2.reduce(this.m_otherwise, bindingEnvironment);
        }
        reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        reductionHelper2.upgradeBinding(this);
        bindingEnvironment.setVariableBinding(this);
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = this;
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        bindingEnvironment.setVariableBinding(this);
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
        try {
            typeEnvironment.unify(this.m_source.getType(typeEnvironment, bindingEnvironment), new LazyStreamType(this.m_elementType), this);
        }
        catch (TypeCheckException typeCheckException) {
            typeCheckException.printStackTrace();
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        return new LazyStreamElementInstruction(this.m_source.cloneWithoutTypeInformation(), this.m_index.cloneWithoutTypeInformation(), this.m_var, this.m_body.cloneWithoutTypeInformation(), this.m_otherwise.cloneWithoutTypeInformation());
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(this.m_source.typeCheck(typeEnvironment, bindingEnvironment, linkedList), new LazyStreamType(this.m_elementType), this);
        typeEnvironment.unify(this.m_index.typeCheck(typeEnvironment, bindingEnvironment, linkedList), IntType.s_intType, this);
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        bindingEnvironment2.setVariableBinding(this);
        Type type = this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
        if (this.m_otherwise != null) {
            typeEnvironment.unify(type, this.m_otherwise.typeCheck(typeEnvironment, new BindingEnvironment(bindingEnvironment), linkedList), this);
        }
        return this.setCachedType(type);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        return this.generateCodeBasedOnDataFlowInternal(dataFlowCodeGenerationHelper, codeGenerationTracker, string, bl, null, false, null);
    }

    protected String generateCodeBasedOnDataFlowInternal(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl, String string2, boolean bl2, Binding binding) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string3 = codeGenerationTracker.generateConventionally(this.m_index, dataFlowCodeGenerationHelper);
        IdentifierInstruction identifierInstruction = (IdentifierInstruction)this.m_source;
        IBinding iBinding = identifierInstruction.getBinding(codeGenerationTracker.m_bindingEnvironment);
        GenerationState generationState = codeGenerationTracker.getGenerationState(iBinding);
        if (generationState == null) {
            throw new RuntimeException();
        }
        String string4 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = this.m_elementType.resolveType(typeEnvironment);
        Type type2 = codeGenerationTracker.resolveType(this);
        if (generationState instanceof LazyStreamFixedIndexGenerationState) {
            ILazyStreamFixedIndexOptimizationInstruction iLazyStreamFixedIndexOptimizationInstruction = (ILazyStreamFixedIndexOptimizationInstruction)((Object)iBinding.getLet().getValue());
            LazyStreamFixedIndexGenerationState lazyStreamFixedIndexGenerationState = (LazyStreamFixedIndexGenerationState)generationState;
            String string5 = iLazyStreamFixedIndexOptimizationInstruction.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, null, lazyStreamFixedIndexGenerationState.getIndex());
            type2.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string4, bl2, binding, codeGenerationTracker);
            dataFlowCodeGenerationHelper.append("if (" + string5 + "__completed) {\n");
            CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
            String string6 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(Binding.generateVariableName(this, dataFlowCodeGenerationHelper));
            String string7 = dataFlowCodeGenerationHelper.m_finalKeyword + " " + type.getImplementationName(dataFlowCodeGenerationHelper) + " " + string6 + " = " + string5 + ";\n";
            codeGenerationTracker2.registerBinding((IBinding)this, new LazyAdditionGenerationState((IBinding)this, string6, string7));
            String string8 = binding == null ? this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, bl) : ((IStreamInADTOptimizationInstruction)((Object)this.m_body)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string2, binding, codeGenerationTracker2, bl2, bl);
            type2.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string4, string8, bl2, binding, codeGenerationTracker2);
            dataFlowCodeGenerationHelper.append("} else {\n");
            if (this.m_otherwise == null) {
                dataFlowCodeGenerationHelper.append("throw new RuntimeException(\"index out of bounds on lazy stream\");\n");
            } else {
                CodeGenerationTracker codeGenerationTracker3 = codeGenerationTracker.cloneBranch();
                String string9 = binding == null ? this.m_otherwise.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker3, null, bl) : ((IStreamInADTOptimizationInstruction)((Object)this.m_otherwise)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string2, binding, codeGenerationTracker3, bl2, bl);
                type2.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string4, string9, bl2, binding, codeGenerationTracker3);
            }
            dataFlowCodeGenerationHelper.append("}\n");
        } else {
            String string10 = codeGenerationTracker.generateConventionally(this.m_source, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("if (" + string3 + " >= " + string10 + ".m_length && !" + string10 + ".m_complete) {\n");
            dataFlowCodeGenerationHelper.append(string10 + ".evaluateMore(" + string3 + ");\n");
            dataFlowCodeGenerationHelper.append("}\n");
            type2.appendHolderVariableDeclaration(dataFlowCodeGenerationHelper, string4, bl2, binding, codeGenerationTracker);
            dataFlowCodeGenerationHelper.append("if (" + string3 + " < " + string10 + ".m_length) {\n");
            CodeGenerationTracker codeGenerationTracker4 = codeGenerationTracker.cloneBranch();
            String string11 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(Binding.generateVariableName(this, dataFlowCodeGenerationHelper));
            String string12 = dataFlowCodeGenerationHelper.m_finalKeyword + " " + type.getImplementationName(dataFlowCodeGenerationHelper) + " " + string11 + " = " + string10 + ".m_data[" + string3 + "];\n";
            codeGenerationTracker4.registerBinding((IBinding)this, new LazyAdditionGenerationState((IBinding)this, string11, string12));
            String string13 = binding == null ? this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker4, null, bl) : ((IStreamInADTOptimizationInstruction)((Object)this.m_body)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string2, binding, codeGenerationTracker4, bl2, bl);
            type2.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string4, string13, bl2, binding, codeGenerationTracker4);
            dataFlowCodeGenerationHelper.append("} else {\n");
            if (this.m_otherwise == null) {
                dataFlowCodeGenerationHelper.append("throw new RuntimeException(\"index out of bounds on lazy stream\");\n");
            } else {
                CodeGenerationTracker codeGenerationTracker5 = codeGenerationTracker.cloneBranch();
                String string14 = binding == null ? this.m_otherwise.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker5, null, bl) : ((IStreamInADTOptimizationInstruction)((Object)this.m_otherwise)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string2, binding, codeGenerationTracker5, bl2, bl);
                type2.appendHolderVariableAssignment(dataFlowCodeGenerationHelper, string4, string14, bl2, binding, codeGenerationTracker5);
            }
            dataFlowCodeGenerationHelper.append("}\n");
        }
        return string4;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException();
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        LazyStream lazyStream = (LazyStream)this.m_source.evaluate(environment, function, iDebuggerInterceptor, false);
        Integer n = (Integer)this.m_index.evaluate(environment, function, iDebuggerInterceptor, false);
        int n2 = n;
        try {
            object = lazyStream.get(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (this.m_otherwise != null) {
                Object object2 = this.m_otherwise.evaluate(environment, function, iDebuggerInterceptor, bl);
                return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
            }
            throw new XylemError("ERR_SYSTEM", "index out of bounds on lazy stream");
        }
        Object object3 = environment.bind(this, object);
        Object object4 = this.m_body.evaluate(environment, function, iDebuggerInterceptor, bl);
        environment.bind(this, object3);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object4);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("lazy-stream-element", n);
        this.m_source.toString(prettyPrinter, n + 1);
        this.m_index.toString(prettyPrinter, n + 1);
        prettyPrinter.printIdentifier(this.m_var, n + 1);
        this.m_body.toString(prettyPrinter, n + 1);
        if (this.m_otherwise != null) {
            this.m_otherwise.toString(prettyPrinter, n + 1);
        }
        prettyPrinter.printFormClose(n);
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        set.remove(this);
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        set.remove(this);
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_source);
        writeObjectFileHelper.writeInstruction(this.m_index);
        writeObjectFileHelper.writeBindingName(this.m_var);
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeBoolean(this.m_otherwise != null);
        if (this.m_otherwise != null) {
            writeObjectFileHelper.writeInstruction(this.m_otherwise);
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_source = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_index = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_var = readObjectFileHelper.readBindingName();
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_otherwise = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
    }

    public boolean isChildInstructionBody(int n) {
        return n == 2 || n == 3;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        if (n != 2) {
            return null;
        }
        return new IBinding[]{this};
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return this.isChildInstructionBody(n);
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Object object = iNewNameGenerator.getNewName();
        map.put(this.m_var, new IdentifierInstruction(object));
        return new LazyStreamElementInstruction(this.m_source.assignNewNames(map, iNewNameGenerator), this.m_index.assignNewNames(map, iNewNameGenerator), object, this.m_body.assignNewNames(map, iNewNameGenerator), this.m_otherwise == null ? null : this.m_otherwise.assignNewNames(map, iNewNameGenerator));
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            if (!this.m_body.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment)) {
                return false;
            }
            return this.m_otherwise == null || this.m_otherwise.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        if (codeGenerationOptimizationStyle instanceof StreamInADTOptimizationStyle) {
            if (!this.m_body.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment)) {
                return false;
            }
            return this.m_otherwise == null || this.m_otherwise.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        Instruction instruction = this.m_body;
        if (!((IStreamInADTOptimizationInstruction)((Object)instruction)).canGenerateObjectless(typeEnvironment)) {
            return false;
        }
        return this.m_otherwise == null || ((IStreamInADTOptimizationInstruction)((Object)this.m_otherwise)).canGenerateObjectless(typeEnvironment);
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        return this.generateCodeBasedOnDataFlowInternal(dataFlowCodeGenerationHelper, codeGenerationTracker, null, bl2, string, bl, binding);
    }

    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
    }

    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
    }

    public Type getBindingType() {
        return this.m_elementType;
    }

    public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType;
    }

    public Object getName() {
        return this.m_var;
    }

    public void setName(Object object) {
        this.m_var = object;
    }

    public Type getTypeParameter(int n) {
        return n == 0 ? this.m_elementType : null;
    }

    public int getTypeParameterCount() {
        return 1;
    }

    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_source;
            }
            case 1: {
                return this.m_index;
            }
            case 2: {
                return this.m_body;
            }
            case 3: {
                return this.m_otherwise;
            }
        }
        return null;
    }

    public int getChildInstructionCount() {
        return this.m_otherwise == null ? 3 : 4;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_source = instruction;
                break;
            }
            case 1: {
                this.m_index = instruction;
                break;
            }
            case 2: {
                this.m_body = instruction;
                break;
            }
            case 3: {
                this.m_otherwise = instruction;
            }
        }
    }

    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_elementType = type;
        }
    }

    public LetInstruction getLet() {
        return null;
    }

    public ISpecialForm getOrigin() {
        return null;
    }

    public int compareTo(Object object) {
        return Binding.compare(this, object);
    }

    public Instruction cloneShallow() {
        return new LazyStreamElementInstruction(this.m_source, this.m_index, this.m_var, this.m_body, this.m_otherwise);
    }
}

