/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LetOnceInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;

public abstract class LetBaseInstruction
extends Instruction
implements IBinding,
ISpecialForm {
    protected Instruction m_value;
    protected Instruction m_body;
    protected Object m_variable;
    protected Type m_cachedValueType = null;
    public Set m_partialInformation = null;

    public LetBaseInstruction() {
    }

    public LetBaseInstruction(Object object, Instruction instruction, Instruction instruction2) {
        this.m_value = instruction;
        this.m_body = instruction2;
        this.m_variable = object;
        if (object == null || object instanceof Instruction || object instanceof Binding) {
            throw new InternalError("A let variable must not be " + object);
        }
    }

    public int compareTo(Object object) {
        return Binding.compare(this, object);
    }

    public Object getVariable() {
        return this.m_variable;
    }

    public void setVariable(Object object) {
        this.m_variable = object;
    }

    public IBinding getBinding() {
        return this;
    }

    public Instruction getValue() {
        return this.m_value;
    }

    public void setValue(Instruction instruction) {
        this.m_value = instruction;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    public abstract Instruction cloneWithoutTypeInformation(Object var1, Instruction var2, Instruction var3);

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        LetBaseInstruction letBaseInstruction = this;
        while (letBaseInstruction.m_body instanceof LetBaseInstruction) {
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        return letBaseInstruction.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_value != null) {
            this.m_cachedValueType = this.m_value.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment, this);
            Type type = this.m_body instanceof LetBaseInstruction ? LetBaseInstruction.typeCheck2((LetBaseInstruction)this.m_body, typeEnvironment, bindingEnvironment2, linkedList) : this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
            return this.setCachedType(type);
        }
        return null;
    }

    public static Type typeCheck2(LetBaseInstruction letBaseInstruction2, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        ArrayList<LetBaseInstruction> arrayList = new ArrayList<LetBaseInstruction>();
        Type type = null;
        while (true) {
            letBaseInstruction2.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
            letBaseInstruction2.m_cachedValueType = letBaseInstruction2.m_value.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
            bindingEnvironment = new BindingEnvironment(bindingEnvironment, letBaseInstruction2);
            arrayList.add(letBaseInstruction2);
            if (!(letBaseInstruction2.m_body instanceof LetBaseInstruction)) break;
            letBaseInstruction2 = (LetBaseInstruction)letBaseInstruction2.m_body;
        }
        type = letBaseInstruction2.m_body.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        for (LetBaseInstruction letBaseInstruction2 : arrayList) {
            letBaseInstruction2.setCachedType(type);
        }
        return type;
    }

    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_value;
            }
            case 1: {
                return this.m_body;
            }
        }
        return null;
    }

    public int getChildInstructionCount() {
        return 2;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_value = instruction;
                break;
            }
            case 1: {
                this.m_body = instruction;
            }
        }
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        LetBaseInstruction letBaseInstruction;
        Instruction instruction = this;
        while (instruction instanceof LetBaseInstruction) {
            letBaseInstruction = instruction;
            letBaseInstruction.getValue().accumulateNonLiteralFreeBindings(set, bindingEnvironment);
            instruction = letBaseInstruction.getBody();
        }
        ((Instruction)instruction).accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        instruction = this;
        while (instruction instanceof LetBaseInstruction) {
            letBaseInstruction = instruction;
            set.remove(letBaseInstruction);
            instruction = letBaseInstruction.getBody();
        }
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        LetBaseInstruction letBaseInstruction;
        Instruction instruction = this;
        while (instruction instanceof LetBaseInstruction) {
            letBaseInstruction = instruction;
            letBaseInstruction.getValue().accumulateFreeBindings(set, bindingEnvironment);
            instruction = letBaseInstruction.getBody();
        }
        ((Instruction)instruction).accumulateFreeBindings(set, bindingEnvironment);
        instruction = this;
        while (instruction instanceof LetBaseInstruction) {
            letBaseInstruction = instruction;
            set.remove(letBaseInstruction);
            instruction = letBaseInstruction.getBody();
        }
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            bindingEnvironment.setVariableBinding(letBaseInstruction);
            letBaseInstruction.m_value.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
            if (!(letBaseInstruction.m_body instanceof LetBaseInstruction)) break;
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        letBaseInstruction.m_body.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    public void clearTypeInformation() {
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            letBaseInstruction.m_bindingEnvironment = null;
            letBaseInstruction.m_hasBeenTypechecked = false;
            letBaseInstruction.m_value.clearTypeInformation();
            if (!(letBaseInstruction.m_body instanceof LetBaseInstruction)) break;
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        letBaseInstruction.m_body.clearTypeInformation();
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Object object;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Instruction instruction = this;
        while (instruction instanceof LetBaseInstruction) {
            object = instruction;
            Object object2 = ((LetBaseInstruction)object).m_value.evaluate(environment, function, iDebuggerInterceptor, false);
            Object object3 = environment.bind((IBinding)object, object2);
            arrayList.add(object3);
            arrayList2.add(object);
            instruction = ((LetBaseInstruction)object).getBody();
        }
        object = null;
        try {
            object = ((Instruction)instruction).evaluate(environment, function, iDebuggerInterceptor, bl);
        }
        catch (FunctionCallInstruction.TailCallEvent tailCallEvent) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                environment.bind((LetBaseInstruction)arrayList2.get(i), arrayList.get(i));
            }
            throw tailCallEvent;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            environment.bind((LetBaseInstruction)arrayList2.get(i), arrayList.get(i));
        }
        Object object4 = object;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object4);
    }

    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<LetBaseInstruction> arrayList2 = new ArrayList<LetBaseInstruction>();
        Instruction instruction = this;
        while (instruction instanceof LetBaseInstruction) {
            LetBaseInstruction letBaseInstruction = instruction;
            Object object = letBaseInstruction.m_value.evaluate(environment, function, iDebuggerInterceptor, false);
            Object object2 = environment.bind(letBaseInstruction, object);
            arrayList.add(object2);
            arrayList2.add(letBaseInstruction);
            instruction = letBaseInstruction.getBody();
        }
        try {
            ((Instruction)instruction).evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
        }
        catch (FunctionCallInstruction.TailCallEvent tailCallEvent) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                environment.bind((LetBaseInstruction)arrayList2.get(i), arrayList.get(i));
            }
            throw tailCallEvent;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            environment.bind((LetBaseInstruction)arrayList2.get(i), arrayList.get(i));
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, Instruction instruction, int n, BindingEnvironment bindingEnvironment) {
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            letBaseInstruction.m_value.determineDataDependencies(bindingArray, hashMap, letBaseInstruction, 0, bindingEnvironment);
            if (!(letBaseInstruction.m_body instanceof LetBaseInstruction)) break;
            instruction = letBaseInstruction;
            n = 0;
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        letBaseInstruction.m_body.determineDataDependencies(bindingArray, hashMap, letBaseInstruction, 1, bindingEnvironment);
    }

    public void determineDataDependencies(Set set) {
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            letBaseInstruction.m_value.determineDataDependencies(set);
            if (!(letBaseInstruction.m_body instanceof LetBaseInstruction)) break;
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        letBaseInstruction.m_body.determineDataDependencies(set);
    }

    public void accumulateFunctionsCalled(Set set) {
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            letBaseInstruction.m_value.accumulateFunctionsCalled(set);
            if (!(letBaseInstruction.m_body instanceof LetBaseInstruction)) break;
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        letBaseInstruction.m_body.accumulateFunctionsCalled(set);
    }

    public Instruction removeAliases(HashMap hashMap) {
        Instruction instruction;
        LetBaseInstruction letBaseInstruction = this;
        Object object = null;
        Object object2 = null;
        while (true) {
            Object object3;
            letBaseInstruction.m_partialInformation = null;
            if (letBaseInstruction.m_value instanceof IdentifierInstruction) {
                Object v;
                instruction = (IdentifierInstruction)letBaseInstruction.m_value;
                object3 = instruction.getVariable();
                while ((v = hashMap.get(object3)) != null) {
                    object3 = v;
                }
                hashMap.put(letBaseInstruction.getName(), object3);
            } else {
                instruction = letBaseInstruction.m_value.removeAliases(hashMap);
                letBaseInstruction.setValue(instruction);
                object3 = letBaseInstruction;
                if (object2 == null) {
                    object = object2 = object3;
                } else {
                    ((LetBaseInstruction)object2).setBody((Instruction)object3);
                    object2 = object3;
                }
            }
            if (!(letBaseInstruction.m_body instanceof LetBaseInstruction)) break;
            letBaseInstruction = (LetBaseInstruction)letBaseInstruction.m_body;
        }
        instruction = letBaseInstruction.m_body.removeAliases(hashMap);
        if (object2 != null) {
            ((LetBaseInstruction)object2).setBody(instruction);
            return object;
        }
        return instruction;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        Instruction instruction;
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            writeObjectFileHelper.writeBindingName(letBaseInstruction.getVariable());
            writeObjectFileHelper.writeInstruction(letBaseInstruction.getValue());
            instruction = letBaseInstruction.getBody();
            if (!(instruction instanceof LetBaseInstruction)) break;
            writeObjectFileHelper.writeBoolean(true);
            letBaseInstruction = (LetBaseInstruction)instruction;
            writeObjectFileHelper.writeBoolean(letBaseInstruction instanceof LetOnceInstruction);
        }
        writeObjectFileHelper.writeBoolean(false);
        writeObjectFileHelper.writeInstruction(instruction);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        LetBaseInstruction letBaseInstruction = this;
        while (true) {
            letBaseInstruction.m_variable = readObjectFileHelper.readBindingName();
            letBaseInstruction.m_value = readObjectFileHelper.readInstruction(bindingEnvironment);
            boolean bl = readObjectFileHelper.readBoolean();
            if (!bl) break;
            boolean bl2 = readObjectFileHelper.readBoolean();
            LetBaseInstruction letBaseInstruction2 = bl2 ? new LetOnceInstruction() : new LetInstruction();
            letBaseInstruction.setBody(letBaseInstruction2);
            letBaseInstruction = letBaseInstruction2;
        }
        letBaseInstruction.setBody(readObjectFileHelper.readInstruction(bindingEnvironment));
    }

    public Type getBindingType() {
        return this.m_cachedValueType;
    }

    public Type getBindingType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.getValue().getType(typeEnvironment, bindingEnvironment);
        if (type == null) {
            throw new RuntimeException();
        }
        return type;
    }

    public Object getName() {
        return this.m_variable;
    }

    public void setName(Object object) {
        this.m_variable = object;
    }

    public void resetCachedValueType() {
        this.m_cachedValueType = null;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        IBinding[] iBindingArray;
        if (n == 1) {
            IBinding[] iBindingArray2 = new IBinding[1];
            iBindingArray = iBindingArray2;
            iBindingArray2[0] = this;
        } else {
            iBindingArray = null;
        }
        return iBindingArray;
    }

    public ISpecialForm getOrigin() {
        return this;
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return n == 1;
    }
}

