/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PolymorphicADTDesugarer;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.interpreter.AbstractDataObject;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.ListStream;
import com.ibm.xylem.interpreter.Tuple;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.ICollectionType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ParallelForEachInstruction
extends Instruction
implements ISpecialForm {
    protected Instruction[] m_sources;
    protected Instruction m_body;
    protected Binding[] m_elementBindings;
    protected Type m_bodyADTType;
    protected Binding m_indexBinding;

    public ParallelForEachInstruction() {
    }

    public ParallelForEachInstruction(Instruction[] instructionArray, Object[] objectArray, Instruction instruction) {
        this(instructionArray, objectArray, instruction, null);
    }

    public ParallelForEachInstruction(Instruction[] instructionArray, Object[] objectArray, Instruction instruction, Type type) {
        this.m_sources = instructionArray;
        this.m_elementBindings = Binding.getBindings(objectArray);
        this.m_body = instruction;
        this.m_bodyADTType = type;
    }

    public void setIndexVar(Object object) {
        if (null == object) {
            this.m_indexBinding = null;
            return;
        }
        if (this.m_indexBinding == null) {
            this.m_indexBinding = new Binding(object, (Type)IntType.s_intType, this);
        } else {
            this.m_indexBinding.setName(object);
        }
    }

    public Instruction getChildInstruction(int n) {
        if (n < this.m_sources.length) {
            return this.m_sources[n];
        }
        if (n == this.m_sources.length) {
            return this.m_body;
        }
        return null;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public Instruction[] getSources() {
        return this.m_sources;
    }

    public Binding[] getElementBindings() {
        return this.m_elementBindings;
    }

    public Object[] getElementVars() {
        return Binding.getNames(this.m_elementBindings);
    }

    public void removeBinding(int n) {
        int n2;
        Binding[] bindingArray = new Binding[this.m_elementBindings.length - 1];
        Instruction[] instructionArray = new Instruction[this.m_sources.length - 1];
        for (n2 = 0; n2 < n; ++n2) {
            bindingArray[n2] = this.m_elementBindings[n2];
            instructionArray[n2] = this.m_sources[n2];
        }
        for (n2 = n + 1; n2 < this.m_elementBindings.length; ++n2) {
            bindingArray[n2 - 1] = this.m_elementBindings[n2];
            instructionArray[n2 - 1] = this.m_sources[n2];
        }
        this.m_elementBindings = bindingArray;
        this.m_sources = instructionArray;
    }

    public Object getIndexVar() {
        return null == this.m_indexBinding ? null : this.m_indexBinding.getName();
    }

    public void setChildInstruction(int n, Instruction instruction) {
        if (n < this.m_sources.length) {
            this.m_sources[n] = instruction;
        } else if (n == this.m_sources.length) {
            this.m_body = instruction;
        } else {
            throw new Error("index oob " + n);
        }
    }

    public int getChildInstructionCount() {
        return this.m_sources.length + 1;
    }

    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_sources.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_sources[i].cloneWithoutTypeInformation();
        }
        Instruction instruction = this.m_body.cloneWithoutTypeInformation();
        ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(instructionArray, Binding.getNames(this.m_elementBindings), instruction, this.m_bodyADTType);
        if (this.m_indexBinding != null) {
            parallelForEachInstruction.setIndexVar(this.m_indexBinding.getName());
        }
        return parallelForEachInstruction;
    }

    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_sources.clone();
        Instruction instruction = this.m_body;
        ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(instructionArray, Binding.getNames(this.m_elementBindings), instruction, this.m_bodyADTType);
        if (this.m_indexBinding != null) {
            parallelForEachInstruction.setIndexVar(this.m_indexBinding.getName());
        }
        return parallelForEachInstruction;
    }

    public Instruction cloneAndRemoveTupleType(PolymorphicADTDesugarer polymorphicADTDesugarer) {
        if (this.m_bodyADTType != null) {
            return this.cloneShallow();
        }
        TupleType tupleType = (TupleType)polymorphicADTDesugarer.resolveType(this.m_body);
        Type type = polymorphicADTDesugarer.convertType(tupleType);
        ParallelForEachInstruction parallelForEachInstruction = new ParallelForEachInstruction(this.m_sources, Binding.getNames(this.m_elementBindings), this.m_body, type);
        if (this.m_indexBinding != null) {
            parallelForEachInstruction.setIndexVar(this.m_indexBinding.getName());
        }
        return parallelForEachInstruction;
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        for (int i = 0; i < this.m_sources.length; ++i) {
            this.m_sources[i] = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_sources[i], bindingEnvironment);
        }
        ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
        for (int i = 0; i < this.m_sources.length; ++i) {
            reductionHelper2.upgradeBinding(this.m_elementBindings[i]);
            bindingEnvironment.setVariableBinding(this.m_elementBindings[i]);
        }
        if (this.m_indexBinding != null) {
            reductionHelper2.upgradeBinding(this.m_indexBinding);
            bindingEnvironment.setVariableBinding(this.m_indexBinding);
        }
        this.m_body = reductionHelper2.reduce(this.m_body, bindingEnvironment);
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        int n;
        int n2 = this.m_sources.length;
        Type[] typeArray = new Type[n2];
        for (n = 0; n < n2; ++n) {
            this.m_sources[n].typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
            typeArray[n] = this.m_sources[n].getType(typeEnvironment, bindingEnvironment).resolveType(typeEnvironment);
        }
        for (n = 0; n < n2; ++n) {
            if (!(typeArray[n] instanceof ICollectionType)) {
                throw new XylemError("ERR_SYSTEM", n + "th source to pfe is not a collection type " + typeArray[n] + " in " + this);
            }
            this.m_elementBindings[n].setType(((ICollectionType)((Object)typeArray[n])).getElementType());
            bindingEnvironment.setVariableBinding(this.m_elementBindings[n]);
        }
        if (this.m_indexBinding != null) {
            bindingEnvironment.setVariableBinding(this.m_indexBinding);
        }
        this.m_body.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        int n = this.m_sources.length;
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray[i] = this.m_sources[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        }
        BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment);
        for (int i = 0; i < n; ++i) {
            bindingEnvironment2.setVariableBinding(this.m_elementBindings[i]);
            typeEnvironment.unify(this.m_elementBindings[i].getBindingType().getStreamType(), typeArray[i], this);
        }
        if (this.m_indexBinding != null) {
            bindingEnvironment2.setVariableBinding(this.m_indexBinding);
        }
        Type type = this.m_body.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
        if (this.m_bodyADTType == null) {
            if (!(type instanceof TupleType)) {
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "expecting TupleType, got " + type + " in body"), this);
            }
            TupleType tupleType = (TupleType)type;
            Type[] typeArray2 = tupleType.getElementTypes();
            for (int i = 0; i < typeArray2.length; ++i) {
                if (typeArray2[i] instanceof StreamType) continue;
                throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "expecting StreamType, got " + typeArray2[i] + " in body tuple"), this);
            }
        } else {
            typeEnvironment.unify(type, this.m_bodyADTType, this);
        }
        return this.setCachedType(type);
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    /*
     * Unable to fully structure code
     */
    public Object evaluate(Environment var1_1, Function var2_2, IDebuggerInterceptor var3_3, boolean var4_4) {
        if (null != var3_3) {
            var3_3.enter(this, var1_1, var2_2);
        }
        var5_5 = this.m_sources.length;
        var6_6 = new IStream[var5_5];
        for (var7_7 = 0; var7_7 < var5_5; ++var7_7) {
            var6_6[var7_7] = (IStream)this.m_sources[var7_7].evaluate(var1_1, var2_2, var3_3, false);
        }
        var7_8 = new Iterator[var5_5];
        var8_9 = new Object[var5_5];
        for (var9_10 = 0; var9_10 < var5_5; ++var9_10) {
            var7_8[var9_10] = var6_6[var9_10].iterator();
            var8_9[var9_10] = var1_1.lookupBinding(this.m_elementBindings[var9_10]);
        }
        var9_11 = null;
        var10_12 = 0;
        if (this.m_indexBinding != null) {
            var9_11 = var1_1.lookupBinding(this.m_indexBinding);
        }
        var12_13 = null;
        if (this.m_bodyADTType != null) {
            var12_13 = ((NamedType)this.m_bodyADTType).resolveNameToADT(var2_2.getTypeEnvironment());
        }
        var11_14 = var12_13 != null ? var12_13.m_constructors[0].m_parameters.length : ((TupleType)this.m_body.evaluateType(var2_2)).getElementTypes().length;
        var13_15 = new ListStream[var11_14];
        for (var14_16 = 0; var14_16 < var11_14; ++var14_16) {
            var13_15[var14_16] = new ListStream();
        }
        block3: while (true) {
            for (var14_16 = 0; var14_16 < var5_5; ++var14_16) {
                if (!var7_8[var14_16].hasNext()) break block3;
                var1_1.bind(this.m_elementBindings[var14_16], var7_8[var14_16].next());
            }
            if (this.m_indexBinding != null) {
                var1_1.bind(this.m_indexBinding, new Integer(var10_12));
                ++var10_12;
            }
            var14_17 = this.m_body.evaluate(var1_1, var2_2, var3_3, false);
            var15_19 = var12_13 != null ? ((AbstractDataObject)var14_17).getValues() : ((Tuple)var14_17).getValues();
            var16_20 = 0;
            while (true) {
                if (var16_20 >= var11_14) ** continue;
                var13_15[var16_20].append(var15_19[var16_20]);
                ++var16_20;
            }
            break;
        }
        for (var14_16 = 0; var14_16 < var5_5; ++var14_16) {
            var1_1.bind(this.m_elementBindings[var14_16], var8_9[var14_16]);
        }
        if (this.m_indexBinding != null) {
            var1_1.bind(this.m_indexBinding, var9_11);
        }
        var14_18 = var12_13 != null ? new AbstractDataObject(var12_13.m_constructors[0], var13_15) : new Tuple(var13_15);
        return Debugger.leave(var3_3, this, var1_1, var2_2, var14_18);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("parallel-foreach", n);
        if (this.m_bodyADTType != null) {
            prettyPrinter.print("@" + this.m_bodyADTType.prettyPrint());
        }
        int n2 = this.m_sources.length;
        prettyPrinter.print(" (");
        for (int i = 0; i < n2; ++i) {
            prettyPrinter.printFormOpenIdentifier(this.m_elementBindings[i].getName(), n + 2);
            this.m_sources[i].toString(prettyPrinter, n + 3);
            prettyPrinter.printFormClose(n + 2);
        }
        prettyPrinter.printFormClose(n + 1);
        this.m_body.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        int n = this.m_sources.length;
        for (int i = 0; i < n; ++i) {
            set.remove(this.m_elementBindings[i]);
        }
        if (this.m_indexBinding != null) {
            set.remove(this.m_indexBinding);
        }
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        int n = this.m_sources.length;
        for (int i = 0; i < n; ++i) {
            set.remove(this.m_elementBindings[i]);
        }
        if (this.m_indexBinding != null) {
            set.remove(this.m_indexBinding);
        }
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Object object;
        Instruction[] instructionArray;
        Instruction[] instructionArray2 = null;
        if (this.m_indexBinding != null) {
            instructionArray = iNewNameGenerator.getNewName();
            map.put(this.m_indexBinding.getName(), new IdentifierInstruction(instructionArray));
            instructionArray2 = instructionArray;
        }
        instructionArray = new Instruction[this.m_sources.length];
        Object[] objectArray = new Object[this.m_elementBindings.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_sources[i].assignNewNames(map, iNewNameGenerator);
            object = iNewNameGenerator.getNewName();
            map.put(this.m_elementBindings[i].getName(), new IdentifierInstruction(object));
            objectArray[i] = object;
        }
        Instruction instruction = this.m_body.assignNewNames(map, iNewNameGenerator);
        object = new ParallelForEachInstruction(instructionArray, objectArray, instruction, this.m_bodyADTType);
        ((ParallelForEachInstruction)object).setIndexVar(instructionArray2);
        return object;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        int n;
        int n2;
        boolean bl;
        BranchInstruction branchInstruction;
        int n3;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, bCELCodeGenerationHelper, instructionListBuilder, null);
        int n4 = this.m_sources.length;
        AbstractDataType.Constructor constructor = this.getBodyADT((TypeEnvironment)typeEnvironment).m_constructors[0];
        int n5 = constructor.m_parameters.length;
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        int[][] nArrayArray = new int[n5][];
        StreamType[] streamTypeArray = new StreamType[n4];
        Type[] typeArray = new StreamType[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            streamTypeArray[n3] = (StreamType)this.m_sources[n3].getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
            nArray[n3] = codeGenerationTracker.generateConventionallyIntoRegister(this.m_sources[n3], bCELCodeGenerationHelper, instructionListBuilder);
            nArray2[n3] = codeGenerationTracker.allocateRegister();
        }
        for (n3 = 0; n3 < n5; ++n3) {
            typeArray[n3] = (StreamType)constructor.m_parameters[n3].getBindingType().resolveType(constructor.m_parameters[n3].getTypeEnvironment());
            nArrayArray[n3] = StreamType.generateCreateStream(instructionListBuilder, 0, typeArray[n3], bCELCodeGenerationHelper, codeGenerationTracker);
        }
        n3 = codeGenerationTracker.allocateRegister();
        int n6 = nArray.length;
        int n7 = codeGenerationTracker.allocateRegister();
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendArrayLength();
        instructionListBuilder.appendIStore(n7);
        for (int i = 1; i < n6; ++i) {
            instructionListBuilder.appendILoad(n7);
            instructionListBuilder.appendALoad(nArray[i]);
            instructionListBuilder.appendArrayLength();
            branchInstruction = instructionListBuilder.appendIficmple();
            instructionListBuilder.appendALoad(nArray[i]);
            instructionListBuilder.appendArrayLength();
            instructionListBuilder.appendIStore(n7);
            branchInstruction.setTarget(instructionListBuilder.appendNOP());
        }
        instructionListBuilder.appendConstant(0);
        instructionListBuilder.appendIStore(n3);
        InstructionHandle instructionHandle2 = instructionListBuilder.appendILoad(n3);
        instructionListBuilder.appendILoad(n7);
        branchInstruction = instructionListBuilder.appendIficmpge();
        for (int i = 0; i < n6; ++i) {
            instructionListBuilder.appendALoad(nArray[i]);
            instructionListBuilder.appendILoad(n3);
            instructionListBuilder.appendArrayLoad(streamTypeArray[i].getElementType());
            instructionListBuilder.appendStore(streamTypeArray[i].getElementType(), nArray2[i]);
        }
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        boolean bl2 = bl = this.m_indexBinding != null && codeGenerationTracker.isBindingUsed(this.m_indexBinding);
        if (bl) {
            codeGenerationTracker2.registerExtantBinding(this.m_indexBinding, n3, BasicType.INT);
        }
        for (n2 = 0; n2 < n6; ++n2) {
            codeGenerationTracker2.registerExtantBinding(this.m_elementBindings[n2], nArray2[n2], streamTypeArray[n2].getElementType().getImplementationType(bCELCodeGenerationHelper));
        }
        n2 = codeGenerationTracker.allocateRegister();
        this.m_body.generateCode(bCELCodeGenerationHelper, codeGenerationTracker2, null, null, instructionListBuilder);
        instructionListBuilder.appendAStore(n2);
        int[] nArray3 = new int[n5];
        for (n = 0; n < n5; ++n) {
            nArray3[n] = codeGenerationTracker.allocateRegister();
            instructionListBuilder.appendALoad(n2);
            instructionListBuilder.appendGetField(constructor, n, bCELCodeGenerationHelper);
            instructionListBuilder.appendAStore(nArray3[n]);
        }
        for (n = 0; n < n5; ++n) {
            StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArrayArray[n], instructionListBuilder, typeArray[n], codeGenerationTracker, nArray3[n], -1);
        }
        instructionListBuilder.appendLocalIncrement(n3);
        instructionListBuilder.appendGoto(instructionHandle2);
        branchInstruction.setTarget(instructionListBuilder.appendNew(this.getBodyADT(typeEnvironment).getImplementationName(bCELCodeGenerationHelper)));
        instructionListBuilder.appendDUP();
        for (n = 0; n < n5; ++n) {
            StreamType.generateCompactStream(nArrayArray[n], instructionListBuilder, typeArray[n], bCELCodeGenerationHelper, codeGenerationTracker);
        }
        instructionListBuilder.appendInvokeConstructor(this.getBodyADT(typeEnvironment).getImplementationName(bCELCodeGenerationHelper), typeArray);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        int n;
        boolean bl2;
        int n2;
        int n3;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        codeGenerationTracker.generateFreeBindings(this, dataFlowCodeGenerationHelper);
        int n4 = this.m_sources.length;
        AbstractDataType.Constructor constructor = this.getBodyADT((TypeEnvironment)typeEnvironment).m_constructors[0];
        int n5 = constructor.m_parameters.length;
        String[] stringArray = new String[n4];
        String[] stringArray2 = new String[n4];
        String[] stringArray3 = new String[n5];
        StreamType[] streamTypeArray = new StreamType[n4];
        StreamType[] streamTypeArray2 = new StreamType[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            streamTypeArray[n3] = (StreamType)this.m_sources[n3].getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
            stringArray[n3] = codeGenerationTracker.generateConventionally(this.m_sources[n3], dataFlowCodeGenerationHelper);
            stringArray2[n3] = dataFlowCodeGenerationHelper.generateNewLocalVariableName(this.m_elementBindings[n3].getName());
        }
        for (n3 = 0; n3 < n5; ++n3) {
            stringArray3[n3] = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
            streamTypeArray2[n3] = (StreamType)constructor.m_parameters[n3].getBindingType().resolveType(constructor.m_parameters[n3].getTypeEnvironment());
            StreamType.generateCreateStream(stringArray3[n3], 0, streamTypeArray2[n3], dataFlowCodeGenerationHelper);
            StreamType.generateGrowStream(dataFlowCodeGenerationHelper, stringArray3[n3], streamTypeArray2[n3], stringArray[0] + ".length");
        }
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        int n6 = stringArray.length;
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        dataFlowCodeGenerationHelper.append("int " + string3 + " = " + stringArray[0] + ".length;\n");
        for (n2 = 1; n2 < n6; ++n2) {
            dataFlowCodeGenerationHelper.append("if (" + string3 + " != " + stringArray[n2] + ".length) System.err.println(\"source lengths unequal (" + this.m_sources[n2] + ")\");\n");
            dataFlowCodeGenerationHelper.append(string3 + " = (" + string3 + " > " + stringArray[n2] + ".length) ? " + stringArray[n2] + ".length : " + string3 + ";\n");
        }
        dataFlowCodeGenerationHelper.append("for (int " + string2 + "=0;" + string2 + "<" + string3 + ";" + string2 + "++){\n");
        for (n2 = 0; n2 < n6; ++n2) {
            dataFlowCodeGenerationHelper.appendAssignment(stringArray2[n2], streamTypeArray[n2].getElementType(), stringArray[n2] + "[" + string2 + "]", codeGenerationTracker);
        }
        CodeGenerationTracker codeGenerationTracker2 = codeGenerationTracker.cloneBranch();
        boolean bl3 = bl2 = this.m_indexBinding != null && codeGenerationTracker.isBindingUsed(this.m_indexBinding);
        if (bl2) {
            codeGenerationTracker2.registerExtantBinding(this.m_indexBinding, string2);
        }
        for (int i = 0; i < n6; ++i) {
            codeGenerationTracker2.registerExtantBinding(this.m_elementBindings[i], stringArray2[i]);
        }
        String string4 = this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker2, null, false);
        String[] stringArray4 = new String[n5];
        for (n = 0; n < n5; ++n) {
            stringArray4[n] = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        }
        this.getBodyADT(typeEnvironment).generateConstructorDeconstructionCode(dataFlowCodeGenerationHelper, string4, codeGenerationTracker, stringArray4, constructor);
        for (n = 0; n < n5; ++n) {
            StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, stringArray3[n], streamTypeArray2[n], stringArray4[n], -1);
        }
        dataFlowCodeGenerationHelper.append("}\n");
        for (n = 0; n < n5; ++n) {
            StreamType.generateCompactStream(stringArray3[n], streamTypeArray2[n], dataFlowCodeGenerationHelper);
        }
        String string5 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string5, this.m_bodyADTType, "new " + this.getBodyADT(typeEnvironment).getImplementationName(dataFlowCodeGenerationHelper) + "(0)", codeGenerationTracker);
        for (int i = 0; i < n5; ++i) {
            dataFlowCodeGenerationHelper.append(string5 + "." + constructor.getConstructorQualifiedFieldName(i, dataFlowCodeGenerationHelper) + " = " + stringArray3[i] + ";\n");
        }
        return string5;
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        int n = readObjectFileHelper.readInt();
        this.m_sources = new Instruction[n];
        this.m_elementBindings = new Binding[n];
        for (int i = 0; i < n; ++i) {
            this.m_sources[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
            this.m_elementBindings[i] = new Binding(readObjectFileHelper.readBindingName());
        }
        if (readObjectFileHelper.readBoolean()) {
            this.m_indexBinding = new Binding(readObjectFileHelper.readBindingName(), (Type)IntType.s_intType, this);
        }
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        if (readObjectFileHelper.readBoolean()) {
            this.m_bodyADTType = readObjectFileHelper.readType();
        }
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        int n = this.m_sources.length;
        writeObjectFileHelper.writeInt(n);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_sources[i]);
            writeObjectFileHelper.writeBindingName(this.m_elementBindings[i].getName());
        }
        writeObjectFileHelper.writeBoolean(this.m_indexBinding != null);
        if (this.m_indexBinding != null) {
            writeObjectFileHelper.writeBindingName(this.m_indexBinding.getName());
        }
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeBoolean(this.m_bodyADTType != null);
        if (this.m_bodyADTType != null) {
            writeObjectFileHelper.writeType(this.m_bodyADTType);
        }
    }

    public AbstractDataType getBodyADT(TypeEnvironment typeEnvironment) {
        return ((NamedType)this.m_bodyADTType).resolveNameToADT(typeEnvironment);
    }

    public boolean isChildInstructionBody(int n) {
        return n == this.m_sources.length;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        return n == this.m_sources.length ? this.m_elementBindings : null;
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }

    public void setBodyADTType(Type type) {
        this.m_bodyADTType = type;
    }

    public NamedType getBodyADTNamedType() {
        return (NamedType)this.m_bodyADTType;
    }
}

