/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.ReadJavaFieldInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.JavaClassInformation;
import com.ibm.xylem.types.JavaObjectType;
import java.io.IOException;
import java.util.LinkedList;

public class ReadJavaConstantInstruction
extends ReadJavaFieldInstruction {
    public ReadJavaConstantInstruction() {
    }

    public ReadJavaConstantInstruction(Instruction instruction, String string) {
        super(instruction, string);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string2 + "." + this.m_fieldName, codeGenerationTracker);
        return string3;
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = super.evaluate(environment, function, iDebuggerInterceptor, bl);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    public Instruction cloneWithoutTypeInformation() {
        return new ReadJavaConstantInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
    }

    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new ReadJavaConstantInstruction(instruction, this.m_fieldName);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(type instanceof JavaObjectType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        JavaObjectType javaObjectType = (JavaObjectType)type;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " does not contain field " + this.m_fieldName), this);
        }
        if (!field.isConstant()) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " contains field " + this.m_fieldName + " but it is not constant."), this);
        }
        return this.setCachedType(field.getType());
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return super.getType(typeEnvironment, bindingEnvironment);
    }

    public String innerToString() {
        return "read-java-constant! " + this.m_fieldName;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
    }

    public Integer getIntegerValue(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type;
        try {
            type = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, new LinkedList());
        }
        catch (TypeCheckException typeCheckException) {
            return null;
        }
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            return null;
        }
        if (!(type instanceof JavaObjectType)) {
            return null;
        }
        JavaObjectType javaObjectType = (JavaObjectType)type;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        if (field == null) {
            return null;
        }
        if (!field.isConstant()) {
            return null;
        }
        Integer n = field.getIntegerObject();
        return n;
    }
}

