/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.Slot;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.UnitType;
import java.io.IOException;
import java.util.LinkedList;

public class SetFieldInstruction
extends BinaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public SetFieldInstruction() {
    }

    public SetFieldInstruction(Instruction instruction, String string, Instruction instruction2) {
        super(instruction, instruction2);
        this.m_fieldName = string;
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand1, dataFlowCodeGenerationHelper);
        String string3 = codeGenerationTracker.generateConventionally(this.m_operand2, dataFlowCodeGenerationHelper);
        dataFlowCodeGenerationHelper.append(string2 + "." + this.m_fieldName + " = " + string3 + ";\n");
        return "1";
    }

    public Instruction cloneWithoutTypeInformation() {
        return new SetFieldInstruction(this.m_operand1.cloneWithoutTypeInformation(), this.m_fieldName, this.m_operand2.cloneWithoutTypeInformation());
    }

    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new SetFieldInstruction(instruction, this.m_fieldName, instruction2);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand1.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand1), this);
        }
        if (!(type instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand1 + " is not an object; it's a " + type.prettyPrint()), this);
        }
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        ClassType.Field field = classType.resolveField(this.m_fieldName, typeEnvironment);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " does not contain field " + this.m_fieldName), this);
        }
        if (!field.isMutable()) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Field " + this.m_fieldName + " of class " + classType.getName() + " is not mutable"), this);
        }
        type = this.m_operand2.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(field.getType(), type, this);
        return this.setCachedType(UnitType.s_unitType);
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return UnitType.s_unitType;
    }

    public String innerToString() {
        return "set-field! " + this.m_fieldName;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Slot slot = (Slot)this.m_operand1.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object = this.m_operand2.evaluate(environment, function, iDebuggerInterceptor, false);
        slot.setValue(object);
        Object object2 = object;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_fieldName = readObjectFileHelper.readString();
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_fieldName);
    }
}

