/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IMatchDestructable;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptUtils;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.interpreter.CharArrayWriterStream;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.interpreter.ListStream;
import com.ibm.xylem.interpreter.StringStream;
import com.ibm.xylem.interpreter.TagStream;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TagType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StreamInstruction
extends Instruction
implements IStreamOptimizationInstruction,
IMatchDestructable {
    protected Type m_elementType;
    protected Instruction[] m_elements;
    protected String m_string;
    public static final int s_runs = 2;
    private StreamType s_charStreamType = CharType.s_charType.getStreamType();
    static final ArrayType s_charArrayType = BCELCodeGenerationHelper.s_charArrayType;

    public StreamInstruction() {
    }

    public StreamInstruction(Type type, Instruction[] instructionArray) {
        if (type instanceof StreamType) {
            throw new XylemError("ERR_SYSTEM", "can't stream a stream type");
        }
        this.m_elementType = type;
        this.setElements(instructionArray);
        this.getStringContent();
    }

    public StreamInstruction(Type type, List list) {
        this.m_elementType = type;
        this.setElements(new Instruction[list.size()]);
        list.toArray(this.m_elements);
        this.getStringContent();
    }

    public StreamInstruction(Type type, Instruction instruction) {
        this(type, new Instruction[]{instruction});
    }

    public StreamInstruction(Type type) {
        this(type, new Instruction[0]);
    }

    public StreamInstruction(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.m_string = string;
        this.m_elementType = CharType.s_charType;
    }

    public Instruction[] getElements() {
        return this.m_elements;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    public boolean isStoredAsString() {
        return this.m_elements == null;
    }

    public boolean isString() {
        this.getStringContent();
        return this.m_elements == null;
    }

    public void setElementType(Type type) {
        this.m_elementType = type;
    }

    public void accumulateFunctionsCalled(Set set) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateFunctionsCalled(set);
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateFreeBindings(set, bindingEnvironment);
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        if (this.m_string != null) {
            return;
        }
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        if (this.m_elements != null) {
            Type type = this.m_elementType.resolveTypeAsMuchAsPossible(typeEnvironment, new HashSet());
            boolean bl = type instanceof TypeVariable;
            for (int i = 0; i < this.m_elements.length; ++i) {
                Type type2;
                Type type3 = this.m_elements[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
                if (!bl || (type2 = type3.resolveTypeAsMuchAsPossible(typeEnvironment, new HashSet())) instanceof TypeVariable) continue;
                if (type2 instanceof StreamType) {
                    typeEnvironment.unify(type, ((StreamType)type2).getElementType(), this);
                    continue;
                }
                typeEnvironment.unify(type, type2, this);
            }
        }
        return this.setCachedType(this.m_elementType.getStreamType());
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_elementType.getStreamType();
    }

    public int getChildInstructionCount() {
        return this.m_elements == null ? this.m_string.length() : this.m_elements.length;
    }

    public Instruction getChildInstruction(int n) {
        if (this.m_elements == null) {
            LiteralInstruction literalInstruction = LiteralInstruction.charLiteral(this.m_string.charAt(n));
            return literalInstruction;
        }
        return this.m_elements[n];
    }

    public void setChildInstruction(int n, Instruction instruction) {
        if (this.m_elements == null) {
            this.convertStringToArray();
        }
        this.m_elements[n] = instruction;
    }

    public int getTypeParameterCount() {
        return 1;
    }

    public Type getTypeParameter(int n) {
        return n == 0 ? this.m_elementType : null;
    }

    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_elementType = type;
        }
    }

    protected void convertStringToArray() {
        if (this.m_elements == null) {
            this.m_elements = new Instruction[this.m_string.length()];
            for (int i = 0; i < this.m_string.length(); ++i) {
                LiteralInstruction literalInstruction = LiteralInstruction.charLiteral(this.m_string.charAt(i));
                try {
                    literalInstruction.typeCheck(null, this.m_bindingEnvironment, new LinkedList());
                }
                catch (TypeCheckException typeCheckException) {
                    typeCheckException.printStackTrace();
                }
                this.m_elements[i] = literalInstruction;
            }
            this.m_string = null;
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        Instruction[] instructionArray = new Instruction[this.m_elements.length];
        for (int i = 0; i < this.m_elements.length; ++i) {
            instructionArray[i] = this.m_elements[i].cloneWithoutTypeInformation();
        }
        return new StreamInstruction(this.m_elementType, instructionArray);
    }

    public Instruction cloneShallow() {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        Instruction[] instructionArray = (Instruction[])this.m_elements.clone();
        return new StreamInstruction(this.m_elementType, instructionArray);
    }

    public String generateEscapedStringValue() {
        return LiteralInstruction.escape(this.getStringContent());
    }

    protected String makeConstant(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker) {
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        Instruction[] instructionArray = this.m_elements;
        int n = instructionArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (instructionArray[0 + i] instanceof LiteralInstruction) continue;
            bl = false;
            break;
        }
        if (bl && type.equals(CharType.s_charType)) {
            return dataFlowCodeGenerationHelper.generateConstant(codeGenerationTracker.resolveType(this).getImplementationName(dataFlowCodeGenerationHelper), dataFlowCodeGenerationHelper.generateStringConstant(this.getStringContent()));
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(codeGenerationTracker.generateConventionally(instructionArray[0 + i], dataFlowCodeGenerationHelper));
        }
        if (!dataFlowCodeGenerationHelper.isTargetCPP()) {
            return dataFlowCodeGenerationHelper.generateConstant(codeGenerationTracker.resolveType(this).getImplementationName(dataFlowCodeGenerationHelper), "new " + type.getImplementationName(dataFlowCodeGenerationHelper) + "[] { " + stringBuffer + " }");
        }
        if (n != 0) {
            throw new XylemError("ERR_SYSTEM", "Dennis, please add c++ codegen for non-empty constant streams.");
        }
        return dataFlowCodeGenerationHelper.generateConstant(codeGenerationTracker.resolveType(this).getImplementationName(dataFlowCodeGenerationHelper), "NEW_ARRAY(" + type.getImplementationName(dataFlowCodeGenerationHelper) + ", 0);");
    }

    protected void makeConstant(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder) {
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        Instruction[] instructionArray = this.m_elements;
        int n = instructionArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (instructionArray[0 + i] instanceof LiteralInstruction) continue;
            bl = false;
            break;
        }
        if (bl && type.equals(CharType.s_charType)) {
            throw new XylemError("ERR_SYSTEM", "Should not reach here");
        }
        StreamInstruction.insertStreamConstant(instructionArray, type, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
    }

    protected DataFlowCodeGenerationHelper.ConstantEntry makeConstant3(Instruction[] instructionArray, int n, int n2, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker) {
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        int n3 = -1;
        String[] stringArray = new String[n2];
        Type type2 = null;
        for (int i = 0; i < n2; ++i) {
            Instruction instruction = instructionArray[n + i];
            stringArray[i] = codeGenerationTracker.generateConventionally(instruction, dataFlowCodeGenerationHelper);
            type2 = instruction.getType(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        }
        return dataFlowCodeGenerationHelper.addConstantElements(stringArray, type2);
    }

    public static StreamInstruction charStreamLiteral(String string) {
        return new StreamInstruction(string);
    }

    public boolean isStatic(BindingEnvironment bindingEnvironment) {
        if (this.m_elements == null) {
            return true;
        }
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (this.m_elements[i] instanceof LiteralInstruction) continue;
            return false;
        }
        return true;
    }

    public static final void insertCharStreamConstant(String string, BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder) {
        String string2 = "char[]/" + string;
        if (!bCELCodeGenerationHelper.insertConstant(string2, s_charArrayType, instructionListBuilder)) {
            InstructionListBuilder instructionListBuilder2 = bCELCodeGenerationHelper.startConstantGeneration();
            int n = string.length();
            if (n < 21000) {
                instructionListBuilder2.appendConstant(string);
                instructionListBuilder2.append(instructionListBuilder2.getClassGenerationHelper().m_if.createInvoke("java.lang.String", "toCharArray", s_charArrayType, BasicType.NO_ARGS, (short)182));
            } else {
                instructionListBuilder2.appendNewAndInvokeConstructor(StringBuffer.class.getName());
                int n2 = 0;
                while (n2 < n) {
                    int n3 = Math.min(n, n2 + 21000);
                    String string3 = string.substring(n2, n3);
                    instructionListBuilder2.appendConstant(string3);
                    instructionListBuilder2.appendInvokeMethod("java.lang.StringBuffer", "append", (com.ibm.xtq.bcel.generic.Type)BasicType.STRINGBUFFER, BasicType.STRING);
                    n2 = n3;
                }
                instructionListBuilder2.append(instructionListBuilder2.getClassGenerationHelper().m_if.createInvoke("java.lang.Object", "toString", BasicType.STRING, BasicType.NO_ARGS, (short)182));
                instructionListBuilder2.append(instructionListBuilder2.getClassGenerationHelper().m_if.createInvoke("java.lang.String", "toCharArray", s_charArrayType, BasicType.NO_ARGS, (short)182));
            }
            bCELCodeGenerationHelper.finishConstantGeneration(string2, s_charArrayType, instructionListBuilder);
        }
    }

    public static final void insertStreamConstant(Instruction[] instructionArray, Type type, BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder) {
        StreamInstruction.insertStreamConstant(instructionArray, type, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder, 0, instructionArray.length);
    }

    public static final void insertStreamConstant(Instruction[] instructionArray, Type type, BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder, int n, int n2) {
        if (type.equals(CharType.s_charType)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(((Character)((LiteralInstruction)instructionArray[n + i]).getValue()).charValue());
            }
            StreamInstruction.insertCharStreamConstant(stringBuffer.toString(), bCELCodeGenerationHelper, instructionListBuilder);
        } else {
            com.ibm.xtq.bcel.generic.Type type2;
            ArrayType arrayType;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(type.prettyPrint());
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(instructionArray[n + i].toString());
            }
            String string = stringBuffer.toString();
            if (!bCELCodeGenerationHelper.insertConstant(string, arrayType = new ArrayType(type2 = type.getImplementationType(bCELCodeGenerationHelper), 1), instructionListBuilder)) {
                InstructionListBuilder instructionListBuilder2 = bCELCodeGenerationHelper.startConstantGeneration();
                instructionListBuilder2.appendNewArray(type2, n2);
                for (int i = 0; i < n2; ++i) {
                    instructionListBuilder2.appendDUP();
                    instructionListBuilder2.appendConstant(i);
                    instructionArray[n + i].generateCode(bCELCodeGenerationHelper, codeGenerationTracker, null, null, instructionListBuilder2);
                    instructionListBuilder2.append(InstructionFactory.createArrayStore(type2));
                }
                bCELCodeGenerationHelper.finishConstantGeneration(string, arrayType, instructionListBuilder);
            }
        }
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        int n;
        if (this.isString()) {
            StreamInstruction.insertCharStreamConstant(this.m_string, bCELCodeGenerationHelper, instructionListBuilder);
            return;
        }
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        this.convertStringToArray();
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this);
        int[] nArray = new int[this.m_elements.length];
        int[] nArray2 = new int[this.m_elements.length];
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.m_elements.length; ++n) {
            if (!(this.m_elements[n] instanceof LiteralInstruction)) {
                bl = true;
                n2 = n + 1;
            } else {
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
            if (type.equals(codeGenerationTracker.resolveType(this.m_elements[n]))) {
                ++n4;
                int n6 = n3;
                nArray2[n6] = nArray2[n6] + 1;
                continue;
            }
            n3 = n + 1;
        }
        if (!bl) {
            this.makeConstant(bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
            return;
        }
        if (n4 == this.m_elements.length && n4 < 5) {
            instructionListBuilder.appendNewArray(type.getImplementationType(bCELCodeGenerationHelper), this.m_elements.length);
            for (n = 0; n < this.m_elements.length; ++n) {
                Instruction instruction = this.m_elements[n];
                Type type2 = instruction.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
                instructionListBuilder.appendDUP();
                instructionListBuilder.appendConstant(n);
                codeGenerationTracker.generateConventionally(instruction, bCELCodeGenerationHelper, null, instructionListBuilder);
                instructionListBuilder.append(InstructionFactory.createArrayStore(type.getImplementationType(bCELCodeGenerationHelper)));
            }
        } else {
            int[] nArray3 = StreamType.generateCreateStream(instructionListBuilder, n4 == this.m_elements.length ? n4 : this.m_elements.length * 32, streamType, bCELCodeGenerationHelper, codeGenerationTracker);
            int n7 = 0;
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction instruction = this.m_elements[i];
                Type type3 = instruction.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
                if (!type3.equals(type)) {
                    if (!(type3 instanceof StreamType) || !((StreamType)type3).getElementType().equals(type)) {
                        throw new XylemError("ERR_SYSTEM", "type error StreamType=" + type3 + " eltType=" + type + " at " + this);
                    }
                    codeGenerationTracker.generateAddToStream(this.m_elements[i], nArray3, instructionListBuilder, streamType, bCELCodeGenerationHelper, null);
                    n7 = 0;
                    continue;
                }
                if (nArray[i] > 2) {
                    if (nArray[i] > 0) {
                        StreamInstruction.insertStreamConstant(this.m_elements, type, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder, i, nArray[i]);
                        StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray3, instructionListBuilder, type.getStreamType(), codeGenerationTracker, -1, nArray[i]);
                    }
                    n7 = nArray[i];
                    i += n7 - 1;
                    continue;
                }
                StreamType.generateGrowIfNeeded(bCELCodeGenerationHelper, nArray3, instructionListBuilder, streamType, 1);
                StreamType.generateStartAddElementToStream(bCELCodeGenerationHelper, nArray3, instructionListBuilder, streamType, codeGenerationTracker);
                codeGenerationTracker.generateConventionally(this.m_elements[i], bCELCodeGenerationHelper, null, instructionListBuilder);
                StreamType.generateFinishAddElementToStream(bCELCodeGenerationHelper, nArray3, instructionListBuilder, streamType, codeGenerationTracker);
                n7 = 0;
            }
            StreamType.generateCompactStream(nArray3, instructionListBuilder, streamType, bCELCodeGenerationHelper, codeGenerationTracker);
        }
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        int n;
        if (this.isString()) {
            return dataFlowCodeGenerationHelper.generateConstant(codeGenerationTracker.resolveType(this).getImplementationName(dataFlowCodeGenerationHelper), dataFlowCodeGenerationHelper.generateStringConstant(this.m_string));
        }
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        this.convertStringToArray();
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this);
        int[] nArray = new int[this.m_elements.length];
        int[] nArray2 = new int[this.m_elements.length];
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.m_elements.length; ++n) {
            if (!(this.m_elements[n] instanceof LiteralInstruction)) {
                bl2 = true;
                n2 = n + 1;
            } else {
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
            if (type.equals(codeGenerationTracker.resolveType(this.m_elements[n]))) {
                ++n4;
                int n6 = n3;
                nArray2[n6] = nArray2[n6] + 1;
                continue;
            }
            n3 = n + 1;
        }
        if (!bl2) {
            return this.makeConstant(dataFlowCodeGenerationHelper, codeGenerationTracker);
        }
        if (n4 == this.m_elements.length && n4 < 5) {
            String string3 = type.getImplementationName(dataFlowCodeGenerationHelper);
            if (string3.endsWith("[]")) {
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "new " + string3.substring(0, string3.length() - 2) + "[" + this.m_elements.length + "][]", codeGenerationTracker);
            } else if (dataFlowCodeGenerationHelper.isTargetCPP()) {
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "NEW_ARRAY(" + string3 + ", " + this.m_elements.length + ")", codeGenerationTracker);
            } else {
                dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), "new " + string3 + "[" + this.m_elements.length + "]", codeGenerationTracker);
            }
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction instruction = this.m_elements[i];
                Type type2 = instruction.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
                String string4 = codeGenerationTracker.generateConventionally(instruction, dataFlowCodeGenerationHelper);
                dataFlowCodeGenerationHelper.append(string2 + "[" + i + "] = " + string4 + ";\n");
            }
        } else {
            StreamType.generateCreateStream(string2, n4 == this.m_elements.length ? n4 : this.m_elements.length * 32, streamType, dataFlowCodeGenerationHelper);
            n = 0;
            for (int i = 0; i < this.m_elements.length; ++i) {
                String[] stringArray;
                Instruction instruction = this.m_elements[i];
                Type type3 = instruction.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment).resolveType(codeGenerationTracker.m_typeEnvironment);
                if (!type3.equals(type)) {
                    if (!(type3 instanceof StreamType) || !((StreamType)type3).getElementType().equals(type)) {
                        throw new XylemError("ERR_SYSTEM", "type error StreamType=" + type3 + " eltType=" + type + " at " + this);
                    }
                    codeGenerationTracker.generateAddToStream(this.m_elements[i], string2, streamType, dataFlowCodeGenerationHelper, false);
                    n = 0;
                    continue;
                }
                if (nArray[i] > 2) {
                    stringArray = this.makeConstant3(this.m_elements, i, nArray[i], dataFlowCodeGenerationHelper, codeGenerationTracker);
                    StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string2, streamType, dataFlowCodeGenerationHelper.isTargetJava() ? dataFlowCodeGenerationHelper.getClassName() + "." + stringArray.m_identifier : stringArray.m_identifier, Integer.toString(nArray[i]), -1);
                    n = nArray[i];
                    i += n - 1;
                    continue;
                }
                stringArray = new String[nArray2[i - n] - n];
                for (int j = 0; j < stringArray.length; ++j) {
                    stringArray[j] = codeGenerationTracker.generateConventionally(this.m_elements[i + j], dataFlowCodeGenerationHelper);
                }
                StreamType.generateAddElementToStream(dataFlowCodeGenerationHelper, string2, streamType, stringArray, n4 == this.m_elements.length);
                i += stringArray.length - 1;
                n = 0;
            }
            StreamType.generateCompactStream(string2, streamType, dataFlowCodeGenerationHelper);
        }
        return string2;
    }

    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        int n;
        if (this.isString()) {
            int n2 = this.m_string.length();
            if (0 < n2) {
                StreamInstruction.insertCharStreamConstant(this.m_string, bCELCodeGenerationHelper, instructionListBuilder);
                StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, this.s_charStreamType, codeGenerationTracker, -1, -1, -1, n2);
            }
            return;
        }
        this.convertStringToArray();
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this);
        int[] nArray2 = new int[this.m_elements.length];
        int[] nArray3 = new int[this.m_elements.length];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.m_elements.length; ++n) {
            if (!(this.m_elements[n] instanceof LiteralInstruction)) {
                bl = true;
                n3 = n + 1;
            } else {
                int n6 = n3;
                nArray2[n6] = nArray2[n6] + 1;
            }
            if (codeGenerationTracker.resolveType(this.m_elements[n]).equals(type)) {
                ++n5;
                int n7 = n4;
                nArray3[n7] = nArray3[n7] + 1;
                continue;
            }
            n4 = n + 1;
        }
        n = 0;
        for (int i = 0; i < this.m_elements.length; ++i) {
            Instruction instruction = this.m_elements[i];
            Type type2 = codeGenerationTracker.resolveType(instruction);
            if (type2 == null) {
                throw new RuntimeException();
            }
            if (!type2.equals(type)) {
                if (!(type2 instanceof StreamType) || !((StreamType)type2).getElementType().equals(type)) {
                    throw new XylemError("ERR_SYSTEM", "codegen type error at " + instruction + " in " + this);
                }
                codeGenerationTracker.generateAddToStream(this.m_elements[i], nArray, instructionListBuilder, streamType, bCELCodeGenerationHelper, i == this.m_elements.length - 1 ? instructionHandle : null);
                n = 0;
                continue;
            }
            if (nArray2[i] > 2) {
                if (nArray2[i] > 0) {
                    StreamInstruction.insertStreamConstant(this.m_elements, type, bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder, i, nArray2[i]);
                    StreamType.generateAddMultipleElementsToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, type.getStreamType(), codeGenerationTracker, -1, -1, -1, nArray2[i]);
                }
                n = nArray2[i];
                i += n - 1;
                continue;
            }
            StreamType.generateGrowIfNeeded(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, 1);
            StreamType.generateStartAddElementToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, codeGenerationTracker);
            codeGenerationTracker.generateConventionally(this.m_elements[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            StreamType.generateFinishAddElementToStream(bCELCodeGenerationHelper, nArray, instructionListBuilder, streamType, codeGenerationTracker);
        }
    }

    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        int n;
        int n2 = CodeGenerationOptUtils.getStreamLength(this, codeGenerationTracker.m_bindingEnvironment);
        if (n2 == 0) {
            return;
        }
        this.convertStringToArray();
        Type type = this.m_elementType.resolveType(codeGenerationTracker.m_typeEnvironment);
        StreamType streamType = (StreamType)codeGenerationTracker.resolveType(this);
        int[] nArray = new int[this.m_elements.length];
        int[] nArray2 = new int[this.m_elements.length];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.m_elements.length; ++n) {
            if (!(this.m_elements[n] instanceof LiteralInstruction)) {
                n3 = n + 1;
            } else {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
            }
            if (codeGenerationTracker.resolveType(this.m_elements[n]).equals(type)) {
                ++n5;
                int n7 = n4;
                nArray2[n7] = nArray2[n7] + 1;
                continue;
            }
            n4 = n + 1;
        }
        n = 0;
        for (int i = 0; i < this.m_elements.length; ++i) {
            String[] stringArray;
            Instruction instruction = this.m_elements[i];
            Type type2 = codeGenerationTracker.resolveType(instruction);
            if (type2 == null) {
                throw new RuntimeException();
            }
            if (!type2.equals(type)) {
                if (!(type2 instanceof StreamType) || !((StreamType)type2).getElementType().equals(type)) {
                    throw new XylemError("ERR_SYSTEM", "codegen type error at " + instruction + " in " + this);
                }
                codeGenerationTracker.generateAddToStream(this.m_elements[i], string, streamType, dataFlowCodeGenerationHelper, bl && i == this.m_elements.length - 1);
                n = 0;
                continue;
            }
            if (nArray[i] > 2) {
                stringArray = this.makeConstant3(this.m_elements, i, nArray[i], dataFlowCodeGenerationHelper, codeGenerationTracker);
                StreamType.generateAddMultipleElementsToStream(dataFlowCodeGenerationHelper, string, streamType, dataFlowCodeGenerationHelper.isTargetJava() ? dataFlowCodeGenerationHelper.getClassName() + "." + stringArray.m_identifier : stringArray.m_identifier, Integer.toString(nArray[i]), -1);
                n = nArray[i];
                i += n - 1;
                continue;
            }
            stringArray = new String[nArray2[i - n] - n];
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray[j] = codeGenerationTracker.generateConventionally(this.m_elements[i + j], dataFlowCodeGenerationHelper);
            }
            StreamType.generateAddElementToStream(dataFlowCodeGenerationHelper, string, streamType, stringArray, false);
            i += stringArray.length - 1;
            n = 0;
        }
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        if (this.m_elements != null) {
            int n = this.m_elements.length;
            Instruction[] instructionArray2 = this.m_elements;
            for (int i = 0; i < n; ++i) {
                Instruction instruction = this.m_elements[i];
                instructionArray2[i] = reductionHelper.reduceToBasicInstruction(instructionArray, instruction, bindingEnvironment);
            }
            this.m_elements = instructionArray2;
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        if (this.isString()) {
            prettyPrinter.printToken("\"" + LiteralInstruction.escape(this.m_string) + "\"", n);
            return;
        }
        prettyPrinter.newline();
        prettyPrinter.printFormOpen("stream", n);
        prettyPrinter.printToken(this.getElementType().prettyPrint(), n + 1);
        for (int i = 0; i < this.m_elements.length; ++i) {
            this.m_elements[i].toString(prettyPrinter, n + 1);
        }
        prettyPrinter.print(")");
    }

    public String getStringContent() {
        if (this.m_string != null) {
            return this.m_string;
        }
        if (this.isStatic(null) && this.getElementType().equals(CharType.s_charType)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_elements.length; ++i) {
                if (!(this.m_elements[i] instanceof LiteralInstruction) || !(((LiteralInstruction)this.m_elements[i]).getValue() instanceof Character)) {
                    return null;
                }
                stringBuffer.append(((Character)((LiteralInstruction)this.m_elements[i]).getValue()).charValue());
            }
            this.m_string = stringBuffer.toString();
            this.m_elements = null;
            return this.m_string;
        }
        return null;
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if (this.m_elements == null) {
            StringStream stringStream = new StringStream(this.m_string);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, stringStream);
        }
        IConvertible iConvertible = this.m_elementType.equals(CharType.s_charType) ? new CharArrayWriterStream() : (this.m_elementType instanceof TagType ? new TagStream() : new ListStream());
        for (int i = 0; i < this.m_elements.length; ++i) {
            this.m_elements[i].evaluate((IAppendableStream)((Object)iConvertible), environment, function, iDebuggerInterceptor);
        }
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, iConvertible);
    }

    public void evaluate(IAppendableStream iAppendableStream, Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if (this.m_elements == null) {
            iAppendableStream.append(new StringStream(this.m_string));
            Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
            return;
        }
        if (this.m_elementType.equals(CharType.s_charType)) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
            }
        } else {
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i].evaluate(iAppendableStream, environment, function, iDebuggerInterceptor);
            }
        }
        Debugger.leave(iDebuggerInterceptor, this, environment, function, null);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof StreamInstruction)) {
            return false;
        }
        StreamInstruction streamInstruction = (StreamInstruction)object;
        if (streamInstruction.m_string != null && this.m_string != null) {
            return this.m_string.equals(streamInstruction.m_string);
        }
        if (streamInstruction.m_elements != null && this.m_elements != null) {
            int n;
            if (streamInstruction.m_elements.length != this.m_elements.length) {
                return false;
            }
            if (this.m_elementType != null && streamInstruction.m_elementType != null && this.m_elementType != streamInstruction.m_elementType) {
                return false;
            }
            for (n = 0; n < this.m_elements.length; ++n) {
                if (this.m_elements[n].hashCode() == streamInstruction.m_elements[n].hashCode()) continue;
                return false;
            }
            for (n = 0; n < this.m_elements.length; ++n) {
                if (this.m_elements[n].equals(streamInstruction.m_elements[n])) continue;
                return false;
            }
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.m_elementType.equals(streamInstruction.m_elementType);
    }

    public void determineDataDependencies(Binding[] bindingArray, HashMap hashMap, Instruction instruction, int n, BindingEnvironment bindingEnvironment) {
        if (this.m_string != null) {
            return;
        }
        super.determineDataDependencies(bindingArray, hashMap, instruction, n, bindingEnvironment);
    }

    public void determineDataDependencies(Set set) {
        if (this.m_string != null) {
            return;
        }
        super.determineDataDependencies(set);
    }

    public void setElements(Instruction[] instructionArray) {
        this.m_elements = instructionArray;
        this.m_string = null;
    }

    public void replaceTypeVariables(Map map) {
        super.replaceTypeVariables(map);
        this.m_elementType = this.m_elementType.replaceType(map);
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }

    public Instruction replaceBindings(Map map) {
        if (this.m_string != null) {
            return this;
        }
        return super.replaceBindings(map);
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        return super.assignNewNames(map, iNewNameGenerator);
    }

    public Instruction cloneReduced() {
        if (this.m_string != null) {
            return new StreamInstruction(this.m_string);
        }
        return super.cloneReduced();
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        if (readObjectFileHelper.readByte() == 1) {
            this.m_string = readObjectFileHelper.readString();
            this.m_elementType = CharType.s_charType;
        } else {
            this.m_elementType = readObjectFileHelper.readType();
            this.m_elements = new Instruction[readObjectFileHelper.readInt()];
            for (int i = 0; i < this.m_elements.length; ++i) {
                this.m_elements[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
            }
        }
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        if (this.m_string != null) {
            writeObjectFileHelper.writeByte(1);
            writeObjectFileHelper.writeString(this.m_string);
        } else {
            writeObjectFileHelper.writeByte(0);
            writeObjectFileHelper.writeType(this.m_elementType);
            super.write(writeObjectFileHelper);
        }
    }

    public int byteCodeSize() {
        if (this.m_string != null) {
            return 4;
        }
        return 2 + 2 * this.getChildInstructionCount();
    }

    public int accumulateByteCodeSize() {
        if (this.m_string == null) {
            return super.accumulateByteCodeSize();
        }
        return 4;
    }

    public void clearTypeInformation() {
        if (this.m_string == null) {
            super.clearTypeInformation();
        } else {
            this.m_hasBeenTypechecked = false;
            this.m_bindingEnvironment = null;
        }
    }

    public void standardizeTypes(Set set, TypeEnvironment typeEnvironment) {
        if (this.m_string != null) {
            this.m_elementType = this.m_elementType.resolveTypeAsMuchAsPossible(typeEnvironment, set);
            Type type = this.getCachedType();
            if (type != null) {
                this.setCachedType(type.resolveTypeAsMuchAsPossible(typeEnvironment, set));
            }
        } else {
            super.standardizeTypes(set, typeEnvironment);
        }
    }

    public Instruction removeAliases(HashMap hashMap) {
        if (this.m_string != null) {
            return this;
        }
        return super.removeAliases(hashMap);
    }

    public void split(int n) {
        if (this.m_string != null) {
            throw new XylemError("ERR_SYSTEM", "can't split String stream!");
        }
        if (n <= 0) {
            throw new XylemError("ERR_SYSTEM", "can't split with zero grain!");
        }
        LinkedList<StreamInstruction> linkedList = new LinkedList<StreamInstruction>();
        LinkedList<Instruction> linkedList2 = new LinkedList<Instruction>();
        for (int i = 0; i < this.m_elements.length; ++i) {
            if (i > 0 && i % n == 0) {
                StreamInstruction streamInstruction = new StreamInstruction(this.getElementType(), linkedList2);
                linkedList.add(streamInstruction);
                linkedList2 = new LinkedList();
            }
            linkedList2.add(this.m_elements[i].cloneWithoutTypeInformation());
        }
        if (linkedList2.size() > 0) {
            StreamInstruction streamInstruction = new StreamInstruction(this.getElementType(), linkedList2);
            linkedList.add(streamInstruction);
        }
        Object[] objectArray = linkedList.toArray();
        this.m_elements = new Instruction[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_elements[i] = (Instruction)objectArray[i];
        }
    }

    public void split() {
        if (this.m_elements == null) {
            throw new XylemError("ERR_SYSTEM", "StreamInstruction.m_elements: NULL");
        }
        this.split(this.m_elements.length / 2);
    }

    protected int doesDescendentCountExceedThresholdHelper(int n) {
        if (this.isStoredAsString()) {
            return n;
        }
        return super.doesDescendentCountExceedThresholdHelper(n);
    }

    public Type typeCheckDestruction(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) throws TypeCheckException {
        if (!this.isString()) {
            for (int i = 0; i < this.m_elements.length; ++i) {
                Instruction instruction = this.m_elements[i];
                if (!(instruction instanceof IMatchDestructable)) {
                    throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", instruction + " not supported in match2 pattern"), this);
                }
                ((IMatchDestructable)((Object)instruction)).typeCheckDestruction(typeEnvironment, bindingEnvironment);
            }
        }
        return this.m_elementType.getStreamType();
    }

    public Instruction desugarDestruction(Instruction instruction, ReductionHelper reductionHelper, IMatchDestructable.Generator generator, IMatchDestructable.Generator generator2, BindingEnvironment bindingEnvironment) {
        if (this.isString()) {
            Object object = reductionHelper.generateReducedIdentifier("");
            Object object2 = reductionHelper.generateReducedIdentifier("");
            LetInstruction letInstruction = new LetInstruction(object2, new DeepEqualityInstruction(instruction, new IdentifierInstruction(object)), new ChooseInstruction(new IdentifierInstruction(object2), generator.generate(), generator2.generate()));
            LetInstruction letInstruction2 = new LetInstruction(object, this, letInstruction);
            return letInstruction2;
        }
        return null;
    }
}

