/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.ClassType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.UnitType;
import java.io.IOException;
import java.util.LinkedList;

public class SuperMethodInvocationInstruction
extends NaryPrimopInstruction {
    protected Type m_classType;
    protected String m_function;

    public SuperMethodInvocationInstruction() {
    }

    public SuperMethodInvocationInstruction(Type type, String string, Instruction[] instructionArray) {
        super(instructionArray);
        this.m_classType = type;
        this.m_function = string;
    }

    public String getFunction() {
        return this.m_function;
    }

    public void setFunction(String string) {
        this.m_function = string;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_classType;
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Invalid type: " + this.m_classType), this);
        }
        if (!(type instanceof NamedType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_classType + " is not a class type"), this);
        }
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        if (method == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + classType.getName() + " has no method named " + this.m_function), this);
        }
        Binding[] bindingArray = method.m_parameters;
        if (bindingArray.length != this.m_parameters.length) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Method " + this.m_function + " of class " + classType.getName() + " takes " + method.m_parameters.length + " parameters"), this);
        }
        for (int i = 0; i < bindingArray.length; ++i) {
            typeEnvironment.unify(bindingArray[i].getBindingType(), this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        }
        return this.setCachedType(method.getReturnType());
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_classType;
        type = type.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type).resolveName(typeEnvironment);
        ClassType.Method method = classType.resolveMethod(this.m_function, typeEnvironment);
        return typeEnvironment.getModule().getFunction(method.getFunction()).getReturnType();
    }

    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new SuperMethodInvocationInstruction(this.m_classType, this.m_function, instructionArray);
    }

    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new SuperMethodInvocationInstruction(this.m_classType, this.m_function, instructionArray);
    }

    public String innerToString() {
        return "super-method-invoke";
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        Object object;
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            object = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            stringBuffer.append((String)object);
        }
        String string3 = "super";
        object = codeGenerationTracker.resolveType(this);
        Type type = this.m_classType.resolveType(typeEnvironment);
        ClassType classType = (ClassType)((NamedType)type).resolveName(codeGenerationTracker.m_typeEnvironment);
        ClassType.Method method = (ClassType.Method)classType.m_methods.get(this.m_function);
        String string4 = string3 + "." + method.getName() + "(" + stringBuffer.toString() + ")";
        if (method.getReturnType() instanceof UnitType) {
            dataFlowCodeGenerationHelper.append(string4 + ";\n");
            string4 = "1";
        }
        dataFlowCodeGenerationHelper.appendAssignment(string2, method.getReturnType(), string4, codeGenerationTracker);
        return string2;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SuperMethodInvocationInstruction superMethodInvocationInstruction = (SuperMethodInvocationInstruction)object;
        return superMethodInvocationInstruction.m_function.equals(this.m_function);
    }

    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_classType = readObjectFileHelper.readType();
        this.m_function = readObjectFileHelper.readString();
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_classType);
        writeObjectFileHelper.writeString(this.m_function);
    }

    public int getTypeParameterCount() {
        return 1;
    }

    public Type getTypeParameter(int n) {
        return n == 0 ? this.m_classType : null;
    }

    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_classType = type;
        }
    }
}

