/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.ObjectType;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import java.io.IOException;
import java.util.LinkedList;

public class TryCatchInstruction
extends Instruction
implements ISpecialForm {
    protected Instruction m_body;
    protected Instruction m_handler;

    public TryCatchInstruction() {
    }

    public TryCatchInstruction(Instruction instruction, Instruction instruction2) {
        this.m_body = instruction;
        this.m_handler = instruction2;
    }

    public Instruction getHandler() {
        return this.m_handler;
    }

    public void setHandler(Instruction instruction) {
        this.m_handler = instruction;
    }

    public Instruction getBody() {
        return this.m_body;
    }

    public void setBody(Instruction instruction) {
        this.m_body = instruction;
    }

    public int getChildInstructionCount() {
        return 2;
    }

    public Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_body;
            }
            case 1: {
                return this.m_handler;
            }
        }
        return null;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_body = instruction;
                break;
            }
            case 1: {
                this.m_handler = instruction;
            }
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        return new TryCatchInstruction(this.m_body.cloneWithoutTypeInformation(), this.m_handler.cloneWithoutTypeInformation());
    }

    public Instruction cloneShallow() {
        return new TryCatchInstruction(this.m_body, this.m_handler);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_body.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.m_handler.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(this.m_body.getCachedType());
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_body.getType(typeEnvironment, bindingEnvironment);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.append(codeGenerationTracker.resolveType(this).getImplementationName(dataFlowCodeGenerationHelper) + " " + string2 + ";\n");
        dataFlowCodeGenerationHelper.append("try {\n");
        String string3 = this.m_body.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, bl);
        dataFlowCodeGenerationHelper.append(string2 + " = " + string3 + ";\n");
        dataFlowCodeGenerationHelper.append("} catch (Exception e) {\n");
        dataFlowCodeGenerationHelper.append("throw new com.ibm.xylem.utils.WrappedRuntimeException(e);\n");
        dataFlowCodeGenerationHelper.append("}\n");
        return string2;
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        InstructionHandle instructionHandle2;
        InstructionHandle instructionHandle3 = instructionListBuilder.appendNOP();
        this.m_body.generateCode(bCELCodeGenerationHelper, codeGenerationTracker.cloneBranch(), string, instructionHandle, instructionListBuilder);
        InstructionHandle instructionHandle4 = instructionListBuilder.appendNOP();
        Function function = codeGenerationTracker.getFunction();
        if (!function.getTryFlag()) {
            BranchInstruction branchInstruction = instructionListBuilder.appendGoto();
            instructionHandle2 = instructionListBuilder.appendInvokeMethod(Throwable.class.getName(), "printStackTrace", com.ibm.xtq.bcel.generic.Type.VOID);
            instructionListBuilder.appendThrowRuntimeSystemError("Exception caught");
            branchInstruction.setTarget(instructionListBuilder.appendNOP());
            function.setTryFlag(true);
            function.setExceptionHandle(instructionHandle2);
        } else {
            instructionHandle2 = function.getExceptionHandle();
        }
        instructionListBuilder.addExceptionHandler(instructionHandle3, instructionHandle4, instructionHandle2, new ObjectType(Exception.class.getName()));
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        this.m_body = reductionHelper.reduce(this.m_body, bindingEnvironment);
        this.m_handler = reductionHelper.reduce(this.m_handler, bindingEnvironment);
        this.m_bindingEnvironment = null;
        instructionArray[0] = this;
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printlnFormOpen("try", n);
        this.m_body.toString(prettyPrinter, n + 1);
        this.m_handler.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = this.m_body.evaluate(environment, function, iDebuggerInterceptor, bl);
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_body);
        writeObjectFileHelper.writeInstruction(this.m_handler);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_body = readObjectFileHelper.readInstruction(bindingEnvironment);
        this.m_handler = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    public boolean isChildInstructionBody(int n) {
        return true;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        return NO_BINDINGS;
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return false;
    }

    public String innerToString() {
        return "try";
    }
}

