/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.INewNameGenerator;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class TypeMatchInstruction
extends Instruction
implements IStreamOptimizationInstruction,
IStreamInADTOptimizationInstruction,
ISpecialForm {
    protected Match[] m_matches;
    protected Instruction m_toMatch;
    protected Instruction m_default;

    public TypeMatchInstruction() {
    }

    public TypeMatchInstruction(Instruction instruction, Match[] matchArray, Instruction instruction2) {
        this.m_toMatch = instruction;
        this.m_matches = matchArray;
        this.m_default = instruction2;
    }

    public int getChildInstructionCount() {
        return (this.m_default == null ? 1 : 2) + this.m_matches.length;
    }

    public Instruction getChildInstruction(int n) {
        if (this.m_default != null) {
            if (n == 0) {
                return this.m_default;
            }
            --n;
        }
        switch (n) {
            case 0: {
                return this.m_toMatch;
            }
        }
        return this.m_matches[n - 1].m_handler;
    }

    public void setChildInstruction(int n, Instruction instruction) {
        if (this.m_default != null) {
            if (n == 0) {
                this.m_default = instruction;
                return;
            }
            --n;
        }
        switch (n) {
            case 0: {
                this.m_toMatch = instruction;
                break;
            }
            default: {
                this.m_matches[n - 1].m_handler = instruction;
            }
        }
    }

    public Instruction cloneWithoutTypeInformation() {
        Match[] matchArray = new Match[this.m_matches.length];
        for (int i = 0; i < matchArray.length; ++i) {
            matchArray[i] = this.m_matches[i].cloneWithoutTypeInformation();
        }
        return new TypeMatchInstruction(this.m_toMatch.cloneWithoutTypeInformation(), matchArray, this.m_default == null ? null : this.m_default.cloneWithoutTypeInformation());
    }

    public Instruction cloneShallow() {
        Match[] matchArray = new Match[this.m_matches.length];
        for (int i = 0; i < matchArray.length; ++i) {
            matchArray[i] = this.m_matches[i].cloneShallow();
        }
        return new TypeMatchInstruction(this.m_toMatch, matchArray, this.m_default);
    }

    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = null;
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = this.m_matches[i];
            Type type2 = match.doTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
            if (type == null) {
                type = type2;
                continue;
            }
            typeEnvironment.unify(type2, type, this);
        }
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "tuple-match requires at least one case"), this);
        }
        if (this.m_default != null) {
            typeEnvironment.unify(type, this.m_default.typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        }
        this.m_toMatch.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        return this.setCachedType(type);
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = this.m_matches[i];
            match.doTypeCheckReduced(typeEnvironment, bindingEnvironment);
        }
        super.typeCheckReduced(typeEnvironment, bindingEnvironment, linkedList);
    }

    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_default != null ? this.m_default.getType(typeEnvironment, bindingEnvironment) : this.m_matches[0].getHandler().getType(typeEnvironment, bindingEnvironment);
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        Match match = this.getEffectiveMatch(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (match != null) {
            codeGenerationTracker = codeGenerationTracker.cloneBranch();
            codeGenerationTracker.registerBinding((IBinding)match.m_binding, this.m_toMatch);
            return match.m_handler.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker, null, bl);
        }
        if (this.m_default != null) {
            return this.m_default.generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, bl);
        }
        throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        Match match = this.getEffectiveMatch(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (match != null) {
            codeGenerationTracker = codeGenerationTracker.cloneBranch();
            codeGenerationTracker.registerBinding((IBinding)match.m_binding, this.m_toMatch);
            match.m_handler.generateCode(bCELCodeGenerationHelper, codeGenerationTracker, null, instructionHandle, instructionListBuilder);
        } else if (this.m_default != null) {
            this.m_default.generateCode(bCELCodeGenerationHelper, codeGenerationTracker.cloneBranch(), null, instructionHandle, instructionListBuilder);
        } else {
            throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
        }
    }

    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Match match = this.getEffectiveMatch(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (match != null) {
            codeGenerationTracker = codeGenerationTracker.cloneBranch();
            codeGenerationTracker.registerBinding((IBinding)match.m_binding, this.m_toMatch);
            return ((IStreamInADTOptimizationInstruction)((Object)match.m_handler)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string, binding, codeGenerationTracker.cloneBranch(), bl, bl2);
        }
        if (this.m_default != null) {
            return ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string, binding, codeGenerationTracker.cloneBranch(), bl, bl2);
        }
        throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
    }

    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        Match match = this.getEffectiveMatch(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (match != null) {
            codeGenerationTracker = codeGenerationTracker.cloneBranch();
            codeGenerationTracker.registerBinding((IBinding)match.m_binding, this.m_toMatch);
            ((IStreamInADTOptimizationInstruction)((Object)match.m_handler)).generateCode(bCELCodeGenerationHelper, nArray, binding, codeGenerationTracker.cloneBranch(), bl, instructionHandle, instructionListBuilder);
        } else if (this.m_default != null) {
            ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).generateCode(bCELCodeGenerationHelper, nArray, binding, codeGenerationTracker.cloneBranch(), bl, instructionHandle, instructionListBuilder);
        } else {
            throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
        }
    }

    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        Match match = this.getEffectiveMatch(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (match != null) {
            codeGenerationTracker = codeGenerationTracker.cloneBranch();
            codeGenerationTracker.registerBinding((IBinding)match.m_binding, this.m_toMatch);
            ((IStreamOptimizationInstruction)((Object)match.m_handler)).generateCodeWithStreamOptimization(dataFlowCodeGenerationHelper, string, codeGenerationTracker, bl);
        } else if (this.m_default != null) {
            ((IStreamOptimizationInstruction)((Object)this.m_default)).generateCodeWithStreamOptimization(dataFlowCodeGenerationHelper, string, codeGenerationTracker.cloneBranch(), bl);
        } else {
            throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
        }
    }

    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        Match match = this.getEffectiveMatch(codeGenerationTracker.m_typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (match != null) {
            codeGenerationTracker = codeGenerationTracker.cloneBranch();
            codeGenerationTracker.registerBinding((IBinding)match.m_binding, this.m_toMatch);
            ((IStreamOptimizationInstruction)((Object)match.m_handler)).generateCodeWithStreamOptimization(bCELCodeGenerationHelper, instructionListBuilder, nArray, codeGenerationTracker, instructionHandle);
        } else if (this.m_default != null) {
            ((IStreamOptimizationInstruction)((Object)this.m_default)).generateCodeWithStreamOptimization(bCELCodeGenerationHelper, instructionListBuilder, nArray, codeGenerationTracker.cloneBranch(), instructionHandle);
        } else {
            throw new XylemError("ERR_SYSTEM", "type-match never matched any type");
        }
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Type type = this.m_toMatch.getCachedType();
        Instruction instruction = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_toMatch, bindingEnvironment);
        if (type == null) {
            throw new RuntimeException();
        }
        if (type.resolveType(reductionHelper.m_typeEnvironment) == null) {
            this.m_toMatch = instruction;
            for (Match match : this.m_matches) {
                ReductionHelper reductionHelper2 = (ReductionHelper)reductionHelper.clone();
                reductionHelper2.upgradeBinding(match.m_binding);
                bindingEnvironment.setVariableBinding(match.m_binding);
                match.m_handler = reductionHelper2.reduce(match.m_handler, bindingEnvironment);
            }
            ReductionHelper reductionHelper3 = (ReductionHelper)reductionHelper.clone();
            if (this.m_default != null) {
                this.m_default = reductionHelper3.reduce(this.m_default, bindingEnvironment);
            }
            this.m_bindingEnvironment = null;
            instructionArray[0] = this;
        } else {
            Match match = this.getEffectiveMatch(reductionHelper.m_typeEnvironment, bindingEnvironment);
            if (match != null) {
                ReductionHelper reductionHelper4 = (ReductionHelper)reductionHelper.clone();
                reductionHelper4.registerConvertedBinding(match.m_binding, ((IdentifierInstruction)instruction).getBinding(bindingEnvironment));
                instructionArray[0] = reductionHelper4.reduceToBasicInstruction(instructionArray, match.getHandler(), bindingEnvironment);
            } else {
                ReductionHelper reductionHelper5 = (ReductionHelper)reductionHelper.clone();
                instructionArray[0] = reductionHelper5.reduceToBasicInstruction(instructionArray, this.m_default, bindingEnvironment);
            }
        }
    }

    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Match match = this.getEffectiveMatch(typeEnvironment, bindingEnvironment);
        if (match != null) {
            return match.m_handler.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        if (this.m_default != null) {
            return this.m_default.supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        throw new XylemError("ERR_SYSTEM", "type-match has no matching case");
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypeMatchInstruction)) {
            return false;
        }
        return super.equals(object);
    }

    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        for (int i = 0; i < this.m_matches.length; ++i) {
            if (((IStreamInADTOptimizationInstruction)((Object)this.m_matches[i].m_handler)).canGenerateObjectless(typeEnvironment)) continue;
            return false;
        }
        return this.m_default == null || ((IStreamInADTOptimizationInstruction)((Object)this.m_default)).canGenerateObjectless(typeEnvironment);
    }

    public Instruction getToMatch() {
        return this.m_toMatch;
    }

    public Match[] getMatches() {
        return this.m_matches;
    }

    public Instruction getDefault() {
        return this.m_default;
    }

    public void setDefault(Instruction instruction) {
        this.m_default = instruction;
    }

    public Match getEffectiveMatch(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_toMatch.getCachedType();
        if (type == null) {
            type = this.m_toMatch.getType(typeEnvironment, bindingEnvironment);
        }
        type = type.resolveType(typeEnvironment);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = this.m_matches[i];
            if (!match.m_binding.getBindingType().resolveType(typeEnvironment).equals(type)) continue;
            return match;
        }
        return null;
    }

    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        Match match;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((match = this.getEffectiveMatch(function.getTypeEnvironment(), this.getBindingEnvironment() == null ? function.getBindingEnvironment() : this.getBindingEnvironment())) == null) {
            if (this.m_default == null) {
                throw new RuntimeException();
            }
            Object object = this.m_default.evaluate(environment, function, iDebuggerInterceptor, bl);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object);
        }
        Object object = this.m_toMatch.evaluate(environment, function, iDebuggerInterceptor, false);
        Object object2 = environment.bind(match.m_binding, object);
        Object object3 = null;
        try {
            object3 = match.getHandler().evaluate(environment, function, iDebuggerInterceptor, bl);
        }
        catch (FunctionCallInstruction.TailCallEvent tailCallEvent) {
            environment.bind(match.m_binding, object2);
            throw tailCallEvent;
        }
        environment.bind(match.m_binding, object2);
        Object object4 = object3;
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, object4);
    }

    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen("type-match", n);
        this.m_toMatch.toString(prettyPrinter, n + 1);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = this.m_matches[i];
            match.toString(prettyPrinter, n + 1);
        }
        if (this.m_default != null) {
            prettyPrinter.printFormOpen("otherwise", n + 1);
            this.m_default.toString(prettyPrinter, n + 2);
            prettyPrinter.printFormClose(n + 1);
        }
        prettyPrinter.printFormClose(n);
    }

    public void accumulateNonLiteralFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateNonLiteralFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = this.m_matches[i];
            set.remove(match.m_binding);
        }
    }

    public void accumulateFreeBindings(Set set, BindingEnvironment bindingEnvironment) {
        super.accumulateFreeBindings(set, bindingEnvironment);
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = this.m_matches[i];
            set.remove(match.m_binding);
        }
    }

    public Instruction assignNewNames(Map map, INewNameGenerator iNewNameGenerator) {
        Match[] matchArray = new Match[this.m_matches.length];
        for (int i = 0; i < this.m_matches.length; ++i) {
            Match match = matchArray[i] = this.m_matches[i].cloneShallow();
            Object object = iNewNameGenerator.getNewName();
            map.put(match.m_binding.getName(), new IdentifierInstruction(object));
            match.m_binding.setName(object);
            match.m_handler = match.m_handler.assignNewNames(map, iNewNameGenerator);
        }
        return new TypeMatchInstruction(this.m_toMatch.assignNewNames(map, iNewNameGenerator), matchArray, this.m_default == null ? null : this.m_default.assignNewNames(map, iNewNameGenerator));
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_toMatch);
        writeObjectFileHelper.writeBoolean(this.m_default != null);
        if (this.m_default != null) {
            writeObjectFileHelper.writeInstruction(this.m_default);
        }
        int n = this.m_matches.length;
        writeObjectFileHelper.writeInt(n);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeType(this.m_matches[i].m_binding.getBindingType());
            writeObjectFileHelper.writeBindingName(this.m_matches[i].m_binding.getName());
            writeObjectFileHelper.writeInstruction(this.m_matches[i].m_handler);
        }
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_toMatch = readObjectFileHelper.readInstruction(bindingEnvironment);
        boolean bl = readObjectFileHelper.readBoolean();
        if (bl) {
            this.m_default = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
        int n = readObjectFileHelper.readInt();
        this.m_matches = new Match[n];
        for (int i = 0; i < n; ++i) {
            this.m_matches[i] = new Match(readObjectFileHelper.readType(), readObjectFileHelper.readBindingName(), readObjectFileHelper.readInstruction(bindingEnvironment));
        }
    }

    public boolean isChildInstructionBody(int n) {
        return this.getChildInstructionBindings(n) != null;
    }

    public IBinding[] getChildInstructionBindings(int n) {
        if (this.m_default != null) {
            --n;
        }
        switch (n) {
            case -1: {
                return NO_BINDINGS;
            }
            case 0: {
                return null;
            }
        }
        return new Binding[]{this.m_matches[n - 1].m_binding};
    }

    public boolean isChildInstructionInTailPosition(int n) {
        return this.getChildInstructionBindings(n) != null;
    }

    public static class Match {
        Instruction m_handler;
        protected Binding m_binding;

        public String toString() {
            return "(case (" + this.m_binding.getBindingType() + ' ' + this.m_binding.getName() + ") " + this.m_handler + ')';
        }

        public Instruction getHandler() {
            return this.m_handler;
        }

        public void setHandler(Instruction instruction) {
            this.m_handler = instruction;
        }

        public Binding getBinding() {
            return this.m_binding;
        }

        public Match(Type type, Object object, Instruction instruction) {
            this.m_handler = instruction;
            this.m_binding = new Binding(object, type, (ISpecialForm)null);
        }

        Type doTypeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
            this.m_binding.setTypeEnvironment(typeEnvironment);
            BindingEnvironment bindingEnvironment2 = new BindingEnvironment(bindingEnvironment, this.m_binding);
            return this.m_handler.typeCheck(typeEnvironment, bindingEnvironment2, linkedList);
        }

        void doTypeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
            bindingEnvironment.setVariableBinding(this.m_binding);
        }

        Match cloneWithoutTypeInformation() {
            return new Match(this.m_binding.getBindingType(), this.m_binding.getName(), this.m_handler.cloneWithoutTypeInformation());
        }

        Match cloneShallow() {
            return new Match(this.m_binding.getBindingType(), this.m_binding.getName(), this.m_handler);
        }

        void toString(PrettyPrinter prettyPrinter, int n) {
            prettyPrinter.printFormOpen("case", n);
            prettyPrinter.printFormOpen(this.m_binding.getBindingType().prettyPrint(), n + 1);
            prettyPrinter.printIdentifier(this.m_binding.getName(), n + 2);
            prettyPrinter.printFormClose(n + 1);
            this.m_handler.toString(prettyPrinter, n + 1);
            prettyPrinter.printFormClose(n);
        }
    }
}

