/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;

public abstract class UnaryPrimopInstruction
extends Instruction {
    protected Instruction m_operand;

    public UnaryPrimopInstruction() {
    }

    protected UnaryPrimopInstruction(Instruction instruction) {
        this.m_operand = instruction;
    }

    public final Instruction getOperand() {
        return this.m_operand;
    }

    public final int getChildInstructionCount() {
        return 1;
    }

    public final Instruction getChildInstruction(int n) {
        switch (n) {
            case 0: {
                return this.m_operand;
            }
        }
        return null;
    }

    public final void setChildInstruction(int n, Instruction instruction) {
        switch (n) {
            case 0: {
                this.m_operand = instruction;
            }
        }
    }

    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        Instruction instruction = reductionHelper.reduceToBasicInstruction(instructionArray, this.m_operand, bindingEnvironment);
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
        this.m_operand = instruction;
    }

    public abstract Instruction cloneWithoutTypeInformation(Instruction var1);

    public Instruction cloneShallow() {
        return this.cloneWithoutTypeInformation(this.m_operand);
    }

    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        this.m_operand = readObjectFileHelper.readInstruction(bindingEnvironment);
    }

    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        writeObjectFileHelper.writeInstruction(this.m_operand);
    }

    public void setOperand(Instruction instruction) {
        this.m_operand = instruction;
    }

    public Instruction cloneReduced() {
        return this.cloneShallow();
    }

    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

