/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.IContext;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.commandline.XylemC;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LoopInstruction;
import com.ibm.xylem.interpreter.DebuggerQuitException;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.EvaluateTerminateException;
import com.ibm.xylem.utils.XylemError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Debugger
implements IDebuggerInterceptor {
    private int m_verbosityLevel = 1;
    private String m_mostRecentConsoleMsg = "";
    private boolean m_sawNewLine = true;
    private ArrayList m_instructionBreakPoints = new ArrayList();
    private boolean m_waitingForBreakpoint = false;
    private ArrayList m_stack = new ArrayList();
    private ArrayList m_contextStack = new ArrayList();
    private Set m_functionBreakPoints = new HashSet();
    private boolean m_breakOnTerminate = true;
    private StackEntry m_target = null;
    private IContext m_contextTarget = null;
    Module m_module = null;
    InputStreamReader m_charReader = new InputStreamReader(System.in);
    BufferedReader m_reader = new BufferedReader(this.m_charReader);

    public Debugger(Module module) {
        this.m_module = module;
    }

    public int getVerbosityLevel() {
        return this.m_verbosityLevel;
    }

    private final StackEntry top() {
        if (this.m_stack.isEmpty()) {
            return null;
        }
        return (StackEntry)this.m_stack.get(this.m_stack.size() - 1);
    }

    private final Environment topEnvironment() {
        StackEntry stackEntry = this.top();
        return null == stackEntry ? null : stackEntry.m_envir;
    }

    private final String topEnvironmentString() {
        Environment environment = this.topEnvironment();
        return null == environment ? "--- No Environment ---" : environment.toString();
    }

    private final boolean shouldBreak(Instruction instruction) {
        String string = ((IContext)this.m_contextStack.get(this.m_contextStack.size() - 1)).getName();
        for (int i = 0; i < this.m_instructionBreakPoints.size(); ++i) {
            InstructionBreakPoint instructionBreakPoint = (InstructionBreakPoint)this.m_instructionBreakPoints.get(i);
            if (!instructionBreakPoint.m_instruction.equals(instruction.getClass()) || !instructionBreakPoint.m_functionName.equals(string)) continue;
            if (instructionBreakPoint.m_lineno == 0) {
                return true;
            }
            if (instructionBreakPoint.m_lineno != instruction.getSourceLineNumber()) continue;
            return true;
        }
        return false;
    }

    public static final Object leave(IDebuggerInterceptor iDebuggerInterceptor, Instruction instruction, Environment environment, Function function, Object object) {
        if (null == iDebuggerInterceptor) {
            return object;
        }
        iDebuggerInterceptor.leave(instruction, environment, function, object);
        return object;
    }

    public static final EvaluateTerminateException terminate(IDebuggerInterceptor iDebuggerInterceptor, Instruction instruction, Environment environment, Function function, String string) {
        EvaluateTerminateException evaluateTerminateException = new EvaluateTerminateException(string);
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.terminate(instruction, environment, function, string);
        }
        throw evaluateTerminateException;
    }

    public static final void enterContext(IDebuggerInterceptor iDebuggerInterceptor, IContext iContext) {
        if (null == iDebuggerInterceptor) {
            return;
        }
        iDebuggerInterceptor.enterContext(iContext);
    }

    public static final Object leaveContext(IDebuggerInterceptor iDebuggerInterceptor, IContext iContext, Object object) {
        if (null == iDebuggerInterceptor) {
            return object;
        }
        iDebuggerInterceptor.leaveContext(iContext, object);
        return object;
    }

    public void enter(Instruction instruction, Environment environment, Function function) throws DebuggerQuitException {
        if (this.m_verbosityLevel == 0) {
            System.out.println("Enter " + instruction);
        } else {
            this.m_mostRecentConsoleMsg = "Enter " + instruction;
        }
        this.m_stack.add(new StackEntry(instruction, environment, function));
        if (this.atStoppingPoint()) {
            this.commandLine(2);
        } else if (this.shouldBreak(instruction)) {
            if (this.m_verbosityLevel < 2) {
                System.out.println("Found breakpoint");
            }
            this.m_waitingForBreakpoint = false;
            this.commandLine(2);
        }
    }

    public void leave(Instruction instruction, Environment environment, Function function, Object object) {
        if (this.m_verbosityLevel == 0) {
            System.out.println("Leave " + instruction + " --- value: " + object);
        } else {
            this.m_mostRecentConsoleMsg = "Leave " + instruction + " --- value: " + object;
        }
        StackEntry stackEntry = (StackEntry)this.m_stack.remove(this.m_stack.size() - 1);
        if (stackEntry == this.m_target) {
            this.m_target = null;
        }
        if (this.atStoppingPoint()) {
            this.commandLine(0);
        }
    }

    public void terminate(Instruction instruction, Environment environment, Function function, String string) {
        System.out.println("Terminate " + instruction + " --- message: " + string);
        if (this.atStoppingPoint() || this.m_breakOnTerminate) {
            this.commandLine(0);
        }
    }

    public void enterContext(IContext iContext) throws DebuggerQuitException {
        if (this.m_verbosityLevel == 0) {
            System.out.println("Enter Context " + iContext.getName());
        } else {
            this.m_mostRecentConsoleMsg = "Enter Context " + iContext.getName();
        }
        this.m_contextStack.add(iContext);
        if (this.atStoppingPoint() || this.m_functionBreakPoints.contains(iContext.getName())) {
            this.m_target = null;
            this.m_contextTarget = null;
            this.m_waitingForBreakpoint = false;
            this.commandLine(1);
        }
    }

    public void leaveContext(IContext iContext, Object object) {
        if (this.m_verbosityLevel == 0) {
            System.out.println("Leave Context " + iContext.getName() + " --- value: " + object);
        } else {
            this.m_mostRecentConsoleMsg = "Leave Context " + iContext.getName() + " --- value: " + object;
        }
        IContext iContext2 = (IContext)this.m_contextStack.remove(this.m_contextStack.size() - 1);
        if (iContext2 == this.m_contextTarget) {
            this.m_contextTarget = null;
        }
        if (this.atStoppingPoint()) {
            this.commandLine(0);
        }
    }

    private final boolean atStoppingPoint() {
        return null == this.m_target && null == this.m_contextTarget && !this.m_waitingForBreakpoint;
    }

    private void clearLine() throws IOException {
        this.m_reader.readLine();
    }

    private void commandLine(int n) throws DebuggerQuitException {
        try {
            block11: while (true) {
                Object object;
                int n2;
                if (this.m_sawNewLine && this.m_mostRecentConsoleMsg.length() > 0) {
                    System.out.println(this.m_mostRecentConsoleMsg);
                    this.m_mostRecentConsoleMsg = "";
                    this.m_sawNewLine = false;
                }
                if (105 == (n2 = this.m_charReader.read())) {
                    return;
                }
                if (111 == n2) {
                    switch (n) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.m_contextTarget = (IContext)this.m_contextStack.get(this.m_contextStack.size() - 1);
                            break;
                        }
                        case 2: {
                            this.m_target = (StackEntry)this.m_stack.get(this.m_stack.size() - 1);
                            break;
                        }
                        default: {
                            throw new XylemError("ERR_SYSTEM", "Bad stepOverFlag value (" + n + ")");
                        }
                    }
                    return;
                }
                if (101 == n2) {
                    try {
                        System.out.println(this.topEnvironmentString());
                    }
                    catch (Exception exception) {
                        System.err.println("Unexpected Exception: " + exception);
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (115 == n2) {
                    int n3 = 1;
                    int n4 = this.m_contextStack.size() - 1;
                    while (true) {
                        if (n4 < 0) continue block11;
                        object = (IContext)this.m_contextStack.get(n4);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(n3 + ":" + object.getName());
                        if (object.getDefinitionURL() != null) {
                            stringBuffer.append(" at " + new File(object.getDefinitionURL().getFile()).getCanonicalPath() + " line " + object.getDefinitionLineNumber());
                        }
                        System.out.println(stringBuffer.toString());
                        --n4;
                        ++n3;
                    }
                }
                if (102 == n2) {
                    System.out.print("Name of function to break on? > ");
                    this.clearLine();
                    String string = this.m_reader.readLine();
                    if (this.m_functionBreakPoints.contains(string)) {
                        this.m_functionBreakPoints.remove(string);
                        System.out.println("Removing function breakpoint for " + string);
                        continue;
                    }
                    if (!this.lookupFunction(string, this.m_module)) {
                        System.err.println("Can't find function \"" + string + "\".");
                        continue;
                    }
                    this.m_functionBreakPoints.add(string);
                    System.out.println("Adding function breakpoint for " + string);
                    continue;
                }
                if (99 == n2) {
                    this.m_target = null;
                    this.m_contextTarget = null;
                    this.m_waitingForBreakpoint = true;
                    return;
                }
                if (116 == n2) {
                    this.m_breakOnTerminate = !this.m_breakOnTerminate;
                    continue;
                }
                if (98 == n2) {
                    this.clearLine();
                    InstructionBreakPoint instructionBreakPoint = InstructionBreakPoint.getFromInput(true, this.m_module, this.m_reader);
                    if (null == instructionBreakPoint) continue;
                    this.m_instructionBreakPoints.add(instructionBreakPoint);
                    continue;
                }
                if (104 == n2) {
                    String string = ((IContext)this.m_contextStack.get(this.m_contextStack.size() - 1)).getName();
                    Instruction instruction = ((StackEntry)this.m_stack.get((int)(this.m_stack.size() - 1))).m_instr;
                    object = instruction.getClass();
                    int n5 = instruction.getSourceLineNumber();
                    this.m_instructionBreakPoints.add(new InstructionBreakPoint(string, (Class)object, n5));
                    continue;
                }
                if (66 == n2) {
                    int n6 = 0;
                    while (true) {
                        if (n6 >= this.m_instructionBreakPoints.size()) continue block11;
                        System.out.println("Break at " + (InstructionBreakPoint)this.m_instructionBreakPoints.get(n6));
                        ++n6;
                    }
                }
                if (118 == n2) {
                    if (0 == this.m_verbosityLevel) {
                        this.m_verbosityLevel = 1;
                        continue;
                    }
                    this.m_verbosityLevel = 0;
                    continue;
                }
                if (113 == n2) {
                    throw new DebuggerQuitException();
                }
                if (10 == n2 || 13 == n2) {
                    this.m_sawNewLine = true;
                    continue;
                }
                System.err.println("Command '" + (char)n2 + "' not understood, try again.");
            }
        }
        catch (DebuggerQuitException debuggerQuitException) {
            throw debuggerQuitException;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.err.println("Unexpected Exception");
        }
    }

    private boolean lookupFunction(String string, Module module) {
        if (module.getFunction(string) != null) {
            return true;
        }
        Iterator iterator = module.getModules().iterator();
        while (iterator.hasNext()) {
            if (((Module)iterator.next()).getFunction(string) == null) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        try {
            linkedList.addFirst(new File(".").toURL());
            ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(linkedList);
            URL uRL = new File(stringArray[0]).toURL();
            linkedList.addFirst(uRL);
            Module module = XylemC.XYLEMC.compile(uRL, null, linkedList, moduleSignatureStore);
            linkedList.removeFirst();
            Debugger debugger = new Debugger(module);
            Environment environment = new Environment();
            Function function = module.getFunction("main");
            debugger.enterContext(function);
            Object object = function.getBody().evaluate(environment, function, debugger, false);
            debugger.leaveContext(function, object);
            System.out.println("End of program execution.");
        }
        catch (DebuggerQuitException debuggerQuitException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class InstructionBreakPoint {
        private static Map m_instrMap = new HashMap();
        private int m_lineno = 0;
        private String m_functionName;
        private Class m_instruction;

        public InstructionBreakPoint(String string, Class clazz, int n) {
            this.m_functionName = string;
            this.m_instruction = clazz;
            this.m_lineno = n;
        }

        public String toString() {
            return this.m_instruction.getName() + " in " + this.m_functionName + (this.m_lineno != 0 ? " at line " + this.m_lineno : "");
        }

        private static void initInstrMap() {
            if (!m_instrMap.isEmpty()) {
                return;
            }
            m_instrMap.put("loop", LoopInstruction.class);
            m_instrMap.put("choose", ChooseInstruction.class);
            m_instrMap.put("apply", ApplyInstruction.class);
            m_instrMap.put("lambda", LambdaInstruction.class);
        }

        public static final InstructionBreakPoint getFromInput(boolean bl, Module module, BufferedReader bufferedReader) {
            InstructionBreakPoint.initInstrMap();
            try {
                String string = null;
                FunctionSignature functionSignature = null;
                if (bl) {
                    while (null == functionSignature) {
                        System.out.println("What's the enclosing function? ('cancel' to not add breakpoint) ");
                        string = bufferedReader.readLine();
                        if (string.equals("cancel")) {
                            return null;
                        }
                        functionSignature = module.getFunctionSignature(string);
                        if (null != functionSignature) continue;
                        System.err.println("Can't find function \"" + string + "\".");
                    }
                } else {
                    while (null == string) {
                        System.out.println("What's the enclosing closure number? ('cancel' to not add breakpoint) ");
                        string = bufferedReader.readLine();
                        if (string.equals("cancel")) {
                            return null;
                        }
                        string = "<closure " + string + ">";
                    }
                }
                String string2 = null;
                Class<?> clazz = null;
                while (null == clazz) {
                    System.out.println("What's the instruction? ('cancel' to not add breakpoint) ");
                    string2 = bufferedReader.readLine();
                    if (string2.equals("cancel")) {
                        return null;
                    }
                    clazz = (Class<?>)m_instrMap.get(string2);
                    if (null == clazz) {
                        try {
                            clazz = Class.forName("com.ibm.xylem.instructions." + string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (null == clazz) {
                        try {
                            clazz = Class.forName(string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (null != clazz) continue;
                    System.err.println("I don't know about instr \"" + string2 + "\".");
                }
                return new InstructionBreakPoint(string, clazz, 0);
            }
            catch (IOException iOException) {
                System.out.println("Unexpected IOException: " + iOException);
                return null;
            }
        }
    }

    public class StackEntry {
        Instruction m_instr;
        Environment m_envir;
        Function m_func;

        public StackEntry(Instruction instruction, Environment environment, Function function) {
            this.m_instr = instruction;
            this.m_envir = environment;
            this.m_func = function;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StackEntry)) {
                return false;
            }
            return this.m_instr == ((StackEntry)object).m_instr;
        }
    }
}

