/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.interpreter;

import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.interpreter.AbstractDataObject;
import com.ibm.xylem.interpreter.Closure;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IAppendableStream;
import com.ibm.xylem.interpreter.IStream;
import com.ibm.xylem.interpreter.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LazyStream
implements IAppendableStream {
    protected List m_list = new ArrayList();
    protected Closure m_c;
    protected IDebuggerInterceptor m_di;
    protected Environment m_e;
    protected boolean m_complete = false;
    protected Object[] m_hints;

    public LazyStream(Closure closure, Environment environment, IDebuggerInterceptor iDebuggerInterceptor, Object[] objectArray) {
        this.m_c = closure;
        this.m_di = iDebuggerInterceptor;
        this.m_e = environment;
        this.m_hints = objectArray;
    }

    protected void evaluateMore(int n) {
        while (!this.m_complete && n >= this.m_list.size()) {
            Object object = this.m_c.evaluate(this.m_e, this.m_hints, this.m_di);
            Object[] objectArray = object instanceof Tuple ? ((Tuple)object).m_values : ((AbstractDataObject)object).m_values;
            IStream iStream = (IStream)objectArray[0];
            Iterator iterator = iStream.iterator();
            while (iterator.hasNext()) {
                this.m_list.add(iterator.next());
            }
            System.arraycopy(objectArray, 2, this.m_hints, 0, this.m_hints.length);
            if (!((Boolean)objectArray[1]).booleanValue()) continue;
            this.m_complete = true;
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            protected int m_index = 0;

            public boolean hasNext() {
                LazyStream.this.evaluateMore(this.m_index);
                return this.m_index < LazyStream.this.m_list.size();
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LazyStream.this.m_list.get(this.m_index++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void append(Object object) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "[lazy stream]";
    }

    public char[] toCharArray() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.m_list.size();
    }

    public Object get(int n) {
        this.evaluateMore(n);
        return this.m_list.get(n);
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }
}

